/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.graph;

import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.df;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class TSFindChildParent {
    public static final int FIND_CHILDREN = 1;
    public static final int FIND_PARENTS = 2;
    public static final int FIND_NEIGHBORS = 3;
    public static final int FIND_DEPTH_ALL = -2;
    private TSGraph graph;
    private TSGraph secondGraph;
    private boolean findChildren;
    private boolean findParents;
    private List newNodeList;
    private TSNode startNode;
    private long origTraversalDepth;
    private boolean findNodes;

    public TSFindChildParent(TSGraph tSGraph, TSNode tSNode, List list, List list2, long l, TSGraph tSGraph2, int n) {
        this.graph = tSGraph;
        this.secondGraph = tSGraph2;
        this.startNode = tSNode;
        this.origTraversalDepth = l;
        this.findNodes = list != null;
        TSSystem.tsAssert(list != null);
        TSSystem.tsAssert(tSGraph != null);
        TSSystem.tsAssert(!tSGraph.isIntergraph());
        TSSystem.tsAssert(tSGraph2 == null || !tSGraph2.isIntergraph());
        this.newNodeList = list != null ? list : null;
        switch (n) {
            case 1: {
                this.findChildren = true;
                this.findParents = false;
                break;
            }
            case 2: {
                this.findChildren = false;
                this.findParents = true;
                break;
            }
            case 3: {
                this.findChildren = true;
                this.findParents = true;
                break;
            }
            default: {
                this.findChildren = false;
                this.findParents = false;
            }
        }
    }

    public void run() {
        this.emptyInformation();
        this.initialize();
        this.algorithmBody();
    }

    public void emptyInformation() {
    }

    public void initialize() {
        if (!this.findNodes) {
            this.newNodeList = new df();
        }
        this.newNodeList.clear();
    }

    public void algorithmBody() {
        TSGraph tSGraph = this.startNode.getOwnerGraph();
        if (tSGraph != null && (tSGraph == this.graph || tSGraph == this.secondGraph)) {
            this.find(this.startNode, this.origTraversalDepth);
        }
        if (this.startNode.isVisited()) {
            this.startNode.setVisited(false);
            this.newNodeList.remove(this.startNode);
        }
        Iterator iterator = this.newNodeList.iterator();
        while (iterator.hasNext()) {
            ((TSNode)iterator.next()).setVisited(false);
        }
    }

    void find(TSNode tSNode, long l) {
        TSGraph tSGraph = tSNode.getOwnerGraph();
        TSSystem.tsAssert(this.graph != null);
        TSSystem.tsAssert(tSGraph != null);
        TSSystem.tsAssert(tSGraph == this.graph || tSGraph == this.secondGraph);
        if (l >= 0L || l == -2L) {
            TSNode tSNode2;
            TSEdge tSEdge;
            Object object;
            if (!tSNode.isVisited()) {
                tSNode.setVisited(true);
                this.collectNode(tSNode);
            }
            if (l != -2L) {
                --l;
            }
            if (this.findChildren) {
                object = tSNode.outEdges().iterator();
                while (object.hasNext()) {
                    tSEdge = (TSEdge)object.next();
                    tSNode2 = tSEdge.getTargetNode();
                    if (tSEdge.getOwnerGraph() != tSGraph || tSNode2.getOwnerGraph() != tSGraph || tSNode2.isVisited() && l == -2L) continue;
                    this.find(tSNode2, l);
                }
            }
            if (this.findParents) {
                object = tSNode.inEdges().iterator();
                while (object.hasNext()) {
                    tSEdge = (TSEdge)object.next();
                    tSNode2 = tSEdge.getSourceNode();
                    if (tSEdge.getOwnerGraph() != tSGraph || tSNode2.getOwnerGraph() != tSGraph || tSNode2.isVisited() && l == -2L) continue;
                    this.find(tSNode2, l);
                }
            }
            if (this.secondGraph != null) {
                object = tSGraph == this.graph ? this.secondGraph : this.graph;
                df df2 = new df(tSNode.inEdges());
                df2.addAll((Collection)tSNode.outEdges());
                df2.addAll((Collection)tSNode.disconnectedEdges());
                Iterator iterator = df2.iterator();
                while (iterator.hasNext()) {
                    TSNode tSNode3;
                    TSNode tSNode4;
                    tSEdge = (TSEdge)iterator.next();
                    if (tSEdge.getOwnerGraph() == tSGraph && tSEdge.isOwned()) {
                        tSNode4 = tSEdge.getSourceNode();
                        tSNode3 = tSEdge.getTargetNode();
                        if (tSNode4 == tSNode && tSNode3.getOwnerGraph() == object && this.findChildren && (!tSNode3.isVisited() || l != -2L)) {
                            this.find(tSNode3, l);
                        }
                        if (tSNode3 != tSNode || tSNode4.getOwnerGraph() != object || !this.findParents || tSNode4.isVisited() && l == -2L) continue;
                        this.find(tSNode4, l);
                        continue;
                    }
                    if (tSEdge.getOwnerGraph() != object || !tSEdge.isOwned()) continue;
                    tSNode4 = tSEdge.getSourceNode();
                    tSNode3 = tSEdge.getTargetNode();
                    if (!(tSNode4 != tSNode || tSNode3.getOwnerGraph() != tSGraph && tSNode3.getOwnerGraph() != object || !this.findChildren || tSNode3.isVisited() && l == -2L)) {
                        this.find(tSNode3, l);
                    }
                    if (tSNode3 != tSNode || tSNode4.getOwnerGraph() != tSGraph && tSNode4.getOwnerGraph() != object || !this.findParents || tSNode4.isVisited() && l == -2L) continue;
                    this.find(tSNode4, l);
                }
            }
        }
    }

    void collectNode(TSNode tSNode) {
        TSSystem.tsAssert(this.newNodeList != null);
        this.newNodeList.add(tSNode);
    }
}

