/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.graph;

import com.tomsawyer.event.TSChildEventSource;
import com.tomsawyer.event.TSEvent;
import com.tomsawyer.event.dd;
import com.tomsawyer.graph.TSChildGraphForest;
import com.tomsawyer.graph.TSChildGraphForestEdge;
import com.tomsawyer.graph.TSChildGraphForestNode;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraphManager;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSGraphObjectTable;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graph.cw;
import com.tomsawyer.graph.de;
import com.tomsawyer.graph.event.TSGraphChangeEvent;
import com.tomsawyer.graph.event.TSGraphChangeEventData;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.f0;
import com.tomsawyer.util.f2;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TSGraph
extends TSGraphObject
implements TSChildEventSource {
    static final int INTERGRAPH = 16;
    public List edgeSet;
    public List nodeSet;
    public List freeSet;
    f0 listLocation;
    public static final int TYPE = 0;
    private TSChildGraphForestNode childGraphForestNode;

    protected void initGraphObject() {
        super.initGraphObject();
        f2.f(f2.au);
        this.edgeSet = new de();
        this.nodeSet = new de();
        this.freeSet = new de();
        this.childGraphForestNode = null;
        this.listLocation = null;
    }

    public Object getParentEventSource() {
        return this.getOwnerGraphManager();
    }

    public boolean fireEvent(TSEvent tSEvent) {
        return this.fireEvent(tSEvent, false);
    }

    public boolean fireEvent(TSEvent tSEvent, boolean bl) {
        if (this.getOwnerGraphManager() != null) {
            return this.getOwnerGraphManager().getEventManager().fireEvent(tSEvent, bl);
        }
        return true;
    }

    public boolean fireModuleEvent(Object object, Object object2, Object object3, String string) {
        dd dd2;
        boolean bl = true;
        if (this.getOwnerGraphManager() != null && (dd2 = this.getOwnerGraphManager().getEventManager().getModule(string)) != null) {
            bl = dd2.a(object, object2, object3);
        }
        return bl;
    }

    public void setFireEvents(boolean bl) {
        if (this.getOwnerGraphManager() != null) {
            this.getOwnerGraphManager().getEventManager().setFireEvents(bl);
        }
    }

    public boolean isFiringEvents() {
        if (this.getOwnerGraphManager() != null) {
            return this.getOwnerGraphManager().getEventManager().isFiringEvents();
        }
        return false;
    }

    public void setCoalesce(boolean bl) {
        if (this.getOwnerGraphManager() != null) {
            this.getOwnerGraphManager().getEventManager().setCoalesce(bl);
        }
    }

    public boolean isCoalesce() {
        if (this.getOwnerGraphManager() != null) {
            return this.getOwnerGraphManager().getEventManager().isCoalesce();
        }
        return false;
    }

    public TSEdge addEdge(TSNode tSNode, TSNode tSNode2) {
        TSSystem.tsAssert(tSNode != null);
        TSSystem.tsAssert(tSNode2 != null);
        TSSystem.tsAssert(tSNode.isOwned());
        TSSystem.tsAssert(tSNode2.isOwned());
        TSEdge tSEdge = this.newEdge();
        tSEdge.setSourceNode(tSNode);
        tSEdge.setTargetNode(tSNode2);
        this.insert(tSEdge);
        return tSEdge;
    }

    public TSEdge addEdge(int n, TSNode tSNode, TSNode tSNode2) {
        TSSystem.tsAssert(tSNode != null);
        TSSystem.tsAssert(tSNode2 != null);
        TSSystem.tsAssert(tSNode.isOwned());
        TSSystem.tsAssert(tSNode2.isOwned());
        TSEdge tSEdge = this.newEdge(n);
        tSEdge.setSourceNode(tSNode);
        tSEdge.setTargetNode(tSNode2);
        this.insert(tSEdge);
        return tSEdge;
    }

    public TSNode addNode() {
        TSNode tSNode = this.newNode();
        this.insert(tSNode);
        return tSNode;
    }

    public TSNode addNode(int n) {
        TSNode tSNode = this.newNode(n);
        this.insert(tSNode);
        return tSNode;
    }

    public boolean contains(TSNode tSNode) {
        return tSNode.getOwner() == this && tSNode.getNodeListLocation() != null && tSNode.getNodeListLocation().c() == this.nodeSet;
    }

    public boolean contains(TSEdge tSEdge) {
        return tSEdge.getOwner() == this && tSEdge.getEdgeListLocation() != null && tSEdge.getEdgeListLocation().c() == this.edgeSet;
    }

    public void discard(TSNode tSNode) {
        if (!tSNode.isDiscarded()) {
            boolean bl = this.isFiringEvents();
            this.setFireEvents(false);
            if (tSNode.isOwned()) {
                this.remove(tSNode);
            }
            this.setFireEvents(bl);
            tSNode.onDiscard(this);
            TSGraphManager tSGraphManager = this.getOwnerGraphManager();
            if (tSGraphManager != null) {
                TSChildGraphForest tSChildGraphForest = tSGraphManager.getChildGraphForest();
                tSChildGraphForest.actOnDiscardGraphMember(tSNode);
            }
        }
    }

    public void discard(TSEdge tSEdge) {
        if (!tSEdge.isDiscarded()) {
            boolean bl = this.isFiringEvents();
            this.setFireEvents(false);
            if (tSEdge.isOwned()) {
                this.remove(tSEdge);
            }
            this.setFireEvents(bl);
            tSEdge.onDiscard(this);
            TSGraphManager tSGraphManager = this.getOwnerGraphManager();
            if (tSGraphManager != null) {
                TSChildGraphForest tSChildGraphForest = tSGraphManager.getChildGraphForest();
                tSChildGraphForest.actOnDiscardGraphMember(tSEdge);
            }
        }
    }

    public List disconnectedEdges() {
        return this.freeSet;
    }

    public List edges() {
        return this.edgeSet;
    }

    public void emptyTopology() {
        try {
            Iterator iterator;
            Vector vector;
            TSGraphObject tSGraphObject;
            if (this.getOwnerGraphManager() != null && (tSGraphObject = this.getOwnerGraphManager().queryIntergraph()) != null) {
                vector = new Vector();
                vector.addAll(this.buildAllAffectedIntergraphEdgeList());
                iterator = vector.iterator();
                while (iterator.hasNext()) {
                    ((TSGraph)tSGraphObject).discard((TSEdge)iterator.next());
                }
            }
            vector = new Vector();
            vector.addAll(this.edges());
            iterator = vector.iterator();
            while (iterator.hasNext()) {
                this.discard((TSEdge)iterator.next());
            }
            vector = new Vector();
            vector.addAll(this.nodes());
            iterator = vector.iterator();
            while (iterator.hasNext()) {
                this.discard((TSNode)iterator.next());
            }
            vector = new Vector();
            vector.addAll(this.disconnectedEdges());
            iterator = vector.iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSEdge)iterator.next();
                if (!tSGraphObject.isOwned()) continue;
                this.discard((TSEdge)tSGraphObject);
            }
        }
        catch (RuntimeException runtimeException) {
            this.initGraphObject();
            throw runtimeException;
        }
        TSSystem.tsAssert(this.numberOfEdges() == 0);
        TSSystem.tsAssert(this.numberOfNodes() == 0);
        TSSystem.tsAssert(this.numberOfDisconnectedEdges() == 0);
    }

    public int numberOfEdges() {
        return this.edgeSet.size();
    }

    public int numberOfDisconnectedEdges() {
        return this.freeSet.size();
    }

    public int numberOfNodes() {
        return this.nodeSet.size();
    }

    public int numberOfGraphs() {
        TSGraph tSGraph;
        TSGraphMember tSGraphMember;
        Iterator iterator;
        int n = 1;
        if (this.numberOfNodes() > 0) {
            iterator = this.nodes().iterator();
            while (iterator.hasNext()) {
                tSGraphMember = (TSNode)iterator.next();
                tSGraph = tSGraphMember.getChildGraph();
                if (tSGraph == null) continue;
                n += tSGraph.numberOfGraphs();
            }
        }
        if (this.numberOfEdges() > 0) {
            iterator = this.edges().iterator();
            while (iterator.hasNext()) {
                tSGraphMember = (TSEdge)iterator.next();
                tSGraph = tSGraphMember.getChildGraph();
                if (tSGraph == null) continue;
                n += tSGraph.numberOfGraphs();
            }
        }
        return n;
    }

    public void insert(TSEdge tSEdge) {
        TSSystem.tsAssert(tSEdge != null);
        TSSystem.tsAssert(!tSEdge.isOwned());
        TSSystem.tsAssert(!tSEdge.isConnected());
        TSSystem.tsAssert(tSEdge.getSourceNode() != null);
        TSSystem.tsAssert(tSEdge.getTargetNode() != null);
        TSSystem.tsAssert(tSEdge.getEdgeListLocation() == null);
        tSEdge.setEdgeListLocation(((de)this.freeSet).b(tSEdge));
        tSEdge.onInsert(this);
        TSGraphManager tSGraphManager = this.getOwnerGraphManager();
        if (tSGraphManager != null) {
            TSChildGraphForest tSChildGraphForest = tSGraphManager.getChildGraphForest();
            tSChildGraphForest.actOnInsertGraphMember(tSEdge);
        }
    }

    public void insert(TSNode tSNode) {
        TSSystem.tsAssert(tSNode != null);
        TSSystem.tsAssert(!tSNode.isOwned());
        TSSystem.tsAssert(tSNode.getNodeListLocation() == null);
        tSNode.setNodeListLocation(((de)this.nodeSet).b(tSNode));
        tSNode.onInsert(this);
        TSGraphManager tSGraphManager = this.getOwnerGraphManager();
        if (tSGraphManager != null) {
            TSChildGraphForest tSChildGraphForest = tSGraphManager.getChildGraphForest();
            tSChildGraphForest.actOnInsertGraphMember(tSNode);
        }
    }

    public void onInsert(TSGraphObject tSGraphObject) {
        super.onInsert(tSGraphObject);
        this.fireEvent(new TSGraphChangeEvent(1L, new TSGraphChangeEventData(this, null, tSGraphObject)));
    }

    public void onRemove(TSGraphObject tSGraphObject) {
        TSGraphManager tSGraphManager = this.getOwnerGraphManager();
        if (tSGraphManager != null) {
            this.fireEvent(new TSGraphChangeEvent(8L, new TSGraphChangeEventData(this, tSGraphObject, null)));
        }
        super.onRemove(tSGraphObject);
    }

    public void onDiscard(TSGraphObject tSGraphObject) {
        this.setDiscarded(true);
        this.fireEvent(new TSGraphChangeEvent(64L, new TSGraphChangeEventData(this, tSGraphObject, null)));
    }

    public List nodes() {
        return this.nodeSet;
    }

    public void remove(TSEdge tSEdge) {
        Cloneable cloneable;
        TSSystem.tsAssert(tSEdge != null);
        TSSystem.tsAssert(tSEdge.isOwned());
        TSSystem.tsAssert(tSEdge.getOwner() == this);
        TSSystem.tsAssert(tSEdge.getSourceNode() != null);
        TSSystem.tsAssert(tSEdge.getTargetNode() != null);
        TSGraphManager tSGraphManager = this.getOwnerGraphManager();
        if (tSGraphManager != null) {
            cloneable = tSGraphManager.getChildGraphForest();
            ((TSChildGraphForest)cloneable).actOnRemoveGraphMember(tSEdge);
        }
        tSEdge.onRemove(this);
        cloneable = tSEdge.getEdgeListLocation();
        TSSystem.tsAssert(cloneable != null);
        TSSystem.tsAssert(((f0)cloneable).c() == this.freeSet);
        ((de)this.freeSet).c(tSEdge.getEdgeListLocation());
        tSEdge.setEdgeListLocation(null);
    }

    public void remove(TSNode tSNode) {
        f0 f02;
        TSSystem.tsAssert(tSNode != null);
        TSSystem.tsAssert(tSNode.isOwned());
        TSSystem.tsAssert(tSNode.getOwner() == this);
        TSGraphManager tSGraphManager = this.getOwnerGraphManager();
        if (tSGraphManager != null) {
            tSGraphManager.getChildGraphForest().actOnRemoveGraphMember(tSNode);
        }
        TSSystem.tsAssert((f02 = tSNode.getNodeListLocation()) != null);
        TSSystem.tsAssert(f02.c() == this.nodeSet);
        ((de)this.nodeSet).c(f02);
        tSNode.onRemove(this);
        tSNode.setNodeListLocation(null);
    }

    public void setTag(Object object) {
        Object object2 = this.getTag();
        super.setTag(object);
        if (!TSSystem.equals(object2, object)) {
            this.fireEvent(new TSGraphChangeEvent(512L, new TSGraphChangeEventData(this, object2, this.getTag())));
        }
    }

    public void setAllNodesVisited(boolean bl) {
        for (f0 f02 = ((de)this.nodeSet).a(); f02 != null; f02 = f02.a()) {
            ((TSNode)f02.b()).setVisited(bl);
        }
    }

    public boolean hasVisitedNodes() {
        for (f0 f02 = ((de)this.nodeSet).a(); f02 != null; f02 = f02.a()) {
            TSNode tSNode = (TSNode)f02.b();
            if (!tSNode.isVisited()) continue;
            return true;
        }
        return false;
    }

    public void setAllEdgesTraversed(boolean bl) {
        if (this.isIntergraph()) {
            for (f0 f02 = ((de)this.freeSet).a(); f02 != null; f02 = f02.a()) {
                ((TSEdge)f02.b()).setTraversed(bl);
            }
        } else {
            for (f0 f03 = ((de)this.edgeSet).a(); f03 != null; f03 = f03.a()) {
                ((TSEdge)f03.b()).setTraversed(bl);
            }
        }
    }

    public boolean hasTraversedEdges() {
        if (this.isIntergraph()) {
            for (f0 f02 = ((de)this.freeSet).a(); f02 != null; f02 = f02.a()) {
                TSEdge tSEdge = (TSEdge)f02.b();
                if (!tSEdge.isTraversed()) continue;
                return true;
            }
        } else {
            for (f0 f03 = ((de)this.edgeSet).a(); f03 != null; f03 = f03.a()) {
                TSEdge tSEdge = (TSEdge)f03.b();
                if (!tSEdge.isTraversed()) continue;
                return true;
            }
        }
        return false;
    }

    public void transfer(TSGraph tSGraph) {
        TSGraphMember tSGraphMember;
        f0 f02;
        TSSystem.tsAssert(tSGraph != null);
        TSSystem.tsAssert(tSGraph != this);
        Vector vector = new Vector(tSGraph.edges());
        Vector vector2 = new Vector(tSGraph.disconnectedEdges());
        while ((f02 = ((de)tSGraph.nodeSet).a()) != null) {
            tSGraphMember = (TSNode)f02.b();
            tSGraph.remove((TSNode)tSGraphMember);
            this.insert((TSNode)tSGraphMember);
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSEdge)iterator.next();
            tSGraph.remove((TSEdge)tSGraphMember);
            this.insert((TSEdge)tSGraphMember);
        }
        iterator = vector2.iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSEdge)iterator.next();
            tSGraph.remove((TSEdge)tSGraphMember);
            this.insert((TSEdge)tSGraphMember);
        }
    }

    public void buildChildGraphList(List list) {
        TSChildGraphForestNode tSChildGraphForestNode;
        if (list != null && (tSChildGraphForestNode = this.getChildGraphForestNode()) != null) {
            Iterator iterator = tSChildGraphForestNode.outEdges().iterator();
            while (iterator.hasNext()) {
                TSChildGraphForestEdge tSChildGraphForestEdge = (TSChildGraphForestEdge)iterator.next();
                TSGraph tSGraph = ((TSChildGraphForestNode)tSChildGraphForestEdge.getTargetNode()).getGraph();
                list.add(tSGraph);
            }
        }
    }

    public void buildAllChildGraphList(List list) {
        TSChildGraphForestNode tSChildGraphForestNode;
        if (list != null && (tSChildGraphForestNode = this.getChildGraphForestNode()) != null) {
            LinkedList<TSNode> linkedList = new LinkedList<TSNode>();
            linkedList.add(tSChildGraphForestNode);
            while (!linkedList.isEmpty()) {
                tSChildGraphForestNode = (TSChildGraphForestNode)linkedList.remove(0);
                Iterator iterator = tSChildGraphForestNode.outEdges().iterator();
                while (iterator.hasNext()) {
                    linkedList.add(((TSChildGraphForestEdge)iterator.next()).getTargetNode());
                }
                list.add(tSChildGraphForestNode.getGraph());
            }
            list.remove(0);
        }
    }

    public List buildAllAffectedIntergraphEdgeList() {
        de de2 = new de();
        if (this.getOwnerGraphManager() != null) {
            Vector<TSGraph> vector = new Vector<TSGraph>();
            this.buildAllChildGraphList(vector);
            vector.add(this);
            Iterator iterator = this.getOwnerGraphManager().intergraphEdges().iterator();
            while (iterator.hasNext()) {
                TSEdge tSEdge = (TSEdge)iterator.next();
                TSGraph tSGraph = (TSGraph)tSEdge.getSourceNode().getOwner();
                TSGraph tSGraph2 = (TSGraph)tSEdge.getTargetNode().getOwner();
                if (!vector.contains(tSGraph) && !vector.contains(tSGraph2)) continue;
                de2.add(tSEdge);
            }
        }
        return de2;
    }

    public List buildEdgeList(TSNode tSNode, TSNode tSNode2, boolean bl) {
        TSEdge tSEdge;
        LinkedList<TSEdge> linkedList = new LinkedList<TSEdge>();
        Iterator iterator = tSNode.outEdges().iterator();
        while (iterator.hasNext()) {
            tSEdge = (TSEdge)iterator.next();
            if (tSEdge.getTargetNode() != tSNode2) continue;
            linkedList.add(tSEdge);
        }
        if (!bl && tSNode != tSNode2) {
            iterator = tSNode.inEdges().iterator();
            while (iterator.hasNext()) {
                tSEdge = (TSEdge)iterator.next();
                if (tSEdge.getSourceNode() != tSNode2) continue;
                linkedList.add(tSEdge);
            }
        }
        return linkedList;
    }

    public List buildEdges(int n) {
        de de2 = new de();
        List list = this.isIntergraph() ? this.freeSet : this.edgeSet;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSEdge tSEdge = (TSEdge)iterator.next();
            if ((n & 2) != 0 && tSEdge.isIntergraphEdge()) {
                de2.add(tSEdge);
            }
            if ((n & 1) != 0 && !tSEdge.isIntergraphEdge()) {
                de2.add(tSEdge);
            }
            if ((n & 2) != 0 || (n & 1) != 0) continue;
            de2.add(tSEdge);
        }
        return de2;
    }

    public Object clone(boolean bl) {
        TSGraph tSGraph = (TSGraph)super.clone(bl);
        tSGraph.copy(this, true, null, null, true, true);
        if (!bl) {
            this.nullifyUtilityObject();
        }
        return tSGraph;
    }

    public void copy(Object object, boolean bl, Map map, Map map2, boolean bl2, boolean bl3) {
        boolean bl4;
        TSGraph tSGraph = (TSGraph)object;
        if (!(bl || this.isHideGraph() || this.isIntergraph())) {
            this.initGraphObject();
        }
        if (!(bl4 = TSGraphObject.isStoreCloneInUtilityObject())) {
            TSGraphObject.setStoreCloneInUtilityObject(true);
        }
        this.copy(tSGraph, bl);
        this.duplicateTopology(tSGraph, bl, bl2, bl3);
        if (map != null || map2 != null) {
            this.createMapping(map, map2);
        }
        TSGraphObject.setStoreCloneInUtilityObject(bl4);
    }

    protected void duplicateTopology(TSGraph tSGraph, boolean bl, boolean bl2, boolean bl3) {
        TSSystem.tsAssert(this != tSGraph);
        TSSystem.tsAssert(tSGraph.levelNumber() == this.levelNumber() || !bl);
        if (bl2) {
            this.duplicateNodes(tSGraph, bl);
        }
        if (bl3) {
            this.duplicateEdges(tSGraph, bl);
        }
    }

    void duplicateNodes(TSGraph tSGraph, boolean bl) {
        Iterator iterator = tSGraph.nodes().iterator();
        while (iterator.hasNext()) {
            TSNode tSNode = (TSNode)iterator.next();
            TSNode tSNode2 = this.getClonedNode(tSNode, bl);
            if (tSNode2 == null || tSNode2.isOwned()) continue;
            this.insert(tSNode2);
            tSNode2.copy(tSNode, bl);
        }
    }

    void duplicateEdges(TSGraph tSGraph, boolean bl) {
        TSEdge tSEdge;
        TSSystem.tsAssert(tSGraph.levelNumber() == this.levelNumber() || !bl);
        Iterator iterator = tSGraph.edges().iterator();
        while (iterator.hasNext()) {
            tSEdge = (TSEdge)iterator.next();
            this.duplicateEdge(tSEdge, bl);
        }
        iterator = tSGraph.disconnectedEdges().iterator();
        while (iterator.hasNext()) {
            tSEdge = (TSEdge)iterator.next();
            this.duplicateEdge(tSEdge, bl);
        }
    }

    void duplicateEdge(TSEdge tSEdge, boolean bl) {
        TSEdge tSEdge2 = this.getClonedEdge(tSEdge, bl);
        if (tSEdge2 != null && !tSEdge2.isOwned()) {
            TSNode tSNode = tSEdge.getSourceNode().getUtilityObject() != null ? (TSNode)tSEdge.getSourceNode().getUtilityObject() : tSEdge.getSourceNode();
            TSNode tSNode2 = tSEdge.getTargetNode().getUtilityObject() != null ? (TSNode)tSEdge.getTargetNode().getUtilityObject() : tSEdge.getTargetNode();
            if (tSEdge2.levelNumber() == tSNode.levelNumber() && tSEdge2.levelNumber() == tSNode2.levelNumber()) {
                tSEdge2.setSourceNode(tSNode);
                tSEdge2.setTargetNode(tSNode2);
                this.insert(tSEdge2);
                if (!tSEdge.isConnected()) {
                    tSEdge2.disconnect();
                }
                tSEdge2.copy(tSEdge, bl);
            }
        }
    }

    public TSNode getClonedNode(TSNode tSNode, boolean bl) {
        TSNode tSNode2 = null;
        if (tSNode != null) {
            if (tSNode.getUtilityObject() != null) {
                tSNode2 = (TSNode)tSNode.getUtilityObject();
            } else {
                tSNode2 = bl ? (TSNode)tSNode.clone(true) : this.newNode(tSNode.getType());
                tSNode.setUtilityObject(tSNode2);
            }
        }
        return tSNode2;
    }

    public TSEdge getClonedEdge(TSEdge tSEdge, boolean bl) {
        TSEdge tSEdge2 = null;
        if (tSEdge != null) {
            if (tSEdge.getUtilityObject() != null) {
                tSEdge2 = (TSEdge)tSEdge.getUtilityObject();
            } else {
                tSEdge2 = bl ? (TSEdge)tSEdge.clone(true) : (this.getOwnerGraphManager() != null ? this.getOwnerGraphManager().newEdge(this.getType()) : this.newEdge(tSEdge.getType()));
                tSEdge.setUtilityObject(tSEdge2);
            }
        }
        return tSEdge2;
    }

    protected void createMapping(Map map, Map map2) {
        TSGraphObject tSGraphObject;
        Iterator iterator = this.nodes().iterator();
        if (this.getUtilityObject() instanceof TSGraph) {
            tSGraphObject = (TSGraph)this.getUtilityObject();
            TSGraph.map(this, tSGraphObject, map, map2);
        }
        while (iterator.hasNext()) {
            tSGraphObject = (TSNode)iterator.next();
            ((TSNode)tSGraphObject).createMapping(map, map2);
        }
        iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSEdge)iterator.next();
            ((TSEdge)tSGraphObject).createMapping(map, map2);
        }
        iterator = this.disconnectedEdges().iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSEdge)iterator.next();
            ((TSEdge)tSGraphObject).createMapping(map, map2);
        }
    }

    public static final void map(TSGraphObject tSGraphObject, TSGraphObject tSGraphObject2, Map map, Map map2) {
        if (map != null) {
            map.put(tSGraphObject, tSGraphObject2);
        }
        if (map2 != null) {
            map2.put(tSGraphObject2, tSGraphObject);
        }
    }

    protected String getAttributeString() {
        return super.getAttributeString() + TSSystem.eol + "\tnodes = " + this.numberOfNodes() + TSSystem.eol + "\tedges = " + this.numberOfEdges() + TSSystem.eol + "\tdisconnected edges = " + this.freeSet.size();
    }

    public boolean isChildGraph() {
        boolean bl = false;
        if (this.getParent() != null) {
            bl = true;
        }
        return bl;
    }

    public TSGraphMember getParent() {
        TSChildGraphForestEdge tSChildGraphForestEdge;
        TSGraphMember tSGraphMember = null;
        if (this.getChildGraphForestNode() != null && (tSChildGraphForestEdge = (TSChildGraphForestEdge)this.getChildGraphForestNode().inEdge()) != null) {
            tSGraphMember = tSChildGraphForestEdge.getGraphMember();
        }
        return tSGraphMember;
    }

    protected TSNode newNode() {
        return new TSNode();
    }

    protected TSNode newNode(int n) {
        return new TSNode();
    }

    protected TSEdge newEdge() {
        return new TSEdge();
    }

    protected TSEdge newEdge(int n) {
        return new TSEdge();
    }

    protected void onEdgeBecomesDisconnected(TSEdge tSEdge) {
        TSSystem.tsAssert(tSEdge != null);
        TSSystem.tsAssert(tSEdge.isConnected());
        TSSystem.tsAssert(tSEdge.isOwned());
        TSSystem.tsAssert(tSEdge.getOwner() == this);
        f0 f02 = tSEdge.getEdgeListLocation();
        TSSystem.tsAssert(f02 != null);
        TSSystem.tsAssert(f02.c() == this.edgeSet);
        ((de)this.edgeSet).c(f02);
        ((de)this.freeSet).b(f02);
    }

    protected void onEdgeBecomesConnected(TSEdge tSEdge) {
        TSSystem.tsAssert(tSEdge != null);
        TSSystem.tsAssert(!tSEdge.isConnected());
        f0 f02 = tSEdge.getEdgeListLocation();
        TSSystem.tsAssert(f02 != null);
        TSSystem.tsAssert(f02.c() == this.freeSet);
        ((de)this.freeSet).c(f02);
        ((de)this.edgeSet).b(f02);
    }

    protected void finalize() {
    }

    public void dispose() {
        if (this.isOwned()) {
            this.getOwnerGraphManager().discard(this);
        } else if (!this.isDiscarded()) {
            this.onDiscard(this.getOwner());
        }
    }

    public long assignIDs(TSGraphObjectTable tSGraphObjectTable, long l) {
        TSGraphMember tSGraphMember;
        if (l >= 0L) {
            tSGraphObjectTable.put(l++, this);
        } else {
            tSGraphObjectTable.put(this.getID(), this);
        }
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSNode)iterator.next();
            l = ((TSNode)tSGraphMember).assignIDs(tSGraphObjectTable, l);
        }
        iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSEdge)iterator.next();
            l = ((TSEdge)tSGraphMember).assignIDs(tSGraphObjectTable, l);
        }
        iterator = this.disconnectedEdges().iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSEdge)iterator.next();
            l = ((TSEdge)tSGraphMember).assignIDs(tSGraphObjectTable, l);
        }
        return l;
    }

    public void nullifyUtilityObject() {
        TSGraphMember tSGraphMember;
        super.nullifyUtilityObject();
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSNode)iterator.next();
            tSGraphMember.nullifyUtilityObject();
        }
        iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSEdge)iterator.next();
            tSGraphMember.nullifyUtilityObject();
        }
        iterator = this.disconnectedEdges().iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSEdge)iterator.next();
            tSGraphMember.nullifyUtilityObject();
        }
    }

    public void setAllMarked(boolean bl) {
        TSGraphMember tSGraphMember;
        super.setAllMarked(bl);
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSNode)iterator.next();
            tSGraphMember.setAllMarked(bl);
        }
        iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSEdge)iterator.next();
            tSGraphMember.setAllMarked(bl);
        }
        iterator = this.disconnectedEdges().iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSEdge)iterator.next();
            tSGraphMember.setAllMarked(bl);
        }
    }

    public boolean hasMarkedObject() {
        TSGraphMember tSGraphMember;
        if (this.isMarked()) {
            return true;
        }
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSNode)iterator.next();
            if (!tSGraphMember.hasMarkedObject()) continue;
            return true;
        }
        iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSEdge)iterator.next();
            if (!tSGraphMember.hasMarkedObject()) continue;
            return true;
        }
        iterator = this.disconnectedEdges().iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSEdge)iterator.next();
            if (!tSGraphMember.hasMarkedObject()) continue;
            return true;
        }
        return false;
    }

    public void readGMF(Reader reader) throws IOException {
        this.readGMF(reader, true);
    }

    public void readGMF(Reader reader, boolean bl) throws IOException {
        this.emptyTopology();
        this.newGMFReader(reader).a(this, bl);
    }

    protected cw newGMFReader(Reader reader) {
        return new cw(reader);
    }

    public boolean userObjectInUse() {
        boolean bl = super.userObjectInUse();
        Iterator iterator = this.nodes().iterator();
        while (!bl && iterator.hasNext()) {
            bl = ((TSNode)iterator.next()).userObjectInUse();
        }
        iterator = this.edges().iterator();
        while (!bl && iterator.hasNext()) {
            bl = ((TSEdge)iterator.next()).userObjectInUse();
        }
        return bl;
    }

    public void nullifyUserObject() {
        super.nullifyUserObject();
        Iterator iterator = this.nodes().iterator();
        while (iterator.hasNext()) {
            ((TSNode)iterator.next()).nullifyUserObject();
        }
        iterator = this.edges().iterator();
        while (iterator.hasNext()) {
            ((TSEdge)iterator.next()).nullifyUserObject();
        }
    }

    public boolean utilityObjectInUse() {
        boolean bl = super.utilityObjectInUse();
        Iterator iterator = this.nodes().iterator();
        while (!bl && iterator.hasNext()) {
            bl = ((TSNode)iterator.next()).utilityObjectInUse();
        }
        iterator = this.edges().iterator();
        while (!bl && iterator.hasNext()) {
            bl = ((TSEdge)iterator.next()).utilityObjectInUse();
        }
        return bl;
    }

    public TSGraphManager getOwnerGraphManager() {
        return (TSGraphManager)this.owner;
    }

    void setGraphListLocation(f0 f02) {
        this.listLocation = f02;
    }

    f0 getGraphListLocation() {
        return this.listLocation;
    }

    public boolean isIntergraph() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isHideGraph() {
        return false;
    }

    public boolean isNestedWithinEdge() {
        TSGraphMember tSGraphMember = this.getParent();
        while (tSGraphMember != null) {
            if (tSGraphMember instanceof TSEdge) {
                return true;
            }
            TSGraph tSGraph = tSGraphMember.getOwnerGraph();
            if (tSGraph != null) {
                tSGraphMember = tSGraph.getParent();
                continue;
            }
            tSGraphMember = null;
        }
        return false;
    }

    protected void setIntergraph(boolean bl) {
        this.flags = bl ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public int getType() {
        return 0;
    }

    public TSChildGraphForestNode getChildGraphForestNode() {
        return this.childGraphForestNode;
    }

    public void setChildGraphForestNode(TSChildGraphForestNode tSChildGraphForestNode) {
        this.childGraphForestNode = tSChildGraphForestNode;
    }
}

