/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.xml;

import com.tomsawyer.xml.TSXMLUtilities;
import com.tomsawyer.xml.TSXMLWriter;
import com.tomsawyer.xml.util.TSObjectTable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class TSTopLevelXMLWriter
extends TSXMLWriter {
    private TSObjectTable objectTable;
    boolean indenting = true;
    String encoding;
    Writer writer;
    boolean usingTemplates = true;
    String schemaLocation;

    public TSTopLevelXMLWriter() {
    }

    public TSTopLevelXMLWriter(Writer writer) {
        this.writer = writer;
        String string = "UTF-8";
        if (this.writer instanceof OutputStreamWriter) {
            string = ((OutputStreamWriter)this.writer).getEncoding();
        }
        this.setEncoding(string);
    }

    public TSTopLevelXMLWriter(String string, boolean bl, boolean bl2) throws FileNotFoundException {
        this(TSTopLevelXMLWriter.getWriterFromFile(new File(string), bl, bl2));
        if (bl2) {
            this.setIndenting(false);
        }
    }

    public TSTopLevelXMLWriter(String string) throws FileNotFoundException {
        this(string, false, false);
    }

    public TSTopLevelXMLWriter(File file, boolean bl, boolean bl2) throws FileNotFoundException {
        this(TSTopLevelXMLWriter.getWriterFromFile(file, bl, bl2));
        if (bl2) {
            this.setIndenting(false);
        }
    }

    public TSTopLevelXMLWriter(File file) throws FileNotFoundException {
        this(file, false, false);
    }

    protected static Writer getWriterFromFile(File file, boolean bl, boolean bl2) throws FileNotFoundException {
        OutputStreamWriter outputStreamWriter = null;
        String string = "UTF-8";
        if (bl) {
            string = "UTF-16";
        }
        try {
            if (!bl2) {
                outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), string);
            } else {
                try {
                    outputStreamWriter = new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(file)), string);
                }
                catch (IOException iOException) {}
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return outputStreamWriter;
    }

    public TSObjectTable getObjectTable() {
        if (this.objectTable == null) {
            this.objectTable = new TSObjectTable();
        }
        return this.objectTable;
    }

    public void setObjectTable(TSObjectTable tSObjectTable) {
        this.objectTable = tSObjectTable;
        Iterator iterator = tSObjectTable.getIDs().iterator();
        long l = 0L;
        while (iterator.hasNext()) {
            Long l2;
            Object e = iterator.next();
            if (!(e instanceof Long) || (l2 = (Long)e) <= l) continue;
            l = l2;
        }
        if (l < this.idSeed) {
            this.idSeed = l + 1L;
        }
    }

    public boolean isIndenting() {
        boolean bl = this.indenting;
        if (this.getParent() != null) {
            bl = ((TSTopLevelXMLWriter)this.getParent()).isIndenting();
        }
        return bl;
    }

    public void setIndenting(boolean bl) {
        this.indenting = bl;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
        if (this.writer instanceof OutputStreamWriter) {
            this.encoding = ((OutputStreamWriter)this.writer).getEncoding();
        }
        this.setEncoding(this.encoding);
    }

    public void setFile(File file, boolean bl, boolean bl2) throws FileNotFoundException {
        this.setWriter(TSTopLevelXMLWriter.getWriterFromFile(file, bl, bl2));
        if (bl2) {
            this.setIndenting(false);
        }
    }

    public void setFile(File file) throws FileNotFoundException {
        this.setFile(file, false, false);
    }

    public void setFileName(String string, boolean bl, boolean bl2) throws FileNotFoundException {
        this.setFile(new File(string), bl, bl2);
    }

    public void setFileName(String string) throws FileNotFoundException {
        this.setFile(new File(string));
    }

    public void write() {
        if (this.getParent() == null) {
            try {
                String string;
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                Element element = document.createElement(this.getDefaultRootElementName());
                if (this.getVersion() != null) {
                    TSXMLUtilities.writeStringAttribute("version", this.getVersion(), element);
                }
                if (this.getProductName() != null) {
                    TSXMLUtilities.writeStringAttribute("product", this.getProductName(), element);
                }
                if (this.getProductEdition() != null) {
                    TSXMLUtilities.writeStringAttribute("edition", this.getProductEdition(), element);
                }
                if ((string = this.getSchemaLocation()) != null) {
                    TSXMLUtilities.writeStringAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", element);
                    TSXMLUtilities.writeStringAttribute("xsi:noNamespaceSchemaLocation", string, element);
                }
                Element element2 = element;
                if (this.hasOwnRoot()) {
                    element2 = TSXMLUtilities.createElement(this.getTagName(), element);
                }
                this.populateDOMElement(element2);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("encoding", this.getEncoding());
                if (this.isIndenting()) {
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                }
                DOMSource dOMSource = new DOMSource(element);
                StreamResult streamResult = new StreamResult(this.writer);
                transformer.transform(dOMSource, streamResult);
                try {
                    this.writer.close();
                }
                catch (IOException iOException) {}
            }
            catch (TransformerException transformerException) {
                transformerException.printStackTrace();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
                System.err.println("Could not locate a factory class");
            }
        }
    }

    protected String getVersion() {
        return null;
    }

    protected String getProductName() {
        return null;
    }

    protected String getProductEdition() {
        return null;
    }

    protected String getDefaultRootElementName() {
        return "TSX";
    }

    protected boolean hasOwnRoot() {
        return true;
    }

    public String getID(Object object) {
        String string;
        if (this.getParent() != null) {
            string = this.getParent().getID(object);
        } else if (this.getObjectTable().contains(object)) {
            string = this.getObjectTable().getID(object);
        } else {
            string = this.nextID();
            this.getObjectTable().setID(string, object);
        }
        return string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    private void setEncoding(String string) {
        this.encoding = string;
    }

    protected abstract void setObjectToWrite(Object var1);

    public void setUsingTemplates(boolean bl) {
        this.usingTemplates = bl;
    }

    public boolean isUsingTemplates() {
        boolean bl = this.usingTemplates;
        if (this.getParent() != null) {
            bl = ((TSTopLevelXMLWriter)this.getParent()).isUsingTemplates();
        }
        return bl;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String string) {
        this.schemaLocation = string;
    }
}

