/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.xml.drawing;

import com.tomsawyer.complexity.TSDChildGraphForestEdge;
import com.tomsawyer.complexity.TSExpandedNodeExtension;
import com.tomsawyer.complexity.TSHidingManager;
import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.drawing.geometry.TSShape;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.xml.TSXMLUtilities;
import com.tomsawyer.xml.TSXMLWriter;
import com.tomsawyer.xml.drawing.TSDEdgeXMLWriter;
import com.tomsawyer.xml.drawing.TSDGraphXMLWriter;
import com.tomsawyer.xml.drawing.fd;
import com.tomsawyer.xml.graph.TSEdgeXMLWriter;
import com.tomsawyer.xml.graph.TSGraphManagerXMLWriter;
import com.tomsawyer.xml.graph.TSGraphXMLWriter;
import com.tomsawyer.xml.graph.fe;
import com.tomsawyer.xml.template.ia;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;

public class TSDGraphManagerXMLWriter
extends TSGraphManagerXMLWriter {
    static final TSShape RECTANGULAR_SHAPE = new TSRect();

    public TSDGraphManagerXMLWriter() {
    }

    public TSDGraphManagerXMLWriter(Writer writer) {
        super(writer);
    }

    public TSDGraphManagerXMLWriter(File file, boolean bl, boolean bl2) throws FileNotFoundException {
        super(file, bl, bl2);
    }

    public TSDGraphManagerXMLWriter(File file) throws FileNotFoundException {
        super(file);
    }

    public TSDGraphManagerXMLWriter(String string, boolean bl, boolean bl2) throws FileNotFoundException {
        super(string, bl, bl2);
    }

    public TSDGraphManagerXMLWriter(String string) throws FileNotFoundException {
        super(string);
    }

    protected TSGraphXMLWriter newGraphXMLWriter() {
        return new TSDGraphXMLWriter();
    }

    protected TSEdgeXMLWriter newEdgeXMLWriter() {
        return new TSDEdgeXMLWriter();
    }

    public void populateDOMElement(Element element) {
        if (this.getGraphManager() instanceof TSDGraphManager) {
            Element element2 = TSXMLUtilities.createElement("resources", element);
            this.createResources(element2);
            if (element2.getChildNodes().getLength() == 0) {
                element.removeChild(element2);
            }
            this.okToWriteTemplates = false;
            super.populateDOMElement(element);
            this.okToWriteTemplates = true;
            Element element3 = TSXMLUtilities.findElement(element, "instances");
            if (element3 != null) {
                Element element4 = TSXMLUtilities.createElement("complexity", element3);
                this.createComplexity(element4);
                if (element4.getChildNodes().getLength() == 0) {
                    element3.removeChild(element4);
                }
                Element element5 = TSXMLUtilities.createElement("rootGraph", element3);
                fe.b(this.getID(((TSDGraphManager)this.getGraphManager()).getMainDisplayGraph()), element5);
                if (this.isUsingTemplates()) {
                    ia.a(element);
                }
            }
        } else {
            super.populateDOMElement(element);
        }
    }

    protected void createResources(Element element) {
        this.createShapes(element);
    }

    private void createShapes(Element element) {
        Object object;
        Object object2;
        LinkedList<TSShape> linkedList = new LinkedList<TSShape>();
        boolean bl = false;
        Iterator iterator = ((TSDGraphManager)this.getGraphManager()).buildNodes(0, true).iterator();
        while (iterator.hasNext()) {
            TSExpandedNodeExtension tSExpandedNodeExtension;
            object2 = (TSDNode)iterator.next();
            bl = this.addShape(((TSDNode)object2).getShape(), linkedList);
            if (((TSDNode)object2).isExpanded() && (tSExpandedNodeExtension = ((TSDChildGraphForestEdge)(object = (TSDChildGraphForestEdge)((TSGraphMember)object2).getChildGraphForestEdge())).getExpandedNodeExtension()) != null && tSExpandedNodeExtension.getPreExpandShape() != null) {
                bl = this.addShape(tSExpandedNodeExtension.getPreExpandShape(), linkedList);
            }
            if (((TSDNode)object2).numberOfConnectors() <= 0) continue;
            Iterator iterator2 = ((TSDNode)object2).connectors().iterator();
            while (iterator2.hasNext()) {
                object = (TSConnector)iterator2.next();
                bl = this.addShape(((TSConnector)object).getShape(), linkedList);
            }
        }
        if (bl) {
            linkedList.add(0, RECTANGULAR_SHAPE);
        }
        if (!linkedList.isEmpty()) {
            object2 = TSXMLUtilities.createElement("shapes", element);
            object = linkedList.iterator();
            while (object.hasNext()) {
                TSShape tSShape = (TSShape)object.next();
                fd.a(tSShape, (TSXMLWriter)this, (Element)object2);
            }
        }
    }

    private boolean addShape(TSShape tSShape, List list) {
        boolean bl = false;
        if (!(tSShape instanceof TSRect) && !list.contains(tSShape)) {
            list.add(tSShape);
        } else {
            bl = true;
        }
        return bl;
    }

    private void createComplexity(Element element) {
        this.createNestingRelations(element);
        this.createMetaEdges(element);
        this.createHiddenObjects(element);
        this.createFolderNodes(element);
    }

    private void createNestingRelations(Element element) {
        Element element2 = TSXMLUtilities.createElement("nestingRelations", element);
        Iterator iterator = this.getGraphManager().graphs(false).iterator();
        while (iterator.hasNext()) {
            TSDGraph tSDGraph = (TSDGraph)iterator.next();
            TSGraphMember tSGraphMember = tSDGraph.getParent();
            if (tSGraphMember == null || !(tSGraphMember instanceof TSDNode) || tSGraphMember.getChildGraphForestEdge() == null) continue;
            TSDNode tSDNode = (TSDNode)tSGraphMember;
            Element element3 = TSXMLUtilities.createElement("nestingRelation", element2);
            this.createNestingRelation(element3, tSDNode);
        }
        if (element2.getChildNodes().getLength() == 0) {
            element.removeChild(element2);
        }
    }

    protected void createNestingRelation(Element element, TSDNode tSDNode) {
        TSDChildGraphForestEdge tSDChildGraphForestEdge = (TSDChildGraphForestEdge)tSDNode.getChildGraphForestEdge();
        TSXMLUtilities.writeStringAttribute("childGraphRelation", this.getID(tSDChildGraphForestEdge), element);
        Element element2 = TSXMLUtilities.createElement("expanded", element);
        fe.b(String.valueOf(tSDNode.isExpanded()), element2);
        TSDGraph tSDGraph = (TSDGraph)tSDNode.getChildGraph();
        TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
        Element element3 = TSXMLUtilities.createElement("calculatedMargins", element);
        TSXMLUtilities.writeDoubleAttribute("left", tSGraphTailor.getLeftConstantMargin(), element3);
        TSXMLUtilities.writeDoubleAttribute("right", tSGraphTailor.getRightConstantMargin(), element3);
        TSXMLUtilities.writeDoubleAttribute("top", tSGraphTailor.getTopConstantMargin(), element3);
        TSXMLUtilities.writeDoubleAttribute("bottom", tSGraphTailor.getBottomConstantMargin(), element3);
        Element element4 = TSXMLUtilities.createElement("nestedMargins", element);
        Element element5 = TSXMLUtilities.createElement("constant", element4);
        TSXMLUtilities.writeDoubleAttribute("left", tSGraphTailor.getLeftNestedViewConstant(), element5);
        TSXMLUtilities.writeDoubleAttribute("right", tSGraphTailor.getRightNestedViewConstant(), element5);
        TSXMLUtilities.writeDoubleAttribute("top", tSGraphTailor.getTopNestedViewConstant(), element5);
        TSXMLUtilities.writeDoubleAttribute("bottom", tSGraphTailor.getBottomNestedViewConstant(), element5);
        Element element6 = TSXMLUtilities.createElement("proportional", element4);
        TSXMLUtilities.writeDoubleAttribute("left", tSGraphTailor.getLeftNestedViewProportional(), element6);
        TSXMLUtilities.writeDoubleAttribute("right", tSGraphTailor.getRightNestedViewProportional(), element6);
        TSXMLUtilities.writeDoubleAttribute("top", tSGraphTailor.getTopNestedViewProportional(), element6);
        TSXMLUtilities.writeDoubleAttribute("bottom", tSGraphTailor.getBottomNestedViewProportional(), element6);
    }

    private void createMetaEdges(Element element) {
        List list = this.getGraphManager().buildEdges(4);
        if (!list.isEmpty()) {
            Element element2 = TSXMLUtilities.createElement("metaEdges", element);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TSDEdge tSDEdge = (TSDEdge)iterator.next();
                Element element3 = TSXMLUtilities.createElement("metaEdge", element2);
                fe.a(this.getID(tSDEdge), element3);
            }
        }
    }

    private void createHiddenObjects(Element element) {
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.getGraphManager();
        TSHidingManager tSHidingManager = TSHidingManager.getManager(tSDGraphManager);
        Iterator iterator = tSDGraphManager.graphs().iterator();
        Element element2 = TSXMLUtilities.createElement("hiddenObjects", element);
        while (iterator.hasNext()) {
            TSDGraph tSDGraph = (TSDGraph)iterator.next();
            tSHidingManager.getHiddenObjects(tSDGraph);
            List list = tSHidingManager.getResultNodeList();
            list.addAll(tSHidingManager.getResultEdgeList());
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Object object;
                TSGraphObject tSGraphObject = (TSGraphObject)iterator2.next();
                if (tSGraphObject instanceof TSDEdge && (!((TSEdge)(object = (TSDEdge)tSGraphObject)).getSourceNode().isOwned() || !((TSEdge)object).getTargetNode().isOwned())) continue;
                object = TSXMLUtilities.createElement("hidden", element2);
                fe.a(this.getID(tSGraphObject), (Element)object);
            }
        }
        if (element2.getChildNodes().getLength() == 0) {
            element.removeChild(element2);
        }
    }

    private void createFolderNodes(Element element) {
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.getGraphManager();
        Element element2 = TSXMLUtilities.createElement("folders", element);
        Iterator iterator = tSDGraphManager.buildNodes(0, true).iterator();
        while (iterator.hasNext()) {
            TSDNode tSDNode = (TSDNode)iterator.next();
            if (!tSDNode.isFolderNode()) continue;
            Element element3 = TSXMLUtilities.createElement("folder", element2);
            fe.a(this.getID(tSDNode), element3);
        }
        if (element2.getChildNodes().getLength() == 0) {
            element.removeChild(element2);
        }
    }
}

