/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.batik.util.DoublyLinkedList;

public class RunnableQueue
implements Runnable {
    public static final RunnableQueueState RUNNING = new RunnableQueueState("Running");
    public static final RunnableQueueState SUSPENDING = new RunnableQueueState("Suspending");
    public static final RunnableQueueState SUSPENDED = new RunnableQueueState("Suspended");
    protected RunnableQueueState state;
    protected Object stateLock = new Object();
    protected DoublyLinkedList list = new DoublyLinkedList();
    protected int preemptCount = 0;
    protected RunHandler runHandler;
    protected Thread runnableQueueThread;
    private static int threadCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RunnableQueue createRunnableQueue() {
        RunnableQueue result;
        RunnableQueue runnableQueue = result = new RunnableQueue();
        synchronized (runnableQueue) {
            Thread t = new Thread((Runnable)result, "RunnableQueue-" + threadCount++);
            t.setDaemon(true);
            t.start();
            while (result.getThread() == null) {
                try {
                    result.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        RunnableQueue runnableQueue = this;
        synchronized (runnableQueue) {
            this.runnableQueueThread = Thread.currentThread();
            this.notify();
        }
        try {
            while (!Thread.currentThread().isInterrupted()) {
                Runnable rable;
                Link l;
                Object object = this.stateLock;
                synchronized (object) {
                    if (this.state != RUNNING) {
                        this.state = SUSPENDED;
                        this.stateLock.notifyAll();
                        this.executionSuspended();
                        while (this.state != RUNNING) {
                            this.state = SUSPENDED;
                            this.stateLock.wait();
                        }
                        this.executionResumed();
                    }
                }
                object = this.list;
                synchronized (object) {
                    if (this.state == SUSPENDING) {
                        continue;
                    }
                    l = (Link)this.list.pop();
                    if (this.preemptCount != 0) {
                        --this.preemptCount;
                    }
                    if (l == null) {
                        this.list.wait();
                        continue;
                    }
                    rable = l.runnable;
                }
                try {
                    rable.run();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                l.unlock();
                this.runnableInvoked(rable);
            }
        }
        catch (InterruptedException interruptedException) {
            RunnableQueue runnableQueue2 = this;
            synchronized (runnableQueue2) {
                this.runnableQueueThread = null;
            }
        }
        finally {
            RunnableQueue t = this;
            synchronized (t) {
                this.runnableQueueThread = null;
            }
        }
    }

    public Thread getThread() {
        return this.runnableQueueThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable r) {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.push(new Link(r));
            this.list.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndWait(Runnable r) throws InterruptedException {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        if (this.runnableQueueThread == Thread.currentThread()) {
            throw new IllegalStateException("Cannot be called from the RunnableQueue thread");
        }
        LockableLink l = new LockableLink(r);
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.push(l);
            this.list.notify();
        }
        l.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preemptLater(Runnable r) {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.add(this.preemptCount, new Link(r));
            ++this.preemptCount;
            this.list.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preemptAndWait(Runnable r) throws InterruptedException {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        if (this.runnableQueueThread == Thread.currentThread()) {
            throw new IllegalStateException("Cannot be called from the RunnableQueue thread");
        }
        LockableLink l = new LockableLink(r);
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.add(this.preemptCount, l);
            ++this.preemptCount;
            this.list.notify();
        }
        l.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunnableQueueState getQueueState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendExecution(boolean waitTillSuspended) {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == SUSPENDED) {
                return;
            }
            if (this.state == RUNNING) {
                this.state = SUSPENDING;
                DoublyLinkedList doublyLinkedList = this.list;
                synchronized (doublyLinkedList) {
                    this.list.notify();
                }
            }
            if (waitTillSuspended) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeExecution() {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != RUNNING) {
                this.state = RUNNING;
                this.stateLock.notifyAll();
            }
        }
    }

    public Object getIteratorLock() {
        return this.list;
    }

    public Iterator iterator() {
        return new Iterator(){
            Link head;
            Link link;
            {
                this.head = (Link)RunnableQueue.this.list.getHead();
            }

            public boolean hasNext() {
                if (this.head == null) {
                    return false;
                }
                if (this.link == null) {
                    return true;
                }
                return this.link != this.head;
            }

            public Object next() {
                if (this.head == null || this.head == this.link) {
                    throw new NoSuchElementException();
                }
                if (this.link == null) {
                    this.link = (Link)this.head.getNext();
                    return this.head.runnable;
                }
                Runnable result = this.link.runnable;
                this.link = (Link)this.link.getNext();
                return result;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public synchronized void setRunHandler(RunHandler rh) {
        this.runHandler = rh;
    }

    public synchronized RunHandler getRunHandler() {
        return this.runHandler;
    }

    protected synchronized void executionSuspended() {
        if (this.runHandler != null) {
            this.runHandler.executionSuspended(this);
        }
    }

    protected synchronized void executionResumed() {
        if (this.runHandler != null) {
            this.runHandler.executionResumed(this);
        }
    }

    protected synchronized void runnableInvoked(Runnable rable) {
        if (this.runHandler != null) {
            this.runHandler.runnableInvoked(this, rable);
        }
    }

    protected static class LockableLink
    extends Link {
        protected boolean locked;

        public LockableLink(Runnable r) {
            super(r);
        }

        public boolean isLocked() {
            return this.locked;
        }

        public synchronized void lock() throws InterruptedException {
            this.locked = true;
            this.notify();
            this.wait();
        }

        public synchronized void unlock() throws InterruptedException {
            while (!this.locked) {
                this.wait();
            }
            this.notify();
        }
    }

    protected static class Link
    extends DoublyLinkedList.Node {
        public Runnable runnable;

        public Link(Runnable r) {
            this.runnable = r;
        }

        public void unlock() throws InterruptedException {
        }
    }

    public static interface RunHandler {
        public void runnableInvoked(RunnableQueue var1, Runnable var2);

        public void executionSuspended(RunnableQueue var1);

        public void executionResumed(RunnableQueue var1);
    }

    public static class RunnableQueueState {
        final String value;

        private RunnableQueueState(String value) {
            this.value = value.intern();
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "[RunnableQueueState: " + this.value + "]";
        }
    }
}

