/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.tables;

import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;
import oracle.toplink.essentials.internal.helper.DatabaseTable;

public class MetadataTable {
    protected String m_name;
    protected String m_schema;
    protected String m_catalog;
    protected MetadataLogger m_logger;
    protected DatabaseTable m_databaseTable;

    public MetadataTable(MetadataLogger logger) {
        this.m_logger = logger;
        this.m_databaseTable = new DatabaseTable();
    }

    public MetadataTable(Table table, MetadataLogger logger) {
        this(logger);
        if (table != null) {
            this.m_name = table.name();
            this.m_schema = table.schema();
            this.m_catalog = table.catalog();
            this.processName();
            this.processUniqueConstraints(table.uniqueConstraints());
        }
    }

    public String getCatalog() {
        return this.m_catalog;
    }

    public String getCatalogContext() {
        return "metadata_default_table_catalog";
    }

    public DatabaseTable getDatabaseTable() {
        return this.m_databaseTable;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNameContext() {
        return "metadata_default_table_name";
    }

    public String getSchema() {
        return this.m_schema;
    }

    public String getSchemaContext() {
        return "metadata_default_table_schema";
    }

    public boolean loadedFromXML() {
        return false;
    }

    protected void processName() {
        if (!this.m_name.equals("")) {
            this.setName(MetadataHelper.getFullyQualifiedTableName(this.m_name, this.m_catalog, this.m_schema));
        }
    }

    protected void processUniqueConstraints(UniqueConstraint[] uniqueConstraints) {
        for (UniqueConstraint uniqueConstraint : uniqueConstraints) {
            this.m_databaseTable.addUniqueConstraints(uniqueConstraint.columnNames());
        }
    }

    public void setName(String name) {
        this.m_databaseTable.setPossiblyQualifiedName(name);
    }
}

