/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.BrokenDataShadow;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DataShadow;
import org.openide.loaders.DefaultDataObject;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.InstanceDataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.OperationListener;
import org.openide.loaders.ShadowChangeAdapter;
import org.openide.loaders.UniFileLoader;
import org.openide.loaders.XMLDataObject;
import org.openide.modules.ModuleInfo;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataLoaderPool
implements Serializable {
    static final long serialVersionUID = -360141823874889956L;
    private static MultiFileLoader[] systemLoaders;
    private static MultiFileLoader[] defaultLoaders;
    private static DataLoaderPool DEFAULT;
    private transient DataLoader[] loaderArray;
    private transient List<DataLoader> allLoaders;
    private transient int cntchanges;
    private transient EventListenerList listeners;
    private transient DataLoader preferredLoader;
    private static final DataLoader.RecognizedFiles emptyDataLoaderRecognized;

    public static synchronized DataLoaderPool getDefault() {
        if (DEFAULT == null && (DEFAULT = (DataLoaderPool)Lookup.getDefault().lookup(DataLoaderPool.class)) == null) {
            DEFAULT = new DefaultPool();
        }
        return DEFAULT;
    }

    protected DataLoaderPool() {
    }

    protected DataLoaderPool(DataLoader dataLoader) {
        this.preferredLoader = dataLoader;
    }

    protected abstract Enumeration<? extends DataLoader> loaders();

    public final synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(ChangeListener.class, changeListener);
    }

    public final synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners != null) {
            this.listeners.remove(ChangeListener.class, changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray;
        DataLoaderPool dataLoaderPool = this;
        synchronized (dataLoaderPool) {
            ++this.cntchanges;
            this.loaderArray = null;
            this.allLoaders = null;
            if (this.listeners == null) {
                return;
            }
            objectArray = this.listeners.getListenerList();
        }
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ChangeListener changeListener = (ChangeListener)objectArray[i + 1];
            changeListener.stateChanged(changeEvent);
        }
    }

    public static OperationListener createWeakOperationListener(OperationListener operationListener, Object object) {
        return (OperationListener)WeakListeners.create(OperationListener.class, (EventListener)operationListener, (Object)object);
    }

    public final synchronized void addOperationListener(OperationListener operationListener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(OperationListener.class, operationListener);
    }

    public final synchronized void removeOperationListener(OperationListener operationListener) {
        if (this.listeners != null) {
            this.listeners.remove(OperationListener.class, operationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void fireOperationEvent(OperationEvent operationEvent, int n) {
        Object[] objectArray;
        DataLoaderPool dataLoaderPool = this;
        synchronized (dataLoaderPool) {
            if (this.listeners == null) {
                return;
            }
            objectArray = this.listeners.getListenerList();
        }
        block12: for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != OperationListener.class) continue;
            OperationListener operationListener = (OperationListener)objectArray[i + 1];
            switch (n) {
                case 1: {
                    operationListener.operationCopy((OperationEvent.Copy)operationEvent);
                    continue block12;
                }
                case 2: {
                    operationListener.operationMove((OperationEvent.Move)operationEvent);
                    continue block12;
                }
                case 3: {
                    operationListener.operationDelete(operationEvent);
                    continue block12;
                }
                case 4: {
                    operationListener.operationRename((OperationEvent.Rename)operationEvent);
                    continue block12;
                }
                case 5: {
                    operationListener.operationCreateShadow((OperationEvent.Copy)operationEvent);
                    continue block12;
                }
                case 6: {
                    operationListener.operationCreateFromTemplate((OperationEvent.Copy)operationEvent);
                    continue block12;
                }
                case 7: {
                    operationListener.operationPostCreate(operationEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Enumeration<DataLoader> allLoaders() {
        int n;
        List<DataLoader> list;
        Object object = this;
        synchronized (object) {
            list = this.allLoaders;
            n = this.cntchanges;
        }
        if (list == null) {
            list = new ArrayList<DataLoader>();
            if (this.preferredLoader != null) {
                list.add(this.preferredLoader);
            }
            list.addAll(Arrays.asList(DataLoaderPool.getSystemLoaders()));
            object = this.loaders();
            while (object.hasMoreElements()) {
                list.add((DataLoader)((Object)object.nextElement()));
            }
            list.addAll(Arrays.asList(DataLoaderPool.getDefaultLoaders()));
            DataLoaderPool dataLoaderPool = this;
            synchronized (dataLoaderPool) {
                if (n == this.cntchanges) {
                    this.allLoaders = list;
                }
            }
        }
        return Collections.enumeration(list);
    }

    public DataLoader[] toArray() {
        DataLoader[] dataLoaderArray = this.loaderArray;
        if (dataLoaderArray != null) {
            return dataLoaderArray;
        }
        ArrayList<DataLoader> arrayList = new ArrayList<DataLoader>();
        Enumeration<? extends DataLoader> enumeration = this.loaders();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        dataLoaderArray = new DataLoader[arrayList.size()];
        dataLoaderArray = arrayList.toArray(dataLoaderArray);
        this.loaderArray = dataLoaderArray;
        return dataLoaderArray;
    }

    public final DataLoader firstProducerOf(Class<? extends DataObject> clazz) {
        Enumeration<DataLoader> enumeration = this.allLoaders();
        while (enumeration.hasMoreElements()) {
            DataLoader dataLoader = enumeration.nextElement();
            if (!dataLoader.getRepresentationClass().isAssignableFrom(clazz)) continue;
            return dataLoader;
        }
        return null;
    }

    public final Enumeration<DataLoader> producersOf(final Class<? extends DataObject> clazz) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ProducerOf
        implements Enumerations.Processor<DataLoader, DataLoader> {
            ProducerOf() {
            }

            public DataLoader process(DataLoader dataLoader, Collection collection) {
                return clazz.isAssignableFrom(dataLoader.getRepresentationClass()) ? dataLoader : null;
            }
        }
        return Enumerations.filter(this.allLoaders(), (Enumerations.Processor)new ProducerOf());
    }

    public DataObject findDataObject(FileObject fileObject) throws IOException {
        return this.findDataObject(fileObject, emptyDataLoaderRecognized);
    }

    public DataObject findDataObject(FileObject fileObject, DataLoader.RecognizedFiles recognizedFiles) throws IOException {
        Object object;
        DataLoader dataLoader = DataLoaderPool.getPreferredLoader(fileObject);
        if (dataLoader != null && (object = dataLoader.findDataObject(fileObject, recognizedFiles)) != null) {
            return object;
        }
        object = this.allLoaders();
        while (object.hasMoreElements()) {
            DataLoader dataLoader2 = (DataLoader)((Object)object.nextElement());
            DataObject dataObject = dataLoader2.findDataObject(fileObject, recognizedFiles);
            if (dataObject == null) continue;
            return dataObject;
        }
        return null;
    }

    public static void setPreferredLoader(FileObject fileObject, DataLoader dataLoader) throws IOException {
        DataLoader dataLoader2 = DataLoaderPool.getPreferredLoader(fileObject);
        if (dataLoader2 == dataLoader) {
            return;
        }
        if (dataLoader == null) {
            fileObject.setAttribute("NetBeansAttrAssignedLoader", null);
        } else {
            Class<?> clazz = ((Object)((Object)dataLoader)).getClass();
            Iterator iterator = Lookup.getDefault().lookupAll(ModuleInfo.class).iterator();
            String string = null;
            while (iterator.hasNext()) {
                ModuleInfo moduleInfo = (ModuleInfo)iterator.next();
                if (!moduleInfo.owns(clazz)) continue;
                string = moduleInfo.getCodeNameBase();
                break;
            }
            fileObject.setAttribute("NetBeansAttrAssignedLoader", (Object)clazz.getName());
            fileObject.setAttribute("NetBeansAttrAssignedLoaderModule", string);
        }
        if (!DataObjectPool.getPOOL().revalidate(Collections.singleton(fileObject)).isEmpty()) {
            DataObject.LOG.fine("It was not possible to invalidate data object: " + fileObject);
        }
    }

    public static DataLoader getPreferredLoader(FileObject fileObject) {
        String string = (String)fileObject.getAttribute("NetBeansAttrAssignedLoader");
        if (string != null) {
            Object object;
            String string2 = (String)fileObject.getAttribute("NetBeansAttrAssignedLoaderModule");
            if (string2 != null) {
                object = Lookup.getDefault().lookupAll(ModuleInfo.class).iterator();
                boolean bl = false;
                while (object.hasNext()) {
                    ModuleInfo moduleInfo = (ModuleInfo)object.next();
                    if (!moduleInfo.getCodeNameBase().equals(string2)) continue;
                    if (moduleInfo.isEnabled()) {
                        bl = true;
                        break;
                    }
                    return null;
                }
                if (!bl) {
                    return null;
                }
            }
            try {
                object = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                if (object == null) {
                    object = DataLoaderPool.class.getClassLoader();
                }
                return DataLoader.getLoader(Class.forName(string, true, (ClassLoader)object).asSubclass(DataLoader.class));
            }
            catch (Exception exception) {
                Logger.getLogger(DataLoaderPool.class.getName()).log(Level.WARNING, null, exception);
            }
        }
        return null;
    }

    private static synchronized MultiFileLoader[] getSystemLoaders() {
        if (systemLoaders == null) {
            systemLoaders = new MultiFileLoader[]{DataLoader.getLoader(ShadowLoader.class), DataLoader.getLoader(InstanceLoaderSystem.class)};
        }
        return systemLoaders;
    }

    private static synchronized MultiFileLoader[] getDefaultLoaders() {
        if (defaultLoaders == null) {
            defaultLoaders = new MultiFileLoader[]{DataLoader.getLoader(FolderLoader.class), DataLoader.getLoader(XMLDataObject.Loader.class), DataLoader.getLoader(InstanceLoader.class), DataLoader.getLoader(DefaultLoader.class)};
        }
        return defaultLoaders;
    }

    static MultiFileLoader getDefaultFileLoader() {
        return DataLoaderPool.getDefaultLoaders()[3];
    }

    static MultiFileLoader getFolderLoader() {
        return DataLoaderPool.getDefaultLoaders()[0];
    }

    static MultiFileLoader getShadowLoader() {
        return DataLoaderPool.getSystemLoaders()[0];
    }

    static {
        emptyDataLoaderRecognized = new DataLoader.RecognizedFiles(){

            public void markRecognized(FileObject fileObject) {
            }
        };
    }

    static final class FolderLoader
    extends UniFileLoader {
        static final long serialVersionUID = -8325525104047820255L;

        public FolderLoader() {
            super("org.openide.loaders.DataFolder");
        }

        protected String actionsContext() {
            return "Loaders/folder/any/Actions";
        }

        protected String defaultDisplayName() {
            return NbBundle.getMessage(DataLoaderPool.class, (String)"LBL_folder_loader_display_name");
        }

        protected FileObject findPrimaryFile(FileObject fileObject) {
            if (fileObject.isFolder()) {
                return fileObject;
            }
            return null;
        }

        protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            return new FileEntry.Folder(multiDataObject, fileObject);
        }

        protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
            return new DataFolder(fileObject, this);
        }

        MultiDataObject createMultiObject(FileObject fileObject, final DataFolder dataFolder) throws DataObjectExistsException, IOException {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class NodeSharingDataFolder
            extends DataFolder {
                public NodeSharingDataFolder(FileObject fileObject) throws DataObjectExistsException, IllegalArgumentException {
                    super(fileObject, FolderLoader.this);
                }

                @Override
                protected Node createNodeDelegate() {
                    return new FilterNode(dataFolder.getNodeDelegate());
                }

                @Override
                Node getClonedNodeDelegate(DataFilter dataFilter) {
                    return new FilterNode(dataFolder.getClonedNodeDelegate(dataFilter));
                }
            }
            return new NodeSharingDataFolder(fileObject);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            try {
                super.readExternal(objectInput);
            }
            catch (OptionalDataException optionalDataException) {
                // empty catch block
            }
        }
    }

    private static final class ShadowLoader
    extends UniFileLoader {
        static final long serialVersionUID = -11013405787959120L;
        private static ShadowChangeAdapter changeAdapter = new ShadowChangeAdapter();

        public ShadowLoader() {
            super("org.openide.loaders.DataShadow");
        }

        protected String defaultDisplayName() {
            return NbBundle.getMessage(DataLoaderPool.class, (String)"LBL_shadow_loader_display_name");
        }

        protected FileObject findPrimaryFile(FileObject fileObject) {
            if (fileObject.hasExt("shadow")) {
                return fileObject;
            }
            return null;
        }

        protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            return new FileEntry(multiDataObject, fileObject);
        }

        protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
            try {
                DataObject dataObject = DataShadow.deserialize(fileObject);
                if (dataObject != null) {
                    return new DataShadow(fileObject, dataObject, this);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new BrokenDataShadow(fileObject, this);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        }
    }

    private static final class DefaultLoader
    extends MultiFileLoader {
        static final long serialVersionUID = -6761887227412396555L;

        public DefaultLoader() {
            super("org.openide.loaders.DefaultDataObject");
        }

        protected String actionsContext() {
            return "Loaders/content/unknown/Actions";
        }

        protected String defaultDisplayName() {
            return NbBundle.getMessage(DataLoaderPool.class, (String)"LBL_default_loader_display_name");
        }

        protected FileObject findPrimaryFile(FileObject fileObject) {
            if (fileObject.isFolder()) {
                return null;
            }
            return fileObject;
        }

        protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
            return new DefaultDataObject(fileObject, this);
        }

        protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            return new FileEntry(multiDataObject, fileObject);
        }

        protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            throw new UnsupportedOperationException();
        }

        void checkFiles(MultiDataObject multiDataObject) {
        }
    }

    private static class InstanceLoader
    extends UniFileLoader {
        static final long serialVersionUID = -3462727693843631328L;

        public InstanceLoader() {
            super("org.openide.loaders.InstanceDataObject");
        }

        protected void initialize() {
            super.initialize();
            this.setExtensions(null);
        }

        protected String actionsContext() {
            return "Loaders/application/x-nbsettings/Actions";
        }

        protected String defaultDisplayName() {
            return NbBundle.getMessage(DataLoaderPool.class, (String)"LBL_instance_loader_display_name");
        }

        protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
            InstanceDataObject instanceDataObject = new InstanceDataObject(fileObject, this);
            return instanceDataObject;
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeObject((Object)this);
            super.writeExternal(objectOutput);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            Object object = objectInput.readObject();
            if (object instanceof SystemAction[]) {
                this.setActions((SystemAction[])object);
                this.setExtensions(this.getExtensions());
            } else if (object instanceof ExtensionList) {
                ExtensionList extensionList = (ExtensionList)object;
                this.setExtensions(extensionList);
            } else {
                super.readExternal(objectInput);
                this.setExtensions(this.getExtensions());
            }
        }

        public void setExtensions(ExtensionList extensionList) {
            super.setExtensions(this.initExtensions(extensionList));
        }

        private ExtensionList initExtensions(ExtensionList extensionList) {
            String[] stringArray = this.getRequiredExt();
            if (extensionList == null) {
                extensionList = new ExtensionList();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                extensionList.addExtension(stringArray[i]);
            }
            return extensionList;
        }

        protected FileObject findPrimaryFile(FileObject fileObject) {
            FileObject fileObject2 = super.findPrimaryFile(fileObject);
            if (fileObject2 != null && fileObject2.getPath().equals("loaders.ser")) {
                try {
                    if (fileObject2.getFileSystem().isDefault()) {
                        return null;
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Logger.getLogger(DataLoaderPool.class.getName()).log(Level.WARNING, null, fileStateInvalidException);
                }
            }
            return fileObject2;
        }

        protected String[] getRequiredExt() {
            return new String[]{"instance", "ser", "settings"};
        }
    }

    private static class InstanceLoaderSystem
    extends InstanceLoader {
        private static final long serialVersionUID = -935749906623354837L;

        protected FileObject findPrimaryFile(FileObject fileObject) {
            FileSystem fileSystem = null;
            try {
                fileSystem = fileObject.getFileSystem();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return null;
            }
            if (fileSystem != Repository.getDefault().getDefaultFileSystem()) {
                return null;
            }
            return super.findPrimaryFile(fileObject);
        }

        protected String[] getRequiredExt() {
            return new String[]{"instance", "settings"};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultPool
    extends DataLoaderPool
    implements LookupListener {
        private final Lookup.Result<DataLoader> result = Lookup.getDefault().lookupResult(DataLoader.class);

        public DefaultPool() {
            this.result.addLookupListener((LookupListener)this);
        }

        @Override
        protected Enumeration<? extends DataLoader> loaders() {
            return Collections.enumeration(this.result.allInstances());
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.fireChangeEvent(new ChangeEvent(this));
        }
    }
}

