/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.CreateFromTemplateHandler;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DefaultDataObject;
import org.openide.loaders.FileEntry;
import org.openide.loaders.FilesSet;
import org.openide.loaders.FolderList;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.UserCancelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiDataObject
extends DataObject {
    static final long serialVersionUID = -7750146802134210308L;
    private static final Object cookieSetLock = new Object();
    private static final Object secondaryCreationLock = new Object();
    private static final RequestProcessor firingProcessor = new RequestProcessor("MDO PropertyChange processor");
    private static final RequestProcessor delayProcessor = new RequestProcessor("MDO Firing delayer");
    private RequestProcessor.Task delayedPropFilesTask;
    private static final Object delayedPropFilesLock = new Object();
    static final Logger ERR = Logger.getLogger(MultiDataObject.class.getName());
    private Entry primary = this.createPrimaryEntry(this, this.getPrimaryFile());
    private HashMap<FileObject, Entry> secondary;
    private CookieSet cookieSet;
    boolean checked = false;
    private ChangeAndBefore chLis;
    private static EmptyRecognizer RECOGNIZER = new EmptyRecognizer();

    public MultiDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
    }

    @Deprecated
    MultiDataObject(FileObject fileObject, DataLoader dataLoader) throws DataObjectExistsException {
        super(fileObject, dataLoader);
    }

    public final MultiFileLoader getMultiFileLoader() {
        DataLoader dataLoader = this.getLoader();
        if (!(dataLoader instanceof MultiFileLoader)) {
            return null;
        }
        return (MultiFileLoader)dataLoader;
    }

    @Override
    public Set<FileObject> files() {
        return new FilesSet(this);
    }

    @Override
    public boolean isDeleteAllowed() {
        return !this.getPrimaryFile().isReadOnly() && !this.existReadOnlySecondary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existReadOnlySecondary() {
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            for (FileObject fileObject : this.getSecondary().keySet()) {
                if (!fileObject.isReadOnly()) continue;
                return true;
            }
        }
        return false;
    }

    private Map<FileObject, Entry> checkSecondary() {
        if (!this.checked) {
            this.checkFiles(this);
            this.checked = true;
        }
        return this.getSecondary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<FileObject, Entry> getSecondary() {
        Object object = secondaryCreationLock;
        synchronized (object) {
            if (this.secondary == null) {
                this.secondary = new HashMap(4);
            }
            if (ERR.isLoggable(Level.FINE)) {
                ERR.fine("getSecondary for " + this + " is " + this.secondary);
            }
            return this.secondary;
        }
    }

    @Override
    public boolean isCopyAllowed() {
        return true;
    }

    @Override
    public boolean isMoveAllowed() {
        return !this.getPrimaryFile().isReadOnly() && !this.existReadOnlySecondary();
    }

    @Override
    public boolean isRenameAllowed() {
        return !this.getPrimaryFile().isReadOnly() && !this.existReadOnlySecondary();
    }

    @Override
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    Object synchObjectSecondary() {
        Map<FileObject, Entry> map = this.checkSecondary();
        if (map == null) {
            throw new IllegalStateException("checkSecondary was null from " + this);
        }
        return this.checkSecondary();
    }

    @Override
    protected Node createNodeDelegate() {
        DataNode dataNode = (DataNode)super.createNodeDelegate();
        return dataNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addSecondaryEntry(Entry entry) {
        Object object = this.getSecondary();
        synchronized (object) {
            this.getSecondary().put(entry.getFile(), entry);
            if (ERR.isLoggable(Level.FINE)) {
                ERR.fine("addSecondaryEntry: " + entry + " for " + this);
            }
        }
        object = this.getFolderList();
        if (object == null) {
            this.firePropertyChangeLater("files", null, null);
        } else if (((FolderList)object).isCreated()) {
            this.firePropertyChangeLater("files", null, null);
        } else {
            this.firePropFilesAfterFinishing();
        }
    }

    private FolderList getFolderList() {
        FileObject fileObject = this.primary.file.getParent();
        if (fileObject != null) {
            return FolderList.find(fileObject, false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeSecondaryEntry(Entry entry) {
        Map<FileObject, Entry> map = this.getSecondary();
        synchronized (map) {
            this.getSecondary().remove(entry.getFile());
            if (ERR.isLoggable(Level.FINE)) {
                ERR.fine("removeSecondaryEntry: " + entry + " for " + this);
            }
        }
        this.firePropertyChangeLater("files", null, null);
        this.updateFilesInCookieSet();
        if (entry.isImportant()) {
            this.checkConsistency(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void markSecondaryEntriesRecognized(DataLoader.RecognizedFiles recognizedFiles) {
        Map<FileObject, Entry> map = this.getSecondary();
        synchronized (map) {
            for (FileObject fileObject : this.getSecondary().keySet()) {
                recognizedFiles.markRecognized(fileObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Entry registerEntry(FileObject fileObject) {
        Map<FileObject, Entry> map = this.getSecondary();
        synchronized (map) {
            if (fileObject == null) {
                return this.primary;
            }
            if (fileObject.equals(this.getPrimaryFile())) {
                return this.primary;
            }
            Entry entry = this.getSecondary().get(fileObject);
            if (entry != null) {
                return entry;
            }
            entry = this.createSecondaryEntry(this, fileObject);
            this.addSecondaryEntry(entry);
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeFile(FileObject fileObject) {
        Map<FileObject, Entry> map = this.getSecondary();
        synchronized (map) {
            Entry entry = this.getSecondary().get(fileObject);
            if (entry != null) {
                this.removeSecondaryEntry(entry);
            }
        }
    }

    public final Entry getPrimaryEntry() {
        return this.primary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<Entry> secondaryEntries() {
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            this.removeAllInvalid();
            return new HashSet<Entry>(this.getSecondary().values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Entry findSecondaryEntry(FileObject fileObject) {
        Entry entry;
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            this.removeAllInvalid();
            entry = this.getSecondary().get(fileObject);
        }
        return entry;
    }

    private void removeAllInvalid() {
        if (ERR.isLoggable(Level.FINE)) {
            ERR.fine("removeAllInvalid, started " + this);
        }
        Iterator<Map.Entry<FileObject, Entry>> iterator = this.checkSecondary().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<FileObject, Entry> entry = iterator.next();
            FileObject fileObject = entry.getKey();
            if (fileObject.isValid()) continue;
            iterator.remove();
            if (ERR.isLoggable(Level.FINE)) {
                ERR.fine("removeAllInvalid, removed: " + fileObject + " for " + this);
            }
            this.firePropertyChangeLater("files", null, null);
        }
        if (ERR.isLoggable(Level.FINE)) {
            ERR.fine("removeAllInvalid, finished " + this);
        }
    }

    @Override
    protected FileLock takePrimaryFileLock() throws IOException {
        return this.getPrimaryEntry().takeLock();
    }

    private String existInFolder(FileObject fileObject, FileObject fileObject2) {
        if (fileObject.isFolder() && this.isMergingFolders(fileObject, fileObject2)) {
            return "";
        }
        String string = fileObject.getName();
        String string2 = FileUtil.findFreeFileName((FileObject)fileObject2, (String)string, (String)fileObject.getExt());
        if (string2.length() <= string.length()) {
            return "";
        }
        return string2.substring(string.length());
    }

    boolean isMergingFolders(FileObject fileObject, FileObject fileObject2) {
        return false;
    }

    @Override
    protected DataObject handleCopy(DataFolder dataFolder) throws IOException {
        String string = this.existInFolder(this.getPrimaryEntry().getFile(), dataFolder.getPrimaryFile());
        if (string == null) {
            throw new UserCancelException();
        }
        Iterator<Entry> iterator = this.secondaryEntries().iterator();
        while (iterator.hasNext()) {
            iterator.next().copy(dataFolder.getPrimaryFile(), string);
        }
        FileObject fileObject = this.getPrimaryEntry().copy(dataFolder.getPrimaryFile(), string);
        boolean bl = this.getMultiFileLoader() == null || this.getMultiFileLoader().findPrimaryFile(fileObject) != fileObject;
        try {
            return bl ? DataObject.find(fileObject) : this.createMultiObject(fileObject);
        }
        catch (DataObjectExistsException dataObjectExistsException) {
            return dataObjectExistsException.getDataObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleDelete() throws IOException {
        Iterator<Map.Entry<FileObject, Entry>> iterator;
        ArrayList arrayList = new ArrayList();
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            this.removeAllInvalid();
            iterator = new ArrayList<Map.Entry<FileObject, Entry>>(this.getSecondary().entrySet()).iterator();
        }
        while (iterator.hasNext()) {
            object = iterator.next();
            ((Entry)object.getValue()).delete();
            arrayList.add(object.getKey());
        }
        object = this.synchObjectSecondary();
        synchronized (object) {
            for (FileObject fileObject : arrayList) {
                this.getSecondary().remove(fileObject);
                if (!ERR.isLoggable(Level.FINE)) continue;
                ERR.fine("  handleDelete, removed entry: " + fileObject);
            }
        }
        this.getPrimaryEntry().delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileObject handleRename(String string) throws IOException {
        Iterator<Map.Entry<FileObject, Entry>> iterator;
        this.getPrimaryEntry().changeFile(this.getPrimaryEntry().rename(string));
        HashMap<FileObject, Object> hashMap = null;
        ArrayList arrayList = new ArrayList();
        Map.Entry<FileObject, Entry> entry = this.synchObjectSecondary();
        synchronized (entry) {
            this.removeAllInvalid();
            iterator = new ArrayList<Map.Entry<FileObject, Entry>>(this.getSecondary().entrySet()).iterator();
        }
        while (iterator.hasNext()) {
            entry = iterator.next();
            FileObject fileObject = entry.getValue().rename(string);
            if (fileObject == null) {
                arrayList.add(entry.getKey());
                continue;
            }
            if (fileObject.equals(entry.getKey())) continue;
            if (hashMap == null) {
                hashMap = new HashMap<FileObject, Object>();
            }
            Object object = (Entry)entry.getValue();
            ((Entry)object).changeFile(fileObject);
            hashMap.put(((Entry)object).getFile(), object);
            arrayList.add(entry.getKey());
        }
        if (hashMap != null || !arrayList.isEmpty()) {
            entry = this.synchObjectSecondary();
            synchronized (entry) {
                if (!arrayList.isEmpty()) {
                    for (Object object : arrayList) {
                        this.getSecondary().remove(object);
                        if (!ERR.isLoggable(Level.FINE)) continue;
                        ERR.fine("handleRename, removed: " + object + " for " + this);
                    }
                }
                if (hashMap != null) {
                    this.getSecondary().putAll(hashMap);
                    if (ERR.isLoggable(Level.FINE)) {
                        ERR.fine("handleRename, putAll: " + hashMap + " for " + this);
                    }
                }
            }
            this.firePropertyChangeLater("files", null, null);
        }
        return this.getPrimaryEntry().getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileObject handleMove(DataFolder dataFolder) throws IOException {
        String string = this.existInFolder(this.getPrimaryEntry().getFile(), dataFolder.getPrimaryFile());
        if (string == null) {
            throw new UserCancelException();
        }
        List<Pair> list = this.saveEntries();
        try {
            Iterator<Map.Entry<FileObject, Entry>> iterator;
            int n;
            FileObject fileObject;
            HashMap<FileObject, Entry> hashMap = null;
            ArrayList arrayList = new ArrayList();
            Object object = this.synchObjectSecondary();
            synchronized (object) {
                this.removeAllInvalid();
                fileObject = new ArrayList(this.getSecondary().entrySet());
                n = fileObject.size();
                iterator = fileObject.iterator();
            }
            if (ERR.isLoggable(Level.FINE)) {
                ERR.fine("move " + this + " to " + dataFolder + " number of secondary entries: " + n);
                ERR.fine("moving primary entry: " + this.getPrimaryEntry());
            }
            this.getPrimaryEntry().changeFile(this.getPrimaryEntry().move(dataFolder.getPrimaryFile(), string));
            if (ERR.isLoggable(Level.FINE)) {
                ERR.fine("               moved: " + this.getPrimaryEntry().getFile());
            }
            while (iterator.hasNext()) {
                object = iterator.next();
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("moving entry :" + object);
                }
                fileObject = ((Entry)object.getValue()).move(dataFolder.getPrimaryFile(), string);
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("  moved to   :" + fileObject);
                }
                if (fileObject == null) {
                    arrayList.add(object.getKey());
                    continue;
                }
                if (fileObject.equals(object.getKey())) continue;
                if (hashMap == null) {
                    hashMap = new HashMap<FileObject, Entry>();
                }
                Entry entry = (Entry)object.getValue();
                entry.changeFile(fileObject);
                hashMap.put(entry.getFile(), entry);
                arrayList.add(object.getKey());
            }
            if (hashMap != null || !arrayList.isEmpty()) {
                object = this.synchObjectSecondary();
                synchronized (object) {
                    if (!arrayList.isEmpty()) {
                        fileObject = arrayList.toArray();
                        for (int i = 0; i < ((FileObject)fileObject).length; ++i) {
                            this.getSecondary().remove(fileObject[i]);
                            if (!ERR.isLoggable(Level.FINE)) continue;
                            ERR.fine("handleMove, remove: " + fileObject[i] + " for " + this);
                        }
                    }
                    if (hashMap != null) {
                        this.getSecondary().putAll(hashMap);
                        if (ERR.isLoggable(Level.FINE)) {
                            ERR.fine("handleMove, putAll: " + hashMap + " for " + this);
                        }
                    }
                }
                this.firePropertyChangeLater("files", null, null);
            }
            if (ERR.isLoggable(Level.FINE)) {
                ERR.fine("successfully moved " + this);
            }
            return this.getPrimaryEntry().getFile();
        }
        catch (IOException iOException) {
            if (ERR.isLoggable(Level.FINE)) {
                ERR.fine("exception is here, restoring entries " + this);
                ERR.log(Level.FINE, null, iOException);
            }
            this.restoreEntries(list);
            if (ERR.isLoggable(Level.FINE)) {
                ERR.fine("entries restored " + this);
            }
            throw iOException;
        }
    }

    @Override
    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String string) throws IOException {
        if (string == null) {
            string = FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)this.getPrimaryFile().getName(), (String)this.getPrimaryFile().getExt());
        }
        FileObject fileObject = null;
        Map<String, Object> map = null;
        for (CreateFromTemplateHandler object : Lookup.getDefault().lookupAll(CreateFromTemplateHandler.class)) {
            Object object2;
            if (!object.accept((FileObject)(object2 = this.getPrimaryEntry().getFile()))) continue;
            if (map == null) {
                map = DataObject.CreateAction.findParameters(string);
            }
            fileObject = object.createFromTemplate((FileObject)object2, dataFolder.getPrimaryFile(), string, DataObject.CreateAction.enhanceParameters(map, string, object2.getExt()));
            assert (fileObject != null);
            break;
        }
        if (map == null) {
            fileObject = this.getPrimaryEntry().createFromTemplate(dataFolder.getPrimaryFile(), string);
        }
        block3: for (Entry entry : this.secondaryEntries()) {
            for (CreateFromTemplateHandler createFromTemplateHandler : Lookup.getDefault().lookupAll(CreateFromTemplateHandler.class)) {
                FileObject fileObject2;
                if (!createFromTemplateHandler.accept(fileObject2 = entry.getFile())) continue;
                if (map == null) {
                    map = DataObject.CreateAction.findParameters(string);
                }
                FileObject fileObject3 = createFromTemplateHandler.createFromTemplate(fileObject2, dataFolder.getPrimaryFile(), string, DataObject.CreateAction.enhanceParameters(map, string, fileObject2.getExt()));
                assert (fileObject3 != null);
                continue block3;
            }
            entry.createFromTemplate(dataFolder.getPrimaryFile(), string);
        }
        try {
            if (this instanceof DefaultDataObject) {
                return DataObject.find(fileObject);
            }
            return this.createMultiObject(fileObject);
        }
        catch (DataObjectExistsException dataObjectExistsException) {
            return dataObjectExistsException.getDataObject();
        }
    }

    @Override
    protected DataObject handleCopyRename(DataFolder dataFolder, String string, String string2) throws IOException {
        if (this.getLoader() instanceof UniFileLoader) {
            FileObject fileObject = this.getPrimaryEntry().copyRename(dataFolder.getPrimaryFile(), string, string2);
            return DataObject.find(fileObject);
        }
        throw new IOException("SaveAs operation not supported for this file type.");
    }

    @Deprecated
    protected final void setCookieSet(CookieSet cookieSet) {
        this.setCookieSet(cookieSet, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCookieSet(CookieSet cookieSet, boolean bl) {
        Object object = cookieSetLock;
        synchronized (object) {
            ChangeAndBefore changeAndBefore = this.getChangeListener();
            if (this.cookieSet != null) {
                this.cookieSet.removeChangeListener((ChangeListener)changeAndBefore);
            }
            cookieSet.addChangeListener((ChangeListener)changeAndBefore);
            this.cookieSet = cookieSet;
        }
        if (bl) {
            this.fireCookieChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final CookieSet getCookieSet() {
        CookieSet cookieSet = this.cookieSet;
        if (cookieSet != null) {
            return cookieSet;
        }
        Object object = cookieSetLock;
        synchronized (object) {
            if (this.cookieSet != null) {
                return this.cookieSet;
            }
            CookieSet cookieSet2 = CookieSet.createGeneric((CookieSet.Before)this.getChangeListener());
            cookieSet2.assign(DataObject.class, (Object[])new DataObject[]{this});
            this.setCookieSet(cookieSet2, false);
            return this.cookieSet;
        }
    }

    @Override
    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        Node.Cookie cookie;
        CookieSet cookieSet = this.cookieSet;
        if (cookieSet != null && (cookie = cookieSet.getCookie(clazz)) != null) {
            return (T)cookie;
        }
        return super.getCookie(clazz);
    }

    final void fireCookieChange() {
        this.firePropertyChange("cookie", null, null);
    }

    private void firePropertyChangeLater(final String string, final Object object, final Object object2) {
        firingProcessor.post(new Runnable(){

            public void run() {
                MultiDataObject.this.firePropertyChange(string, object, object2);
                if ("files".equals(string) || "primaryFile".equals(string)) {
                    MultiDataObject.this.updateFilesInCookieSet();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropFilesAfterFinishing() {
        Object object = delayedPropFilesLock;
        synchronized (object) {
            if (this.delayedPropFilesTask == null) {
                this.delayedPropFilesTask = delayProcessor.post(new Runnable(){

                    public void run() {
                        FolderList folderList = MultiDataObject.this.getFolderList();
                        if (folderList != null) {
                            folderList.waitProcessingFinished();
                        }
                        MultiDataObject.this.firePropertyChangeLater("files", null, null);
                    }
                });
            } else {
                this.delayedPropFilesTask.schedule(0);
            }
        }
    }

    @Override
    final void recognizedByFolder() {
        this.checked = true;
    }

    final ChangeAndBefore getChangeListener() {
        if (this.chLis == null) {
            this.chLis = new ChangeAndBefore();
        }
        return this.chLis;
    }

    private final Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        MultiFileLoader multiFileLoader = this.getMultiFileLoader();
        if (multiFileLoader != null) {
            return multiFileLoader.createPrimaryEntry(multiDataObject, fileObject);
        }
        Entry entry = fileObject.isFolder() ? new FileEntry.Folder(multiDataObject, fileObject) : new FileEntry(multiDataObject, fileObject);
        return entry;
    }

    private final Entry createSecondaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        MultiFileLoader multiFileLoader = this.getMultiFileLoader();
        if (multiFileLoader != null) {
            return multiFileLoader.createSecondaryEntryImpl(multiDataObject, fileObject);
        }
        Entry entry = fileObject.isFolder() ? new FileEntry.Folder(multiDataObject, fileObject) : new FileEntry(multiDataObject, fileObject);
        return entry;
    }

    private final MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        MultiFileLoader multiFileLoader = this.getMultiFileLoader();
        MultiDataObject multiDataObject = multiFileLoader != null ? DataObjectPool.createMultiObject(multiFileLoader, fileObject) : (MultiDataObject)this.getLoader().findDataObject(fileObject, RECOGNIZER);
        return multiDataObject;
    }

    private final void checkConsistency(MultiDataObject multiDataObject) {
        MultiFileLoader multiFileLoader = this.getMultiFileLoader();
        if (multiFileLoader != null) {
            multiFileLoader.checkConsistency(multiDataObject);
        }
    }

    private final void checkFiles(MultiDataObject multiDataObject) {
        MultiFileLoader multiFileLoader = this.getMultiFileLoader();
        if (multiFileLoader != null) {
            multiFileLoader.checkFiles(multiDataObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<Pair> saveEntries() {
        Object object = this.synchObjectSecondary();
        synchronized (object) {
            LinkedList<Pair> linkedList = new LinkedList<Pair>();
            linkedList.add(new Pair(this.getPrimaryEntry()));
            for (Entry entry : this.secondaryEntries()) {
                linkedList.add(new Pair(entry));
            }
            return linkedList;
        }
    }

    final void restoreEntries(List<Pair> list) {
        for (Pair pair : list) {
            if (pair.entry.getFile().equals(pair.file)) continue;
            if (pair.file.isValid()) {
                pair.entry.changeFile(pair.file);
                continue;
            }
            try {
                if (pair.entry.getFile().isData()) {
                    pair.entry.changeFile(pair.entry.getFile().copy(pair.file.getParent(), pair.file.getName(), pair.file.getExt()));
                    continue;
                }
                FileObject fileObject = pair.file.getParent().createFolder(pair.file.getName());
                FileUtil.copyAttributes((FileObject)pair.entry.getFile(), (FileObject)fileObject);
                pair.entry.changeFile(fileObject);
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    void notifyFileDeleted(FileEvent fileEvent) {
        this.removeFile(fileEvent.getFile());
        if (fileEvent.getFile().equals(this.getPrimaryFile())) {
            try {
                this.markInvalid0();
            }
            catch (PropertyVetoException propertyVetoException) {
                Logger.getLogger(MultiDataObject.class.getName()).log(Level.WARNING, null, propertyVetoException);
            }
        }
    }

    @Override
    void notifyFileDataCreated(FileEvent fileEvent) {
        this.checked = false;
    }

    final void updateFilesInCookieSet() {
        this.getCookieSet().assign(FileObject.class, (Object[])this.files().toArray(new FileObject[0]));
    }

    void checkCookieSet(Class<?> clazz) {
    }

    private static final class EntryReplace
    implements Serializable {
        static final long serialVersionUID = -1498798537289529182L;
        private FileObject file;
        private transient Entry entry;

        public EntryReplace(FileObject fileObject) {
            this.file = fileObject;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            try {
                DataObject dataObject = DataObject.find(this.file);
                if (dataObject instanceof MultiDataObject) {
                    MultiDataObject multiDataObject = (MultiDataObject)dataObject;
                    if (this.file.equals(multiDataObject.getPrimaryFile())) {
                        this.entry = multiDataObject.getPrimaryEntry();
                    } else {
                        Entry entry = multiDataObject.findSecondaryEntry(this.file);
                        if (entry == null) {
                            throw new InvalidObjectException(dataObject.toString());
                        }
                        this.entry = entry;
                    }
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                throw new InvalidObjectException(dataObjectNotFoundException.getMessage());
            }
        }

        public Object readResolve() {
            return this.entry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ChangeAndBefore
    implements ChangeListener,
    CookieSet.Before {
        private ChangeAndBefore() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            MultiDataObject.this.fireCookieChange();
        }

        public void beforeLookup(Class<?> clazz) {
            if (clazz.isAssignableFrom(FileObject.class)) {
                MultiDataObject.this.updateFilesInCookieSet();
            }
            MultiDataObject.this.checkCookieSet(clazz);
        }
    }

    public abstract class Entry
    implements Serializable {
        static final long serialVersionUID = 6024795908818133571L;
        private FileObject file;
        private transient WeakReference<FileLock> lock;

        protected Entry(FileObject fileObject) {
            this.file = fileObject;
            if (!this.isImportant()) {
                fileObject.setImportant(false);
            }
        }

        final void changeFile(FileObject fileObject) {
            FileLock fileLock;
            assert (fileObject != null) : "NPE for " + this.file;
            if (fileObject.equals(this.file)) {
                return;
            }
            if (ERR.isLoggable(Level.FINE)) {
                ERR.fine("changeFile: " + fileObject + " for " + this + " of " + this.getDataObject());
            }
            fileObject.setImportant(this.isImportant());
            this.file = fileObject;
            FileLock fileLock2 = fileLock = this.lock == null ? null : (FileLock)this.lock.get();
            if (fileLock != null && fileLock.isValid()) {
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("releasing old lock: " + this + " was: " + fileLock);
                }
                fileLock.releaseLock();
            }
            this.lock = null;
        }

        public final FileObject getFile() {
            return this.file;
        }

        public final MultiDataObject getDataObject() {
            return MultiDataObject.this;
        }

        public boolean isImportant() {
            return true;
        }

        public abstract FileObject copy(FileObject var1, String var2) throws IOException;

        public abstract FileObject rename(String var1) throws IOException;

        public abstract FileObject move(FileObject var1, String var2) throws IOException;

        public abstract void delete() throws IOException;

        public abstract FileObject createFromTemplate(FileObject var1, String var2) throws IOException;

        public FileObject copyRename(FileObject fileObject, String string, String string2) throws IOException {
            throw new IOException("Unsupported operation");
        }

        public FileLock takeLock() throws IOException {
            FileLock fileLock;
            FileLock fileLock2 = fileLock = this.lock == null ? null : (FileLock)this.lock.get();
            if (fileLock == null || !fileLock.isValid()) {
                fileLock = this.getFile().lock();
                this.lock = new WeakReference<FileLock>(fileLock);
            }
            if (ERR.isLoggable(Level.FINE)) {
                ERR.fine("takeLock: " + this + " is: " + fileLock);
            }
            return fileLock;
        }

        public boolean isLocked() {
            FileLock fileLock = this.lock == null ? null : (FileLock)this.lock.get();
            return fileLock != null && fileLock.isValid();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            return this.getFile().equals(((Entry)object).getFile());
        }

        public int hashCode() {
            return this.getFile().hashCode();
        }

        protected Object writeReplace() {
            return new EntryReplace(this.getFile());
        }
    }

    static final class Pair {
        Entry entry;
        FileObject file;

        Pair(Entry entry) {
            this.entry = entry;
            this.file = entry.getFile();
        }
    }

    private static class EmptyRecognizer
    implements DataLoader.RecognizedFiles {
        EmptyRecognizer() {
        }

        public void markRecognized(FileObject fileObject) {
        }
    }
}

