/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview.ui;

import java.awt.BorderLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.netbeans.modules.xml.multiview.ui.ErrorPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.openide.ErrorManager;
import org.openide.actions.SaveAction;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public abstract class AbstractDesignEditor
extends TopComponent
implements ExplorerManager.Provider {
    public static final String PROPERTY_FLUSH_DATA = "Flush Data";
    private static final String ACTION_INVOKE_HELP = "invokeHelp";
    protected JComponent structureView;
    protected PanelView contentView;
    protected Action helpAction;
    private ExplorerManager manager;
    protected static String iconURL = "/org/netbeans/modules/form/resources/inspector.gif";
    protected static final long serialVersionUID = 1L;
    static /* synthetic */ Class class$org$netbeans$modules$xml$multiview$ui$AbstractDesignEditor;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$openide$util$HelpCtx;

    public AbstractDesignEditor() {
        this.init();
    }

    private void init() {
        this.manager = new ExplorerManager();
        this.helpAction = new HelpAction();
        ActionMap actionMap = this.getActionMap();
        this.getInputMap(1).put(KeyStroke.getKeyStroke(112, 0), ACTION_INVOKE_HELP);
        actionMap.put(ACTION_INVOKE_HELP, this.helpAction);
        SaveAction saveAction = (SaveAction)SystemAction.get((Class)SaveAction.class);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this.getInputMap(1).put(keyStroke, "save");
        actionMap.put("save", (Action)saveAction);
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)actionMap));
        this.manager.addPropertyChangeListener((PropertyChangeListener)new NodeSelectedListener());
        this.setLayout(new BorderLayout());
    }

    public AbstractDesignEditor(PanelView panelView) {
        this.init();
        this.contentView = panelView;
        this.setRootContext(panelView.getRoot());
    }

    public void setContentView(PanelView panelView) {
        this.contentView = panelView;
        this.setRootContext(panelView.getRoot());
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
    }

    public void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
    }

    public void componentClosed() {
        super.componentClosed();
    }

    public void componentOpened() {
        super.componentOpened();
    }

    public void componentShowing() {
        super.componentShowing();
    }

    public void componentHidden() {
        super.componentShowing();
    }

    public void setRootContext(Node node) {
        this.getExplorerManager().setRootContext(node);
    }

    public PanelView getContentView() {
        return this.contentView;
    }

    public JComponent getStructureView() {
        if (this.structureView == null) {
            this.structureView = this.createStructureComponent();
            this.structureView.addPropertyChangeListener(new NodeSelectedListener());
        }
        return this.structureView;
    }

    public abstract JComponent createStructureComponent();

    public abstract ErrorPanel getErrorPanel();

    public void open() {
        if (this.contentView != null) {
            this.contentView.open();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("ComponentPanel");
    }

    public void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        super.fireVetoableChange(string, object, object2);
    }

    final class HelpAction
    extends AbstractAction {
        HelpCtx.Provider provider;

        public HelpAction() {
            super(NbBundle.getMessage((Class)(class$org$netbeans$modules$xml$multiview$ui$AbstractDesignEditor == null ? (class$org$netbeans$modules$xml$multiview$ui$AbstractDesignEditor = AbstractDesignEditor.class$("org.netbeans.modules.xml.multiview.ui.AbstractDesignEditor")) : class$org$netbeans$modules$xml$multiview$ui$AbstractDesignEditor), (String)"CTL_Help"), new ImageIcon(((Object)((Object)AbstractDesignEditor.this)).getClass().getResource("/org/netbeans/modules/xml/multiview/resources/help.gif")));
            this.provider = null;
        }

        public boolean isEnabled() {
            return this.getContext() != null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HelpCtx helpCtx = this.getContext();
            if (helpCtx == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            try {
                Class<?> clazz = ((ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = AbstractDesignEditor.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader)).loadClass("org.netbeans.api.javahelp.Help");
                Object object = Lookup.getDefault().lookup(clazz);
                if (object != null) {
                    Method method = clazz.getMethod("showHelp", class$org$openide$util$HelpCtx == null ? (class$org$openide$util$HelpCtx = AbstractDesignEditor.class$("org.openide.util.HelpCtx")) : class$org$openide$util$HelpCtx);
                    if (method != null) {
                        method.invoke(object, helpCtx);
                    }
                    return;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
            Toolkit.getDefaultToolkit().beep();
        }

        private HelpCtx getContext() {
            Node[] nodeArray = AbstractDesignEditor.this.getExplorerManager().getSelectedNodes();
            if (nodeArray != null && nodeArray.length > 0) {
                return nodeArray[0].getHelpCtx();
            }
            return null;
        }
    }

    class NodeSelectedListener
    implements PropertyChangeListener {
        NodeSelectedListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (AbstractDesignEditor.this.contentView.isSectionHeaderClicked()) {
                AbstractDesignEditor.this.contentView.setSectionHeaderClicked(false);
                return;
            }
            if (!"selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            Node[] nodeArray = AbstractDesignEditor.this.getExplorerManager().getSelectedNodes();
            if (nodeArray != null && nodeArray.length > 0) {
                AbstractDesignEditor.this.contentView.showSelection(nodeArray);
            }
        }
    }
}

