/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.api.support;

import org.netbeans.modules.bpel.model.api.references.SchemaReference;
import org.netbeans.modules.bpel.model.api.support.BpelXPathModelFactory;
import org.netbeans.modules.bpel.model.ext.editor.api.Cast;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.xpath.ext.XPathException;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathModel;
import org.netbeans.modules.xml.xpath.ext.spi.XPathCast;
import org.openide.ErrorManager;

public class XPathCastImpl
implements XPathCast {
    private Cast mCast;
    private String myPathText;
    private GlobalType mCastTo;
    private XPathExpression mXPathExpression;

    public static XPathExpression getExpression(Cast cast) {
        String string = cast.getPath();
        XPathModel xPathModel = BpelXPathModelFactory.create(cast);
        XPathExpression xPathExpression = null;
        try {
            xPathExpression = xPathModel.parseExpression(string);
        }
        catch (XPathException xPathException) {
            ErrorManager.getDefault().log(16, "Unresolved XPath: " + string);
        }
        return xPathExpression;
    }

    public static XPathCastImpl convert(Cast cast) {
        SchemaReference<GlobalType> schemaReference = cast.getType();
        if (schemaReference == null) {
            return null;
        }
        GlobalType globalType = (GlobalType)schemaReference.get();
        String string = cast.getPath();
        if (cast == null || string == null || string.length() == 0) {
            return null;
        }
        XPathCastImpl xPathCastImpl = new XPathCastImpl();
        xPathCastImpl.mCast = cast;
        xPathCastImpl.myPathText = string;
        xPathCastImpl.mCastTo = globalType;
        return xPathCastImpl;
    }

    private XPathCastImpl() {
    }

    public XPathCastImpl(XPathExpression xPathExpression, GlobalType globalType) {
        this.mXPathExpression = xPathExpression;
        this.mCastTo = globalType;
    }

    public String getPathText() {
        return this.myPathText;
    }

    public GlobalType getCastTo() {
        return this.mCastTo;
    }

    public XPathExpression getPath() {
        if (this.mXPathExpression == null) {
            this.mXPathExpression = XPathCastImpl.getExpression(this.mCast);
        }
        return this.mXPathExpression;
    }

    public String toString() {
        return "(" + this.mCastTo.toString() + ")" + this.mXPathExpression.getExpressionString();
    }
}

