/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.common;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import java.io.IOException;
import java.util.Collections;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.openide.util.Parameters;

public class Utilities {
    public static AnnotationMirror findAnnotation(Element element, String string) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!string.equals(annotationMirror.getAnnotationType().toString())) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean hasAnnotation(Element element, String string) {
        AnnotationMirror annotationMirror = Utilities.findAnnotation(element, string);
        return annotationMirror != null;
    }

    public static AnnotationValue getAnnotationAttrValue(AnnotationMirror annotationMirror, String string) {
        if (annotationMirror != null) {
            for (ExecutableElement executableElement : annotationMirror.getElementValues().keySet()) {
                if (!string.equals(executableElement.getSimpleName().toString())) continue;
                return annotationMirror.getElementValues().get(executableElement);
            }
        }
        return null;
    }

    public static ExpressionTree getAnnotationArgumentTree(AnnotationTree annotationTree, String string) {
        for (ExpressionTree expressionTree : annotationTree.getArguments()) {
            ExpressionTree expressionTree2;
            if (!(expressionTree instanceof AssignmentTree) || !((expressionTree2 = ((AssignmentTree)expressionTree).getVariable()) instanceof IdentifierTree) || !string.equals(((IdentifierTree)expressionTree2).getName().toString())) continue;
            return expressionTree;
        }
        return null;
    }

    public static void addAnnotation(WorkingCopy workingCopy, Element element, String string) throws IOException {
        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
        ModifiersTree modifiersTree = null;
        if (element instanceof TypeElement) {
            modifiersTree = workingCopy.getTrees().getTree((TypeElement)element).getModifiers();
        } else if (element instanceof ExecutableElement) {
            modifiersTree = workingCopy.getTrees().getTree((ExecutableElement)element).getModifiers();
        } else if (element instanceof VariableElement) {
            modifiersTree = ((VariableTree)workingCopy.getTrees().getTree(element)).getModifiers();
        }
        if (modifiersTree == null) {
            return;
        }
        TypeElement typeElement = workingCopy.getElements().getTypeElement(string);
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        AnnotationTree annotationTree = treeMaker.Annotation((Tree)treeMaker.QualIdent((Element)typeElement), Collections.emptyList());
        ModifiersTree modifiersTree2 = treeMaker.addModifiersAnnotation(modifiersTree, annotationTree);
        workingCopy.rewrite((Tree)modifiersTree, (Tree)modifiersTree2);
    }

    public static void removeAnnotation(WorkingCopy workingCopy, Element element, AnnotationMirror annotationMirror) throws IOException {
        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
        ModifiersTree modifiersTree = null;
        if (element instanceof TypeElement) {
            modifiersTree = workingCopy.getTrees().getTree((TypeElement)element).getModifiers();
        } else if (element instanceof ExecutableElement) {
            modifiersTree = workingCopy.getTrees().getTree((ExecutableElement)element).getModifiers();
        } else if (element instanceof VariableElement) {
            modifiersTree = ((VariableTree)workingCopy.getTrees().getTree(element)).getModifiers();
        }
        if (modifiersTree == null) {
            return;
        }
        AnnotationTree annotationTree = (AnnotationTree)workingCopy.getTrees().getTree(element, annotationMirror);
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ModifiersTree modifiersTree2 = treeMaker.removeModifiersAnnotation(modifiersTree, annotationTree);
        workingCopy.rewrite((Tree)modifiersTree, (Tree)modifiersTree2);
    }

    public static void removeAnnotationArgument(WorkingCopy workingCopy, Element element, AnnotationMirror annotationMirror, String string) throws IOException {
        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
        Parameters.javaIdentifierOrNull((CharSequence)"argumentName", (CharSequence)string);
        ModifiersTree modifiersTree = null;
        if (element instanceof TypeElement) {
            modifiersTree = workingCopy.getTrees().getTree((TypeElement)element).getModifiers();
        } else if (element instanceof ExecutableElement) {
            modifiersTree = workingCopy.getTrees().getTree((ExecutableElement)element).getModifiers();
        } else if (element instanceof VariableElement) {
            modifiersTree = ((VariableTree)workingCopy.getTrees().getTree(element)).getModifiers();
        }
        if (modifiersTree == null) {
            return;
        }
        AnnotationTree annotationTree = (AnnotationTree)workingCopy.getTrees().getTree(element, annotationMirror);
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ExpressionTree expressionTree = Utilities.getAnnotationArgumentTree(annotationTree, string);
        AnnotationTree annotationTree2 = treeMaker.removeAnnotationAttrValue(annotationTree, expressionTree);
        workingCopy.rewrite((Tree)annotationTree, (Tree)annotationTree2);
    }

    public static void addAnnotationArgument(WorkingCopy workingCopy, Element element, AnnotationMirror annotationMirror, String string, Object object) throws IOException {
        Object object2;
        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
        Parameters.javaIdentifierOrNull((CharSequence)"argumentName", (CharSequence)string);
        Parameters.notNull((CharSequence)"argumentValue", (Object)object);
        ModifiersTree modifiersTree = null;
        if (element instanceof TypeElement) {
            modifiersTree = workingCopy.getTrees().getTree((TypeElement)element).getModifiers();
        } else if (element instanceof ExecutableElement) {
            modifiersTree = workingCopy.getTrees().getTree((ExecutableElement)element).getModifiers();
        } else if (element instanceof VariableElement) {
            modifiersTree = ((VariableTree)workingCopy.getTrees().getTree(element)).getModifiers();
        }
        if (modifiersTree == null) {
            return;
        }
        AnnotationTree annotationTree = (AnnotationTree)workingCopy.getTrees().getTree(element, annotationMirror);
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ExpressionTree expressionTree = Utilities.getAnnotationArgumentTree(annotationTree, string);
        if (expressionTree != null) {
            annotationTree = treeMaker.removeAnnotationAttrValue(annotationTree, expressionTree);
        }
        ExpressionTree expressionTree2 = null;
        if (object instanceof Enum) {
            object2 = workingCopy.getElements().getTypeElement(object.getClass().getCanonicalName());
            expressionTree2 = treeMaker.MemberSelect(treeMaker.QualIdent((Element)object2), (CharSequence)((Enum)object).name());
        } else {
            try {
                expressionTree2 = treeMaker.Literal(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
        }
        if (string != null) {
            expressionTree2 = treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)string), expressionTree2);
        }
        object2 = treeMaker.addAnnotationAttrValue(annotationTree, expressionTree2);
        workingCopy.rewrite((Tree)annotationTree, (Tree)object2);
    }

    public static TextSpan getUnderlineSpan(CompilationInfo compilationInfo, Tree tree) {
        SourcePositions sourcePositions = compilationInfo.getTrees().getSourcePositions();
        int n = (int)sourcePositions.getStartPosition(compilationInfo.getCompilationUnit(), tree);
        int n2 = (int)sourcePositions.getEndPosition(compilationInfo.getCompilationUnit(), tree);
        Tree tree2 = null;
        if (tree.getKind() == Tree.Kind.CLASS) {
            tree2 = ((ClassTree)tree).getModifiers();
        } else if (tree.getKind() == Tree.Kind.METHOD) {
            tree2 = ((MethodTree)tree).getReturnType();
        } else if (tree.getKind() == Tree.Kind.VARIABLE) {
            tree2 = ((VariableTree)tree).getType();
        }
        if (tree2 != null) {
            int n3 = (int)sourcePositions.getEndPosition(compilationInfo.getCompilationUnit(), tree2);
            TokenSequence tokenSequence = compilationInfo.getTreeUtilities().tokensFor(tree);
            if (tokenSequence != null) {
                boolean bl = false;
                tokenSequence.move(n3);
                do {
                    boolean bl2 = bl = !tokenSequence.moveNext();
                } while (!bl && tokenSequence.token().id() != JavaTokenId.IDENTIFIER);
                if (!bl) {
                    Token token = tokenSequence.token();
                    n = token.offset(compilationInfo.getTokenHierarchy());
                    n2 = n + token.length();
                }
            }
        }
        return new TextSpan(n, n2);
    }

    public static class TextSpan {
        private int startOffset;
        private int endOffset;

        public TextSpan(int n, int n2) {
            this.startOffset = n;
            this.endOffset = n2;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }
}

