/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.swingapp.ActionEditor;
import org.netbeans.modules.swingapp.ActionManager;
import org.netbeans.modules.swingapp.ActionPropertyEditorPanel;
import org.netbeans.modules.swingapp.AppFrameworkSupport;
import org.netbeans.modules.swingapp.ProxyAction;
import org.netbeans.modules.swingapp.actiontable.ActionTableModel;
import org.netbeans.modules.swingapp.actiontable.IconTableCellRenderer;
import org.netbeans.modules.swingapp.util.FilteredTableModel;
import org.netbeans.modules.swingapp.util.TableSorter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class GlobalActionPanel
extends JPanel {
    private ActionManager actionManager;
    private ActionManager.ActionChangedListener actChangeListener = new ActionManager.ActionChangedListener(){

        public void actionChanged(ProxyAction proxyAction) {
            if (GlobalActionPanel.this.realModel != null) {
                int n = GlobalActionPanel.this.getSelectedRow();
                GlobalActionPanel.this.realModel.updateAction(proxyAction);
                GlobalActionPanel.this.setSelectedRow(n);
            }
        }
    };
    private PropertyChangeListener amListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            GlobalActionPanel.this.reloadTable();
            GlobalActionPanel.this.reloadClassesCombo();
        }
    };
    private ActionTableModel realModel;
    private static final String SHOW_ALL_CLASSES = GlobalActionPanel.getLocalizedString("classesFilter.allClasses");
    private String filterClass = null;
    private Action deleteAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            GlobalActionPanel.this.deleteSelectedAction();
        }
    };
    private JTable actionTable;
    private JList boundComponentList;
    private JComboBox classCombo;
    private JButton deleteActionButton;
    private JButton editActionButton;
    private JTextField filterTextfield;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JButton newActionButton;
    private JComboBox projectCombo;
    private JScrollPane scrollPane;
    private JButton viewSourceButton;
    private PropertyChangeListener topcompsListener;

    public GlobalActionPanel() {
        this.initComponents();
        this.jSplitPane1.setResizeWeight(1.0);
        this.actionManager = ActionManager.getEmptyActionManager();
        this.actionTable.setSelectionMode(0);
        this.actionTable.setDefaultRenderer(Icon.class, new IconTableCellRenderer());
        this.actionTable.setRowHeight(18);
        this.jSplitPane1.setDividerLocation(-1);
        this.actionTable.setAutoResizeMode(0);
        this.actionTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    GlobalActionPanel.this.editSelectedAction();
                }
                if (GlobalActionPanel.this.getSelectedAction() != null) {
                    GlobalActionPanel.this.editActionButton.setEnabled(true);
                    GlobalActionPanel.this.enableViewSource(true);
                    GlobalActionPanel.this.enableDeleteAction(true);
                }
            }
        });
        this.actionTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl = GlobalActionPanel.this.getSelectedAction() != null;
                GlobalActionPanel.this.editActionButton.setEnabled(bl);
                GlobalActionPanel.this.enableViewSource(bl);
                GlobalActionPanel.this.enableDeleteAction(bl);
            }
        });
        this.boundComponentList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    GlobalActionPanel.this.jumpToSelectedComponent();
                }
            }
        });
        this.projectCombo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                JLabel jLabel = (JLabel)component;
                if (object instanceof Project) {
                    jLabel.setText(((Project)object).getProjectDirectory().getName());
                }
                return component;
            }
        });
        this.projectCombo.setModel(new DefaultComboBoxModel());
        this.classCombo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                JLabel jLabel = (JLabel)component;
                jLabel.setText("" + object);
                return component;
            }
        });
        this.actionTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ProxyAction proxyAction = GlobalActionPanel.this.getSelectedAction();
                if (proxyAction != null) {
                    List<RADComponent> list = GlobalActionPanel.this.actionManager.getBoundComponents(proxyAction);
                    DefaultListModel<RADComponent> defaultListModel = new DefaultListModel<RADComponent>();
                    for (RADComponent rADComponent : list) {
                        defaultListModel.addElement(rADComponent);
                    }
                    GlobalActionPanel.this.boundComponentList.setModel(defaultListModel);
                }
            }
        });
        this.boundComponentList.setModel(new DefaultListModel());
        this.boundComponentList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                JLabel jLabel = (JLabel)component;
                if (object instanceof RADComponent) {
                    RADComponent rADComponent = (RADComponent)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(rADComponent.getName());
                    stringBuffer.append(", ");
                    if (rADComponent.getFormModel() != null) {
                        stringBuffer.append(rADComponent.getFormModel().getName());
                    }
                    jLabel.setText(stringBuffer.toString());
                }
                return component;
            }
        });
        this.filterTextfield.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                GlobalActionPanel.this.filterTable();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                GlobalActionPanel.this.filterTable();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                GlobalActionPanel.this.filterTable();
            }
        });
        this.deleteAction.putValue("Name", GlobalActionPanel.getLocalizedString("deleteAction.text"));
        this.deleteAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        this.attachTopComponentsListener();
        this.reloadProjectsCombo();
        this.reloadClassesCombo();
        this.reloadTable();
        Set<AWTKeyStroke> set = this.actionTable.getFocusTraversalKeys(0);
        set = new HashSet<AWTKeyStroke>(set);
        set.add(AWTKeyStroke.getAWTKeyStroke(9, 640));
        this.actionTable.setFocusTraversalKeys(0, set);
    }

    private boolean actionHasSource(ProxyAction proxyAction) {
        if (this.actionManager == null) {
            return false;
        }
        if (proxyAction == null) {
            return false;
        }
        if (proxyAction.getClassname() == null) {
            return false;
        }
        FileObject fileObject = this.actionManager.getFileForClass(proxyAction.getClassname());
        return fileObject != null;
    }

    private void enableViewSource(boolean bl) {
        this.viewSourceButton.setEnabled(bl);
        if (!this.actionHasSource(this.getSelectedAction())) {
            this.viewSourceButton.setEnabled(false);
        }
    }

    private void enableDeleteAction(boolean bl) {
        this.deleteActionButton.setEnabled(bl);
        if (!this.actionHasSource(this.getSelectedAction())) {
            this.deleteActionButton.setEnabled(false);
        }
    }

    public GlobalActionPanel(FileObject fileObject) {
        this();
        this.actionManager = ActionManager.getActionManager(fileObject);
        this.actionManager.rescan();
    }

    private void reloadClassesCombo() {
        Object object = this.classCombo.getSelectedItem();
        Collection<String> collection = this.actionManager.getAllClasses();
        ArrayList<String> arrayList = new ArrayList<String>(collection.size() + 1);
        arrayList.add(0, SHOW_ALL_CLASSES);
        arrayList.addAll(collection);
        this.classCombo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        this.classCombo.setSelectedItem(object);
    }

    private void reloadProjectsCombo() {
        Set<Project> set = ActionManager.getKnownProjects();
        this.classCombo.setSelectedItem(SHOW_ALL_CLASSES);
        if (set.size() > 0) {
            Project project = (Project)set.toArray()[0];
            this.projectCombo.setModel(new DefaultComboBoxModel<Object>(set.toArray()));
            if (set.contains(this.actionManager.getProject())) {
                this.projectCombo.setSelectedItem(this.actionManager.getProject());
            } else {
                this.projectCombo.setSelectedItem(project);
                this.actionManager = ActionManager.getActionManager(project);
            }
            this.actionManager.rescan();
            this.projectCombo.setEnabled(true);
            this.newActionButton.setEnabled(true);
            this.classCombo.setEnabled(true);
            this.reloadTable();
        } else {
            this.actionManager = ActionManager.getEmptyActionManager();
            this.projectCombo.setModel(new DefaultComboBoxModel());
            this.projectCombo.setEnabled(false);
            this.newActionButton.setEnabled(false);
            this.editActionButton.setEnabled(false);
            this.viewSourceButton.setEnabled(false);
            this.deleteActionButton.setEnabled(false);
            this.classCombo.setEnabled(false);
            this.reloadTable();
        }
    }

    private void initComponents() {
        this.newActionButton = new JButton();
        this.editActionButton = new JButton();
        this.deleteActionButton = new JButton();
        this.jLabel4 = new JLabel();
        this.projectCombo = new JComboBox();
        this.jLabel1 = new JLabel();
        this.classCombo = new JComboBox();
        this.jLabel2 = new JLabel();
        this.filterTextfield = new JTextField();
        this.jPanel3 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.scrollPane = new JScrollPane();
        this.actionTable = new JTable();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.boundComponentList = new JList();
        this.viewSourceButton = new JButton();
        this.newActionButton.setMnemonic('N');
        this.newActionButton.setText(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.newActionButton.text"));
        this.newActionButton.setEnabled(false);
        this.newActionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GlobalActionPanel.this.newActionButtonActionPerformed(actionEvent);
            }
        });
        this.editActionButton.setMnemonic('E');
        this.editActionButton.setText(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.editActionButton.text"));
        this.editActionButton.setEnabled(false);
        this.editActionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GlobalActionPanel.this.editActionButtonActionPerformed(actionEvent);
            }
        });
        this.deleteActionButton.setAction(this.getDeleteAction());
        this.deleteActionButton.setMnemonic('D');
        this.deleteActionButton.setText(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.deleteActionButton.text"));
        this.deleteActionButton.setEnabled(false);
        this.jLabel4.setDisplayedMnemonic('P');
        this.jLabel4.setText(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.jLabel4.text"));
        this.projectCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.projectCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GlobalActionPanel.this.projectComboActionPerformed(actionEvent);
            }
        });
        this.jLabel1.setDisplayedMnemonic('C');
        this.jLabel1.setText(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.jLabel1.text"));
        this.classCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.classCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GlobalActionPanel.this.classComboActionPerformed(actionEvent);
            }
        });
        this.jLabel2.setDisplayedMnemonic('S');
        this.jLabel2.setLabelFor(this.filterTextfield);
        this.jLabel2.setText(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.jLabel2.text"));
        this.filterTextfield.setText(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.filterTextfield.text"));
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(500);
        this.jSplitPane1.setResizeWeight(1.0);
        this.actionTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.scrollPane.setViewportView(this.actionTable);
        this.actionTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.actionTable.AccessibleContext.accessibleName"));
        this.actionTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.actionTable.AccessibleContext.accessibleDescription"));
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.scrollPane, -1, 500, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.scrollPane, -1, 143, Short.MAX_VALUE));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jLabel3.setDisplayedMnemonic('B');
        this.jLabel3.setLabelFor(this.boundComponentList);
        this.jLabel3.setText(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.jLabel3.text"));
        this.boundComponentList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.jScrollPane1.setViewportView(this.boundComponentList);
        this.boundComponentList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.boundComponentList.AccessibleContext.accessibleName"));
        this.boundComponentList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.boundComponentList.AccessibleContext.accessibleDescription"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.jLabel3).addContainerGap(68, Short.MAX_VALUE)).add((Component)this.jScrollPane1, -1, 191, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 119, Short.MAX_VALUE)));
        this.jSplitPane1.setRightComponent(this.jPanel2);
        GroupLayout groupLayout3 = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.jSplitPane1, -1, 700, Short.MAX_VALUE).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.jSplitPane1, -1, 143, Short.MAX_VALUE).addContainerGap()));
        this.viewSourceButton.setMnemonic('V');
        this.viewSourceButton.setText(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.viewSourceButton.text"));
        this.viewSourceButton.setEnabled(false);
        this.viewSourceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GlobalActionPanel.this.viewSourceButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout4 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.projectCombo, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.classCombo, -2, -1, -2).addPreferredGap(0, 349, Short.MAX_VALUE).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.filterTextfield, -2, 80, -2)).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.newActionButton).add(6, 6, 6).add((Component)this.editActionButton).addPreferredGap(0).add((Component)this.viewSourceButton).addPreferredGap(0).add((Component)this.deleteActionButton).addContainerGap(313, Short.MAX_VALUE)).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.classCombo, -2, -1, -2).add((Component)this.jLabel1).add((Component)this.jLabel4).add((Component)this.projectCombo, -2, -1, -2).add((Component)this.filterTextfield, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.newActionButton).add((Component)this.editActionButton).add((Component)this.viewSourceButton).add((Component)this.deleteActionButton))));
        this.newActionButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.newActionButton.AccessibleContext.accessibleDescription"));
        this.editActionButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.editActionButton.AccessibleContext.accessibleDescription"));
        this.deleteActionButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.deleteActionButton.AccessibleContext.accessibleDescription"));
        this.projectCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.projectCombo.AccessibleContext.accessibleName"));
        this.projectCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.projectCombo.AccessibleContext.accessibleDescription"));
        this.classCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.classCombo.AccessibleContext.accessibleName"));
        this.classCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.classCombo.AccessibleContext.accessibleDescription"));
        this.filterTextfield.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.filterTextfield.AccessibleContext.accessibleName"));
        this.filterTextfield.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.filterTextfield.AccessibleContext.accessibleDescription"));
        this.viewSourceButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GlobalActionPanel.class, (String)"GlobalActionPanel.viewSourceButton.AccessibleContext.accessibleDescription"));
    }

    private void viewSourceButtonActionPerformed(ActionEvent actionEvent) {
        this.viewsourceSelectedAction();
    }

    private void projectComboActionPerformed(ActionEvent actionEvent) {
        if (this.projectCombo.getSelectedItem() != null) {
            this.setSelectedProject((Project)this.projectCombo.getSelectedItem());
        }
    }

    private void editActionButtonActionPerformed(ActionEvent actionEvent) {
        this.editSelectedAction();
    }

    Action getDeleteAction() {
        return this.deleteAction;
    }

    private void editSelectedAction() {
        ProxyAction proxyAction = this.getSelectedAction();
        int n = this.getSelectedRow();
        if (proxyAction == null) {
            return;
        }
        String string = proxyAction.getClassname();
        FileObject fileObject = this.actionManager.getFileForClass(string);
        if (fileObject == null) {
            fileObject = this.actionManager.getApplicationClassFile();
        }
        ActionEditor actionEditor = new ActionEditor(fileObject);
        actionEditor.setValue(proxyAction);
        ActionPropertyEditorPanel actionPropertyEditorPanel = (ActionPropertyEditorPanel)actionEditor.getCustomEditor();
        actionPropertyEditorPanel.setMode(ActionPropertyEditorPanel.Mode.Global);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)actionPropertyEditorPanel, GlobalActionPanel.getLocalizedString("editActionPropertiesDialog.title"), true, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.pack();
        dialog.setVisible(true);
        if (dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            try {
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "action", proxyAction, actionEditor.getValue());
                actionEditor.confirmChanges(propertyChangeEvent);
                this.setSelectedRow(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
            }
            catch (PropertyVetoException propertyVetoException) {
                ErrorManager.getDefault().notify((Throwable)propertyVetoException);
            }
        }
    }

    private void viewsourceSelectedAction() {
        ProxyAction proxyAction = this.getSelectedAction();
        if (proxyAction == null) {
            return;
        }
        this.actionManager.jumpToActionSource(proxyAction);
    }

    private int getSelectedRow() {
        return this.actionTable.getSelectedRow();
    }

    private ProxyAction getSelectedAction() {
        int n = this.actionTable.getSelectedRow();
        if (n < 0) {
            return null;
        }
        TableSorter tableSorter = (TableSorter)this.actionTable.getModel();
        n = tableSorter.modelIndex(n);
        FilteredTableModel filteredTableModel = (FilteredTableModel)tableSorter.getTableModel();
        ActionTableModel actionTableModel = (ActionTableModel)filteredTableModel.getTableModel();
        ProxyAction proxyAction = actionTableModel.getAction(n);
        return proxyAction;
    }

    private void setSelectedRow(int n) {
        this.actionTable.getSelectionModel().setSelectionInterval(n, n);
    }

    private void deleteSelectedAction() {
        ProxyAction proxyAction = this.getSelectedAction();
        if (proxyAction == null) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(this, GlobalActionPanel.getLocalizedString("deleteActionQuestion") + proxyAction.getId(), GlobalActionPanel.getLocalizedString("deleteActionButton.text"), 2);
        if (n == 0) {
            this.actionManager.deleteAction(proxyAction);
            this.reloadTable();
        }
    }

    private void newActionButtonActionPerformed(ActionEvent actionEvent) {
        FileObject fileObject = this.actionManager.getRoot();
        if (fileObject == null) {
            return;
        }
        ActionEditor actionEditor = new ActionEditor(fileObject, true);
        ActionPropertyEditorPanel actionPropertyEditorPanel = (ActionPropertyEditorPanel)actionEditor.getCustomEditor();
        actionPropertyEditorPanel.setMode(ActionPropertyEditorPanel.Mode.NewActionGlobal);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)actionPropertyEditorPanel, GlobalActionPanel.getLocalizedString("createNewActionDialog.title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        while (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            if (actionPropertyEditorPanel.canCreateNewAction()) {
                actionEditor.setSourceFile(actionPropertyEditorPanel.getSelectedSourceFile());
                actionEditor.createNewAction();
                break;
            }
            String string = "UNKNOWN ERROR";
            if (!actionPropertyEditorPanel.isMethodNonEmpty()) {
                string = NbBundle.getMessage(ActionEditor.class, (String)"ActionEditor.createMethodError.emptyMethod");
            } else if (actionPropertyEditorPanel.doesMethodContainBadChars()) {
                string = NbBundle.getMessage(ActionEditor.class, (String)"ActionEditor.createMethodError.invalidName", (Object)actionPropertyEditorPanel.getNewMethodName());
            } else if (!actionPropertyEditorPanel.isValidClassname()) {
                string = NbBundle.getMessage(ActionEditor.class, (String)"ActionEditor.createMethodError.invalidClassname");
            } else if (actionPropertyEditorPanel.isDuplicateMethod()) {
                string = NbBundle.getMessage(ActionEditor.class, (String)"ActionEditor.createMethodError.duplicateMethod", (Object)actionPropertyEditorPanel.getNewMethodName());
            }
            JOptionPane.showMessageDialog(dialog, string);
            dialog.setVisible(true);
        }
    }

    private void classComboActionPerformed(ActionEvent actionEvent) {
        if (this.classCombo.getSelectedItem() == SHOW_ALL_CLASSES) {
            this.filterClass = null;
            this.reloadTable();
        } else {
            this.filterClass = (String)this.classCombo.getSelectedItem();
            this.reloadTable();
        }
    }

    private void reloadTable() {
        this.realModel = this.filterClass == null ? new ActionTableModel(this.actionManager.getAllActions()) : new ActionTableModel(this.actionManager.getActions(this.filterClass, false));
        this.actionTable.setModel(new TableSorter(new FilteredTableModel(this.realModel), this.actionTable.getTableHeader()));
        this.filterTable();
        GlobalActionPanel.initColumnSizes(this.actionTable);
        this.actionTable.getColumnModel().moveColumn(ActionTableModel.ICON_COLUMN, 3);
        this.actionTable.getColumnModel().moveColumn(ActionTableModel.TASK_COLUMN, 4);
        this.actionTable.getColumnModel().moveColumn(6, 5);
        this.boundComponentList.setModel(new DefaultListModel());
    }

    public void refresh() {
        this.actionManager.rescan();
        this.reloadProjectsCombo();
        this.reloadClassesCombo();
        this.reloadTable();
    }

    private void setSelectedProject(Project project) {
        if (this.actionManager != ActionManager.getActionManager(project)) {
            if (this.actionManager != null) {
                this.actionManager.removePropertyChangeListener(this.amListener);
                this.actionManager.removeActionChangedListener(this.actChangeListener);
            }
            this.actionManager = ActionManager.getActionManager(project);
            if (this.actionManager != null) {
                this.actionManager.addPropertyChangeListener(this.amListener);
                this.actionManager.addActionChangedListener(this.actChangeListener);
            }
        }
        this.reloadClassesCombo();
        this.classCombo.setSelectedItem(SHOW_ALL_CLASSES);
        this.reloadTable();
    }

    private void filterTable() {
        FilteredTableModel filteredTableModel = (FilteredTableModel)((TableSorter)this.actionTable.getModel()).getTableModel();
        filteredTableModel.setFilterString(this.filterTextfield.getText());
    }

    private void jumpToSelectedComponent() {
        RADComponent rADComponent = (RADComponent)this.boundComponentList.getSelectedValue();
        if (rADComponent != null) {
            FormModel formModel = rADComponent.getFormModel();
            FileObject fileObject = FormEditor.getFormDataObject((FormModel)formModel).getPrimaryFile();
            try {
                FormDataObject formDataObject = (FormDataObject)FormDataObject.find((FileObject)fileObject);
                formDataObject.getFormEditor().loadForm();
                formDataObject.getFormEditor().openFormEditor(true);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                dataObjectNotFoundException.printStackTrace();
            }
        }
    }

    private void switchedToTopComponent(TopComponent topComponent) {
        if (topComponent == null) {
            return;
        }
        FormEditorSupport formEditorSupport = FormEditorSupport.getFormEditor((TopComponent)topComponent);
        if (formEditorSupport == null) {
            return;
        }
        FileObject fileObject = formEditorSupport.getFormDataObject().getFormFile();
        if (!AppFrameworkSupport.isFrameworkEnabledProject(fileObject)) {
            return;
        }
        if (this.actionManager != ActionManager.getActionManager(fileObject)) {
            if (this.actionManager != null) {
                this.actionManager.removePropertyChangeListener(this.amListener);
                this.actionManager.removeActionChangedListener(this.actChangeListener);
            }
            this.actionManager = ActionManager.getActionManager(fileObject);
            if (this.actionManager != null) {
                this.actionManager.addPropertyChangeListener(this.amListener);
                this.actionManager.addActionChangedListener(this.actChangeListener);
                this.refresh();
            }
        }
    }

    private void attachTopComponentsListener() {
        if (this.topcompsListener != null) {
            return;
        }
        this.topcompsListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("activated".equals(propertyChangeEvent.getPropertyName())) {
                    TopComponent topComponent = TopComponent.getRegistry().getActivated();
                    GlobalActionPanel.this.switchedToTopComponent(topComponent);
                }
            }
        };
        TopComponent.getRegistry().addPropertyChangeListener(this.topcompsListener);
        OpenProjects.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                GlobalActionPanel.this.checkOpenProjects();
            }
        });
        this.checkOpenProjects();
    }

    private void checkOpenProjects() {
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        if (ActionManager.clearClosedProjects(projectArray)) {
            this.reloadProjectsCombo();
        }
    }

    private static String getLocalizedString(String string) {
        return NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)("GlobalActionPanel." + string));
    }

    private static void initColumnSizes(JTable jTable) {
        TableModel tableModel = jTable.getModel();
        TableColumn tableColumn = null;
        Component component = null;
        int n = 0;
        int n2 = 0;
        int n3 = tableModel.getColumnCount();
        int n4 = tableModel.getRowCount();
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        for (int i = 0; i < n3; ++i) {
            tableColumn = jTable.getColumnModel().getColumn(i);
            Object object = null;
            for (int j = 0; j < n4; ++j) {
                Object object2 = tableModel.getValueAt(j, i);
                if (object == null) {
                    object = object2;
                    continue;
                }
                if (!(object instanceof String) || !(object2 instanceof String) || ((String)object2).length() <= ((String)object).length()) continue;
                object = object2;
            }
            component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, 0);
            n = component.getPreferredSize().width;
            if (object == null) {
                n2 = 0;
            } else {
                component = jTable.getDefaultRenderer(tableModel.getColumnClass(i)).getTableCellRendererComponent(jTable, object, false, false, 0, i);
                n2 = component.getPreferredSize().width;
                n2 += 5;
            }
            tableColumn.setPreferredWidth(Math.max(n, n2));
        }
    }
}

