/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import org.netbeans.modules.debugger.jpda.expr.JavaParserConstants;
import org.netbeans.modules.debugger.jpda.expr.Token;

class Operators
implements JavaParserConstants {
    private VirtualMachine vm;

    public Operators(VirtualMachine virtualMachine) {
        this.vm = virtualMachine;
    }

    public PrimitiveValue evaluate(Token token, PrimitiveValue primitiveValue) {
        switch (token.kind) {
            case 95: {
                if (!(primitiveValue instanceof BooleanValue)) break;
                return this.vm.mirrorOf(!primitiveValue.booleanValue());
            }
            case 96: {
                if (primitiveValue instanceof BooleanValue || primitiveValue instanceof DoubleValue || primitiveValue instanceof FloatValue) break;
                if (primitiveValue instanceof LongValue) {
                    return this.vm.mirrorOf(primitiveValue.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                }
                return this.vm.mirrorOf(~primitiveValue.intValue());
            }
            case 107: {
                if (primitiveValue instanceof BooleanValue) break;
                return primitiveValue;
            }
            case 108: {
                if (primitiveValue instanceof BooleanValue) break;
                if (primitiveValue instanceof DoubleValue) {
                    return this.vm.mirrorOf(-primitiveValue.doubleValue());
                }
                if (primitiveValue instanceof FloatValue) {
                    return this.vm.mirrorOf(-primitiveValue.floatValue());
                }
                if (primitiveValue instanceof LongValue) {
                    return this.vm.mirrorOf(-primitiveValue.longValue());
                }
                return this.vm.mirrorOf(-primitiveValue.intValue());
            }
            case 105: 
            case 106: {
                int n;
                int n2 = n = token.kind == 105 ? 1 : -1;
                if (primitiveValue instanceof BooleanValue) break;
                if (primitiveValue instanceof DoubleValue) {
                    return this.vm.mirrorOf(primitiveValue.doubleValue() + (double)n);
                }
                if (primitiveValue instanceof FloatValue) {
                    return this.vm.mirrorOf(primitiveValue.floatValue() + (float)n);
                }
                if (primitiveValue instanceof LongValue) {
                    return this.vm.mirrorOf(primitiveValue.longValue() + (long)n);
                }
                return this.vm.mirrorOf(primitiveValue.intValue() + n);
            }
        }
        throw new IllegalArgumentException("badUnarySemantics");
    }

    public Value evaluate(Value value, Token token, Value value2) {
        boolean bl;
        if (value instanceof BooleanValue && value2 instanceof BooleanValue) {
            boolean bl2 = ((BooleanValue)value).booleanValue();
            boolean bl3 = ((BooleanValue)value2).booleanValue();
            boolean bl4 = false;
            switch (token.kind) {
                case 99: {
                    bl4 = bl2 == bl3;
                    break;
                }
                case 102: {
                    bl4 = bl2 != bl3;
                    break;
                }
                case 112: {
                    bl4 = bl2 | bl3;
                    break;
                }
                case 111: {
                    bl4 = bl2 & bl3;
                    break;
                }
                case 113: {
                    bl4 = bl2 ^ bl3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("badBinarySemantics");
                }
            }
            return this.vm.mirrorOf(bl4);
        }
        boolean bl5 = value instanceof PrimitiveValue && !(value instanceof BooleanValue);
        boolean bl6 = bl = value2 instanceof PrimitiveValue && !(value2 instanceof BooleanValue);
        if (bl5 && bl) {
            switch (token.kind) {
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 114: {
                    return this.evaluateAddOperator((PrimitiveValue)value, (PrimitiveValue)value2, token.kind);
                }
                case 115: 
                case 116: 
                case 117: {
                    return this.evaluateShiftOperator((PrimitiveValue)value, (PrimitiveValue)value2, token.kind);
                }
                case 111: 
                case 112: 
                case 113: {
                    return this.evaluateBitOperator((PrimitiveValue)value, (PrimitiveValue)value2, token.kind);
                }
                case 93: 
                case 94: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    return this.evaluateComparisonOperator((PrimitiveValue)value, (PrimitiveValue)value2, token.kind);
                }
            }
        }
        if (token.kind == 99 || token.kind == 102) {
            if (value == null) {
                if (value2 == null) {
                    return this.vm.mirrorOf(token.kind == 99);
                }
                if (value2 instanceof ObjectReference) {
                    return this.vm.mirrorOf(token.kind == 102);
                }
            }
            if (value instanceof ObjectReference) {
                if (value2 == null) {
                    return this.vm.mirrorOf(token.kind == 102);
                }
                if (value2 instanceof ObjectReference) {
                    if (token.kind == 99) {
                        return this.vm.mirrorOf(value2.equals(value));
                    }
                    return this.vm.mirrorOf(!value2.equals(value));
                }
            }
        }
        if ((value == null || value instanceof StringReference || value2 == null || value2 instanceof StringReference) && token.kind == 107) {
            String string = null;
            String string2 = null;
            string = value instanceof StringReference ? ((StringReference)value).value() : (value == null ? "null" : value.toString());
            string2 = value2 instanceof StringReference ? ((StringReference)value2).value() : (value2 == null ? "null" : value2.toString());
            return this.vm.mirrorOf(string + string2);
        }
        throw new IllegalArgumentException("Bad semantics for binary operator");
    }

    private PrimitiveValue evaluateAddOperator(PrimitiveValue primitiveValue, PrimitiveValue primitiveValue2, int n) {
        if (primitiveValue instanceof DoubleValue || primitiveValue2 instanceof DoubleValue) {
            double d = primitiveValue.doubleValue();
            double d2 = primitiveValue2.doubleValue();
            double d3 = 0.0;
            switch (n) {
                case 107: {
                    d3 = d + d2;
                    break;
                }
                case 108: {
                    d3 = d - d2;
                    break;
                }
                case 114: {
                    d3 = d % d2;
                    break;
                }
                case 109: {
                    d3 = d * d2;
                    break;
                }
                case 110: {
                    d3 = d / d2;
                }
            }
            return this.vm.mirrorOf(d3);
        }
        if (primitiveValue instanceof FloatValue || primitiveValue2 instanceof FloatValue) {
            float f = primitiveValue.floatValue();
            float f2 = primitiveValue2.floatValue();
            float f3 = 0.0f;
            switch (n) {
                case 107: {
                    f3 = f + f2;
                    break;
                }
                case 108: {
                    f3 = f - f2;
                    break;
                }
                case 114: {
                    f3 = f % f2;
                    break;
                }
                case 109: {
                    f3 = f * f2;
                    break;
                }
                case 110: {
                    f3 = f / f2;
                }
            }
            return this.vm.mirrorOf(f3);
        }
        if (primitiveValue instanceof LongValue || primitiveValue2 instanceof LongValue) {
            long l = primitiveValue.longValue();
            long l2 = primitiveValue2.longValue();
            long l3 = 0L;
            switch (n) {
                case 107: {
                    l3 = l + l2;
                    break;
                }
                case 108: {
                    l3 = l - l2;
                    break;
                }
                case 114: {
                    l3 = l % l2;
                    break;
                }
                case 109: {
                    l3 = l * l2;
                    break;
                }
                case 110: {
                    l3 = l / l2;
                }
            }
            return this.vm.mirrorOf(l3);
        }
        int n2 = primitiveValue.intValue();
        int n3 = primitiveValue2.intValue();
        int n4 = 0;
        switch (n) {
            case 107: {
                n4 = n2 + n3;
                break;
            }
            case 108: {
                n4 = n2 - n3;
                break;
            }
            case 114: {
                n4 = n2 % n3;
                break;
            }
            case 109: {
                n4 = n2 * n3;
                break;
            }
            case 110: {
                n4 = n2 / n3;
            }
        }
        return this.vm.mirrorOf(n4);
    }

    private PrimitiveValue evaluateShiftOperator(PrimitiveValue primitiveValue, PrimitiveValue primitiveValue2, int n) {
        if (primitiveValue instanceof FloatValue || primitiveValue instanceof DoubleValue || primitiveValue2 instanceof FloatValue || primitiveValue2 instanceof DoubleValue) {
            throw new IllegalArgumentException("Bad semantics for shift operator");
        }
        if (primitiveValue instanceof LongValue) {
            long l = primitiveValue.longValue();
            long l2 = primitiveValue2.longValue();
            long l3 = 0L;
            switch (n) {
                case 115: {
                    l3 = l << (int)l2;
                    break;
                }
                case 116: {
                    l3 = l >> (int)l2;
                    break;
                }
                case 117: {
                    l3 = l >>> (int)l2;
                }
            }
            return this.vm.mirrorOf(l3);
        }
        int n2 = primitiveValue.intValue();
        long l = primitiveValue2.longValue();
        int n3 = 0;
        switch (n) {
            case 115: {
                n3 = n2 << (int)l;
                break;
            }
            case 116: {
                n3 = n2 >> (int)l;
                break;
            }
            case 117: {
                n3 = n2 >>> (int)l;
            }
        }
        return this.vm.mirrorOf(n3);
    }

    private PrimitiveValue evaluateBitOperator(PrimitiveValue primitiveValue, PrimitiveValue primitiveValue2, int n) {
        if (primitiveValue instanceof FloatValue || primitiveValue instanceof DoubleValue || primitiveValue2 instanceof FloatValue || primitiveValue2 instanceof DoubleValue) {
            throw new IllegalArgumentException("Bad semantics for bit operator");
        }
        if (primitiveValue instanceof LongValue || primitiveValue2 instanceof LongValue) {
            long l = primitiveValue.longValue();
            long l2 = primitiveValue2.longValue();
            long l3 = 0L;
            switch (n) {
                case 111: {
                    l3 = l & l2;
                    break;
                }
                case 112: {
                    l3 = l | l2;
                    break;
                }
                case 113: {
                    l3 = l ^ l2;
                }
            }
            return this.vm.mirrorOf(l3);
        }
        int n2 = primitiveValue.intValue();
        int n3 = primitiveValue2.intValue();
        int n4 = 0;
        switch (n) {
            case 111: {
                n4 = n2 & n3;
                break;
            }
            case 112: {
                n4 = n2 | n3;
                break;
            }
            case 113: {
                n4 = n2 ^ n3;
            }
        }
        return this.vm.mirrorOf(n4);
    }

    private BooleanValue evaluateComparisonOperator(PrimitiveValue primitiveValue, PrimitiveValue primitiveValue2, int n) {
        boolean bl = false;
        if (primitiveValue instanceof DoubleValue || primitiveValue2 instanceof DoubleValue) {
            double d = primitiveValue.doubleValue();
            double d2 = primitiveValue2.doubleValue();
            switch (n) {
                case 94: {
                    bl = d < d2;
                    break;
                }
                case 93: {
                    bl = d > d2;
                    break;
                }
                case 100: {
                    bl = d <= d2;
                    break;
                }
                case 101: {
                    bl = d >= d2;
                    break;
                }
                case 99: {
                    bl = d == d2;
                    break;
                }
                case 102: {
                    bl = d != d2;
                }
            }
        } else if (primitiveValue instanceof FloatValue || primitiveValue2 instanceof FloatValue) {
            float f = primitiveValue.floatValue();
            float f2 = primitiveValue2.floatValue();
            switch (n) {
                case 94: {
                    bl = f < f2;
                    break;
                }
                case 93: {
                    bl = f > f2;
                    break;
                }
                case 100: {
                    bl = f <= f2;
                    break;
                }
                case 101: {
                    bl = f >= f2;
                    break;
                }
                case 99: {
                    bl = f == f2;
                    break;
                }
                case 102: {
                    bl = f != f2;
                }
            }
        } else if (primitiveValue instanceof LongValue || primitiveValue instanceof LongValue) {
            long l = primitiveValue.longValue();
            long l2 = primitiveValue2.longValue();
            switch (n) {
                case 94: {
                    bl = l < l2;
                    break;
                }
                case 93: {
                    bl = l > l2;
                    break;
                }
                case 100: {
                    bl = l <= l2;
                    break;
                }
                case 101: {
                    bl = l >= l2;
                    break;
                }
                case 99: {
                    bl = l == l2;
                    break;
                }
                case 102: {
                    bl = l != l2;
                }
            }
        } else {
            float f = primitiveValue.intValue();
            float f3 = primitiveValue2.intValue();
            switch (n) {
                case 94: {
                    bl = f < f3;
                    break;
                }
                case 93: {
                    bl = f > f3;
                    break;
                }
                case 100: {
                    bl = f <= f3;
                    break;
                }
                case 101: {
                    bl = f >= f3;
                    break;
                }
                case 99: {
                    bl = f == f3;
                    break;
                }
                case 102: {
                    bl = f != f3;
                }
            }
        }
        return this.vm.mirrorOf(bl);
    }
}

