/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.ReturnVariableImpl;
import org.netbeans.modules.debugger.jpda.models.ThisVariable;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JPDAThreadImpl
implements JPDAThread,
Customizer {
    public static final String PROP_SUSPENDED = "suspended";
    private ThreadReference threadReference;
    private JPDADebuggerImpl debugger;
    private boolean suspended;
    private int suspendCount;
    private EditorContext.Operation currentOperation;
    private List<EditorContext.Operation> lastOperations;
    private boolean doKeepLastOperations;
    private ReturnVariableImpl returnVariable;
    private PropertyChangeSupport pch = new PropertyChangeSupport(this);
    private CallStackFrame[] cachedFrames;
    private int cachedFramesFrom = -1;
    private int cachedFramesTo = -1;
    private Object cachedFramesLock = new Object();
    private Object lastBottomSF;
    private boolean methodInvoking;
    private boolean methodInvokingDisabledUntilResumed;

    public JPDAThreadImpl(ThreadReference threadReference, JPDADebuggerImpl jPDADebuggerImpl) {
        this.threadReference = threadReference;
        this.debugger = jPDADebuggerImpl;
        this.suspended = threadReference.isSuspended();
        this.suspendCount = threadReference.suspendCount();
    }

    public String getName() {
        try {
            return this.threadReference.name();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return "";
        }
        catch (ObjectCollectedException objectCollectedException) {
            return "";
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return "";
        }
    }

    public JPDAThreadGroup getParentThreadGroup() {
        try {
            ThreadGroupReference threadGroupReference = this.threadReference.threadGroup();
            if (threadGroupReference == null) {
                return null;
            }
            return this.debugger.getThreadGroup(threadGroupReference);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return null;
        }
        catch (ObjectCollectedException objectCollectedException) {
            return null;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return null;
        }
    }

    public int getLineNumber(String string) {
        try {
            if (this.threadReference.frameCount() < 1) {
                return -1;
            }
            return this.threadReference.frame(0).location().lineNumber(string);
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return -1;
    }

    public synchronized EditorContext.Operation getCurrentOperation() {
        return this.currentOperation;
    }

    public synchronized void setCurrentOperation(EditorContext.Operation operation) {
        this.currentOperation = operation;
    }

    public synchronized List<EditorContext.Operation> getLastOperations() {
        return this.lastOperations;
    }

    public synchronized void addLastOperation(EditorContext.Operation operation) {
        if (this.lastOperations == null) {
            this.lastOperations = new ArrayList<EditorContext.Operation>();
        }
        this.lastOperations.add(operation);
    }

    public synchronized void clearLastOperations() {
        if (this.lastOperations != null) {
            for (EditorContext.Operation operation : this.lastOperations) {
                operation.setReturnValue(null);
            }
        }
        this.lastOperations = null;
    }

    public synchronized void holdLastOperations(boolean bl) {
        this.doKeepLastOperations = bl;
    }

    public int getState() {
        try {
            return this.threadReference.status();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return -1;
    }

    public synchronized boolean isSuspended() {
        return this.suspended;
    }

    public boolean isThreadSuspended() {
        try {
            return this.threadReference.isSuspended();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return false;
    }

    public String getClassName() {
        try {
            if (this.threadReference.frameCount() < 1) {
                return "";
            }
            return this.threadReference.frame(0).location().declaringType().name();
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return "";
    }

    public String getMethodName() {
        try {
            if (this.threadReference.frameCount() < 1) {
                return "";
            }
            return this.threadReference.frame(0).location().method().name();
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return "";
    }

    public String getSourceName(String string) throws AbsentInformationException {
        try {
            if (this.threadReference.frameCount() < 1) {
                return "";
            }
            return this.threadReference.frame(0).location().sourceName(string);
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return "";
    }

    public String getSourcePath(String string) throws AbsentInformationException {
        try {
            if (this.threadReference.frameCount() < 1) {
                return "";
            }
            return this.threadReference.frame(0).location().sourcePath(string);
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return "";
    }

    public CallStackFrame[] getCallStack() throws AbsentInformationException {
        return this.getCallStack(0, this.getStackDepth());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallStackFrame[] getCallStack(int n, int n2) throws AbsentInformationException {
        try {
            int n3 = this.threadReference.frameCount();
            n = Math.min(n, n3);
            n2 = Math.min(n2, n3);
            if (n2 - n > 1) {
                Object object = this.cachedFramesLock;
                synchronized (object) {
                    if (n == this.cachedFramesFrom && n2 == this.cachedFramesTo) {
                        return this.cachedFrames;
                    }
                }
            }
            if (n < 0) {
                throw new IndexOutOfBoundsException("from = " + n);
            }
            if (n == n2) {
                return new CallStackFrame[0];
            }
            if (n >= n3) {
                throw new IndexOutOfBoundsException("from = " + n + " is too high, frame count = " + n3);
            }
            int n4 = n2 - n;
            if (n4 < 0 || n + n4 > n3) {
                throw new IndexOutOfBoundsException("from = " + n + ", to = " + n2 + ", frame count = " + n3);
            }
            List<StackFrame> list = this.threadReference.frames(n, n4);
            int n5 = list.size();
            CallStackFrame[] callStackFrameArray = new CallStackFrame[n5];
            for (int i = 0; i < n5; ++i) {
                callStackFrameArray[i] = new CallStackFrameImpl(list.get(i), n + i, this.debugger);
                if (n != 0 || i != 0 || this.currentOperation == null) continue;
                ((CallStackFrameImpl)callStackFrameArray[i]).setCurrentOperation(this.currentOperation);
            }
            if (n2 - n > 1) {
                Object object = this.cachedFramesLock;
                synchronized (object) {
                    this.cachedFrames = callStackFrameArray;
                    this.cachedFramesFrom = n;
                    this.cachedFramesTo = n2;
                }
            }
            return callStackFrameArray;
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            AbsentInformationException absentInformationException = new AbsentInformationException(incompatibleThreadStateException.getLocalizedMessage());
            absentInformationException.initCause(incompatibleThreadStateException);
            throw absentInformationException;
        }
        catch (ObjectCollectedException objectCollectedException) {
            AbsentInformationException absentInformationException = new AbsentInformationException(objectCollectedException.getLocalizedMessage());
            absentInformationException.initCause(objectCollectedException);
            throw absentInformationException;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            AbsentInformationException absentInformationException = new AbsentInformationException(illegalThreadStateException.getLocalizedMessage());
            absentInformationException.initCause(illegalThreadStateException);
            throw absentInformationException;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return new CallStackFrame[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCachedFrames() {
        Object object = this.cachedFramesLock;
        synchronized (object) {
            this.cachedFrames = null;
            this.cachedFramesFrom = -1;
            this.cachedFramesTo = -1;
        }
    }

    public int getStackDepth() {
        try {
            return this.threadReference.frameCount();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            // empty catch block
        }
        return 0;
    }

    public void popFrames(StackFrame stackFrame) throws IncompatibleThreadStateException {
        try {
            this.threadReference.popFrames(stackFrame);
            this.cleanCachedFrames();
            this.setReturnVariable(null);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            throw new IncompatibleThreadStateException("Thread exited.");
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new IncompatibleThreadStateException("Thread died.");
        }
        catch (NativeMethodException nativeMethodException) {
            this.cleanCachedFrames();
            ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)nativeMethodException, NbBundle.getMessage(JPDAThreadImpl.class, (String)"MSG_NativeMethodPop")));
        }
        catch (InternalException internalException) {
            this.cleanCachedFrames();
            if (internalException.errorCode() == 32) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)internalException, NbBundle.getMessage(JPDAThreadImpl.class, (String)"MSG_NativeMethodPop")));
            }
            throw internalException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Boolean bl = null;
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            try {
                if (!this.isSuspended()) {
                    this.threadReference.suspend();
                    bl = Boolean.TRUE;
                    ++this.suspendCount;
                }
                this.suspended = true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
            }
            catch (ObjectCollectedException objectCollectedException) {
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
        if (bl != null) {
            this.pch.firePropertyChange(PROP_SUSPENDED, (Object)(bl == false ? 1 : 0), bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        boolean bl;
        if (this == this.debugger.getCurrentThread() && !(bl = this.debugger.currentThreadToBeResumed())) {
            return;
        }
        Boolean bl2 = null;
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            this.waitUntilMethodInvokeDone();
            this.setReturnVariable(null);
            this.setCurrentOperation(null);
            if (!this.doKeepLastOperations) {
                this.clearLastOperations();
            }
            try {
                if (this.isSuspended()) {
                    for (int i = this.threadReference.suspendCount(); i > 0; --i) {
                        this.threadReference.resume();
                    }
                    bl2 = Boolean.FALSE;
                }
                this.suspendCount = 0;
                this.suspended = false;
                this.methodInvokingDisabledUntilResumed = false;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
            }
            catch (ObjectCollectedException objectCollectedException) {
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
        this.cleanCachedFrames();
        if (bl2 != null) {
            this.pch.firePropertyChange(PROP_SUSPENDED, (Object)(bl2 == false ? 1 : 0), bl2);
        }
    }

    public void notifyToBeResumed() {
        this.notifyToBeRunning(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyToBeRunning(boolean bl, boolean bl2) {
        Boolean bl3 = null;
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            if (bl2) {
                this.waitUntilMethodInvokeDone();
            }
            if (bl2 && --this.suspendCount > 0) {
                return;
            }
            this.suspendCount = 0;
            if (bl) {
                this.setCurrentOperation(null);
                this.setReturnVariable(null);
                if (!this.doKeepLastOperations) {
                    this.clearLastOperations();
                }
            }
            if (this.suspended) {
                this.suspended = false;
                bl3 = Boolean.FALSE;
                this.methodInvokingDisabledUntilResumed = false;
            }
        }
        this.cleanCachedFrames();
        if (bl3 != null) {
            this.pch.firePropertyChange(PROP_SUSPENDED, (Object)(bl3 == false ? 1 : 0), bl3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySuspended() {
        Boolean bl = null;
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            try {
                this.suspendCount = this.threadReference.suspendCount();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return;
            }
            catch (ObjectCollectedException objectCollectedException) {
                return;
            }
            if (!this.suspended && this.isThreadSuspended()) {
                this.suspended = true;
                bl = Boolean.TRUE;
            }
        }
        if (bl != null) {
            this.pch.firePropertyChange(PROP_SUSPENDED, (Object)(bl == false ? 1 : 0), bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMethodInvoking() throws PropertyVetoException {
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            if (this.methodInvokingDisabledUntilResumed) {
                throw new PropertyVetoException("disabled until resumed", null);
            }
            if (this.methodInvoking) {
                throw new PropertyVetoException("Already invoking!", null);
            }
            this.methodInvoking = true;
        }
        this.notifyToBeRunning(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMethodInvokeDone() {
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            this.methodInvoking = false;
            this.notifyAll();
        }
        this.notifySuspended();
    }

    public synchronized boolean isMethodInvoking() {
        return this.methodInvoking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilMethodInvokeDone() {
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            while (this.methodInvoking) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    public synchronized void disableMethodInvokeUntilResumed() {
        this.methodInvokingDisabledUntilResumed = true;
    }

    public void interrupt() {
        try {
            if (this.isSuspended()) {
                return;
            }
            this.threadReference.interrupt();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    public void makeCurrent() {
        this.debugger.setCurrentThread(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectVariable getContendedMonitor() {
        ObjectReference objectReference;
        try {
            if (!this.threadReference.virtualMachine().canGetCurrentContendedMonitor()) {
                return null;
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return null;
        }
        catch (ObjectCollectedException objectCollectedException) {
            return null;
        }
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            if (!this.isSuspended()) {
                return null;
            }
            if ("DestroyJavaVM".equals(this.threadReference.name())) {
                return null;
            }
            try {
                objectReference = this.threadReference.currentContendedMonitor();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return null;
            }
            catch (ObjectCollectedException objectCollectedException) {
                return null;
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                String string = "Thread '" + this.threadReference.name() + "': status = " + this.threadReference.status() + ", is suspended = " + this.threadReference.isSuspended() + ", suspend count = " + this.threadReference.suspendCount() + ", is at breakpoint = " + this.threadReference.isAtBreakpoint() + ", internal suspend status = " + this.suspended;
                Logger.getLogger(JPDAThreadImpl.class.getName()).log(Level.WARNING, string, incompatibleThreadStateException);
                return null;
            }
            catch (InternalException internalException) {
                String string = "Thread '" + this.threadReference.name() + "': status = " + this.threadReference.status() + ", is suspended = " + this.threadReference.isSuspended() + ", suspend count = " + this.threadReference.suspendCount() + ", is at breakpoint = " + this.threadReference.isAtBreakpoint() + ", internal suspend status = " + this.suspended;
                Logger.getLogger(JPDAThreadImpl.class.getName()).log(Level.WARNING, string, internalException);
                return null;
            }
        }
        if (objectReference == null) {
            return null;
        }
        return new ThisVariable(this.debugger, objectReference, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectVariable[] getOwnedMonitors() {
        List<ObjectReference> list;
        try {
            if (!this.threadReference.virtualMachine().canGetOwnedMonitorInfo()) {
                return new ObjectVariable[0];
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return new ObjectVariable[0];
        }
        catch (ObjectCollectedException objectCollectedException) {
            return new ObjectVariable[0];
        }
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            if (!this.isSuspended()) {
                return new ObjectVariable[0];
            }
            if ("DestroyJavaVM".equals(this.threadReference.name())) {
                return new ObjectVariable[0];
            }
            try {
                list = this.threadReference.ownedMonitors();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return new ObjectVariable[0];
            }
            catch (ObjectCollectedException objectCollectedException) {
                return new ObjectVariable[0];
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                String string = "Thread '" + this.threadReference.name() + "': status = " + this.threadReference.status() + ", is suspended = " + this.threadReference.isSuspended() + ", suspend count = " + this.threadReference.suspendCount() + ", is at breakpoint = " + this.threadReference.isAtBreakpoint() + ", internal suspend status = " + this.suspended;
                Logger.getLogger(JPDAThreadImpl.class.getName()).log(Level.WARNING, string, incompatibleThreadStateException);
                return new ObjectVariable[0];
            }
            catch (InternalException internalException) {
                String string = "Thread '" + this.threadReference.name() + "': status = " + this.threadReference.status() + ", is suspended = " + this.threadReference.isSuspended() + ", suspend count = " + this.threadReference.suspendCount() + ", is at breakpoint = " + this.threadReference.isAtBreakpoint() + ", internal suspend status = " + this.suspended;
                Logger.getLogger(JPDAThreadImpl.class.getName()).log(Level.WARNING, string, internalException);
                return new ObjectVariable[0];
            }
        }
        int n = list.size();
        ObjectVariable[] objectVariableArray = new ObjectVariable[n];
        for (int i = 0; i < n; ++i) {
            objectVariableArray[i] = new ThisVariable(this.debugger, list.get(i), "");
        }
        return objectVariableArray;
    }

    public ThreadReference getThreadReference() {
        return this.threadReference;
    }

    public synchronized ReturnVariableImpl getReturnVariable() {
        return this.returnVariable;
    }

    public synchronized void setReturnVariable(ReturnVariableImpl returnVariableImpl) {
        this.returnVariable = returnVariableImpl;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pch.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pch.removePropertyChangeListener(propertyChangeListener);
    }

    private void fireSuspended(boolean bl) {
        this.pch.firePropertyChange(PROP_SUSPENDED, (Object)(!bl ? 1 : 0), (Object)bl);
    }

    @Override
    public void setObject(Object object) {
        throw new UnsupportedOperationException("Not supported, do not call. Implementing Customizer interface just because of add/remove PropertyChangeListener.");
    }
}

