/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.util;

import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.StepRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.openide.ErrorManager;

public class Operator {
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.jdievents");
    private Thread thread;
    private boolean breakpointsDisabled;
    private List<EventSet> staledEvents = new ArrayList<EventSet>();
    private List<EventRequest> staledRequests = new ArrayList<EventRequest>();
    private boolean stop;
    private boolean canInterrupt;

    public Operator(VirtualMachine virtualMachine, final JPDADebuggerImpl jPDADebuggerImpl, Executor executor, Runnable runnable, final Object object) {
        EventQueue eventQueue = virtualMachine.eventQueue();
        if (eventQueue == null) {
            throw new NullPointerException();
        }
        final Object[] objectArray = new Object[]{eventQueue, executor, runnable};
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                EventQueue eventQueue = (EventQueue)objectArray[0];
                Executor executor = (Executor)objectArray[1];
                Runnable runnable = (Runnable)objectArray[2];
                objectArray[0] = null;
                objectArray[1] = null;
                objectArray[2] = null;
                boolean bl = false;
                block42: while (true) {
                    try {
                        Mirror mirror;
                        Object object2;
                        Object object22;
                        Object object32;
                        Object object4;
                        EventSet eventSet;
                        while (true) {
                            eventSet = null;
                            if (bl) {
                                Operator operator = Operator.this;
                                synchronized (operator) {
                                    if (Operator.this.staledEvents.size() == 0) {
                                        bl = false;
                                    } else {
                                        eventSet = (EventSet)Operator.this.staledEvents.remove(0);
                                        while (Operator.this.staledRequests.size() > 0) {
                                            EventRequest eventRequest = (EventRequest)Operator.this.staledRequests.remove(0);
                                            eventRequest.virtualMachine().eventRequestManager().deleteEventRequest(eventRequest);
                                        }
                                    }
                                }
                            }
                            if (eventSet == null) {
                                Operator operator;
                                block81: {
                                    try {
                                        operator = Operator.this;
                                        synchronized (operator) {
                                            if (Operator.this.stop) {
                                                break block42;
                                            }
                                            Operator.this.canInterrupt = true;
                                        }
                                        eventSet = eventQueue.remove();
                                        if (!logger.isLoggable(Level.FINE)) break block81;
                                        try {
                                            logger.fine("HAVE EVENT(s) in the Queue: " + eventSet);
                                        }
                                        catch (ObjectCollectedException objectCollectedException) {
                                            ErrorManager.getDefault().notify((Throwable)objectCollectedException);
                                        }
                                    }
                                    catch (InterruptedException interruptedException) {
                                        Operator operator2 = Operator.this;
                                        synchronized (operator2) {
                                            if (Operator.this.stop) {
                                                break block42;
                                            }
                                        }
                                        bl = true;
                                        continue;
                                    }
                                }
                                operator = Operator.this;
                                synchronized (operator) {
                                    Operator.this.canInterrupt = false;
                                }
                            }
                            Operator operator = Operator.this;
                            synchronized (operator) {
                                if (Operator.this.breakpointsDisabled) {
                                    if (eventSet.suspendPolicy() == 2) {
                                        Operator.this.staledEvents.add(eventSet);
                                        eventSet.resume();
                                        if (logger.isLoggable(Level.FINE)) {
                                            logger.fine("RESUMING " + eventSet);
                                        }
                                    }
                                    continue;
                                }
                            }
                            boolean bl2 = true;
                            boolean bl3 = true;
                            boolean bl4 = false;
                            int n = eventSet.suspendPolicy();
                            boolean bl5 = n == 2;
                            JPDAThreadImpl jPDAThreadImpl = null;
                            if (bl5) {
                                jPDADebuggerImpl.notifySuspendAll();
                            }
                            if (n == 1) {
                                object4 = null;
                                for (Object object32 : eventSet) {
                                    bl4 = Boolean.TRUE.equals(object32.request().getProperty("silent"));
                                    object4 = Operator.getEventThread((Event)object32);
                                    if (object4 == null) continue;
                                    break;
                                }
                                if (object4 != null && !bl4) {
                                    jPDAThreadImpl = (JPDAThreadImpl)jPDADebuggerImpl.getThread((ThreadReference)object4);
                                    jPDAThreadImpl.notifySuspended();
                                }
                            }
                            if (logger.isLoggable(Level.FINE)) {
                                switch (n) {
                                    case 2: {
                                        logger.fine("JDI new events (suspend all)=============================================");
                                        break;
                                    }
                                    case 1: {
                                        logger.fine("JDI new events (suspend one)=============================================");
                                        break;
                                    }
                                    case 0: {
                                        logger.fine("JDI new events (suspend none)=============================================");
                                        break;
                                    }
                                    default: {
                                        logger.fine("JDI new events (?????)=============================================");
                                    }
                                }
                            }
                            for (Object object22 : eventSet) {
                                if (object22 instanceof VMDeathEvent || object22 instanceof VMDisconnectEvent) {
                                    if (logger.isLoggable(Level.FINE)) {
                                        Operator.this.printEvent((Event)object22, null);
                                    }
                                    object32 = Operator.this;
                                    synchronized (object32) {
                                        Operator.this.stop = true;
                                        break block42;
                                    }
                                }
                                if (object22 instanceof VMStartEvent && executor != null) {
                                    bl2 &= executor.exec((Event)object22);
                                    if (!logger.isLoggable(Level.FINE)) continue;
                                    Operator.this.printEvent(object22, null);
                                    continue;
                                }
                                object32 = null;
                                if (object22.request() == null) {
                                    if (logger.isLoggable(Level.FINE)) {
                                        logger.fine("EVENT: " + object22 + " REQUEST: null");
                                    }
                                } else {
                                    object32 = (Executor)object22.request().getProperty("executor");
                                }
                                if (logger.isLoggable(Level.FINE)) {
                                    Operator.this.printEvent(object22, (Executor)object32);
                                }
                                if (object32 == null) continue;
                                try {
                                    bl3 = false;
                                    bl2 &= object32.exec((Event)object22);
                                }
                                catch (VMDisconnectedException vMDisconnectedException) {
                                    object2 = Operator.this;
                                    synchronized (object2) {
                                        Operator.this.stop = true;
                                        break block42;
                                    }
                                }
                                catch (Exception exception) {
                                    ErrorManager.getDefault().notify((Throwable)exception);
                                }
                            }
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("JDI events dispatched (resume " + (bl2 && !bl3) + ")");
                                logger.fine("  resume = " + bl2 + ", startEventOnly = " + bl3);
                            }
                            if (!bl3) {
                                if (bl2) {
                                    if (!bl4 && bl5) {
                                        jPDADebuggerImpl.notifyToBeResumedAll();
                                    }
                                    if (!bl4 && jPDAThreadImpl != null) {
                                        jPDAThreadImpl.notifyToBeResumed();
                                    }
                                    object4 = object;
                                    synchronized (object4) {
                                        eventSet.resume();
                                    }
                                } else if (!bl4 && (bl5 || jPDAThreadImpl != null)) {
                                    object4 = jPDADebuggerImpl.getSession();
                                    if (object4 != null) {
                                        DebuggerManager.getDebuggerManager().setCurrentSession((Session)object4);
                                    }
                                    object22 = null;
                                    object32 = eventSet.iterator();
                                    while (object32.hasNext() && (object22 = Operator.getEventThread((Event)(mirror = (Event)object32.next()))) == null) {
                                    }
                                    if (object22 != null) {
                                        jPDADebuggerImpl.setStoppedState((ThreadReference)object22);
                                    }
                                }
                            }
                            if (!bl4 && !bl2) break;
                        }
                        object4 = object;
                        synchronized (object4) {
                            object22 = eventSet.virtualMachine().allThreads();
                            object32 = object22.iterator();
                            while (object32.hasNext()) {
                                mirror = (ThreadReference)object32.next();
                                object2 = (JPDAThreadImpl)jPDADebuggerImpl.getExistingThread((ThreadReference)mirror);
                                while (mirror.suspendCount() > 1) {
                                    if (object2 != null) {
                                        ((JPDAThreadImpl)object2).notifyToBeResumed();
                                    }
                                    mirror.resume();
                                }
                            }
                            continue;
                        }
                    }
                    catch (VMDisconnectedException vMDisconnectedException) {
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                        continue;
                    }
                    break;
                }
                if (runnable != null) {
                    runnable.run();
                }
                runnable = null;
                eventQueue = null;
                executor = null;
            }
        }, "Debugger operator thread");
    }

    private static final ThreadReference getEventThread(Event event) {
        ThreadReference threadReference = null;
        if (event instanceof LocatableEvent) {
            threadReference = ((LocatableEvent)event).thread();
        } else if (event instanceof ClassPrepareEvent) {
            threadReference = ((ClassPrepareEvent)event).thread();
        } else if (event instanceof ThreadStartEvent) {
            threadReference = ((ThreadStartEvent)event).thread();
        } else if (event instanceof ThreadDeathEvent) {
            threadReference = ((ThreadDeathEvent)event).thread();
        }
        return threadReference;
    }

    public void start() {
        this.thread.start();
    }

    public synchronized void register(EventRequest eventRequest, Executor executor) {
        eventRequest.putProperty("executor", executor);
        if (this.staledEvents.size() > 0 && eventRequest instanceof StepRequest) {
            boolean bl = false;
            for (EventSet eventSet : this.staledEvents) {
                for (Event event : eventSet) {
                    EventRequest eventRequest2 = event.request();
                    if (!(eventRequest2 instanceof StepRequest)) {
                        bl = true;
                        break;
                    }
                    ThreadReference threadReference = ((StepRequest)eventRequest2).thread();
                    ThreadReference threadReference2 = ((StepRequest)eventRequest).thread();
                    if (!threadReference2.equals(threadReference)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                break;
            }
            if (bl) {
                this.staledRequests.add(eventRequest);
            }
        }
    }

    public synchronized void unregister(EventRequest eventRequest) {
        Executor executor = (Executor)eventRequest.getProperty("executor");
        eventRequest.putProperty("executor", null);
        if (executor != null) {
            executor.removed(eventRequest);
        }
        this.staledRequests.remove(eventRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Operator operator = this;
        synchronized (operator) {
            this.staledRequests.clear();
            this.staledEvents.clear();
            if (this.stop) {
                return;
            }
            this.stop = true;
            if (this.canInterrupt) {
                this.thread.interrupt();
            }
        }
    }

    public synchronized void breakpointsDisabled() {
        this.breakpointsDisabled = true;
    }

    public synchronized void breakpointsEnabled() {
        this.breakpointsDisabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushStaledEvents() {
        boolean bl;
        Operator operator = this;
        synchronized (operator) {
            boolean bl2 = bl = this.staledEvents.size() > 0;
            if (bl) {
                this.thread.interrupt();
            }
        }
        return bl;
    }

    private void printEvent(Event event, Executor executor) {
        try {
            if (event instanceof ClassPrepareEvent) {
                logger.fine("JDI EVENT: ClassPrepareEvent " + ((ClassPrepareEvent)event).referenceType());
            } else if (event instanceof ClassUnloadEvent) {
                logger.fine("JDI EVENT: ClassUnloadEvent " + ((ClassUnloadEvent)event).className());
            } else if (event instanceof ThreadStartEvent) {
                try {
                    logger.fine("JDI EVENT: ThreadStartEvent " + ((ThreadStartEvent)event).thread());
                }
                catch (Exception exception) {
                    logger.fine("JDI EVENT: ThreadStartEvent1 " + event);
                }
            } else if (event instanceof ThreadDeathEvent) {
                try {
                    logger.fine("JDI EVENT: ThreadDeathEvent " + ((ThreadDeathEvent)event).thread());
                }
                catch (Exception exception) {
                    logger.fine("JDI EVENT: ThreadDeathEvent1 " + event);
                }
            } else if (event instanceof MethodEntryEvent) {
                try {
                    logger.fine("JDI EVENT: MethodEntryEvent " + event);
                }
                catch (Exception exception) {
                    logger.fine("JDI EVENT: MethodEntryEvent " + event);
                }
            } else if (event instanceof BreakpointEvent) {
                logger.fine("JDI EVENT: BreakpointEvent " + ((BreakpointEvent)event).thread() + " : " + ((BreakpointEvent)event).location());
            } else if (event instanceof StepEvent) {
                logger.fine("JDI EVENT: StepEvent " + ((StepEvent)event).thread() + " : " + ((StepEvent)event).location());
            } else {
                logger.fine("JDI EVENT: " + event + " : " + executor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

