/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.screen.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.screen.resource.ScreenResourceItemPresenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScreenResourceOrderingController {
    private static ArrayOrderingController arrayOrdering;
    private static DefaultOrderingController defaultOrdering;

    public static ScreenResourceOrderingController getArrayOrdering(String string) {
        if (arrayOrdering == null) {
            arrayOrdering = new ArrayOrderingController(string);
        }
        return arrayOrdering;
    }

    public static ScreenResourceOrderingController getDefaultOrdering() {
        if (defaultOrdering == null) {
            defaultOrdering = new DefaultOrderingController();
        }
        return defaultOrdering;
    }

    public abstract List<ScreenResourceItemPresenter> getOrdered(DesignComponent var1, Collection<ScreenResourceItemPresenter> var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultOrderingController
    extends ScreenResourceOrderingController {
        private DefaultOrderingController() {
        }

        @Override
        public List<ScreenResourceItemPresenter> getOrdered(DesignComponent designComponent, Collection<ScreenResourceItemPresenter> collection) {
            ArrayList<ScreenResourceItemPresenter> arrayList = new ArrayList<ScreenResourceItemPresenter>(collection);
            Collections.sort(arrayList, new Comparator<ScreenResourceItemPresenter>(){

                @Override
                public int compare(ScreenResourceItemPresenter screenResourceItemPresenter, ScreenResourceItemPresenter screenResourceItemPresenter2) {
                    String string = InfoPresenter.getDisplayName((DesignComponent)screenResourceItemPresenter.getRelatedComponent());
                    String string2 = InfoPresenter.getDisplayName((DesignComponent)screenResourceItemPresenter2.getRelatedComponent());
                    if (string == null || string2 == null) {
                        throw new NullPointerException();
                    }
                    return string.compareTo(string2);
                }
            });
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayOrderingController
    extends ScreenResourceOrderingController {
        private String propertyName;

        private ArrayOrderingController(String string) {
            this.propertyName = string;
        }

        @Override
        public List<ScreenResourceItemPresenter> getOrdered(DesignComponent designComponent, Collection<ScreenResourceItemPresenter> collection) {
            ArrayList<ScreenResourceItemPresenter> arrayList = new ArrayList<ScreenResourceItemPresenter>(collection.size());
            ArrayList arrayList2 = new ArrayList(designComponent.readProperty(this.propertyName).getArray());
            block0: for (PropertyValue propertyValue : arrayList2) {
                DesignComponent designComponent2 = propertyValue.getComponent();
                for (ScreenResourceItemPresenter screenResourceItemPresenter : collection) {
                    if (screenResourceItemPresenter.getRelatedComponent() != designComponent2) continue;
                    arrayList.add(screenResourceItemPresenter);
                    continue block0;
                }
            }
            return arrayList;
        }
    }
}

