/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.database;

import java.io.IOException;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.database.JdbcInfo;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.openide.LifecycleManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

class PostgreSQLAdapter
implements RailsDatabaseConfiguration {
    PostgreSQLAdapter() {
    }

    public String railsGenerationParam() {
        return "postgresql";
    }

    public void editConfig(RailsProject railsProject) {
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)railsProject);
        if (rubyPlatform.isJRuby()) {
            PostgreSQLAdapter.uncommentTcpIpConfig(railsProject.getProjectDirectory());
        }
    }

    public String getDisplayName() {
        return this.railsGenerationParam();
    }

    private static void uncommentTcpIpConfig(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getFileObject("config/database.yml");
        if (fileObject2 != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject2);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie != null) {
                    StyledDocument styledDocument = editorCookie.openDocument();
                    String string = styledDocument.getText(0, styledDocument.getLength());
                    int n = string.indexOf("#host:");
                    if (n == -1) {
                        return;
                    }
                    styledDocument.remove(n, 1);
                    string = styledDocument.getText(0, styledDocument.getLength());
                    int n2 = string.indexOf("#port:");
                    if (n2 != -1) {
                        styledDocument.remove(n2, 1);
                        string = styledDocument.getText(0, styledDocument.getLength());
                    }
                    int n3 = 0;
                    for (int i = n - 1; i >= 0 && string.charAt(i) != '\n'; --i) {
                        ++n3;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("# (Automatically uncommented by the IDE - JRuby doesn't support socket)\n");
                    for (int i = 0; i < n3; ++i) {
                        stringBuilder.append(" ");
                    }
                    styledDocument.insertString(n, stringBuilder.toString(), null);
                    SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
                    if (saveCookie != null) {
                        saveCookie.save();
                    } else {
                        LifecycleManager.getDefault().saveAll();
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public JdbcInfo getJdbcInfo() {
        return new JdbcInfo(){

            public String getDriverClass() {
                return "org.postgresql.Driver";
            }

            public String getURL(String string, String string2) {
                return "jdbc:postgresql://" + string + "/" + string2;
            }
        };
    }
}

