/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.core.ProjectWebServiceView;
import org.netbeans.modules.websvc.core.ProjectWebServiceViewImpl;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class ProjectWebServiceNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project project) {
        assert (project != null);
        return new WsNodeList(project);
    }

    private static class WsClientPrivilegedTemplates
    implements PrivilegedTemplates {
        private WsClientPrivilegedTemplates() {
        }

        public String[] getPrivilegedTemplates() {
            return new String[]{"Templates/WebServices/WebServiceClient", "Templates/WebServices/MessageHandler.java", "Templates/WebServices/LogicalHandler.java"};
        }
    }

    private static class WsPrivilegedTemplates
    implements PrivilegedTemplates {
        private WsPrivilegedTemplates() {
        }

        public String[] getPrivilegedTemplates() {
            return new String[]{"Templates/WebServices/WebService.java", "Templates/WebServices/WebServiceFromWSDL.java", "Templates/WebServices/MessageHandler.java", "Templates/WebServices/LogicalHandler.java"};
        }
    }

    private static class WSRootNode
    extends AbstractNode {
        private static final String SERVICES_BADGE = "org/netbeans/modules/websvc/core/webservices/ui/resources/webservicegroup.png";
        private Icon folderIconCache;
        private Icon openedFolderIconCache;
        private Image cachedServicesBadge;

        public WSRootNode(WsNodeList.Children children, Lookup lookup) {
            super((Children)children, lookup);
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(PropertiesAction.class)};
        }

        public Image getIcon(int n) {
            return this.computeIcon(false);
        }

        public Image getOpenedIcon(int n) {
            return this.computeIcon(true);
        }

        private Image getServicesImage() {
            if (this.cachedServicesBadge == null) {
                this.cachedServicesBadge = Utilities.loadImage((String)SERVICES_BADGE);
            }
            return this.cachedServicesBadge;
        }

        private Icon getFolderIcon(boolean bl) {
            if (this.openedFolderIconCache == null) {
                Node node = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
                this.openedFolderIconCache = new ImageIcon(node.getOpenedIcon(1));
                this.folderIconCache = new ImageIcon(node.getIcon(1));
            }
            if (bl) {
                return this.openedFolderIconCache;
            }
            return this.folderIconCache;
        }

        private Image computeIcon(boolean bl) {
            Icon icon = this.getFolderIcon(bl);
            Image image = ((ImageIcon)icon).getImage();
            image = Utilities.mergeImages((Image)image, (Image)this.getServicesImage(), (int)7, (int)7);
            return image;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WsNodeList
    implements NodeList<ProjectWebServiceView.ViewType>,
    ChangeListener {
        private Project project;
        private ChangeSupport changeSupport;
        private ProjectWebServiceView view;
        private Node serviceNode;
        private Node clientNode;

        public WsNodeList(Project project) {
            this.project = project;
            this.changeSupport = new ChangeSupport((Object)this);
        }

        public List<ProjectWebServiceView.ViewType> keys() {
            this.initView();
            ArrayList<ProjectWebServiceView.ViewType> arrayList = new ArrayList<ProjectWebServiceView.ViewType>();
            if (!this.view.isViewEmpty(ProjectWebServiceView.ViewType.SERVICE)) {
                arrayList.add(ProjectWebServiceView.ViewType.SERVICE);
            }
            if (!this.view.isViewEmpty(ProjectWebServiceView.ViewType.CLIENT)) {
                arrayList.add(ProjectWebServiceView.ViewType.CLIENT);
            }
            return arrayList;
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        private void fireChange() {
            this.changeSupport.fireChange();
        }

        public Node node(ProjectWebServiceView.ViewType viewType) {
            switch (viewType) {
                case SERVICE: {
                    if (this.serviceNode == null) {
                        this.serviceNode = new WSRootNode(new Children(viewType), this.createLookup(this.project, new WsPrivilegedTemplates()));
                        this.serviceNode.setDisplayName(NbBundle.getBundle(ProjectWebServiceNodeFactory.class).getString("LBL_WebServices"));
                    }
                    return this.serviceNode;
                }
                case CLIENT: {
                    if (this.clientNode == null) {
                        this.clientNode = new WSRootNode(new Children(viewType), this.createLookup(this.project, new WsClientPrivilegedTemplates()));
                        this.clientNode.setDisplayName(NbBundle.getBundle(ProjectWebServiceNodeFactory.class).getString("LBL_ServiceReferences"));
                    }
                    return this.clientNode;
                }
            }
            return null;
        }

        public void addNotify() {
            this.initView();
            this.view.addChangeListener(this, ProjectWebServiceView.ViewType.SERVICE);
            this.view.addChangeListener(this, ProjectWebServiceView.ViewType.CLIENT);
            this.view.addNotify();
        }

        public void removeNotify() {
            if (this.view != null) {
                this.view.removeChangeListener(this, ProjectWebServiceView.ViewType.SERVICE);
                this.view.removeChangeListener(this, ProjectWebServiceView.ViewType.CLIENT);
                this.view.removeNotify();
            }
        }

        @Override
        public void stateChanged(final ChangeEvent changeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WsNodeList.this.fireChange();
                    Object object = changeEvent.getSource();
                    if (object instanceof ProjectWebServiceViewImpl) {
                        ProjectWebServiceViewImpl projectWebServiceViewImpl = (ProjectWebServiceViewImpl)object;
                        if (WsNodeList.this.serviceNode != null) {
                            ((Children)WsNodeList.this.serviceNode.getChildren()).updateKey(projectWebServiceViewImpl);
                        }
                        if (WsNodeList.this.clientNode != null) {
                            ((Children)WsNodeList.this.clientNode.getChildren()).updateKey(projectWebServiceViewImpl);
                        }
                    }
                }
            });
        }

        private void initView() {
            if (this.view == null) {
                this.view = ProjectWebServiceView.getProjectWebServiceView(this.project);
            }
        }

        private Lookup createLookup(Project project, PrivilegedTemplates privilegedTemplates) {
            return Lookups.fixed((Object[])new Object[]{project, privilegedTemplates});
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class Children
        extends Children.Keys<ProjectWebServiceViewImpl> {
            private ProjectWebServiceView.ViewType viewType;

            public Children(ProjectWebServiceView.ViewType viewType) {
                this.viewType = viewType;
            }

            protected Node[] createNodes(ProjectWebServiceViewImpl projectWebServiceViewImpl) {
                return projectWebServiceViewImpl.createView(this.viewType);
            }

            protected void addNotify() {
                super.addNotify();
                if (WsNodeList.this.view != null && !WsNodeList.this.view.isViewEmpty(this.viewType)) {
                    this.setKeys(WsNodeList.this.view.getWebServiceViews());
                } else {
                    this.setKeys(Collections.emptyList());
                }
            }

            protected void removeNotify() {
                super.removeNotify();
                this.setKeys(Collections.emptyList());
            }

            private void updateKey(ProjectWebServiceViewImpl projectWebServiceViewImpl) {
                if (!this.isInitialized()) {
                    return;
                }
                super.refreshKey((Object)projectWebServiceViewImpl);
            }
        }
    }
}

