/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.sync;

import java.util.Arrays;
import java.util.Vector;
import org.netbeans.modules.xml.sync.Representation;
import org.netbeans.modules.xml.sync.Util;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

public abstract class SyncSupport {
    private DataObject dobj;
    protected static final int JUST_SYNCHRONIZING = 1;
    protected static final int JUST_RESOLVING_CONFLICT = 2;
    protected static final int NOP = 0;
    private int syncOperation;
    private final Object syncOperationLock = new SyncSupportLock();

    public SyncSupport(DataObject dataObject) throws IllegalArgumentException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Creating sychronizator " + System.identityHashCode(this) + " for: " + dataObject.getPrimaryFile());
        }
        this.dobj = dataObject;
        this.syncOperation = 0;
    }

    private void waitFor(int n) throws InterruptedException {
        while (this.getSyncOp() != 0) {
            this.syncOperationLock.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSyncOp(int n) {
        Object object = this.syncOperationLock;
        synchronized (object) {
            if (n == this.syncOperation) {
                return;
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("" + System.identityHashCode(this) + " syncOperation " + this.syncOperation + " => " + n + " Thread:" + Thread.currentThread().getName());
            }
            this.syncOperation = n;
            this.syncOperationLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSyncOp() {
        Object object = this.syncOperationLock;
        synchronized (object) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("" + System.identityHashCode(this) + " syncOperation = " + this.syncOperation + " Thread:" + Thread.currentThread().getName());
            }
            return this.syncOperation;
        }
    }

    public boolean isInSync() {
        return this.getSyncOp() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRequest(Runnable runnable) {
        boolean bl = false;
        try {
            Object object = this.syncOperationLock;
            synchronized (object) {
                this.waitFor(0);
                bl = true;
                this.setSyncOp(1);
            }
            runnable.run();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (bl) {
                this.setSyncOp(0);
            }
        }
    }

    protected final Node.Cookie getCookie(Class clazz) {
        return this.getDO().getCookie(clazz);
    }

    protected final DataObject getDO() {
        return this.dobj;
    }

    public abstract void addRepresentation(Representation var1);

    public abstract void removeRepresentation(Representation var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void representationChanged(Class clazz) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("" + System.identityHashCode(this) + " entering synchronizator: " + clazz);
        }
        if (this.isInSync()) {
            return;
        }
        try {
            int n;
            this.setSyncOp(1);
            Representation representation = null;
            Representation[] representationArray = this.getRepresentations(null);
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("\tReps: " + Arrays.asList(representationArray));
            }
            Vector<Representation> vector = new Vector<Representation>();
            for (n = 0; n < representationArray.length; ++n) {
                if (representationArray[n].represents(clazz)) {
                    representation = representationArray[n];
                    vector.add(representationArray[n]);
                    continue;
                }
                if (!representationArray[n].isModified()) continue;
                vector.add(representationArray[n]);
            }
            if (vector.size() > 1) {
                representation = this.selectMasterRepresentation(vector.toArray(new Representation[0]));
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("\t" + System.identityHashCode(this) + " master: " + representation);
            }
            if (representation == null) {
                return;
            }
            for (n = 0; n < representationArray.length; ++n) {
                Object object;
                if (representationArray[n] == representation) continue;
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("\tpreffered update class: " + representationArray[n].getUpdateClass());
                }
                if ((object = representation.getChange(representationArray[n].getUpdateClass())) == null) {
                    object = representation.getChange(null);
                }
                if (object == null) continue;
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("\t" + System.identityHashCode(this) + " updating: " + representationArray[n] + " with:" + object.getClass());
                }
                representationArray[n].update(object);
            }
        }
        finally {
            this.setSyncOp(0);
        }
    }

    protected abstract Representation[] getRepresentations();

    protected Representation[] getRepresentations(Class clazz) {
        Representation[] representationArray = this.getRepresentations();
        if (clazz == null) {
            return representationArray;
        }
        throw new RuntimeException("Not Implemened.");
    }

    protected Representation selectMasterRepresentation(Representation[] representationArray) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("COMODIFICATION:");
        }
        return representationArray[0];
    }

    private static class SyncSupportLock {
        private SyncSupportLock() {
        }
    }
}

