/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wizard;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.xml.lib.AbstractUtil;
import org.netbeans.modules.xml.wizard.SchemaParser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.ActionManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Util
extends AbstractUtil {
    private static File lastDirectory;
    public static final Util THIS;
    public static final String NO_NAME_SPACE = "NO_NAME_SPACE";
    private static Map namespaces;
    private static Map prefixes;

    private Util() {
    }

    public static File selectSchemaFile(final String string) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                while (stringTokenizer.hasMoreElements()) {
                    if (!file.getName().endsWith(stringTokenizer.nextToken())) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return THIS.getString("PROP_schema_mask");
            }
        });
        if (lastDirectory != null) {
            jFileChooser.setCurrentDirectory(lastDirectory);
        }
        jFileChooser.setDialogTitle(THIS.getString("PROP_schema_dialog_name"));
        while (jFileChooser.showDialog(WindowManager.getDefault().getMainWindow(), THIS.getString("PROP_schema_select_button")) == 0) {
            File file = jFileChooser.getSelectedFile();
            lastDirectory = jFileChooser.getCurrentDirectory();
            if (file != null && file.isFile()) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                while (stringTokenizer.hasMoreElements()) {
                    if (!file.getName().endsWith(stringTokenizer.nextToken())) continue;
                    return file;
                }
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)THIS.getString("MSG_inValidFile"), 2));
        }
        return null;
    }

    public static String[] getKnownDTDPublicIDs() {
        UserCatalog userCatalog = UserCatalog.getDefault();
        if (userCatalog != null) {
            TreeSet<String> treeSet = new TreeSet<String>();
            Iterator iterator = userCatalog.getPublicIDs();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = string.toLowerCase();
                if (string2.startsWith("schema:") || string2.endsWith(".xsd")) continue;
                treeSet.add(string);
            }
            return treeSet.toArray(new String[treeSet.size()]);
        }
        THIS.debug("Note SourceResolver not found!");
        return new String[0];
    }

    public static void performDefaultAction(DataObject dataObject) {
        Node node = dataObject.getNodeDelegate();
        SystemAction systemAction = node.getDefaultAction();
        if (systemAction != null) {
            ActionManager actionManager = (ActionManager)Lookup.getDefault().lookup(ActionManager.class);
            actionManager.invokeAction((Action)systemAction, new ActionEvent(node, 1001, ""));
        }
    }

    public static String getDocumentType() {
        return "xsd";
    }

    public static Map getFiles2NSMappingInProj(File file, String string) {
        List list = Util.getFilesWithExtension(file, string, new ArrayList());
        HashMap<FileObject, String> hashMap = new HashMap<FileObject, String>();
        String string2 = "//xsd:schema/@targetNamespace";
        for (int i = 0; i < list.size(); ++i) {
            File file2 = (File)list.get(i);
            if (Thread.currentThread().isInterrupted()) break;
            List list2 = null;
            try {
                list2 = Util.runXPathQuery(file2, string2);
                String string3 = null;
                FileObject fileObject = FileUtil.toFileObject((File)file2);
                string3 = list2.size() > 0 ? (String)list2.get(0) : NO_NAME_SPACE;
                if (string3 == NO_NAME_SPACE) continue;
                hashMap.put(fileObject, string3);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hashMap;
    }

    public static List getFilesWithExtension(File file, String string, List arrayList) {
        File[] fileArray;
        String string2;
        int n;
        if (Thread.currentThread().isInterrupted()) {
            return arrayList;
        }
        if (arrayList == null) {
            arrayList = new ArrayList<File>();
        }
        if (file.isFile() && (n = file.getName().lastIndexOf(".")) != -1 && (string2 = file.getName().substring(n + 1)) != null && string2.equalsIgnoreCase(string)) {
            arrayList.add(file);
        }
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                Util.getFilesWithExtension(file2, string, arrayList);
            }
        }
        return arrayList;
    }

    public static List runXPathQuery(File file, String string) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(Util.getNamespaceContext());
        InputSource inputSource = new InputSource(new FileInputStream(file));
        NodeList nodeList = (NodeList)xPath.evaluate(string, inputSource, XPathConstants.NODESET);
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                org.w3c.dom.Node node = nodeList.item(i);
                arrayList.add(node.getNodeValue());
            }
        }
        return arrayList;
    }

    public static String getNamespace(FileObject fileObject) {
        SchemaParser schemaParser = new SchemaParser();
        File file = FileUtil.toFile((FileObject)fileObject);
        SchemaParser.SchemaInfo schemaInfo = schemaParser.parse(file.toURI().toString());
        if (schemaInfo == null) {
            return null;
        }
        return schemaInfo.namespace;
    }

    public static SchemaParser.SchemaInfo getRootElements(FileObject fileObject) {
        SchemaParser schemaParser = new SchemaParser();
        File file = FileUtil.toFile((FileObject)fileObject);
        SchemaParser.SchemaInfo schemaInfo = schemaParser.parse(file.toURI().toString());
        if (schemaInfo == null) {
            return null;
        }
        return schemaInfo;
    }

    public static String getRelativePath(File file, File file2) throws IOException {
        int n;
        File file3 = file;
        File file4 = file2;
        ArrayList<File> arrayList = new ArrayList<File>();
        String string = file.getAbsolutePath();
        String string2 = file2.getAbsolutePath();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string3 = null;
        String string4 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if ((stringTokenizer = new StringTokenizer(string2, ":")).hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        if (string3 != null && string4 != null && !string3.equals(string4)) {
            return file.toURI().toString();
        }
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (file = file.getCanonicalFile(); file != null; file = file.getParentFile()) {
            arrayList.add(0, file);
        }
        for (file2 = file2.getCanonicalFile(); file2 != null; file2 = file2.getParentFile()) {
            arrayList2.add(0, file2);
        }
        int n2 = 0;
        file = (File)arrayList.get(n2);
        file2 = (File)arrayList2.get(n2);
        while (n2 < arrayList.size() - 1 && n2 < arrayList2.size() - 1 && file.equals(file2)) {
            file = (File)arrayList.get(++n2);
            file2 = (File)arrayList2.get(n2);
        }
        if (file.equals(file2)) {
            ++n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = n2; n < arrayList2.size(); ++n) {
            stringBuffer.append("../");
        }
        for (n = n2; n < arrayList.size() - 1; ++n) {
            stringBuffer.append(((File)arrayList.get(n)).getName() + "/");
        }
        stringBuffer.append(((File)arrayList.get(arrayList.size() - 1)).getName());
        return stringBuffer.toString();
    }

    private static NamespaceContext getNamespaceContext() {
        namespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
        prefixes.put("http://www.w3.org/2001/XMLSchema", "xsd");
        return new HashNamespaceResolver(namespaces, prefixes);
    }

    static {
        THIS = new Util();
        namespaces = new HashMap();
        prefixes = new HashMap();
    }

    public static final class HashNamespaceResolver
    implements NamespaceContext {
        private Map prefixes;
        private Map namespaces;

        public HashNamespaceResolver(Map map) {
            this.namespaces = map;
            this.prefixes = new HashMap();
            Set set = this.namespaces.entrySet();
            for (Map.Entry entry : set) {
                this.prefixes.put(entry.getValue(), entry.getKey());
            }
        }

        public HashNamespaceResolver(Map map, Map map2) {
            this.namespaces = map;
            this.prefixes = map2;
        }

        public Iterator getPrefixes(String string) {
            return Collections.singletonList(this.getPrefix(string)).iterator();
        }

        public String getPrefix(String string) {
            return (String)this.prefixes.get(string);
        }

        public String getNamespaceURI(String string) {
            return (String)this.namespaces.get(string);
        }
    }
}

