/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wizard;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.AnyElement;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.Compositor;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.visitor.AXIVisitor;
import org.netbeans.modules.xml.axi.visitor.DeepAXITreeVisitor;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.model.Attribute;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.wizard.XMLContentAttributes;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class XMLGeneratorVisitor
extends DeepAXITreeVisitor {
    private XMLContentAttributes contentAttr;
    private String prefix;
    private AXIModel axiModel;
    private int depth = 0;
    private String schemaFileName;
    private String rootElement;
    private Writer writer;

    public XMLGeneratorVisitor(String string, XMLContentAttributes xMLContentAttributes, Writer writer) {
        this.contentAttr = xMLContentAttributes;
        this.prefix = this.contentAttr.getPrefix();
        this.schemaFileName = string;
        this.writer = writer;
    }

    public void generateXML(String string) {
        if (string == null || this.schemaFileName == null || this.schemaFileName.equals("") || string.equals("")) {
            return;
        }
        this.rootElement = string;
        File file = new File(this.schemaFileName);
        FileObject fileObject = FileUtil.toFileObject((File)(file = FileUtil.normalizeFile((File)file)));
        if (fileObject == null) {
            return;
        }
        ModelSource modelSource = null;
        try {
            modelSource = Utilities.createModelSource((FileObject)fileObject, (boolean)true);
        }
        catch (Exception exception) {
            return;
        }
        if (modelSource == null) {
            return;
        }
        SchemaModel schemaModel = SchemaModelFactory.getDefault().getModel(modelSource);
        this.axiModel = AXIModelFactory.getDefault().getModel(schemaModel);
        Element element = this.findAXIGlobalElement(string);
        if (element != null) {
            this.visit(element);
        }
    }

    public void generateXML(Element element) {
        if (element != null) {
            this.visit(element);
        }
    }

    public void visit(Element element) {
        int n = this.getOccurence(element.getMinOccurs(), element.getMaxOccurs());
        if (!this.contentAttr.generateOptionalElements() && this.isElementOptional(element)) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.visitChildren((AXIComponent)element);
        }
    }

    protected void visitChildren(AXIComponent aXIComponent) {
        try {
            this.printModel(aXIComponent);
            ++this.depth;
            this.visitChildrenForXML(aXIComponent);
            this.postVisitChildren(aXIComponent);
            --this.depth;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isElementOptional(Element element) {
        int n = Integer.parseInt(element.getMinOccurs());
        return n == 0;
    }

    private void printModel(AXIComponent aXIComponent) throws IOException {
        Element element;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        if (aXIComponent.getChildElements().isEmpty()) {
            bl = false;
        }
        if (aXIComponent instanceof Compositor) {
            Compositor compositor = (Compositor)aXIComponent;
            stringBuffer.append(this.getTab() == null ? compositor : this.getTab() + compositor);
            stringBuffer.append("<min=" + compositor.getMinOccurs() + ":max=" + compositor.getMaxOccurs() + ">");
            return;
        }
        if (aXIComponent instanceof Element) {
            element = (Element)aXIComponent;
            if (element.getName().equals(this.rootElement)) {
                return;
            }
            stringBuffer.append(this.getTab() == null ? element.getName() : this.getTab() + "<" + this.contentAttr.getPrefix() + ":" + element.getName());
            if (element.getAttributes().size() != 0) {
                stringBuffer.append(" " + this.getAttributes(element));
            }
            if (bl) {
                this.writer.write(stringBuffer.toString() + ">" + "\n");
            } else {
                this.writer.write(stringBuffer.toString() + ">");
            }
            this.writer.write(this.getComponentValue((AXIComponent)element));
        }
        if (aXIComponent instanceof AnyElement) {
            element = (AnyElement)aXIComponent;
            stringBuffer.append(this.getTab() == null ? element : this.getTab() + element);
            this.writer.write(stringBuffer.toString() + "\n");
        }
    }

    private String getAttributes(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        for (AbstractAttribute abstractAttribute : element.getAttributes()) {
            if (abstractAttribute instanceof Attribute && !this.contentAttr.generateOptionalAttributes()) {
                if (!((Attribute)abstractAttribute).getUse().equals((Object)Attribute.Use.REQUIRED)) continue;
                stringBuffer.append(abstractAttribute + "=\"" + this.getComponentValue((AXIComponent)((Attribute)abstractAttribute)) + "\" ");
                continue;
            }
            if (abstractAttribute instanceof Attribute) {
                stringBuffer.append(abstractAttribute + "=\"" + this.getComponentValue((AXIComponent)((Attribute)abstractAttribute)) + "\" ");
                continue;
            }
            stringBuffer.append(abstractAttribute + "= \" \" ");
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString().substring(0, stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private String getTab() {
        String string = "    ";
        if (this.depth == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.depth; ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    protected void visitChildrenForXML(AXIComponent aXIComponent) {
        Object object;
        if (!super.canVisit(aXIComponent)) {
            return;
        }
        if (aXIComponent instanceof Compositor && (object = ((Compositor)aXIComponent).getType()).equals((Object)Compositor.CompositorType.CHOICE)) {
            List list = aXIComponent.getChildren();
            if (list != null && list.size() > 0) {
                ((AXIComponent)aXIComponent.getChildren().get(0)).accept((AXIVisitor)this);
            }
            return;
        }
        for (AXIComponent aXIComponent2 : aXIComponent.getChildren()) {
            aXIComponent2.accept((AXIVisitor)this);
        }
    }

    private int getOccurence(String string, String string2) {
        if (string2.equals("unbounded")) {
            return this.contentAttr.getPreferredOccurences();
        }
        int n = Integer.parseInt(string);
        int n2 = Integer.parseInt(string2);
        if (this.contentAttr.getPreferredOccurences() > n && this.contentAttr.getPreferredOccurences() < n2) {
            return this.contentAttr.getPreferredOccurences();
        }
        if (this.contentAttr.getPreferredOccurences() > n2) {
            return n2;
        }
        if (this.contentAttr.getPreferredOccurences() < n) {
            return n;
        }
        return n;
    }

    private void postVisitChildren(AXIComponent aXIComponent) throws IOException {
        if (aXIComponent instanceof Element) {
            if (((Element)aXIComponent).getName().equals(this.rootElement)) {
                return;
            }
            if (aXIComponent.getChildElements().isEmpty()) {
                this.writer.write("</" + this.prefix + ":" + ((Element)aXIComponent).getName() + ">" + "\n");
            } else {
                this.writer.write(this.getTab() + "</" + this.prefix + ":" + ((Element)aXIComponent).getName() + ">" + "\n");
            }
        }
    }

    private Element findAXIGlobalElement(String string) {
        if (string == null) {
            return null;
        }
        for (Element element : this.axiModel.getRoot().getElements()) {
            if (!element.getName().equals(string)) continue;
            return element;
        }
        return null;
    }

    private String getComponentValue(AXIComponent aXIComponent) {
        Element element;
        String string = null;
        if (aXIComponent instanceof Attribute) {
            Attribute attribute = (Attribute)aXIComponent;
            string = attribute.getFixed();
            if (string == null) {
                string = attribute.getDefault();
            }
        } else if (aXIComponent instanceof Element && (string = (element = (Element)aXIComponent).getFixed()) == null) {
            string = element.getDefault();
        }
        if (string != null) {
            return string;
        }
        return "";
    }
}

