/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wizard;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.netbeans.modules.xml.retriever.RetrieveEntry;
import org.netbeans.modules.xml.retriever.RetrieverEngine;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wizard.AbstractPanel;
import org.netbeans.modules.xml.wizard.DTDPanel;
import org.netbeans.modules.xml.wizard.DocumentModel;
import org.netbeans.modules.xml.wizard.DocumentPanel;
import org.netbeans.modules.xml.wizard.SchemaObject;
import org.netbeans.modules.xml.wizard.SchemaPanel;
import org.netbeans.modules.xml.wizard.Util;
import org.netbeans.modules.xml.wizard.XMLContentPanel;
import org.netbeans.modules.xml.wizard.XMLGeneratorVisitor;
import org.netbeans.spi.project.CacheDirectoryProvider;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class XMLWizardIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 5070430920636117204L;
    private static final String XML_EXT = "xml";
    private transient TemplateWizard templateWizard;
    private transient DocumentModel model;
    private transient int current;
    private static final int TARGET_PANEL = 0;
    private transient WizardDescriptor.Panel targetPanel;
    private static final int DOCUMENT_PANEL = 1;
    private transient DocumentPanel documentPanel;
    private static final int CONSTRAINT_PANEL = 2;
    private transient SchemaPanel schemaPanel;
    private transient DTDPanel dtdPanel;
    private static final int CONTENT_PANEL = 3;
    private transient XMLContentPanel xmlPanel;
    private static Reference<XMLWizardIterator> instance;
    private transient Map listenersMap = new HashMap(2);
    private transient String[] beforeSteps;
    private transient Object targetSteps;

    public static synchronized XMLWizardIterator singleton() {
        XMLWizardIterator xMLWizardIterator;
        XMLWizardIterator xMLWizardIterator2 = xMLWizardIterator = instance == null ? null : instance.get();
        if (xMLWizardIterator == null) {
            xMLWizardIterator = new XMLWizardIterator();
            instance = new WeakReference<XMLWizardIterator>(xMLWizardIterator);
        }
        return xMLWizardIterator;
    }

    public void initialize(TemplateWizard templateWizard) {
        Object object;
        this.templateWizard = templateWizard;
        this.current = 0;
        URL uRL = null;
        try {
            object = templateWizard.getTargetFolder();
            uRL = object.getPrimaryFile().getURL();
            if (!uRL.toExternalForm().endsWith("/")) {
                uRL = new URL(uRL.toExternalForm() + "/");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.model = new DocumentModel(uRL);
        object = templateWizard.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            this.beforeSteps = (String[])object;
        }
    }

    public void uninitialize(TemplateWizard templateWizard) {
        if (this.targetPanel != null) {
            ((JComponent)this.targetPanel.getComponent()).putClientProperty("WizardPanel_contentData", this.targetSteps);
            this.targetPanel = null;
        }
        this.current = -1;
        this.model = null;
        templateWizard = null;
        this.schemaPanel = null;
        this.dtdPanel = null;
        this.documentPanel = null;
        this.xmlPanel = null;
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        final DataFolder dataFolder = templateWizard.getTargetFolder();
        final File file = FileUtil.toFile((FileObject)dataFolder.getPrimaryFile());
        String string = templateWizard.getTargetName();
        if (string == null || "null".equals(string)) {
            string = "XMLDocument";
        }
        final FileObject fileObject = dataFolder.getPrimaryFile();
        String string2 = string;
        int n = 2;
        while (fileObject.getFileObject(string2, XML_EXT) != null) {
            string2 = string + n;
            ++n;
        }
        final String string3 = string2;
        FileSystem fileSystem = fileObject.getFileSystem();
        final FileObject[] fileObjectArray = new FileObject[1];
        FileSystem.AtomicAction atomicAction = new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                String string = EncodingUtil.getProjectEncoding((FileObject)dataFolder.getPrimaryFile());
                if (!EncodingUtil.isValidEncoding((String)string)) {
                    string = "UTF-8";
                }
                FileObject fileObject2 = fileObject.createData(string3, XMLWizardIterator.XML_EXT);
                FileLock fileLock = null;
                try {
                    fileLock = fileObject2.lock();
                    OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                    outputStream = new BufferedOutputStream(outputStream, 999);
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
                    String string2 = XMLWizardIterator.this.model.getRoot();
                    if (string2 == null) {
                        string2 = "root";
                    }
                    String string32 = XMLWizardIterator.this.model.getPrefix();
                    outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"" + string + "\"?>\n");
                    outputStreamWriter.write("\n");
                    String string4 = string3 + "." + XMLWizardIterator.XML_EXT;
                    Date date = new Date();
                    String string5 = DateFormat.getDateInstance(1).format(date);
                    String string6 = DateFormat.getTimeInstance(3).format(date);
                    String string7 = System.getProperty("user.name");
                    outputStreamWriter.write("<!--\n");
                    outputStreamWriter.write("    Document   : " + string4 + "\n");
                    outputStreamWriter.write("    Created on : " + string5 + ", " + string6 + "\n");
                    outputStreamWriter.write("    Author     : " + string7 + "\n");
                    outputStreamWriter.write("    Description:\n");
                    outputStreamWriter.write("        Purpose of the document follows.\n");
                    outputStreamWriter.write("-->\n");
                    outputStreamWriter.write("\n");
                    int n = XMLWizardIterator.this.model.getType();
                    XMLWizardIterator.this.model;
                    if (n == 1) {
                        if (XMLWizardIterator.this.model.getPublicID() == null) {
                            outputStreamWriter.write("<!DOCTYPE " + string2 + " SYSTEM '" + XMLWizardIterator.this.model.getSystemID() + "'>\n");
                        } else {
                            outputStreamWriter.write("<!DOCTYPE " + string2 + " PUBLIC '" + XMLWizardIterator.this.model.getPublicID() + "' '" + XMLWizardIterator.this.model.getSystemID() + "'>\n");
                        }
                        outputStreamWriter.write("<" + string2 + ">\n");
                    } else {
                        int n2 = XMLWizardIterator.this.model.getType();
                        XMLWizardIterator.this.model;
                        if (n2 == 2) {
                            String string8 = XMLWizardIterator.this.model.getNamespace();
                            List list = XMLWizardIterator.this.model.getSchemaNodes();
                            if (string32 == null || "".equals(string32)) {
                                outputStreamWriter.write("<" + string2 + "  xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'\n");
                            } else {
                                outputStreamWriter.write("<" + string32 + ":" + string2 + "  xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'\n");
                            }
                            if (list != null) {
                                SchemaObject schemaObject;
                                int n3;
                                for (n3 = 0; n3 < list.size(); ++n3) {
                                    schemaObject = (SchemaObject)list.get(n3);
                                    if (schemaObject.getPrefix() == null || "".equals(schemaObject.getPrefix())) {
                                        outputStreamWriter.write("   xmlns='" + schemaObject.getNamespace() + "'\n");
                                        continue;
                                    }
                                    outputStreamWriter.write("   xmlns:" + schemaObject.getPrefix() + "='" + schemaObject.getNamespace() + "'\n");
                                }
                                for (n3 = 0; n3 < list.size(); ++n3) {
                                    schemaObject = (SchemaObject)list.get(n3);
                                    String string9 = null;
                                    string9 = schemaObject.toString().startsWith("http") ? schemaObject.toString() : Util.getRelativePath(new File(schemaObject.getSchemaFileName()), file);
                                    if (n3 == 0) {
                                        if (list.size() == 1) {
                                            outputStreamWriter.write("   xsi:schemaLocation='" + schemaObject.getNamespace() + " " + string9 + "'>\n");
                                            continue;
                                        }
                                        outputStreamWriter.write("   xsi:schemaLocation='" + schemaObject.getNamespace() + " " + string9 + "\n");
                                        continue;
                                    }
                                    if (n3 == list.size() - 1) {
                                        outputStreamWriter.write("   " + schemaObject.getNamespace() + " " + string9 + "'>\n");
                                        continue;
                                    }
                                    outputStreamWriter.write("   " + schemaObject.getNamespace() + " " + string9 + "\n");
                                }
                            }
                            XMLWizardIterator.this.generateXMLBody(XMLWizardIterator.this.model, string2, outputStreamWriter);
                        } else {
                            outputStreamWriter.write("<" + string2 + ">\n");
                        }
                    }
                    if (string32 == null || "".equals(string32)) {
                        outputStreamWriter.write("\n");
                        outputStreamWriter.write("</" + string2 + ">\n");
                    } else {
                        outputStreamWriter.write("\n");
                        outputStreamWriter.write("</" + string32 + ":" + string2 + ">\n");
                    }
                    ((Writer)outputStreamWriter).flush();
                    ((Writer)outputStreamWriter).close();
                    fileLock.releaseLock();
                    fileLock = null;
                    fileObjectArray[0] = fileObject2;
                }
                finally {
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            }
        };
        fileSystem.runAtomicAction(atomicAction);
        HashSet<DataObject> hashSet = new HashSet<DataObject>(1);
        DataObject dataObject = DataObject.find((FileObject)fileObjectArray[0]);
        Util.performDefaultAction(dataObject);
        hashSet.add(dataObject);
        return hashSet;
    }

    public WizardDescriptor.Panel current() {
        WizardDescriptor.Panel panel = this.currentComponent();
        if (panel.getComponent() instanceof JComponent) {
            ((JComponent)panel.getComponent()).putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.current));
        }
        return panel;
    }

    private WizardDescriptor.Panel currentComponent() {
        switch (this.current) {
            case 0: {
                return this.getTargetPanel();
            }
            case 1: {
                return this.getDocumentPanel();
            }
            case 2: {
                switch (this.model.getType()) {
                    case 1: {
                        return this.getDTDPanel();
                    }
                    case 2: {
                        return this.getSchemaPanel();
                    }
                }
                throw new IllegalStateException();
            }
            case 3: {
                return this.getXMLContentPanel();
            }
        }
        throw new IllegalStateException();
    }

    public boolean hasNext() {
        boolean bl = this.model.getType() == 0;
        int n = 0;
        if (this.model.getType() == 2) {
            n = 3;
        }
        if (this.model.getType() == 0) {
            n = 1;
        } else if (this.model.getType() == 1) {
            n = 2;
        }
        return this.current < n;
    }

    public boolean hasPrevious() {
        return this.current > 0;
    }

    public String name() {
        return NbBundle.getMessage(XMLWizardIterator.class, (String)"TITLE_x_of_y", (Object)(this.current + 1), (Object)this.current);
    }

    public void nextPanel() {
        ++this.current;
    }

    public void previousPanel() {
        --this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        Map map = this.listenersMap;
        synchronized (map) {
            Object v = this.listenersMap.remove(changeListener);
            if (v == null) {
                return;
            }
            if (this.model == null) {
                return;
            }
            this.model.removePropertyChangeListener((PropertyChangeListener)v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(final ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        Map map = this.listenersMap;
        synchronized (map) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){
                final ChangeEvent EVENT;
                {
                    this.EVENT = new ChangeEvent(XMLWizardIterator.this);
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    changeListener.stateChanged(this.EVENT);
                }
            };
            if (this.listenersMap.put(changeListener, propertyChangeListener) == null) {
                this.model.addPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    private WizardDescriptor.Panel getDocumentPanel() {
        if (this.documentPanel == null) {
            this.documentPanel = new DocumentPanel();
            this.documentPanel.setObject(this.model);
            String[] stringArray = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), Util.THIS.getString("MSG_unknown")};
            String[] stringArray2 = XMLWizardIterator.createSteps(this.beforeSteps, stringArray);
            this.documentPanel.putClientProperty("WizardPanel_contentData", stringArray2);
        }
        return new AbstractPanel.WizardStep(this.documentPanel);
    }

    private WizardDescriptor.Panel getDTDPanel() {
        if (this.dtdPanel == null) {
            this.dtdPanel = new DTDPanel();
            this.dtdPanel.setObject(this.model);
            String[] stringArray = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), this.getDTDPanelName()};
            String[] stringArray2 = XMLWizardIterator.createSteps(this.beforeSteps, stringArray);
            this.dtdPanel.putClientProperty("WizardPanel_contentData", stringArray2);
        }
        return new AbstractPanel.WizardStep(this.dtdPanel);
    }

    private WizardDescriptor.Panel getSchemaPanel() {
        if (this.schemaPanel == null) {
            this.schemaPanel = new SchemaPanel(this.templateWizard);
            this.schemaPanel.setObject(this.model);
            String[] stringArray = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), this.getSchemaPanelName(), this.getXMLContentPanelName()};
            String[] stringArray2 = XMLWizardIterator.createSteps(this.beforeSteps, stringArray);
            this.schemaPanel.putClientProperty("WizardPanel_contentData", stringArray2);
        }
        return new AbstractPanel.WizardStep(this.schemaPanel);
    }

    private WizardDescriptor.Panel getTargetPanel() {
        if (this.targetPanel == null) {
            this.targetPanel = this.templateWizard.targetChooser();
            if (this.targetPanel.getComponent() instanceof JComponent) {
                JComponent jComponent = (JComponent)this.targetPanel.getComponent();
                this.targetSteps = jComponent.getClientProperty("WizardPanel_contentData");
                String[] stringArray = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), Util.THIS.getString("MSG_unknown")};
                String[] stringArray2 = XMLWizardIterator.createSteps(this.beforeSteps, stringArray);
                jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
            }
        }
        return this.targetPanel;
    }

    private String getTargetPanelName() {
        Component component = this.getTargetPanel().getComponent();
        if (component instanceof JComponent) {
            return ((JComponent)component).getName();
        }
        return "";
    }

    private String getDocumentPanelName() {
        return Util.THIS.getString("PROP_doc_panel_name");
    }

    private String getDTDPanelName() {
        return Util.THIS.getString("PROP_dtd_panel_name");
    }

    private String getSchemaPanelName() {
        return Util.THIS.getString("PROP_schema_panel_name");
    }

    private static String[] createSteps(String[] stringArray, String[] stringArray2) {
        int n = 0;
        if (stringArray == null) {
            stringArray = new String[]{};
        } else if (stringArray.length > 0) {
            n = "...".equals(stringArray[stringArray.length - 1]) ? 1 : 0;
        }
        String[] stringArray3 = new String[stringArray.length - n + stringArray2.length];
        for (int i = 0; i < stringArray3.length; ++i) {
            stringArray3[i] = i < stringArray.length - n ? stringArray[i] : stringArray2[i - stringArray.length + n];
        }
        return stringArray3;
    }

    private WizardDescriptor.Panel getXMLContentPanel() {
        if (this.xmlPanel == null) {
            this.xmlPanel = new XMLContentPanel();
            this.xmlPanel.setObject(this.model);
            String[] stringArray = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), this.getSchemaPanelName(), this.getXMLContentPanelName()};
            String[] stringArray2 = XMLWizardIterator.createSteps(this.beforeSteps, stringArray);
            this.xmlPanel.putClientProperty("WizardPanel_contentData", stringArray2);
        }
        return new AbstractPanel.WizardStep(this.xmlPanel);
    }

    private String getXMLContentPanelName() {
        return Util.THIS.getString("PROP_xml_content_panel_name");
    }

    private void generateXMLBody(DocumentModel documentModel, String string, Writer writer) {
        String string2 = documentModel.getPrimarySchema();
        if (documentModel.getPrimarySchema().startsWith("http")) {
            string2 = this.retrieveURLSchema(documentModel.getPrimarySchema());
        }
        XMLGeneratorVisitor xMLGeneratorVisitor = new XMLGeneratorVisitor(string2, documentModel.getXMLContentAttributes(), writer);
        xMLGeneratorVisitor.generateXML(string);
    }

    private String retrieveURLSchema(String string) {
        try {
            String string2;
            Comparable<URI> comparable;
            URI uRI;
            Project project = Templates.getProject((WizardDescriptor)this.templateWizard);
            FileObject fileObject = project.getProjectDirectory();
            File file = FileUtil.toFile((FileObject)fileObject);
            Object var5_6 = null;
            URI uRI2 = null;
            CacheDirectoryProvider cacheDirectoryProvider = (CacheDirectoryProvider)project.getLookup().lookup(CacheDirectoryProvider.class);
            String string3 = "private/cache/retriever";
            try {
                if (cacheDirectoryProvider != null && cacheDirectoryProvider.getCacheDirectory() != null) {
                    uRI = file.toURI();
                    comparable = FileUtil.toFile((FileObject)cacheDirectoryProvider.getCacheDirectory()).toURI();
                    string2 = Utilities.relativize((URI)uRI, (URI)comparable);
                    string3 = string2 + "/" + "retriever";
                }
                uRI2 = new URI(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uRI2 == null) {
                return null;
            }
            uRI = file.toURI().resolve(uRI2);
            comparable = new File(uRI);
            if (!((File)comparable).isDirectory()) {
                ((File)comparable).mkdirs();
            }
            string2 = RetrieverEngine.getRetrieverEngine(comparable, (boolean)false);
            RetrieveEntry retrieveEntry = new RetrieveEntry(null, string, null, null, Utilities.DocumentTypesEnum.schema, true);
            string2.addResourceToRetrieve(retrieveEntry);
            string2.setFileOverwrite(true);
            string2.start();
            String string4 = ((File)comparable).getPath() + string.substring(6, string.length());
            return string4;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

