/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.ChangeTypeFix;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChangeType
implements ErrorRule<Void> {
    private static Set<String> codes = new HashSet<String>();

    static void computeType(CompilationInfo compilationInfo, int n, TypeMirror[] typeMirrorArray, ExpressionTree[] expressionTreeArray, TypeMirror[] typeMirrorArray2, Tree[] treeArray) {
        TreePath treePath = compilationInfo.getTreeUtilities().pathFor(n);
        if (treePath != null) {
            Tree tree = treePath.getLeaf();
            TypeMirror typeMirror = null;
            TypeMirror typeMirror2 = null;
            ExpressionTree expressionTree = null;
            if (tree.getKind() == Tree.Kind.ASSIGNMENT) {
                if ((treePath = treePath.getParentPath()) != null) {
                    tree = treePath.getLeaf();
                }
            } else if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
                if ((treePath = treePath.getParentPath()) != null && (tree = treePath.getLeaf()).getKind() == Tree.Kind.METHOD_INVOCATION && (treePath = treePath.getParentPath()) != null) {
                    tree = treePath.getLeaf();
                }
            } else if (tree.getKind() == Tree.Kind.IDENTIFIER && (treePath = treePath.getParentPath()) != null && ((tree = treePath.getLeaf()).getKind() == Tree.Kind.MEMBER_SELECT || tree.getKind() == Tree.Kind.METHOD_INVOCATION) && (treePath = treePath.getParentPath()) != null) {
                tree = treePath.getLeaf();
            }
            if (tree.getKind() == Tree.Kind.VARIABLE && ((VariableTree)tree).getInitializer() != null) {
                typeMirror = compilationInfo.getTrees().getTypeMirror(treePath);
                expressionTree = ((VariableTree)tree).getInitializer();
                typeMirror2 = Utilities.resolveCapturedType(compilationInfo, compilationInfo.getTrees().getTypeMirror(new TreePath(treePath, expressionTree)));
            }
            if (typeMirror != null && typeMirror2 != null && typeMirror2.getKind() != TypeKind.VOID && typeMirror2.getKind() != TypeKind.EXECUTABLE && typeMirror2.getKind() != TypeKind.ERROR && typeMirror.getKind() != TypeKind.ERROR) {
                typeMirrorArray[0] = typeMirror;
                expressionTreeArray[0] = expressionTree;
                typeMirrorArray2[0] = typeMirror2;
                treeArray[0] = tree;
            }
        }
    }

    @Override
    public Set<String> getCodes() {
        return codes;
    }

    @Override
    public List<Fix> run(CompilationInfo compilationInfo, String string, int n, TreePath treePath, ErrorRule.Data<Void> data) {
        ArrayList<Fix> arrayList = new ArrayList<Fix>();
        TypeMirror[] typeMirrorArray = new TypeMirror[1];
        ExpressionTree[] expressionTreeArray = new ExpressionTree[1];
        TypeMirror[] typeMirrorArray2 = new TypeMirror[1];
        Tree[] treeArray = new Tree[1];
        ChangeType.computeType(compilationInfo, n, typeMirrorArray, expressionTreeArray, typeMirrorArray2, treeArray);
        if (treeArray[0] instanceof VariableTree && typeMirrorArray[0] != null) {
            arrayList.add(new ChangeTypeFix(compilationInfo.getJavaSource(), ((VariableTree)treeArray[0]).getName().toString(), ((Object)org.netbeans.modules.editor.java.Utilities.getTypeName((TypeMirror)typeMirrorArray2[0], (boolean)false)).toString(), n));
        }
        return arrayList;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return ChangeType.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(ChangeType.class, (String)"MSG_ChangeVariablesTypeDisplayName");
    }

    public String getDescription() {
        return NbBundle.getMessage(ChangeType.class, (String)"MSG_ChangeVariablesTypeDescription");
    }

    static {
        codes = new HashSet<String>();
        codes.add("compiler.err.prob.found.req");
        codes.add("compiler.err.incomparable.types");
        codes = Collections.unmodifiableSet(codes);
    }
}

