/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.modules.java.editor.overridden.IsOverriddenAnnotationHandler;
import org.netbeans.modules.java.hints.errors.ErrorFixesFakeHint;
import org.netbeans.modules.java.hints.errors.MagicSurroundWithTryCatchFix;
import org.netbeans.modules.java.hints.errors.OrigSurroundWithTryCatchFix;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UncaughtException
implements ErrorRule<Void> {
    private static final Set<ElementKind> EXECUTABLE_ELEMENTS = EnumSet.of(ElementKind.CONSTRUCTOR, ElementKind.METHOD);
    static final Set<Tree.Kind> STATEMENT_KINDS;

    private List<? extends TypeMirror> findUncaughtExceptions(CompilationInfo compilationInfo, TreePath treePath, List<? extends TypeMirror> list) {
        ArrayList<? extends TypeMirror> arrayList = new ArrayList<TypeMirror>();
        arrayList.addAll(list);
        Tree tree = null;
        while (treePath != null) {
            TryTree object2;
            TypeMirror typeMirror = compilationInfo.getTrees().getTypeMirror(treePath);
            if (typeMirror != null && typeMirror.getKind() == TypeKind.EXECUTABLE) {
                for (TypeMirror typeMirror2 : ((ExecutableType)typeMirror).getThrownTypes()) {
                    Iterator<CatchTree> iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        if (!compilationInfo.getTypes().isSameType((TypeMirror)((Object)iterator.next()), typeMirror2)) continue;
                        iterator.remove();
                    }
                }
                break;
            }
            Tree tree2 = treePath.getLeaf();
            if (tree2.getKind() == Tree.Kind.TRY && (object2 = (TryTree)tree2).getBlock() == tree) {
                for (CatchTree catchTree : object2.getCatches()) {
                    TreePath treePath2 = new TreePath(new TreePath(treePath, catchTree), catchTree.getParameter());
                    VariableElement variableElement = (VariableElement)compilationInfo.getTrees().getElement(treePath2);
                    arrayList.remove(variableElement.asType());
                }
            }
            tree = treePath.getLeaf();
            treePath = treePath.getParentPath();
        }
        return arrayList;
    }

    @Override
    public Set<String> getCodes() {
        return Collections.singleton("compiler.err.unreported.exception.need.to.catch.or.throw");
    }

    @Override
    public List<Fix> run(CompilationInfo compilationInfo, String string, int n, TreePath treePath, ErrorRule.Data<Void> data) {
        Object object;
        Object object2;
        MethodInvocationTree methodInvocationTree;
        Object object3;
        TreePath treePath2;
        ArrayList<Fix> arrayList = new ArrayList<Fix>();
        List<? extends TypeMirror> list = null;
        boolean bl = false;
        block5: for (treePath2 = compilationInfo.getTreeUtilities().pathFor(n + 1); treePath2 != null; treePath2 = treePath2.getParentPath()) {
            object3 = treePath2.getLeaf();
            switch (object3.getKind()) {
                case METHOD_INVOCATION: {
                    methodInvocationTree = (MethodInvocationTree)object3;
                    if (methodInvocationTree.getMethodSelect().getKind() == Tree.Kind.IDENTIFIER && ("super".equals(object2 = ((IdentifierTree)methodInvocationTree.getMethodSelect()).getName().toString()) || "this".equals(object2))) {
                        object = compilationInfo.getTrees().getElement(treePath2);
                        bl = object != null && object.getKind() == ElementKind.CONSTRUCTOR;
                    }
                }
                case NEW_CLASS: {
                    Element element = compilationInfo.getTrees().getElement(treePath2);
                    if (!UncaughtException.isInsideMethod(treePath2)) {
                        bl = true;
                    }
                    if (this.isThisParameter(treePath2)) {
                        boolean bl2 = bl = element != null && (element.getKind() == ElementKind.CONSTRUCTOR || element.getKind() == ElementKind.METHOD);
                    }
                    if (element != null && EXECUTABLE_ELEMENTS.contains((Object)element.getKind())) {
                        object2 = object3.getKind() == Tree.Kind.NEW_CLASS ? compilationInfo.getTrees().getTypeMirror(new TreePath(treePath2, ((NewClassTree)object3).getIdentifier())) : compilationInfo.getTrees().getTypeMirror(new TreePath(treePath2, ((MethodInvocationTree)object3).getMethodSelect()));
                        list = object2 != null && object2.getKind() == TypeKind.EXECUTABLE ? ((ExecutableType)object2).getThrownTypes() : ((ExecutableElement)element).getThrownTypes();
                    }
                    treePath2 = treePath2.getParentPath();
                    break block5;
                }
                case THROW: {
                    object2 = compilationInfo.getTrees().getTypeMirror(new TreePath(treePath2, ((ThrowTree)object3).getExpression()));
                    list = Collections.singletonList(object2);
                    break block5;
                }
                default: {
                    continue block5;
                }
            }
        }
        if (list != null) {
            list = this.findUncaughtExceptions(compilationInfo, treePath2, list);
            for (object3 = treePath2; object3 != null && ((TreePath)object3).getLeaf().getKind() != Tree.Kind.METHOD; object3 = ((TreePath)object3).getParentPath()) {
            }
            MethodInvocationTree methodInvocationTree2 = methodInvocationTree = object3 != null ? (ExecutableElement)compilationInfo.getTrees().getElement((TreePath)object3) : null;
            if (methodInvocationTree != null && !Utilities.isMethodHeaderInsideGuardedBlock(compilationInfo, (MethodTree)((TreePath)object3).getLeaf())) {
                Object object4;
                Object object5;
                object2 = new LinkedList();
                object = IsOverriddenAnnotationHandler.detectOverrides((CompilationInfo)compilationInfo, (TypeElement)((TypeElement)methodInvocationTree.getEnclosingElement()), (ExecutableElement)((Object)methodInvocationTree), object2);
                Object object6 = null;
                if (object != null) {
                    object6 = new LinkedList();
                    Iterator object7 = object2.iterator();
                    while (object7.hasNext()) {
                        ElementDescription elementDescription = (ElementDescription)object7.next();
                        ExecutableElement executableElement = (ExecutableElement)elementDescription.getHandle().resolve(compilationInfo);
                        object5 = new LinkedList<TypeMirror>(executableElement.getThrownTypes());
                        object4 = object6.iterator();
                        while (object4.hasNext()) {
                            Iterator iterator = object5.iterator();
                            while (iterator.hasNext()) {
                                TypeMirror typeMirror = (TypeMirror)object4.next();
                                TypeMirror typeMirror2 = (TypeMirror)iterator.next();
                                if (compilationInfo.getTypes().isSubtype(typeMirror2, typeMirror)) {
                                    iterator.remove();
                                    continue;
                                }
                                if (compilationInfo.getTypes().isSubtype(typeMirror, typeMirror2)) {
                                    object4.remove();
                                    continue;
                                }
                                iterator.remove();
                                object4.remove();
                            }
                        }
                        object6.addAll(object5);
                    }
                }
                for (TypeMirror typeMirror : list) {
                    if (object6 != null) {
                        boolean bl3 = false;
                        object5 = object6.iterator();
                        while (object5.hasNext()) {
                            object4 = (TypeMirror)object5.next();
                            if (!compilationInfo.getTypes().isSubtype(typeMirror, (TypeMirror)object4)) continue;
                            bl3 = true;
                            break;
                        }
                        if (!bl3) continue;
                    }
                    if (typeMirror.getKind() == TypeKind.ERROR) continue;
                    arrayList.add(new AddThrowsClauseHintImpl(compilationInfo.getJavaSource(), ((Object)org.netbeans.modules.editor.java.Utilities.getTypeName((TypeMirror)typeMirror, (boolean)true)).toString(), TypeMirrorHandle.create((TypeMirror)typeMirror), (ElementHandle<ExecutableElement>)ElementHandle.create((Element)((Object)methodInvocationTree))));
                }
            }
            if (!list.isEmpty() && !bl) {
                object2 = new ArrayList();
                object = new ArrayList();
                for (TypeMirror typeMirror : list) {
                    if (typeMirror.getKind() == TypeKind.ERROR) continue;
                    object2.add(TypeMirrorHandle.create((TypeMirror)typeMirror));
                    object.add(((Object)org.netbeans.modules.editor.java.Utilities.getTypeName((TypeMirror)typeMirror, (boolean)true)).toString());
                }
                if (ErrorFixesFakeHint.enabled(ErrorFixesFakeHint.FixKind.SURROUND_WITH_TRY_CATCH)) {
                    arrayList.add(new OrigSurroundWithTryCatchFix(compilationInfo.getJavaSource(), (List<TypeMirrorHandle>)object2, TreePathHandle.create((TreePath)treePath2, (CompilationInfo)compilationInfo)));
                    arrayList.add(new MagicSurroundWithTryCatchFix(compilationInfo.getJavaSource(), (List<TypeMirrorHandle>)object2, n, (ElementHandle<ExecutableElement>)ElementHandle.create((Element)((Object)methodInvocationTree)), (List<String>)object));
                }
            }
        }
        return arrayList;
    }

    private boolean isThisParameter(TreePath treePath) {
        while (treePath.getLeaf().getKind() != Tree.Kind.CLASS && treePath.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            String string;
            MethodInvocationTree methodInvocationTree;
            if (treePath.getParentPath().getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION && (methodInvocationTree = (MethodInvocationTree)treePath.getParentPath().getLeaf()).getMethodSelect().getKind() == Tree.Kind.IDENTIFIER && ("super".equals(string = ((IdentifierTree)methodInvocationTree.getMethodSelect()).getName().toString()) || "this".equals(string))) {
                return true;
            }
            treePath = treePath.getParentPath();
        }
        return false;
    }

    private static boolean isInsideMethod(TreePath treePath) {
        while (treePath != null) {
            if (treePath.getLeaf().getKind() == Tree.Kind.METHOD) {
                return true;
            }
            treePath = treePath.getParentPath();
        }
        return false;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return UncaughtException.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(UncaughtException.class, (String)"DN_AddThrowsClauseAndSurround");
    }

    public String getDescription() {
        return NbBundle.getMessage(UncaughtException.class, (String)"DESC_AddThrowsClauseAndSurround");
    }

    static {
        HashSet<Tree.Kind> hashSet = new HashSet<Tree.Kind>();
        for (Tree.Kind kind : Tree.Kind.values()) {
            Class<? extends Tree> clazz = kind.asInterface();
            if (clazz == null || !StatementTree.class.isAssignableFrom(clazz)) continue;
            hashSet.add(kind);
        }
        STATEMENT_KINDS = Collections.unmodifiableSet(EnumSet.copyOf(hashSet));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AddThrowsClauseHintImpl
    implements Fix {
        private JavaSource js;
        private String fqn;
        private TypeMirrorHandle thandle;
        private ElementHandle<ExecutableElement> method;

        public AddThrowsClauseHintImpl(JavaSource javaSource, String string, TypeMirrorHandle typeMirrorHandle, ElementHandle<ExecutableElement> elementHandle) {
            this.js = javaSource;
            this.fqn = string;
            this.thandle = typeMirrorHandle;
            this.method = elementHandle;
        }

        public String getText() {
            return NbBundle.getMessage(UncaughtException.class, (String)"FIX_AddThrowsClause", (Object[])new Object[]{String.valueOf(this.fqn)});
        }

        public ChangeInfo implement() throws IOException {
            this.js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws Exception {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    MethodTree methodTree = workingCopy.getTrees().getTree((ExecutableElement)AddThrowsClauseHintImpl.this.method.resolve((CompilationInfo)workingCopy));
                    assert (methodTree != null);
                    assert (methodTree.getKind() == Tree.Kind.METHOD);
                    MethodTree methodTree2 = workingCopy.getTreeMaker().addMethodThrows(methodTree, (ExpressionTree)workingCopy.getTreeMaker().Type(AddThrowsClauseHintImpl.this.thandle.resolve((CompilationInfo)workingCopy)));
                    workingCopy.rewrite((Tree)methodTree, (Tree)methodTree2);
                }
            }).commit();
            return null;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            AddThrowsClauseHintImpl addThrowsClauseHintImpl = (AddThrowsClauseHintImpl)object;
            if (!(this.js == addThrowsClauseHintImpl.js || this.js != null && this.js.equals(addThrowsClauseHintImpl.js))) {
                return false;
            }
            if (this.fqn == null || !this.fqn.equals(addThrowsClauseHintImpl.fqn)) {
                return false;
            }
            return this.method == addThrowsClauseHintImpl.method || this.method != null && this.method.equals(addThrowsClauseHintImpl.method);
        }

        public int hashCode() {
            int n = 7;
            n = 13 * n + (this.fqn != null ? this.fqn.hashCode() : 0);
            n = 13 * n + (this.method != null ? this.method.hashCode() : 0);
            return n;
        }
    }
}

