/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    public static String guessName(CompilationInfo compilationInfo, TreePath treePath) {
        String string = Utilities.getName((ExpressionTree)treePath.getLeaf());
        if (string == null) {
            return "name";
        }
        Scope scope = compilationInfo.getTrees().getScope(treePath);
        int n = 0;
        boolean bl = true;
        String string2 = string;
        block0: while (bl) {
            string2 = string + (n != 0 ? String.valueOf(n) : "");
            bl = false;
            for (Element element : compilationInfo.getElementUtilities().getLocalMembersAndVars(scope, (ElementUtilities.ElementAcceptor)new VariablesFilter())) {
                if (!string2.equals(element.getSimpleName().toString())) continue;
                ++n;
                bl = true;
                continue block0;
            }
        }
        return string2;
    }

    public static String getName(TypeMirror typeMirror) {
        if (typeMirror.getKind().isPrimitive()) {
            return "" + Character.toLowerCase(typeMirror.getKind().name().charAt(0));
        }
        switch (typeMirror.getKind()) {
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                return Utilities.firstToLower(declaredType.asElement().getSimpleName().toString());
            }
            case ARRAY: {
                return Utilities.getName(((ArrayType)typeMirror).getComponentType());
            }
        }
        return null;
    }

    public static String getName(ExpressionTree expressionTree) {
        return Utilities.adjustName(Utilities.getNameRaw(expressionTree));
    }

    private static String getNameRaw(ExpressionTree expressionTree) {
        if (expressionTree == null) {
            return null;
        }
        switch (expressionTree.getKind()) {
            case IDENTIFIER: {
                return ((IdentifierTree)expressionTree).getName().toString();
            }
            case METHOD_INVOCATION: {
                return Utilities.getName(((MethodInvocationTree)expressionTree).getMethodSelect());
            }
            case MEMBER_SELECT: {
                return ((MemberSelectTree)expressionTree).getIdentifier().toString();
            }
            case NEW_CLASS: {
                String string = ((NewClassTree)expressionTree).getIdentifier().toString();
                char c = string.charAt(0);
                if (Character.isUpperCase(c)) {
                    return Character.toLowerCase(c) + string.substring(1);
                }
                return string + "1";
            }
        }
        return null;
    }

    static String adjustName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        if (string.startsWith("get") && string.length() > 3) {
            string2 = string.substring(3);
        }
        if (string.startsWith("is") && string.length() > 2) {
            string2 = string.substring(2);
        }
        if (string2 != null) {
            return Utilities.firstToLower(string2);
        }
        if (SourceVersion.isKeyword(string)) {
            return "a" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        return string;
    }

    private static String firstToLower(String string) {
        if (string.length() == 0) {
            return null;
        }
        String string2 = Character.toLowerCase(string.charAt(0)) + string.substring(1);
        if (SourceVersion.isKeyword(string2)) {
            string2 = "a" + string;
        }
        return string2;
    }

    public static ChangeInfo commitAndComputeChangeInfo(FileObject fileObject, ModificationResult modificationResult) throws IOException {
        ChangeInfo changeInfo;
        block5: {
            List list = modificationResult.getDifferences(fileObject);
            changeInfo = null;
            try {
                if (list == null) break block5;
                for (ModificationResult.Difference difference : list) {
                    if (difference.getNewText() == null) continue;
                    final PositionRef positionRef = difference.getStartPosition();
                    StyledDocument styledDocument = positionRef.getCloneableEditorSupport().getDocument();
                    if (styledDocument == null) {
                        styledDocument = positionRef.getCloneableEditorSupport().openDocument();
                    }
                    final Position[] positionArray = new Position[1];
                    final StyledDocument styledDocument2 = styledDocument;
                    styledDocument.render(new Runnable(){

                        public void run() {
                            try {
                                positionArray[0] = NbDocument.createPosition((Document)styledDocument2, (int)positionRef.getOffset(), (Position.Bias)Position.Bias.Backward);
                            }
                            catch (BadLocationException badLocationException) {
                                Exceptions.printStackTrace((Throwable)badLocationException);
                            }
                        }
                    });
                    if (positionArray[0] != null) {
                        changeInfo = new ChangeInfo(fileObject, positionArray[0], positionArray[0]);
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        modificationResult.commit();
        return changeInfo;
    }

    public static boolean isMethodHeaderInsideGuardedBlock(CompilationInfo compilationInfo, MethodTree methodTree) {
        try {
            Document document = compilationInfo.getDocument();
            if (document instanceof GuardedDocument) {
                GuardedDocument guardedDocument = (GuardedDocument)document;
                int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), methodTree);
                int n2 = (int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), methodTree);
                return (guardedDocument.getGuardedBlockChain().compareBlock(n, n2) & 1) != 0;
            }
            return false;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    public static TypeMirror resolveCapturedType(CompilationInfo compilationInfo, TypeMirror typeMirror) {
        TypeMirror typeMirror2 = Utilities.resolveCapturedTypeInt(compilationInfo, typeMirror);
        if (typeMirror2.getKind() == TypeKind.WILDCARD) {
            return ((WildcardType)typeMirror2).getExtendsBound();
        }
        return typeMirror2;
    }

    private static TypeMirror resolveCapturedTypeInt(CompilationInfo compilationInfo, TypeMirror typeMirror) {
        WildcardType wildcardType = SourceUtils.resolveCapturedType((TypeMirror)typeMirror);
        if (wildcardType != null) {
            return wildcardType;
        }
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            LinkedList<TypeMirror> linkedList = new LinkedList<TypeMirror>();
            for (TypeMirror typeMirror2 : declaredType.getTypeArguments()) {
                linkedList.add(Utilities.resolveCapturedTypeInt(compilationInfo, typeMirror2));
            }
            return compilationInfo.getTypes().getDeclaredType((TypeElement)declaredType.asElement(), linkedList.toArray(new TypeMirror[0]));
        }
        return typeMirror;
    }

    public static <T extends Tree> T copyComments(WorkingCopy workingCopy, Tree tree, T t) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        for (Comment comment : workingCopy.getTreeUtilities().getComments(tree, true)) {
            treeMaker.addComment(t, comment, true);
        }
        for (Comment comment : workingCopy.getTreeUtilities().getComments(tree, false)) {
            treeMaker.addComment(t, comment, false);
        }
        return t;
    }

    private static final class VariablesFilter
    implements ElementUtilities.ElementAcceptor {
        private static final Set<ElementKind> ACCEPTABLE_KINDS = EnumSet.of(ElementKind.ENUM_CONSTANT, ElementKind.EXCEPTION_PARAMETER, ElementKind.FIELD, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER);

        private VariablesFilter() {
        }

        public boolean accept(Element element, TypeMirror typeMirror) {
            return ACCEPTABLE_KINDS.contains((Object)element.getKind());
        }
    }
}

