/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.tag;

import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JButton;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.tag.RtagCommand;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.MergePanel;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.RTagExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MergeBranchAction
extends AbstractSystemAction {
    private static final int enabledForStatus = 1208;

    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_MergeBranch";
    }

    protected int getFileEnabledStatus() {
        return 1208;
    }

    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    public void performCvsAction(Node[] nodeArray) {
        Context context = this.getContext(nodeArray);
        String string = MessageFormat.format(NbBundle.getBundle(MergeBranchAction.class).getString("CTL_MergeBranchDialog_Title"), this.getContextDisplayName(nodeArray));
        MergePanel mergePanel = new MergePanel(context.getFiles());
        JButton jButton = new JButton(NbBundle.getMessage(MergeBranchAction.class, (String)"CTL_MergeBranchDialog_Action_Merge"));
        mergePanel.putClientProperty("OKButton", jButton);
        jButton.setToolTipText(NbBundle.getMessage(MergeBranchAction.class, (String)"TT_MergeBranchDialog_Action_Merge"));
        JButton jButton2 = new JButton(NbBundle.getMessage(MergeBranchAction.class, (String)"CTL_MergeBranchDialog_Action_Cancel"));
        jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MergeBranchAction.class, (String)"ACSD_MergeBranchDialog_Action_Cancel"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)mergePanel, string, true, new Object[]{jButton, jButton2}, (Object)jButton, 0, new HelpCtx(MergeBranchAction.class), null);
        dialogDescriptor.setClosingOptions(null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MergeBranchAction.class, (String)"ACSD_MergeBranchDialog"));
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != jButton) {
            return;
        }
        mergePanel.saveSettings();
        RequestProcessor.getDefault().post((Runnable)new MergeBranchExecutor(context, mergePanel, this.getRunningName(nodeArray), this.getContextDisplayName(nodeArray)));
    }

    protected boolean asynchronous() {
        return false;
    }

    private static class MergeBranchExecutor
    implements Runnable {
        private final Context context;
        private final MergePanel settings;
        private final String contextName;
        private String temporaryTag;
        private String name;

        public MergeBranchExecutor(Context context, MergePanel mergePanel, String string, String string2) {
            this.context = context;
            this.settings = mergePanel;
            this.name = string;
            this.contextName = string2;
        }

        public void run() {
            final ExecutorGroup executorGroup = new ExecutorGroup(this.name);
            if (this.settings.isTaggingAfterMerge()) {
                this.temporaryTag = this.settings.getAfterMergeTagName() + "_tempheadmarker";
                final ExecutorSupport[] executorSupportArray = this.tagHeadTemporary();
                executorGroup.addExecutors(executorSupportArray);
                Runnable runnable = new Runnable(){

                    public void run() {
                        if (executorSupportArray == null || ExecutorSupport.wait(executorSupportArray)) {
                            executorGroup.addCleanups(MergeBranchExecutor.this.removeTagHeadTemporary());
                        }
                    }
                };
                executorGroup.addBarrier(runnable);
                executorGroup.addExecutors(this.update());
                executorGroup.addBarrier(null);
                executorGroup.addExecutors(this.tag());
            } else {
                executorGroup.addExecutors(this.update());
            }
            executorGroup.execute();
        }

        private UpdateExecutor[] update() {
            UpdateCommand updateCommand = new UpdateCommand();
            String string = this.temporaryTag != null ? this.temporaryTag : (this.settings.isMergingFromTrunk() ? "HEAD" : (this.settings.isMergingFromBranch() ? this.settings.getBranchName() : this.settings.getEndTagName()));
            GlobalOptions globalOptions = CvsVersioningSystem.createGlobalOptions();
            if (this.context.getExclusions().size() > 0) {
                globalOptions.setExclusions(this.context.getExclusions().toArray(new File[this.context.getExclusions().size()]));
            }
            if (this.settings.isUsingMergeTag()) {
                updateCommand.setMergeRevision1(this.settings.getMergeTagName());
                updateCommand.setMergeRevision2(string);
            } else {
                updateCommand.setMergeRevision1(string);
            }
            updateCommand.setFiles(this.context.getRootFiles());
            updateCommand.setBuildDirectories(true);
            updateCommand.setPruneDirectories(true);
            return UpdateExecutor.splitCommand(updateCommand, CvsVersioningSystem.getInstance(), globalOptions, this.contextName);
        }

        private RTagExecutor[] tag() {
            RtagCommand rtagCommand = new RtagCommand();
            rtagCommand.setOverrideExistingTag(true);
            rtagCommand.setTagByRevision(this.temporaryTag);
            rtagCommand.setTag(this.settings.getAfterMergeTagName());
            return RTagExecutor.splitCommand(rtagCommand, this.context.getFiles(), null);
        }

        private RTagExecutor[] tagHeadTemporary() {
            RtagCommand rtagCommand = new RtagCommand();
            rtagCommand.setOverrideExistingTag(true);
            rtagCommand.setTagByRevision(this.settings.isMergingFromTrunk() ? "HEAD" : this.settings.getBranchName());
            rtagCommand.setTag(this.temporaryTag);
            return RTagExecutor.splitCommand(rtagCommand, this.context.getFiles(), null);
        }

        private RTagExecutor[] removeTagHeadTemporary() {
            RtagCommand rtagCommand = new RtagCommand();
            rtagCommand.setDeleteTag(true);
            rtagCommand.setTag(this.temporaryTag);
            return RTagExecutor.splitCommand(rtagCommand, this.context.getFiles(), null);
        }
    }
}

