/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.samples.bankapp;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.uml.samples.bankapp.UMLBankAppSampleWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class UMLBankAppSamplePanelVisual
extends JPanel
implements DocumentListener {
    public static final String PROP_PROJECT_NAME = "projectName";
    public static final String PROP_UML_PROJECT_NAME = "umlProjectName";
    private UMLBankAppSampleWizardPanel panel;
    private JButton browseButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JLabel createdUmlFolderLabel;
    private JTextField createdUmlFolderTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JLabel umlProjectNameLabel;
    private JTextField umlProjectNameTextField;

    public UMLBankAppSamplePanelVisual(UMLBankAppSampleWizardPanel uMLBankAppSampleWizardPanel) {
        this.initComponents();
        this.panel = uMLBankAppSampleWizardPanel;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        this.umlProjectNameTextField.getDocument().addDocumentListener(this);
    }

    public String getProjectName() {
        return this.projectNameTextField.getText();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.umlProjectNameLabel = new JLabel();
        this.umlProjectNameTextField = new JTextField();
        this.createdUmlFolderLabel = new JLabel();
        this.createdUmlFolderTextField = new JTextField();
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"LBL_JavaProjectNameLabel"));
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"LBL_ProjectsLocationLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"LBL_BrowseButton"));
        this.browseButton.setActionCommand("BROWSE");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UMLBankAppSamplePanelVisual.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"LBL_JavaProjectFolderLable"));
        this.createdFolderTextField.setEditable(false);
        this.umlProjectNameLabel.setLabelFor(this.umlProjectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.umlProjectNameLabel, (String)NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"LBL_UMLProjectNameLabel"));
        this.createdUmlFolderLabel.setLabelFor(this.createdUmlFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdUmlFolderLabel, (String)NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"LBL_UMLProjectFolderLabel"));
        this.createdUmlFolderTextField.setEditable(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectNameLabel).add((Component)this.projectLocationLabel).add((Component)this.umlProjectNameLabel).add((Component)this.createdFolderLabel).add((Component)this.createdUmlFolderLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.projectLocationTextField, -1, 213, Short.MAX_VALUE).add((Component)this.projectNameTextField, -1, 213, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.browseButton).addContainerGap()).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.createdUmlFolderTextField, -1, 213, Short.MAX_VALUE).add((Component)this.createdFolderTextField, -1, 213, Short.MAX_VALUE).add((Component)this.umlProjectNameTextField, -1, 213, Short.MAX_VALUE)).add(95, 95, 95)))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectNameLabel).add((Component)this.projectNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectLocationLabel).add((Component)this.browseButton).add((Component)this.projectLocationTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.createdFolderLabel).add((Component)this.createdFolderTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.umlProjectNameLabel).add((Component)this.umlProjectNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.createdUmlFolderLabel).add((Component)this.createdUmlFolderTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.projectNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"ACSN_JavaProjectName"));
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"ACSD_JavaProjectName"));
        this.projectLocationTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"ACSN_ProjectsLocation"));
        this.projectLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"ACSD_ProjectsLocation"));
        this.createdFolderTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"ACSN_JavaProjectFolder"));
        this.createdFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"ACSD_JavaProjectFolder"));
        this.umlProjectNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"ACSN_UMLProjectName"));
        this.umlProjectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"ACSD_UMLProjectName"));
        this.createdUmlFolderTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"ACSN_UMLProjectFolder"));
        this.createdUmlFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"ACSD_UMLProjectFolder"));
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("BROWSE".equals(string)) {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
            jFileChooser.setDialogTitle(NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"MSG_SelectProjectLocation"));
            jFileChooser.setFileSelectionMode(1);
            String string2 = this.projectLocationTextField.getText();
            if (string2.length() > 0 && (file = new File(string2)).exists()) {
                jFileChooser.setSelectedFile(file);
            }
            if (0 == jFileChooser.showOpenDialog(this)) {
                file = jFileChooser.getSelectedFile();
                this.projectLocationTextField.setText(FileUtil.normalizeFile((File)file).getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        File file;
        File file2;
        File file3;
        File file4;
        if (this.projectNameTextField.getText().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"MSG_JavaProjectNameNotValidFolder"));
            return false;
        }
        File file5 = FileUtil.normalizeFile((File)new File(this.projectLocationTextField.getText()).getAbsoluteFile());
        if (!file5.isDirectory()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"MSG_JavaProjectFolderNotValidPath"));
            return false;
        }
        for (file4 = file3 = FileUtil.normalizeFile((File)new File(this.createdFolderTextField.getText()).getAbsoluteFile()); file4 != null && !file4.exists(); file4 = file4.getParentFile()) {
        }
        if (file4 == null || !file4.canWrite()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"MSG_CantCreateJavaProjectFolder"));
            return false;
        }
        if (FileUtil.toFileObject((File)file4) == null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"MSG_JavaProjectFolderNotValidPath"));
            return false;
        }
        File[] fileArray = file3.listFiles();
        if (file3.exists() && fileArray != null && fileArray.length > 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"MSG_JavaProjectFolderExists"));
            return false;
        }
        if (this.umlProjectNameTextField.getText().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"MSG_UMLProjectNameNotValidFolder"));
            return false;
        }
        File file6 = FileUtil.normalizeFile((File)new File(this.projectLocationTextField.getText()).getAbsoluteFile());
        for (file2 = file = FileUtil.normalizeFile((File)new File(this.createdUmlFolderTextField.getText()).getAbsoluteFile()); file2 != null && !file2.exists(); file2 = file2.getParentFile()) {
        }
        if (file2 == null || !file2.canWrite()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"MSG_CantCreateUMLProjectFolder"));
            return false;
        }
        if (FileUtil.toFileObject((File)file4) == null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"MSG_UMLProjectFolderNotValidPath"));
            return false;
        }
        File[] fileArray2 = file.listFiles();
        if (file.exists() && fileArray2 != null && fileArray2.length > 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"MSG_UMLProjectFolderExists"));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    void store(WizardDescriptor wizardDescriptor) {
        String string = this.projectNameTextField.getText().trim();
        String string2 = this.createdFolderTextField.getText().trim();
        String string3 = this.umlProjectNameTextField.getText().trim();
        String string4 = this.createdUmlFolderTextField.getText().trim();
        wizardDescriptor.putProperty("projdir", (Object)new File(string2));
        wizardDescriptor.putProperty("name", (Object)string);
        wizardDescriptor.putProperty("umlprojdir", (Object)new File(string4));
        wizardDescriptor.putProperty("umlname", (Object)string3);
    }

    void read(WizardDescriptor wizardDescriptor) {
        File file = (File)wizardDescriptor.getProperty("projdir");
        file = file == null || file.getParentFile() == null || !file.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : file.getParentFile();
        this.projectLocationTextField.setText(file.getAbsolutePath());
        String string = (String)wizardDescriptor.getProperty("name");
        if (string == null) {
            string = NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"MSG_ProjectBaseName");
        }
        this.projectNameTextField.setText(string);
        this.projectNameTextField.selectAll();
        String string2 = (String)wizardDescriptor.getProperty("umlname");
        if (string2 == null) {
            string2 = string + NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"MSG_UMLProjectSuffix");
        }
        this.umlProjectNameTextField.setText(string2);
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        } else if (this.umlProjectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_UML_PROJECT_NAME, null, this.umlProjectNameTextField.getText());
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        } else if (this.umlProjectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_UML_PROJECT_NAME, null, this.umlProjectNameTextField.getText());
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        } else if (this.umlProjectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_UML_PROJECT_NAME, null, this.umlProjectNameTextField.getText());
        }
    }

    private void updateTexts(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.projectNameTextField.getDocument() || document == this.projectLocationTextField.getDocument() || document == this.umlProjectNameTextField.getDocument()) {
            if (document == this.projectNameTextField.getDocument() || document == this.projectLocationTextField.getDocument()) {
                String string = this.projectNameTextField.getText();
                String string2 = this.projectLocationTextField.getText();
                this.createdFolderTextField.setText(string2 + File.separatorChar + string);
                this.umlProjectNameTextField.setText(this.projectNameTextField.getText() + NbBundle.getMessage(UMLBankAppSamplePanelVisual.class, (String)"MSG_UMLProjectSuffix"));
            }
            this.createdUmlFolderTextField.setText(this.projectLocationTextField.getText() + File.separatorChar + this.umlProjectNameTextField.getText());
        }
        this.panel.fireChangeEvent();
    }
}

