/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.timers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.timers.TimesCollectorPeer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.modules.ModuleInstall;

public class Install
extends ModuleInstall {
    static Logger logger;
    private static Handler timers;
    private static PropertyChangeListener docTracker;
    private static String INSTANCES;

    public void restored() {
        Logger logger = Logger.getLogger("TIMER");
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.FINE);
        logger.addHandler(timers);
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)docTracker);
    }

    static {
        timers = new TimerHandler();
        docTracker = new ActivatedDocumentListener();
        INSTANCES = "Important instances";
    }

    private static class ActivatedDocumentListener
    implements PropertyChangeListener {
        ActivatedDocumentListener() {
        }

        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTextComponent jTextComponent = EditorRegistry.focusedComponent();
            if (jTextComponent == null) {
                return;
            }
            Document document = jTextComponent.getDocument();
            Object object = document.getProperty("stream");
            if (!(object instanceof DataObject)) {
                return;
            }
            FileObject fileObject = ((DataObject)object).getPrimaryFile();
            TimesCollectorPeer.getDefault().select(fileObject);
        }
    }

    private static class TimerHandler
    extends Handler {
        TimerHandler() {
        }

        public void publish(LogRecord logRecord) {
            Object[] objectArray;
            String string = logRecord.getMessage();
            if (logRecord.getResourceBundle() != null) {
                try {
                    string = logRecord.getResourceBundle().getString(logRecord.getMessage());
                    if (logRecord.getParameters() != null) {
                        string = MessageFormat.format(string, logRecord.getParameters());
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    Logger.getAnonymousLogger().log(Level.INFO, null, missingResourceException);
                }
            }
            if ((objectArray = logRecord.getParameters()) == null || objectArray[0] == null) {
                return;
            }
            if (objectArray.length == 1) {
                TimesCollectorPeer.getDefault().reportReference(INSTANCES, logRecord.getMessage(), string, objectArray[0]);
                return;
            }
            if (objectArray.length < 2) {
                return;
            }
            Object object = objectArray[0];
            if (objectArray[1] instanceof Number) {
                TimesCollectorPeer.getDefault().reportTime(object, logRecord.getMessage(), string, ((Number)objectArray[1]).longValue());
            } else if (!(objectArray[1] instanceof Boolean)) {
                String string2 = string.startsWith("[M]") ? string : "[M] " + string;
                TimesCollectorPeer.getDefault().reportReference(object, logRecord.getMessage(), string2, objectArray[1]);
            }
        }

        public void flush() {
        }

        public void close() throws SecurityException {
        }
    }
}

