/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.FormatLayer;
import org.netbeans.editor.ext.FormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.cplusplus.CCFormatSupport;
import org.netbeans.modules.cnd.editor.cplusplus.CCSyntax;
import org.netbeans.modules.cnd.editor.cplusplus.CCTokenContext;
import org.netbeans.modules.cnd.editor.cplusplus.CKit;

public class CCFormatter
extends ExtFormatter {
    public static final String IGNORE_IN_COMMENTS_MODE = "IgnoreInCommentMode";

    public CCFormatter(Class clazz) {
        super(clazz);
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof CCSyntax;
    }

    public int[] getReformatBlock(JTextComponent jTextComponent, String string) {
        int[] nArray = null;
        BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
        int n = jTextComponent.getCaret().getDot();
        if (baseDocument != null && (nArray = CCFormatter.getKeywordBasedReformatBlock(baseDocument, n, string)) == null) {
            nArray = super.getReformatBlock(jTextComponent, string);
        }
        return nArray;
    }

    public static int[] getKeywordBasedReformatBlock(BaseDocument baseDocument, int n, String string) {
        int[] nArray = null;
        if ("e".equals(string)) {
            try {
                int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
                if (CCFormatter.checkCase(baseDocument, n2, "else")) {
                    nArray = new int[]{n2, n2 + 4};
                }
            }
            catch (BadLocationException badLocationException) {}
        } else if (":".equals(string)) {
            try {
                int n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
                if (CCFormatter.checkCase(baseDocument, n3, "case")) {
                    nArray = new int[]{n3, n3 + 4};
                } else if (CCFormatter.checkCase(baseDocument, n3, "default")) {
                    nArray = new int[]{n3, n3 + 7};
                } else if (CCFormatter.checkCase(baseDocument, n3, "public")) {
                    nArray = new int[]{n3, n3 + 6};
                } else if (CCFormatter.checkCase(baseDocument, n3, "protected")) {
                    nArray = new int[]{n3, n3 + 9};
                } else if (CCFormatter.checkCase(baseDocument, n3, "private")) {
                    nArray = new int[]{n3, n3 + 7};
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (nArray == null && string != null && string.length() == 1 && Character.isLetter(string.charAt(0))) {
            try {
                int n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
                if (CCFormatter.checkCase(baseDocument, n4, string + "\n")) {
                    nArray = new int[]{n4, n4 + 1};
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return nArray;
    }

    private static boolean checkCase(BaseDocument baseDocument, int n, String string) throws BadLocationException {
        return n >= 0 && n + string.length() <= baseDocument.getLength() && string.equals(baseDocument.getText(n, string.length()));
    }

    protected void initFormatLayers() {
        if (CKit.class.equals((Object)this.getKitClass())) {
            this.addFormatLayer((FormatLayer)new StripEndWhitespaceLayer(CodeStyle.Language.C));
            this.addFormatLayer((FormatLayer)new CCLayer(CodeStyle.Language.C));
        } else {
            this.addFormatLayer((FormatLayer)new StripEndWhitespaceLayer(CodeStyle.Language.CPP));
            this.addFormatLayer((FormatLayer)new CCLayer(CodeStyle.Language.CPP));
        }
    }

    public FormatSupport createFormatSupport(FormatWriter formatWriter) {
        return new CCFormatSupport(formatWriter);
    }

    public class CCLayer
    extends AbstractFormatLayer {
        private CodeStyle.Language language;

        public CCLayer(CodeStyle.Language language) {
            super("cc-layer");
            this.language = language;
        }

        protected FormatSupport createFormatSupport(FormatWriter formatWriter) {
            return new CCFormatSupport(formatWriter);
        }

        public void format(FormatWriter formatWriter) {
            block6: {
                try {
                    CCFormatSupport cCFormatSupport = (CCFormatSupport)this.createFormatSupport(formatWriter);
                    FormatTokenPosition formatTokenPosition = cCFormatSupport.getFormatStartPosition();
                    if (cCFormatSupport.isIndentOnly()) {
                        Boolean bl = (Boolean)formatWriter.getDocument().getProperty(CCFormatter.IGNORE_IN_COMMENTS_MODE);
                        cCFormatSupport.indentLine(formatTokenPosition, Boolean.TRUE == bl);
                        break block6;
                    }
                    while (formatTokenPosition != null) {
                        cCFormatSupport.indentLine(formatTokenPosition, false);
                        this.formatLine(cCFormatSupport, formatTokenPosition);
                        FormatTokenPosition formatTokenPosition2 = cCFormatSupport.findLineEnd(formatTokenPosition);
                        if (formatTokenPosition2 != null && formatTokenPosition2.getToken() != null && (formatTokenPosition = cCFormatSupport.getNextPosition(formatTokenPosition2, Position.Bias.Forward)) != formatTokenPosition2 && formatTokenPosition != null && formatTokenPosition.getToken() != null) {
                            FormatTokenPosition formatTokenPosition3 = cCFormatSupport.findLineFirstNonWhitespace(formatTokenPosition);
                            if (formatTokenPosition3 != null) {
                                formatTokenPosition = formatTokenPosition3;
                                continue;
                            }
                            formatTokenPosition = cCFormatSupport.findLineStart(formatTokenPosition);
                            continue;
                        }
                        break;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }

        private void removeLineBeforeToken(TokenItem tokenItem, CCFormatSupport cCFormatSupport, boolean bl) {
            FormatTokenPosition formatTokenPosition;
            FormatTokenPosition formatTokenPosition2;
            FormatTokenPosition formatTokenPosition3 = cCFormatSupport.getPosition(tokenItem, 0);
            if (cCFormatSupport.findNonWhitespace(formatTokenPosition3, null, true, true) != null) {
                return;
            }
            if (bl && ((formatTokenPosition2 = cCFormatSupport.findNonWhitespace(formatTokenPosition3, null, false, true)) == null || formatTokenPosition2.getToken().getTokenID().getNumericID() != 65)) {
                return;
            }
            if (cCFormatSupport.getNextPosition(formatTokenPosition3) != null && (formatTokenPosition2 = cCFormatSupport.findImportant(cCFormatSupport.getNextPosition(formatTokenPosition3), null, true, false)) != null) {
                this.insertNewLineBeforeToken(formatTokenPosition2.getToken(), cCFormatSupport);
            }
            if ((formatTokenPosition = cCFormatSupport.getPreviousPosition(formatTokenPosition2 = cCFormatSupport.findLineStart(formatTokenPosition3))) == null || formatTokenPosition.getToken().getTokenID() != CCTokenContext.WHITESPACE) {
                return;
            }
            formatTokenPosition2 = cCFormatSupport.findLineStart(formatTokenPosition);
            if ((formatTokenPosition2 = cCFormatSupport.findImportant(formatTokenPosition3, formatTokenPosition2, false, true)) == null) {
                return;
            }
            formatTokenPosition2 = cCFormatSupport.findNonWhitespace(formatTokenPosition, null, true, true);
            if (formatTokenPosition2.getToken().getTokenID() == CCTokenContext.LINE_COMMENT || formatTokenPosition2.getToken().getTokenID() == CCTokenContext.LBRACE || cCFormatSupport.isPreprocessorLine(formatTokenPosition2.getToken())) {
                return;
            }
            boolean bl2 = true;
            while (bl2) {
                if (tokenItem.getPrevious() == formatTokenPosition.getToken()) {
                    bl2 = false;
                }
                if (cCFormatSupport.canRemoveToken(tokenItem.getPrevious())) {
                    cCFormatSupport.removeToken(tokenItem.getPrevious());
                    continue;
                }
                return;
            }
            if (cCFormatSupport.canInsertToken(tokenItem)) {
                cCFormatSupport.insertSpaces(tokenItem, 1);
            }
        }

        private void insertNewLineBeforeToken(TokenItem tokenItem, CCFormatSupport cCFormatSupport) {
            FormatTokenPosition formatTokenPosition = cCFormatSupport.getPosition(tokenItem, 0);
            FormatTokenPosition formatTokenPosition2 = cCFormatSupport.findImportant(formatTokenPosition, null, true, true);
            if (formatTokenPosition2 != null && formatTokenPosition2.getToken().getTokenContextPath() == cCFormatSupport.getTokenContextPath() && cCFormatSupport.canInsertToken(tokenItem)) {
                cCFormatSupport.insertToken(tokenItem, cCFormatSupport.getValidWhitespaceTokenID(), cCFormatSupport.getValidWhitespaceTokenContextPath(), "\n");
                cCFormatSupport.removeLineEndWhitespace(formatTokenPosition2);
                cCFormatSupport.indentLine(formatTokenPosition, false);
            }
        }

        protected void formatLine(CCFormatSupport cCFormatSupport, FormatTokenPosition formatTokenPosition) {
            if (formatTokenPosition.getToken().getTokenID() == CCTokenContext.WHITESPACE && formatTokenPosition.getToken().getImage().indexOf(10) == 0) {
                return;
            }
            TokenItem tokenItem = cCFormatSupport.findLineStart(formatTokenPosition).getToken();
            if (cCFormatSupport.isPreprocessorLine(tokenItem)) {
                return;
            }
            boolean bl = true;
            while (tokenItem != null) {
                if (!bl && tokenItem.getTokenID() == CCTokenContext.WHITESPACE && tokenItem.getImage().indexOf(10) >= 0) {
                    return;
                }
                bl = false;
                if (tokenItem.getTokenContextPath() == cCFormatSupport.getTokenContextPath()) {
                    switch (tokenItem.getTokenID().getNumericID()) {
                        case 64: {
                            tokenItem = this.processBrace(cCFormatSupport, tokenItem);
                            break;
                        }
                        case 60: {
                            TokenItem tokenItem2;
                            TokenItem tokenItem3;
                            if (cCFormatSupport.getFormatSpaceBeforeMethodCallParenthesis()) {
                                tokenItem3 = tokenItem.getPrevious();
                                if (tokenItem3 == null || tokenItem3.getTokenID() != CCTokenContext.IDENTIFIER || !cCFormatSupport.canInsertToken(tokenItem)) break;
                                cCFormatSupport.insertToken(tokenItem, cCFormatSupport.getWhitespaceTokenID(), cCFormatSupport.getWhitespaceTokenContextPath(), " ");
                                break;
                            }
                            tokenItem3 = tokenItem.getPrevious();
                            if (tokenItem3 == null || tokenItem3.getTokenID() != CCTokenContext.WHITESPACE || tokenItem3.getImage().length() != 1 || (tokenItem2 = tokenItem3.getPrevious()) == null || tokenItem2.getTokenID() != CCTokenContext.IDENTIFIER || !cCFormatSupport.canRemoveToken(tokenItem3)) break;
                            cCFormatSupport.removeToken(tokenItem3);
                            break;
                        }
                        case 55: {
                            TokenItem tokenItem3 = tokenItem.getNext();
                            if (tokenItem3 == null) break;
                            if (cCFormatSupport.getFormatSpaceAfterComma()) {
                                if (tokenItem3.getTokenID() == CCTokenContext.WHITESPACE) break;
                                cCFormatSupport.insertToken(tokenItem3, cCFormatSupport.getValidWhitespaceTokenID(), cCFormatSupport.getWhitespaceTokenContextPath(), " ");
                                break;
                            }
                            if (tokenItem3.getTokenID() != CCTokenContext.WHITESPACE) break;
                            cCFormatSupport.removeToken(tokenItem3);
                        }
                    }
                }
                tokenItem = tokenItem.getNext();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private TokenItem processBrace(CCFormatSupport cCFormatSupport, TokenItem tokenItem) {
            FormatTokenPosition formatTokenPosition;
            FormatTokenPosition formatTokenPosition2;
            if (cCFormatSupport.isIndentOnly()) {
                return tokenItem;
            }
            if (!cCFormatSupport.getFormatNewlineBeforeBrace()) {
                if (!cCFormatSupport.getFormatNewlineBeforeBraceDeclaration()) return this.removeNewLine(tokenItem, cCFormatSupport);
            }
            if ((formatTokenPosition2 = cCFormatSupport.findImportant(formatTokenPosition = cCFormatSupport.getPosition(tokenItem, 0), null, true, true)) != null && formatTokenPosition2.getToken().getTokenContextPath() == cCFormatSupport.getTokenContextPath()) {
                switch (formatTokenPosition2.getToken().getTokenID().getNumericID()) {
                    case 8: 
                    case 9: {
                        return tokenItem;
                    }
                    case 63: {
                        return tokenItem;
                    }
                    case 22: 
                    case 55: 
                    case 64: {
                        return tokenItem;
                    }
                    default: {
                        FormatTokenPosition formatTokenPosition3 = cCFormatSupport.findImportant(formatTokenPosition, null, true, false);
                        if (formatTokenPosition3 != null && formatTokenPosition3.getToken() != null) {
                            if (formatTokenPosition3.getToken().getTokenID() == CCTokenContext.RBRACE) return tokenItem;
                        }
                        if (!this.isAddNewLine(cCFormatSupport, tokenItem)) return this.removeNewLine(tokenItem, cCFormatSupport);
                        if (!cCFormatSupport.canInsertToken(tokenItem)) return tokenItem;
                        cCFormatSupport.insertToken(tokenItem, cCFormatSupport.getValidWhitespaceTokenID(), cCFormatSupport.getValidWhitespaceTokenContextPath(), "\n");
                        cCFormatSupport.removeLineEndWhitespace(formatTokenPosition2);
                        cCFormatSupport.indentLine(formatTokenPosition, false);
                        return formatTokenPosition2.getToken();
                    }
                }
            } else {
                if (this.isAddNewLine(cCFormatSupport, tokenItem)) return tokenItem;
                return this.removeNewLine(tokenItem, cCFormatSupport);
            }
        }

        private boolean isAddNewLine(CCFormatSupport cCFormatSupport, TokenItem tokenItem) {
            TokenItem tokenItem2;
            TokenItem tokenItem3 = cCFormatSupport.findImportantToken(tokenItem, null, true, true);
            if (tokenItem3 == null) {
                return true;
            }
            switch (tokenItem3.getTokenID().getNumericID()) {
                case 102: 
                case 103: 
                case 126: {
                    return cCFormatSupport.getFormatNewlineBeforeBrace();
                }
                case 58: {
                    return true;
                }
            }
            if (tokenItem3.getTokenID().getNumericID() == 61 && (tokenItem2 = cCFormatSupport.findStatementStart(tokenItem3, false)) != null) {
                switch (tokenItem2.getTokenID().getNumericID()) {
                    case 96: 
                    case 107: 
                    case 110: 
                    case 130: {
                        return cCFormatSupport.getFormatNewlineBeforeBrace();
                    }
                    case 121: {
                        return cCFormatSupport.getFormatNewlineBeforeBraceSwitch();
                    }
                }
            }
            return cCFormatSupport.getFormatNewlineBeforeBraceDeclaration();
        }

        private TokenItem removeNewLine(TokenItem tokenItem, CCFormatSupport cCFormatSupport) {
            FormatTokenPosition formatTokenPosition = cCFormatSupport.getPosition(tokenItem, 0);
            if (cCFormatSupport.findNonWhitespace(formatTokenPosition, null, true, true) != null) {
                return tokenItem;
            }
            if (cCFormatSupport.getNextPosition(formatTokenPosition) != null && cCFormatSupport.findImportant(cCFormatSupport.getNextPosition(formatTokenPosition), null, true, false) != null) {
                return tokenItem;
            }
            FormatTokenPosition formatTokenPosition2 = cCFormatSupport.findLineStart(formatTokenPosition);
            FormatTokenPosition formatTokenPosition3 = cCFormatSupport.getPreviousPosition(formatTokenPosition2);
            if (formatTokenPosition3 == null || formatTokenPosition3.getToken().getTokenID() != CCTokenContext.WHITESPACE) {
                return tokenItem;
            }
            formatTokenPosition2 = cCFormatSupport.findLineStart(formatTokenPosition3);
            if ((formatTokenPosition2 = cCFormatSupport.findImportant(formatTokenPosition, formatTokenPosition2, false, true)) == null) {
                return tokenItem;
            }
            formatTokenPosition2 = cCFormatSupport.findNonWhitespace(formatTokenPosition3, null, true, true);
            if (formatTokenPosition2.getToken().getTokenID() == CCTokenContext.LINE_COMMENT || formatTokenPosition2.getToken().getTokenID() == CCTokenContext.LBRACE || cCFormatSupport.isPreprocessorLine(formatTokenPosition2.getToken())) {
                return tokenItem;
            }
            boolean bl = true;
            while (bl) {
                if (tokenItem.getPrevious() == formatTokenPosition3.getToken()) {
                    bl = false;
                }
                if (!cCFormatSupport.canRemoveToken(tokenItem.getPrevious())) break;
                cCFormatSupport.removeToken(tokenItem.getPrevious());
            }
            if (cCFormatSupport.canInsertToken(tokenItem)) {
                cCFormatSupport.insertSpaces(tokenItem, 1);
            }
            return tokenItem;
        }
    }

    public class StripEndWhitespaceLayer
    extends AbstractFormatLayer {
        private CodeStyle.Language language;

        public StripEndWhitespaceLayer(CodeStyle.Language language) {
            super("cc-strip-whitespace-at-line-end");
            this.language = language;
        }

        protected FormatSupport createFormatSupport(FormatWriter formatWriter) {
            return new CCFormatSupport(formatWriter);
        }

        public void format(FormatWriter formatWriter) {
            CCFormatSupport cCFormatSupport = (CCFormatSupport)this.createFormatSupport(formatWriter);
            FormatTokenPosition formatTokenPosition = cCFormatSupport.getFormatStartPosition();
            if (!cCFormatSupport.isIndentOnly()) {
                while (formatTokenPosition.getToken() != null) {
                    if ((formatTokenPosition = cCFormatSupport.removeLineEndWhitespace(formatTokenPosition)).getToken() == null) continue;
                    formatTokenPosition = cCFormatSupport.getNextPosition(formatTokenPosition);
                }
            }
        }
    }
}

