/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import java.util.Arrays;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.jpa.verification.JPAClassRule;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.fixes.ImplementSerializable;
import org.netbeans.modules.j2ee.jpa.verification.rules.entity.IdDefinedInHierarchy;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbBundle;

public class SerializableClass
extends JPAClassRule {
    public SerializableClass() {
        this.setClassContraints(Arrays.asList(JPAClassRule.ClassConstraints.ENTITY, JPAClassRule.ClassConstraints.EMBEDDABLE, JPAClassRule.ClassConstraints.IDCLASS));
    }

    public ErrorDescription[] apply(TypeElement typeElement, ProblemContext problemContext) {
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            if (!"java.io.Serializable".equals(((Object)typeMirror).toString())) continue;
            return null;
        }
        ImplementSerializable implementSerializable = new ImplementSerializable(problemContext.getFileObject(), (ElementHandle<TypeElement>)ElementHandle.create((Element)typeElement));
        return new ErrorDescription[]{SerializableClass.createProblem((Element)typeElement, problemContext, NbBundle.getMessage(IdDefinedInHierarchy.class, (String)"MSG_NonSerializableClass"), Severity.WARNING, implementSerializable)};
    }
}

