/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.core.api.support.java;

import org.netbeans.api.java.classpath.ClassPath;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public final class JavaIdentifiers {
    private JavaIdentifiers() {
    }

    public static boolean isValidPackageName(String string) {
        Parameters.notNull((CharSequence)"packageName", (Object)string);
        if ("".equals(string)) {
            return true;
        }
        if (string.startsWith(".") || string.endsWith(".")) {
            return false;
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 0) {
            return Utilities.isJavaIdentifier((String)string);
        }
        for (String string2 : stringArray) {
            if (Utilities.isJavaIdentifier((String)string2)) continue;
            return false;
        }
        return true;
    }

    public static String getQualifiedName(FileObject fileObject) {
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath != null) {
            return classPath.getResourceName(fileObject, '.', false);
        }
        return null;
    }

    public static String unqualify(String string) {
        JavaIdentifiers.checkFQN(string);
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String getPackageName(String string) {
        JavaIdentifiers.checkFQN(string);
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return "";
        }
        return string.substring(0, n);
    }

    private static void checkFQN(String string) {
        Parameters.notEmpty((CharSequence)"fqn", (CharSequence)string);
        if (!JavaIdentifiers.isValidPackageName(string)) {
            throw new IllegalArgumentException("The given fqn [" + string + "] does not represent a fully qualified class name");
        }
    }
}

