/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.ui.form.valid;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValidStateManager
implements ValidStateManager {
    private static String NBSP = "&nbsp;";
    private static String HTML = "<html>";
    private HashMap<Validator, List<Validator.Reason>> myProblems = new HashMap();
    private List<ValidStateManager.ValidStateListener> myListeners = new ArrayList<ValidStateManager.ValidStateListener>();
    private List<Validator> validatorsToIgnor = new ArrayList<Validator>();

    @Override
    public void clearReasons() {
        boolean bl = !this.isValid();
        this.myProblems.clear();
        if (bl) {
            this.fireStateChanged();
        }
    }

    @Override
    public void processValidationResults(Validator validator) {
        List<Validator.Reason> list = validator.getReasons();
        if (this.isIgnorValidator(validator)) {
            return;
        }
        if (!validator.hasReasons(null)) {
            if (this.myProblems.containsKey(validator)) {
                this.myProblems.remove(validator);
                this.fireStateChanged();
            }
        } else {
            boolean bl = false;
            if (this.myProblems.containsKey(validator)) {
                List<Validator.Reason> list2 = this.myProblems.get(validator);
                if (!this.equals(list2, list)) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                this.myProblems.put(validator, new ArrayList<Validator.Reason>(list));
                this.fireStateChanged();
            }
        }
    }

    @Override
    public void ignoreValidator(Validator validator, boolean bl) {
        if (validator == null) {
            return;
        }
        if (bl) {
            if (!this.validatorsToIgnor.contains(validator)) {
                this.validatorsToIgnor.add(validator);
            }
        } else {
            this.validatorsToIgnor.remove(validator);
        }
    }

    @Override
    public boolean isIgnorValidator(Validator validator) {
        return this.validatorsToIgnor.contains(validator);
    }

    @Override
    public void removeValidStateListener(ValidStateManager.ValidStateListener validStateListener) {
        this.myListeners.remove(validStateListener);
    }

    @Override
    public void addValidStateListener(ValidStateManager.ValidStateListener validStateListener) {
        this.myListeners.add(validStateListener);
    }

    @Override
    public boolean isValid() {
        return this.myProblems.isEmpty();
    }

    @Override
    public Validator.Reason getFistReason(Validator.Severity severity) {
        for (List<Validator.Reason> list : this.myProblems.values()) {
            if (list == null || list.size() <= 0) continue;
            if (severity == null) {
                return list.get(0);
            }
            for (Validator.Reason reason : list) {
                if (reason.getSeverity() != severity) continue;
                return reason;
            }
        }
        return null;
    }

    @Override
    public List<Validator.Reason> getReasons(Validator.Severity severity) {
        ArrayList<Validator.Reason> arrayList = new ArrayList<Validator.Reason>();
        for (List<Validator.Reason> list : this.myProblems.values()) {
            if (list == null || list.size() <= 0) continue;
            if (severity == null) {
                arrayList.addAll(list);
                continue;
            }
            for (Validator.Reason reason : list) {
                if (reason.getSeverity() != severity) continue;
                arrayList.add(reason);
            }
        }
        return arrayList;
    }

    @Override
    public String getHtmlReasons() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(HTML);
        Validator.Reason reason = this.getFistReason(Validator.Severity.ERROR);
        if (reason == null) {
            reason = this.getFistReason(Validator.Severity.WARNING);
        }
        if (reason != null) {
            String string = reason.getText();
            if (string.startsWith(HTML)) {
                string = string.substring(HTML.length());
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private void fireStateChanged() {
        boolean bl = this.isValid();
        for (ValidStateManager.ValidStateListener validStateListener : this.myListeners) {
            validStateListener.stateChanged(this, bl);
        }
    }

    private boolean equals(List<Validator.Reason> list, List<Validator.Reason> list2) {
        if (list == null && list2 == null) {
            return true;
        }
        if (list == null && list2 != null) {
            return false;
        }
        if (list != null && list2 == null) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Validator.Reason reason = list.get(i);
            Validator.Reason reason2 = list2.get(i);
            if (!(reason != null ? !reason.equals(reason2) : reason2 != null && !reason2.equals(reason))) continue;
            return false;
        }
        return true;
    }

    public void validateChildrenControls(Container container, boolean bl) {
        DefaultValidStateManager.validateChildrenControls(this, container, bl);
    }

    public static void validateChildrenControls(ValidStateManager validStateManager, Container container, boolean bl) {
        for (Component component : container.getComponents()) {
            Validator validator = null;
            if (component instanceof Validator) {
                validator = (Validator)((Object)component);
            } else if (component instanceof Validator.Provider) {
                validator = ((Validator.Provider)((Object)component)).getValidator();
            }
            if (validator != null && !validStateManager.isIgnorValidator(validator)) {
                validator.clearReasons();
                validator.doValidation(bl);
                validStateManager.processValidationResults(validator);
            }
            if (!(component instanceof Container)) continue;
            DefaultValidStateManager.validateChildrenControls(validStateManager, (Container)component, bl);
        }
    }

    public static ValidStateManager findVSM(Component component, boolean bl) {
        while (component != null) {
            if (component instanceof ValidStateManager.Provider) {
                return ((ValidStateManager.Provider)((Object)component)).getValidStateManager(bl);
            }
            component = component.getParent();
        }
        return null;
    }

    public static class DefaultVsmProvider
    implements ValidStateManager.Provider {
        private Component myComponent;

        public DefaultVsmProvider(Component component) {
            this.myComponent = component;
        }

        public ValidStateManager getValidStateManager(boolean bl) {
            return DefaultValidStateManager.findVSM(this.myComponent, bl);
        }
    }
}

