/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.ui.util;

import org.netbeans.modules.soa.ui.util.Duration;
import org.netbeans.modules.soa.ui.util.UI;

public final class DurationUtil {
    private static final int NINE = 9;
    private static final String EMPTY = "";
    private static final String ZERO = "0";
    private static final String MINUS = "-";
    private static final String COLON = ":";
    private static final String QUOTE = "'";
    private static final String D_DELIM = "D";
    private static final String H_DELIM = "H";
    private static final String M_DELIM = "M";
    private static final String P_DELIM = "P";
    private static final String S_DELIM = "S";
    private static final String Y_DELIM = "Y";
    public static final String T_DELIM = "T";

    private DurationUtil() {
    }

    public static Duration parseDuration(String string, boolean bl) {
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        if (string == null || string.length() == 0) {
            return DurationUtil.throwException("FIX_Empty_Value", bl, bl2, n, n2, n3, n4, n5, d);
        }
        if (!string.startsWith(QUOTE) && !string.endsWith(QUOTE)) {
            return new Duration(bl2, n, n2, n3, n4, n5, d);
        }
        if (string.length() == 1 && string.startsWith(QUOTE)) {
            return DurationUtil.throwException("FIX_Invalid_Value", string, bl, bl2, n, n2, n3, n4, n5, d);
        }
        if (string.startsWith(QUOTE) && !string.endsWith(QUOTE)) {
            return DurationUtil.throwException("FIX_Invalid_Value", string, bl, bl2, n, n2, n3, n4, n5, d);
        }
        if (!string.startsWith(QUOTE) && string.endsWith(QUOTE)) {
            return DurationUtil.throwException("FIX_Invalid_Value", string, bl, bl2, n, n2, n3, n4, n5, d);
        }
        if ((string = DurationUtil.removeQuotes(string)).length() == 0) {
            return DurationUtil.throwException("FIX_Empty_Value", bl, bl2, n, n2, n3, n4, n5, d);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if (string.charAt(0) == MINUS.charAt(0)) {
            bl2 = true;
            string = string.substring(1);
        }
        if (string.charAt(0) != P_DELIM.charAt(0)) {
            return DurationUtil.throwException("FIX_P_symbol", bl, bl2, n, n2, n3, n4, n5, d);
        }
        int n6 = (string = string.substring(1)).indexOf(Y_DELIM);
        if (n6 != -1) {
            bl3 = true;
            n = DurationUtil.parseInt(string.substring(0, n6));
            if (n < 0) {
                return DurationUtil.throwException("FIX_Year", bl, bl2, n, n2, n3, n4, n5, d);
            }
            string = string.substring(n6 + 1);
        }
        n6 = string.indexOf(M_DELIM);
        int n7 = string.indexOf(T_DELIM);
        if (n6 != -1) {
            n2 = DurationUtil.parseInt(string.substring(0, n6));
            if (n2 < 0) {
                if (n7 == -1 || n6 < n7) {
                    return DurationUtil.throwException("FIX_Months", bl, bl2, n, n2, n3, n4, n5, d);
                }
                n2 = 0;
            } else {
                bl3 = true;
                string = string.substring(n6 + 1);
            }
        }
        if ((n6 = string.indexOf(D_DELIM)) != -1) {
            bl3 = true;
            n3 = DurationUtil.parseInt(string.substring(0, n6));
            if (n3 < 0) {
                return DurationUtil.throwException("FIX_Days", bl, bl2, n, n2, n3, n4, n5, d);
            }
            string = string.substring(n6 + 1);
        }
        if (string.length() == 0) {
            if (!bl3) {
                return DurationUtil.throwException("FIX_Designator", bl, bl2, n, n2, n3, n4, n5, d);
            }
            return new Duration(bl2, n, n2, n3, n4, n5, d);
        }
        if (string.charAt(0) != T_DELIM.charAt(0)) {
            return DurationUtil.throwException("FIX_T_symbol", bl, bl2, n, n2, n3, n4, n5, d);
        }
        n6 = (string = string.substring(1)).indexOf(H_DELIM);
        if (n6 != -1) {
            bl3 = true;
            bl4 = true;
            n4 = DurationUtil.parseInt(string.substring(0, n6));
            if (n4 < 0) {
                return DurationUtil.throwException("FIX_Hours", bl, bl2, n, n2, n3, n4, n5, d);
            }
            string = string.substring(n6 + 1);
        }
        if ((n6 = string.indexOf(M_DELIM)) != -1) {
            bl3 = true;
            bl4 = true;
            n5 = DurationUtil.parseInt(string.substring(0, n6));
            if (n5 < 0) {
                return DurationUtil.throwException("FIX_Minutes", bl, bl2, n, n2, n3, n4, n5, d);
            }
            string = string.substring(n6 + 1);
        }
        if ((n6 = string.indexOf(S_DELIM)) != -1) {
            bl3 = true;
            bl4 = true;
            d = DurationUtil.parseDouble(string.substring(0, n6));
            if (d < 0.0) {
                return DurationUtil.throwException("FIX_Seconds", bl, bl2, n, n2, n3, n4, n5, d);
            }
            string = string.substring(n6 + 1);
        }
        if (!bl4) {
            return DurationUtil.throwException("FIX_Absent_T_symbol", bl, bl2, n, n2, n3, n4, n5, d);
        }
        if (!bl3) {
            return DurationUtil.throwException("FIX_Designator", bl, bl2, n, n2, n3, n4, n5, d);
        }
        return new Duration(bl2, n, n2, n3, n4, n5, d);
    }

    private static Duration throwException(String string, boolean bl, boolean bl2, int n, int n2, int n3, int n4, int n5, double d) {
        return DurationUtil.throwExceptionMsg(UI.i18n(DurationUtil.class, string), bl, bl2, n, n2, n3, n4, n5, d);
    }

    private static Duration throwException(String string, String string2, boolean bl, boolean bl2, int n, int n2, int n3, int n4, int n5, double d) {
        return DurationUtil.throwExceptionMsg(UI.i18n(DurationUtil.class, string, string2), bl, bl2, n, n2, n3, n4, n5, d);
    }

    private static Duration throwExceptionMsg(String string, boolean bl, boolean bl2, int n, int n2, int n3, int n4, int n5, double d) {
        if (bl) {
            throw new IllegalArgumentException(string);
        }
        return new Duration(bl2, n, n2, n3, n4, n5, d);
    }

    public static String addQuotes(String string) {
        return QUOTE + string + QUOTE;
    }

    public static String removeQuotes(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith(QUOTE)) {
            string = string.substring(1);
        }
        if (string.endsWith(QUOTE)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String getContent(boolean bl, int n, int n2, int n3, int n4, int n5, double d) {
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(P_DELIM);
            stringBuffer.append(DurationUtil.getStr(n));
            stringBuffer.append(Y_DELIM);
            stringBuffer.append(DurationUtil.getStr(n2));
            stringBuffer.append(M_DELIM);
            stringBuffer.append(DurationUtil.getStr(n3));
            stringBuffer.append(D_DELIM);
            stringBuffer.append(T_DELIM);
            stringBuffer.append(DurationUtil.getStr(n4));
            stringBuffer.append(H_DELIM);
            stringBuffer.append(DurationUtil.getStr(n5));
            stringBuffer.append(M_DELIM);
            stringBuffer.append(DurationUtil.getStr(d));
            stringBuffer.append(S_DELIM);
            return stringBuffer.toString();
        }
        return DurationUtil.getParseUntil(DurationUtil.getString(n), DurationUtil.getString(n2), DurationUtil.getString(n3), DurationUtil.getString(n4), DurationUtil.getString(n5), DurationUtil.getStr(d));
    }

    public static String getParseUntil(String string, String string2, String string3, String string4, String string5, String string6) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(MINUS);
        stringBuffer.append(string2);
        stringBuffer.append(MINUS);
        stringBuffer.append(string3);
        stringBuffer.append(T_DELIM);
        stringBuffer.append(string4);
        stringBuffer.append(COLON);
        stringBuffer.append(string5);
        stringBuffer.append(COLON);
        stringBuffer.append(string6);
        return stringBuffer.toString();
    }

    public static int parseInt(String string) {
        return UI.getInt(string);
    }

    public static double parseDouble(String string) {
        return UI.getDouble(string);
    }

    private static String getString(int n) {
        if (0 <= n && n <= 9) {
            return ZERO + n;
        }
        return DurationUtil.getStr(n);
    }

    private static String getStr(int n) {
        return EMPTY + n;
    }

    private static String getStr(double d) {
        return EMPTY + d;
    }
}

