/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.nbprefuse;

import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import prefuse.Visualization;
import prefuse.controls.FocusControl;
import prefuse.data.Tuple;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ui.UILib;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class NbFocusControl
extends FocusControl {
    private String group = Visualization.FOCUS_ITEMS;
    protected SelectionMode selectionMode = SelectionMode.MULTIPLE;

    public NbFocusControl() {
    }

    public NbFocusControl(String string) {
        super(string);
    }

    public NbFocusControl(int n) {
        super(n);
    }

    public NbFocusControl(String string, int n) {
        super(string, n);
    }

    public NbFocusControl(int n, String string) {
        super(n, string);
    }

    public NbFocusControl(String string, int n, String string2) {
        super(string, n, string2);
    }

    public void itemClicked(VisualItem visualItem, MouseEvent mouseEvent) {
        if (UILib.isButtonPressed((InputEvent)mouseEvent, (int)this.button) && mouseEvent.getClickCount() == this.ccount) {
            Visualization visualization = visualItem.getVisualization();
            TupleSet tupleSet = visualization.getFocusGroup(this.group);
            boolean bl = mouseEvent.isControlDown();
            if (!bl) {
                this.curFocus = visualItem;
                tupleSet.setTuple((Tuple)visualItem);
            } else if (tupleSet.containsTuple((Tuple)visualItem)) {
                tupleSet.removeTuple((Tuple)visualItem);
                if (visualItem instanceof NodeItem && visualItem.canSetBoolean("mouseover")) {
                    visualItem.setBoolean("mouseover", false);
                }
            } else if (this.selectionMode == SelectionMode.MULTIPLE) {
                tupleSet.addTuple((Tuple)visualItem);
            } else {
                this.curFocus = visualItem;
                tupleSet.setTuple((Tuple)visualItem);
            }
            this.runActivity(visualization);
        }
    }

    protected void runActivity(Visualization visualization) {
        if (this.activity != null) {
            visualization.run(this.activity);
        }
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        this.selectionMode = selectionMode;
    }

    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SelectionMode {
        SINGLE,
        MULTIPLE;

    }
}

