/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

final class FeedbackSurvey {
    private static final Logger LOG = Logger.getLogger(FeedbackSurvey.class.getName());

    private FeedbackSurvey() {
    }

    public static void start() {
        Object object;
        Object object2;
        Preferences preferences = NbPreferences.root().node("/org/netbeans/modules/autoupdate");
        String string = preferences.get("ideIdentity", "unknown");
        long l = -1L;
        try {
            object2 = ManagementFactory.getOperatingSystemMXBean();
            object = object2.getClass().getMethod("getTotalPhysicalMemorySize", new Class[0]);
            ((Method)object).setAccessible(true);
            l = (Long)((Method)object).invoke(object2, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            Exceptions.printStackTrace((Throwable)illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Exceptions.printStackTrace((Throwable)illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Exceptions.printStackTrace((Throwable)noSuchMethodException);
        }
        catch (SecurityException securityException) {
            Exceptions.printStackTrace((Throwable)securityException);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Exceptions.printStackTrace((Throwable)noSuchMethodError);
        }
        object2 = NbBundle.getMessage(FeedbackSurvey.class, (String)"MSG_FeedbackSurvey_URL", (Object)string, (Object)l);
        if (((String)object2).length() == 0) {
            return;
        }
        try {
            int n;
            object = NbPreferences.forModule(FeedbackSurvey.class);
            long l2 = ((Preferences)object).getLong("feedback.survey.show.at", 0L);
            if (l2 == 0L) {
                l2 = System.currentTimeMillis() + FeedbackSurvey.bundledInt("MSG_FeedbackSurvey_Delay");
                ((Preferences)object).putLong("feedback.survey.show.at", l2);
            }
            if ((long)(n = ((Preferences)object).getInt("feedback.survey.startups", 0)) < FeedbackSurvey.bundledInt("MSG_FeedbackSurvey_MinimalStartups")) {
                ((Preferences)object).putInt("feedback.survey.startups", n + 1);
                return;
            }
            if (System.currentTimeMillis() < l2) {
                LOG.log(Level.FINE, "Not enough time passed");
                return;
            }
            int n2 = ((Preferences)object).getInt("feedback.survey.show.count", 0);
            if ((long)n2 >= FeedbackSurvey.bundledInt("MSG_FeedbackSurvey_AskTimes")) {
                return;
            }
            URL uRL = new URL((String)object2);
            URLConnection uRLConnection = uRL.openConnection();
            String string2 = uRLConnection.getContentType();
            if (string2 == null || !string2.startsWith("text/html")) {
                LOG.log(Level.INFO, "Wrong mimetype - {0} - skipping survey", uRLConnection.getContentType());
                return;
            }
            ((Preferences)object).putInt("feedback.survey.show.count", n2 + 1);
            if (FeedbackSurvey.showDialog(uRL)) {
                ((Preferences)object).putLong("feedback.survey.show.at", Long.MAX_VALUE);
            } else {
                ((Preferences)object).putLong("feedback.survey.show.at", System.currentTimeMillis() + FeedbackSurvey.bundledInt("MSG_FeedbackSurveyAgain"));
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Cannot connect to {0}, skipping feedback survey", object2);
            LOG.log(Level.FINE, iOException.getMessage(), iOException);
        }
    }

    private static long bundledInt(String string) {
        return Long.parseLong(NbBundle.getMessage(FeedbackSurvey.class, (String)string));
    }

    private static boolean showDialog(URL uRL) {
        String string = NbBundle.getMessage(FeedbackSurvey.class, (String)"MSG_FeedbackSurvey_Message");
        String string2 = NbBundle.getMessage(FeedbackSurvey.class, (String)"MSG_FeedbackSurvey_Title");
        String string3 = NbBundle.getMessage(FeedbackSurvey.class, (String)"MSG_FeedbackSurvey_Yes");
        String string4 = NbBundle.getMessage(FeedbackSurvey.class, (String)"MSG_FeedbackSurvey_Later");
        String string5 = NbBundle.getMessage(FeedbackSurvey.class, (String)"MSG_FeedbackSurvey_Never");
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 3);
        message.setTitle(string2);
        JButton jButton = new JButton();
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FeedbackSurvey.class, (String)"ACSD_FeedbackSurvey_Yes"));
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)string3);
        JButton jButton2 = new JButton();
        jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FeedbackSurvey.class, (String)"ACSD_FeedbackSurvey_Later"));
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)string4);
        JButton jButton3 = new JButton();
        jButton3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FeedbackSurvey.class, (String)"ACSD_FeedbackSurvey_Never"));
        Mnemonics.setLocalizedText((AbstractButton)jButton3, (String)string5);
        Object[] objectArray = new Object[]{jButton, jButton2, jButton3};
        message.setOptions(objectArray);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        if (object == jButton) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
            return true;
        }
        if (object == jButton3) {
            Preferences preferences = NbPreferences.forModule(FeedbackSurvey.class);
            preferences.putInt("feedback.survey.show.count", (int)FeedbackSurvey.bundledInt("MSG_FeedbackSurvey_AskTimes"));
        }
        return false;
    }
}

