/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.welcome.content.ActionButton;
import org.netbeans.modules.welcome.content.BundleSupport;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.Utils;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class GetStarted
extends JPanel
implements Constants {
    private int row;

    public GetStarted() {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.buildContent();
    }

    private void buildContent() {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("WelcomePage/GettingStartedLinks");
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        DataObject[] dataObjectArray = dataFolder.getChildren();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            if (dataObjectArray[i].getPrimaryFile().isFolder()) {
                String string = dataObjectArray[i].getNodeDelegate().getDisplayName();
                JLabel jLabel = new JLabel(string);
                jLabel.setFont(BUTTON_FONT);
                jLabel.setHorizontalAlignment(2);
                jLabel.setOpaque(true);
                jLabel.setBorder(HEADER_TEXT_BORDER);
                this.add((Component)jLabel, new GridBagConstraints(0, this.row++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
                DataFolder dataFolder2 = DataFolder.findFolder((FileObject)dataObjectArray[i].getPrimaryFile());
                DataObject[] dataObjectArray2 = dataFolder2.getChildren();
                for (int j = 0; j < dataObjectArray2.length; ++j) {
                    this.row = this.addLink(this.row, dataObjectArray2[j]);
                }
                continue;
            }
            this.row = this.addLink(this.row, dataObjectArray[i]);
        }
        this.add((Component)new JLabel(), new GridBagConstraints(0, this.row++, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    private int addLink(int n, DataObject dataObject) {
        OpenCookie openCookie = (OpenCookie)dataObject.getCookie(InstanceCookie.class);
        if (null != openCookie) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setOpaque(false);
            LinkAction linkAction = new LinkAction(dataObject);
            ActionButton actionButton = new ActionButton(linkAction, false, Utils.getUrlString(dataObject));
            jPanel.add((Component)actionButton, new GridBagConstraints(1, 0, 1, 3, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            actionButton.setFont(GET_STARTED_FONT);
            jPanel.add((Component)new JLabel(), new GridBagConstraints(2, 0, 1, 3, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            String string = (String)dataObject.getPrimaryFile().getAttribute("SystemFileSystem.localizingBundle");
            if (null != string) {
                ResourceBundle resourceBundle = NbBundle.getBundle((String)string);
                Object object = dataObject.getPrimaryFile().getAttribute("imageKey");
                if (null != object) {
                    String string2 = resourceBundle.getString(object.toString());
                    Image image = Utilities.loadImage((String)string2, (boolean)true);
                    JLabel jLabel = new JLabel(new ImageIcon(image));
                    jLabel.setVerticalAlignment(1);
                    jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 18), 0, 0));
                }
            }
            actionButton.getAccessibleContext().setAccessibleName(actionButton.getText());
            actionButton.getAccessibleContext().setAccessibleDescription(BundleSupport.getAccessibilityDescription("GettingStarted", actionButton.getText()));
            this.add((Component)jPanel, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 7, 0), 0, 0));
        }
        return n;
    }

    private static class LinkAction
    extends AbstractAction {
        private DataObject dob;

        public LinkAction(DataObject dataObject) {
            super(dataObject.getNodeDelegate().getDisplayName());
            this.dob = dataObject;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OpenCookie openCookie = (OpenCookie)this.dob.getCookie(OpenCookie.class);
            if (null != openCookie) {
                openCookie.open();
            }
        }
    }
}

