/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.refactoring.query.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import org.netbeans.modules.xml.nbprefuse.AnalysisViewer;
import org.netbeans.modules.xml.nbprefuse.EdgeFillColorAction;
import org.netbeans.modules.xml.nbprefuse.EdgeStrokeColorAction;
import org.netbeans.modules.xml.nbprefuse.NodeExpansionMouseControl;
import org.netbeans.modules.xml.nbprefuse.NodeFillColorAction;
import org.netbeans.modules.xml.nbprefuse.NodeStrokeColorAction;
import org.netbeans.modules.xml.nbprefuse.NodeTextColorAction;
import org.netbeans.modules.xml.nbprefuse.PopupMouseControl;
import org.netbeans.modules.xml.nbprefuse.View;
import org.netbeans.modules.xml.nbprefuse.layout.NbFruchtermanReingoldLayout;
import org.netbeans.modules.xml.nbprefuse.render.CompositionEdgeRenderer;
import org.netbeans.modules.xml.nbprefuse.render.FindUsagesRendererFactory;
import org.netbeans.modules.xml.nbprefuse.render.GeneralizationEdgeRenderer;
import org.netbeans.modules.xml.nbprefuse.render.NbLabelRenderer;
import org.netbeans.modules.xml.nbprefuse.render.ReferenceEdgeRenderer;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.refactoring.query.readers.QuerySubstitutionGroupsReader;
import org.netbeans.modules.xml.schema.refactoring.query.views.ActivatedNodesControlAdapter;
import org.netbeans.modules.xml.schema.refactoring.query.views.WhereUsedView;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.animate.ColorAnimator;
import prefuse.action.animate.QualityControlAnimator;
import prefuse.action.animate.VisibilityAnimator;
import prefuse.activity.Pacer;
import prefuse.activity.SlowInSlowOutPacer;
import prefuse.controls.Control;
import prefuse.controls.FocusControl;
import prefuse.controls.NeighborHighlightControl;
import prefuse.controls.PanControl;
import prefuse.controls.SubtreeDragControl;
import prefuse.controls.ToolTipControl;
import prefuse.controls.WheelZoomControl;
import prefuse.controls.ZoomControl;
import prefuse.data.Graph;
import prefuse.render.EdgeRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;

public class QuerySubstitutionGroupsView
implements View,
PropertyChangeListener {
    private SchemaModel model;
    private Display display = null;
    private JPanel displayPanel;
    private Graph graph;
    private boolean usePacer = false;
    private int resizeCounter = 0;

    public QuerySubstitutionGroupsView(SchemaModel schemaModel) {
        this.model = schemaModel;
        this.display = new Display();
    }

    public Object[] createModels() {
        this.usePacer = true;
        this.resizeCounter = 0;
        this.graph = null;
        QuerySubstitutionGroupsReader querySubstitutionGroupsReader = new QuerySubstitutionGroupsReader(this.model);
        this.graph = querySubstitutionGroupsReader.loadGraph();
        return new Object[]{this.graph};
    }

    public boolean showView(AnalysisViewer analysisViewer) {
        boolean bl = false;
        analysisViewer.setCurrentView((View)this);
        if (this.resizeCounter == 0) {
            ++this.resizeCounter;
        } else if (this.resizeCounter == 1 || this.resizeCounter == 2) {
            ++this.resizeCounter;
            return bl;
        }
        Visualization visualization = null;
        if (this.graph == null) {
            ErrorManager.getDefault().log(65536, NbBundle.getMessage(WhereUsedView.class, (String)"LBL_Graph_Not_Created_Error"));
            return bl;
        }
        try {
            this.display = new Display();
            this.display.setBackground(Color.WHITE);
            visualization = new Visualization();
            this.display.setVisualization(visualization);
            Dimension dimension = analysisViewer.getPanel().getBounds().getSize();
            Dimension dimension2 = this.display.getBounds().getSize();
            if (!dimension.equals(dimension2)) {
                this.display.setSize(dimension.width, dimension.height);
            }
            this.displayPanel = new JPanel(new BorderLayout());
            this.displayPanel.add((Component)this.display, "Center");
            analysisViewer.addDisplayPanel(this.displayPanel);
            this.display.addControlListener((Control)new SubtreeDragControl());
            this.display.addControlListener((Control)new PanControl());
            this.display.addControlListener((Control)new ZoomControl());
            this.display.addControlListener((Control)new WheelZoomControl());
            this.display.addControlListener((Control)new ToolTipControl("tooltip"));
            this.display.addControlListener((Control)new FocusControl());
            this.display.addControlListener((Control)new ActivatedNodesControlAdapter());
            this.display.addControlListener((Control)new NeighborHighlightControl("action-update"));
            this.display.addControlListener((Control)new PopupMouseControl());
            this.display.addControlListener((Control)new NodeExpansionMouseControl(visualization, "action-update"));
            visualization.addGraph("graph", this.graph);
            if (this.graph.getNodeCount() < 1) {
                return false;
            }
            visualization.setRendererFactory((RendererFactory)new FindUsagesRendererFactory(new NbLabelRenderer(), new NbLabelRenderer(), (Renderer)new GeneralizationEdgeRenderer(), (Renderer)new CompositionEdgeRenderer(), (Renderer)new ReferenceEdgeRenderer(), (Renderer)new EdgeRenderer()));
            ActionList actionList = new ActionList(visualization);
            actionList.add((Action)new NodeFillColorAction());
            actionList.add((Action)new NodeTextColorAction());
            actionList.add((Action)new NodeStrokeColorAction());
            actionList.add((Action)new EdgeStrokeColorAction());
            actionList.add((Action)new EdgeFillColorAction());
            actionList.add((Action)new RepaintAction());
            visualization.putAction("action-update", (Action)actionList);
            ActionList actionList2 = new ActionList();
            actionList2.add((Action)new NodeFillColorAction());
            actionList2.add((Action)new NodeTextColorAction());
            actionList2.add((Action)new NodeStrokeColorAction());
            actionList2.add((Action)new EdgeStrokeColorAction());
            actionList2.add((Action)new EdgeFillColorAction());
            visualization.putAction("action-draw", (Action)actionList2);
            ActionList actionList3 = new ActionList();
            actionList3.add((Action)new NbFruchtermanReingoldLayout("graph"));
            actionList3.add((Action)new RepaintAction());
            visualization.putAction("action-layout", (Action)actionList3);
            visualization.runAfter("action-draw", "action-layout");
            if (this.usePacer) {
                ActionList actionList4 = new ActionList(1500L, 20L);
                actionList4.setPacingFunction((Pacer)new SlowInSlowOutPacer());
                actionList4.add((Action)new QualityControlAnimator());
                actionList4.add((Action)new VisibilityAnimator());
                actionList4.add((Action)new ColorAnimator());
                actionList4.add((Action)new RepaintAction());
                visualization.putAction("action-animate", (Action)actionList4);
                visualization.alwaysRunAfter("action-layout", "action-animate");
            }
            visualization.run("action-draw");
            bl = true;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return bl;
    }

    public void usePacer(boolean bl) {
        this.usePacer = bl;
    }

    public boolean getMaximizeWidth() {
        return true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }
}

