/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.refactoring.ui;

import java.awt.Color;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.xml.nbprefuse.AnalysisConstants;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.visitor.FindUsageVisitor;
import org.netbeans.modules.xml.schema.model.visitor.Preview;
import org.netbeans.modules.xml.schema.refactoring.ui.NodeComparator;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import prefuse.data.Graph;
import prefuse.util.ColorLib;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueryUtilities {
    public static List<SourceGroup> getProjectSourceGroups(SchemaModel schemaModel, String string) {
        if (schemaModel == null || string == null) {
            return null;
        }
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        Project project = QueryUtilities.getProject((Model)schemaModel);
        if (project == null) {
            return null;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(string);
        for (String string2 : arrayList2) {
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups(string2);
            if (sourceGroupArray == null) continue;
            for (SourceGroup sourceGroup : sourceGroupArray) {
                arrayList.add(sourceGroup);
            }
        }
        return arrayList;
    }

    private static Project getProject(Model model) {
        if (model == null) {
            return null;
        }
        FileObject fileObject = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class);
        return FileOwnerQuery.getOwner((FileObject)fileObject);
    }

    public static Preview getUsagesPreview(Schema schema, NamedReferenceable namedReferenceable) {
        FindUsageVisitor findUsageVisitor = new FindUsageVisitor();
        return findUsageVisitor.findUsages(Collections.singletonList(schema), namedReferenceable);
    }

    public static AbstractNode createCategoryNode(AnalysisConstants.GlobalTypes globalTypes) {
        Children.SortedArray sortedArray = new Children.SortedArray();
        sortedArray.setComparator((Comparator)new NodeComparator());
        AbstractNode abstractNode = new AbstractNode((Children)sortedArray){
            Node node = null;

            private Node getDelegateNode() {
                if (this.node == null) {
                    try {
                        this.node = DataObject.find((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        // empty catch block
                    }
                }
                return this.node;
            }

            public Image getIcon(int n) {
                Node node = this.getDelegateNode();
                return node != null ? node.getIcon(n) : super.getIcon(n);
            }

            public Image getOpenedIcon(int n) {
                Node node = this.getDelegateNode();
                return node != null ? node.getOpenedIcon(n) : super.getOpenedIcon(n);
            }
        };
        String string = null;
        switch (globalTypes) {
            case COMPLEX_TYPE: {
                string = NbBundle.getMessage(QueryUtilities.class, (String)"LBL_GlobalComplexTypes");
                break;
            }
            case SIMPLE_TYPE: {
                string = NbBundle.getMessage(QueryUtilities.class, (String)"LBL_GlobalSimpleTypes");
                break;
            }
            case PRIMITIVE: {
                string = NbBundle.getMessage(QueryUtilities.class, (String)"LBL_Primitives");
                break;
            }
            case ELEMENT: {
                string = NbBundle.getMessage(QueryUtilities.class, (String)"LBL_GlobalElements");
                break;
            }
            case GROUP: {
                string = NbBundle.getMessage(QueryUtilities.class, (String)"LBL_GlobalGroups");
                break;
            }
            case ATTRIBUTE: {
                string = NbBundle.getMessage(QueryUtilities.class, (String)"LBL_GlobalAttributes");
                break;
            }
            case ATTRIBUTE_GROUP: {
                string = NbBundle.getMessage(QueryUtilities.class, (String)"LBL_GlobalAttributeGroups");
                break;
            }
            case BASE_COMPLEX_TYPES: {
                string = NbBundle.getMessage(QueryUtilities.class, (String)"LBL_Global_ComplexTypes_With_Derivations");
            }
        }
        abstractNode.setName(string);
        return abstractNode;
    }

    public static int[] getHSBPalette(int n, float f, float f2, AnalysisConstants.HSBHues[] hSBHuesArray) {
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            float f3 = 0.0f;
            boolean bl = false;
            block1: while (!bl) {
                f3 = (float)n2++ / (float)n;
                if (hSBHuesArray != null) {
                    for (AnalysisConstants.HSBHues hSBHues : hSBHuesArray) {
                        boolean bl2 = bl = !QueryUtilities.isInColorFamily(f3, hSBHues);
                        if (!bl) continue block1;
                    }
                    continue;
                }
                bl = true;
            }
            nArray[i] = ColorLib.hsb((float)f3, (float)f, (float)f2);
        }
        return nArray;
    }

    private static boolean isInColorFamily(float f, AnalysisConstants.HSBHues hSBHues) {
        if (hSBHues == null) {
            return false;
        }
        return f >= hSBHues.low() && f <= hSBHues.high();
    }

    public static void dumpGraph(Graph graph) {
    }

    public static String getTextForSchemaComponent(Component component) {
        SchemaComponent schemaComponent = null;
        if (component instanceof SchemaComponent) {
            schemaComponent = (SchemaComponent)SchemaComponent.class.cast(component);
        }
        if (schemaComponent == null) {
            return "";
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)((FileObject)schemaComponent.getModel().getModelSource().getLookup().lookup(FileObject.class)));
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
        }
        CloneableEditorSupport cloneableEditorSupport = (CloneableEditorSupport)dataObject.getCookie(EditorCookie.class);
        Line.Set set = cloneableEditorSupport.getLineSet();
        StyledDocument styledDocument = cloneableEditorSupport.getDocument();
        int n = schemaComponent.findPosition();
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
        Line line = set.getCurrent(n2);
        String string = line.getText().trim();
        Pattern pattern = Pattern.compile("<");
        Matcher matcher = pattern.matcher(string);
        string = matcher.replaceAll("&lt;");
        Pattern pattern2 = Pattern.compile(">");
        Matcher matcher2 = pattern2.matcher(string);
        string = matcher2.replaceAll("&gt;");
        return QueryUtilities.boldenRefOrType(string);
    }

    private static String boldenRefOrType(String string) {
        int n = string.indexOf(" type");
        if (n < 0) {
            n = string.indexOf(" ref");
        }
        if (n < 0) {
            return string;
        }
        int n2 = string.indexOf(34, n);
        if (n2 < n) {
            return string;
        }
        int n3 = string.indexOf(58, n2);
        int n4 = string.indexOf(34, n2 + 1);
        if (n4 < n2 || n3 > n4) {
            return string;
        }
        int n5 = -1;
        n5 = n3 > -1 ? n3 + 1 : n2 + 1;
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.insert(n5, "<b>");
        stringBuffer.insert(n4 + 3, "</b>");
        return stringBuffer.toString();
    }

    public static class ToolTipLine {
        private String text = "";
        private int fontSizePercentage = 100;
        private int rgbColor = Color.BLACK.getRGB();
        private HorizontalAlignment hAlign = HorizontalAlignment.CENTER;

        public ToolTipLine(String string, int n, int n2, HorizontalAlignment horizontalAlignment) {
            this.text = string;
            this.fontSizePercentage = n;
            this.rgbColor = n2;
            this.hAlign = horizontalAlignment;
        }

        public ToolTipLine(String string, int n) {
            this.text = string;
            this.rgbColor = n;
        }

        public ToolTipLine(String string) {
            this.text = string;
        }

        public String getHorizontalAlignmentAsString() {
            return this.hAlign.toString();
        }

        public String getText() {
            return " " + this.text + " ";
        }

        public String getFontSizePercentageAsString() {
            return String.valueOf(this.fontSizePercentage);
        }

        public String getColorAsRGBString() {
            Color color = new Color(this.rgbColor);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(");
            stringBuffer.append(String.valueOf(color.getRed()));
            stringBuffer.append(",");
            stringBuffer.append(String.valueOf(color.getGreen()));
            stringBuffer.append(",");
            stringBuffer.append(String.valueOf(color.getBlue()));
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum HorizontalAlignment {
            CENTER("center"),
            LEFT("left"),
            RIGHT("right");

            private final String name;

            private HorizontalAlignment(String string2) {
                this.name = string2;
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

