/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.webmvc;

import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.spring.spi.beans.SpringConfigFileLocationProvider;
import org.netbeans.modules.spring.spi.beans.SpringConfigFileProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebModuleProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebProjectSpringConfigFileProvider
implements SpringConfigFileProvider,
SpringConfigFileLocationProvider {
    private final Project project;

    public WebProjectSpringConfigFileProvider(Project project) {
        this.project = project;
    }

    public Set<File> getConfigFiles() {
        FileObject fileObject = this.getWebInf();
        if (fileObject == null) {
            return Collections.emptySet();
        }
        HashSet<File> hashSet = new HashSet<File>();
        WebProjectSpringConfigFileProvider.addFilesInWebInf(fileObject, hashSet);
        return Collections.unmodifiableSet(hashSet);
    }

    private static void addFilesInWebInf(FileObject fileObject, Set<File> set) {
        for (FileObject fileObject2 : NbCollections.iterable((Enumeration)fileObject.getChildren(true))) {
            File file;
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (!"text/x-springconfig+xml".equals(fileObject2.getMIMEType()) || (file = FileUtil.toFile((FileObject)fileObject2)) == null) continue;
            set.add(file);
        }
    }

    public FileObject getLocation() {
        return this.getWebInf();
    }

    private FileObject getWebInf() {
        WebModuleProvider webModuleProvider = (WebModuleProvider)this.project.getLookup().lookup(WebModuleProvider.class);
        if (webModuleProvider == null) {
            return null;
        }
        WebModule webModule = webModuleProvider.findWebModule(this.project.getProjectDirectory());
        if (webModule == null) {
            return null;
        }
        return webModule.getWebInf();
    }
}

