/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.webmvc.utils;

import java.util.regex.Pattern;

public class SpringWebFrameworkUtils {
    private static final String DISPATCHER_MAPPING = ".htm";
    private static final char[] INVALID_CHARS = new char[]{'<', '>', '*', '\\', ':', '\"', '/', '%', '|', '?'};

    public static boolean isDispatcherServletConfigFilenameValid(String string) {
        boolean bl = true;
        for (char c : INVALID_CHARS) {
            if (string.indexOf(c) == -1) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean isDispatcherMappingPatternValid(String string) {
        if (string.startsWith("*.")) {
            String string2 = string.substring(2);
            return Pattern.matches("\\w+", string2);
        }
        if (string.length() > 3 && string.endsWith("/*") && string.startsWith("/") && !string.contains(" ")) {
            return true;
        }
        return string.matches("/");
    }

    public static String replaceExtensionInTemplates(String string, String string2) {
        if (string.contains(DISPATCHER_MAPPING) && string2.contains("*.")) {
            int n = string.indexOf(DISPATCHER_MAPPING);
            int n2 = n + DISPATCHER_MAPPING.length();
            int n3 = string2.indexOf("*") + 1;
            assert (n != -1);
            assert (n2 != -1);
            assert (n3 != -1);
            string = string.substring(0, n) + string2.substring(n3) + string.substring(n2);
        }
        return string;
    }

    public static String reviseRedirectJsp(String string, String string2) {
        int n;
        if (string2.length() > 3 && string2.endsWith("/*") && string2.startsWith("/") && !string2.contains(" ") && (n = string.indexOf("index.htm")) > -1) {
            String string3 = string2.substring(1, string2.indexOf("*"));
            return string.substring(0, n) + string3 + string.substring(n);
        }
        return string;
    }
}

