/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core;

import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.netbeans.modules.uml.core.IApplication;
import org.netbeans.modules.uml.core.IQueryBuilder;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IVersionableElement;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.support.umlsupport.ProductRetriever;
import org.netbeans.modules.uml.core.support.umlsupport.XMLManip;
import org.netbeans.modules.uml.core.typemanagement.ITypeManager;

public class QueryBuilder
implements IQueryBuilder {
    private String m_SchemaLocation = "";
    private String m_ProjID = "";
    private String m_DefaultUpdaterProgId = "";
    private String m_ResultLocation = "";

    public void setSchemaLocation(String string) {
        this.m_SchemaLocation = string;
    }

    public String getSchemaLocation() {
        return this.m_SchemaLocation;
    }

    public Document generateResults(Node node) {
        Document document = null;
        if (node != null) {
            this.m_DefaultUpdaterProgId = "";
            this.verifyBuildEnvironment();
            Document document2 = this.loadSchema();
            if (document2 != null) {
                Document document3;
                int n;
                List list;
                Element element = document2.getRootElement();
                if (element != null) {
                    this.m_DefaultUpdaterProgId = XMLManip.getAttributeValue((Node)element, "defaultUpdater");
                }
                if ((list = document2.selectNodes("//Query")) != null && (n = list.size()) > 0 && (document3 = XMLManip.getDOMDocument()) != null) {
                    Element element2 = XMLManip.createElement(document3, "CachedQueries");
                    if (element2 != null) {
                        for (int i = 0; i < n; ++i) {
                            Node node2 = (Node)list.get(i);
                            this.processQuery(node, node2, element2);
                        }
                    }
                    document = document3;
                }
            }
        }
        return document;
    }

    private void processQuery(Node node, Node node2, Element element) {
        Node node3;
        int n;
        List list;
        QuerySchema querySchema = this.buildSchemaNode(node2);
        if (querySchema.validate() && (list = node.selectNodes(querySchema.m_MainQuery)) != null && (n = list.size()) > 0 && (node3 = querySchema.createResultContainer(element)) != null) {
            for (int i = 0; i < n; ++i) {
                Node node4 = (Node)list.get(i);
                Node node5 = querySchema.createResultNode(node3, node4);
            }
        }
    }

    private QuerySchema buildSchemaNode(Node node) {
        QuerySchema querySchema = new QuerySchema();
        querySchema.m_Project = this.getProject();
        querySchema.m_resultContainerName = XMLManip.getAttributeValue(node, "name");
        querySchema.m_MainQuery = XMLManip.getAttributeValue(node, "locate");
        querySchema.m_Updater = XMLManip.getAttributeValue(node, "updater");
        Node node2 = node.selectSingleNode("./QueryResult");
        if (node2 != null) {
            List list;
            String string = XMLManip.getAttributeValue(node2, "includeNodeType");
            querySchema.m_ResultNodeName = XMLManip.getAttributeValue(node2, "name");
            if (string != null && string.equals("true")) {
                querySchema.m_IncludeNodeName = true;
            }
            if ((list = node2.selectNodes("./ResultAttr")) != null) {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    Node node3 = (Node)list.get(i);
                    String string2 = XMLManip.getAttributeValue(node3, "name");
                    String string3 = XMLManip.getAttributeValue(node3, "query");
                    String string4 = XMLManip.getAttributeValue(node3, "isUnique");
                    String string5 = XMLManip.getAttributeValue(node3, "isProperty");
                    querySchema.m_ResultAttrs.add(new ResultAttr(string2, string3, string4, string5));
                }
            }
        }
        return querySchema;
    }

    private Document loadSchema() {
        Document document = null;
        if (this.m_SchemaLocation == null || (document = XMLManip.getDOMDocument(this.m_SchemaLocation)) == null) {
            // empty if block
        }
        return document;
    }

    private void verifyBuildEnvironment() {
        File file = new File(this.m_SchemaLocation);
        if (!file.exists()) {
            // empty if block
        }
    }

    public void setProjectId(String string) {
        this.m_ProjID = string;
    }

    public String getProjectId() {
        return this.m_ProjID;
    }

    public String getDefaultUpdaterProgId() {
        return this.m_DefaultUpdaterProgId;
    }

    private IProject getProject() {
        IApplication iApplication;
        IProject iProject = null;
        ICoreProduct iCoreProduct = ProductRetriever.retrieveProduct();
        if (iCoreProduct != null && (iApplication = iCoreProduct.getApplication()) != null) {
            iProject = iApplication.getProjectByID(this.m_ProjID);
        }
        return iProject;
    }

    private class QuerySchema {
        private String m_resultContainerName = "";
        private boolean m_IncludeNodeName = false;
        private String m_MainQuery = "";
        private String m_ResultNodeName = "";
        private String m_Updater = "";
        private Vector m_ResultAttrs = new Vector();
        private IProject m_Project = null;

        private QuerySchema() {
        }

        public boolean validate() {
            boolean bl = false;
            if (this.m_resultContainerName != null && this.m_resultContainerName.length() > 0 && this.m_ResultNodeName != null && this.m_ResultNodeName.length() > 0 && this.m_MainQuery != null && this.m_MainQuery.length() > 0) {
                bl = true;
            }
            return bl;
        }

        public Node createResultContainer(Element element) {
            Element element2 = null;
            element2 = XMLManip.createElement(element, this.m_resultContainerName);
            if (element2 != null) {
                XMLManip.setAttributeValue((Node)element2, "updater", this.m_Updater);
            }
            return element2;
        }

        private Node createResultNode(Node node, Node node2) {
            Element element = null;
            if (this.m_ResultAttrs != null && this.m_ResultAttrs.size() > 0) {
                if (node.getNodeType() == 1) {
                    element = XMLManip.createElement((Element)node, this.m_ResultNodeName);
                }
                if (element != null) {
                    if (this.m_IncludeNodeName) {
                        XMLManip.setAttributeValue((Node)element, "nodeType_", XMLManip.retrieveSimpleName(node2));
                    }
                    ITypeManager iTypeManager = null;
                    if (this.m_Project != null) {
                        iTypeManager = this.m_Project.getTypeManager();
                    }
                    int n = this.m_ResultAttrs.size();
                    for (int i = 0; i < n; ++i) {
                        Object object;
                        String string = "";
                        ResultAttr resultAttr = (ResultAttr)this.m_ResultAttrs.get(i);
                        if (iTypeManager != null && resultAttr.m_PropertyGet) {
                            IVersionableElement iVersionableElement;
                            object = XMLManip.getAttributeValue(node2, "xmi.id");
                            if (object != null && ((String)object).length() > 0 && (iVersionableElement = iTypeManager.getElementByID((String)object)) != null && iVersionableElement instanceof IElement) {
                                try {
                                    Object object2;
                                    Class<?> clazz = iVersionableElement.getClass();
                                    Method method = null;
                                    Method[] methodArray = clazz.getMethods();
                                    if (methodArray != null) {
                                        for (int j = 0; j < methodArray.length; ++j) {
                                            Method method2 = methodArray[j];
                                            if (!method2.getName().equals(resultAttr.m_Query)) continue;
                                            method = method2;
                                            break;
                                        }
                                    }
                                    if (method != null && (object2 = method.invoke((Object)iVersionableElement, (Object[])null)) != null && object2 instanceof String) {
                                        string = (String)object2;
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        } else {
                            object = node2.selectSingleNode(resultAttr.m_Query);
                            if (object != null && object.getNodeType() == 2) {
                                string = object.getStringValue();
                            }
                        }
                        if (string == null || string.length() <= 0) continue;
                        XMLManip.setAttributeValue((Node)element, resultAttr.m_AttrName, string);
                    }
                }
            }
            return element;
        }
    }

    private class ResultAttr {
        private String m_AttrName = "";
        private String m_Query = "";
        private boolean m_IsUnique = false;
        private boolean m_PropertyGet = false;

        public ResultAttr(String string, String string2, String string3, String string4) {
            this.m_AttrName = string;
            this.m_Query = string2;
            if (string3 != null && string3.equals("true")) {
                this.m_IsUnique = true;
            }
            if (string4 != null && string4.equals("true")) {
                this.m_PropertyGet = true;
            }
        }
    }
}

