/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.netbeans.modules.uml.core.IApplication;
import org.netbeans.modules.uml.core.IQueryBuilder;
import org.netbeans.modules.uml.core.IQueryManager;
import org.netbeans.modules.uml.core.IQueryUpdater;
import org.netbeans.modules.uml.core.QueryBuilder;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.coreapplication.ICoreProductEventDispatcher;
import org.netbeans.modules.uml.core.coreapplication.ICoreProductInitEventsSink;
import org.netbeans.modules.uml.core.eventframework.EventDispatchNameKeeper;
import org.netbeans.modules.uml.core.eventframework.EventDispatchRetriever;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IConfigManager;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElementChangeEventDispatcher;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IExternalElementEventsSink;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IVersionableElement;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.metamodel.structure.IProjectEventsSink;
import org.netbeans.modules.uml.core.metamodel.structure.IStructureEventDispatcher;
import org.netbeans.modules.uml.core.support.umlsupport.FileSysManip;
import org.netbeans.modules.uml.core.support.umlsupport.IResultCell;
import org.netbeans.modules.uml.core.support.umlsupport.IStrings;
import org.netbeans.modules.uml.core.support.umlsupport.ProductRetriever;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.core.support.umlsupport.XMLManip;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.typemanagement.ITypeManager;
import org.netbeans.modules.uml.core.workspacemanagement.IWorkspace;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryManager
implements IQueryManager,
ICoreProductInitEventsSink,
IExternalElementEventsSink,
IProjectEventsSink {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.uml.core");
    public static final String QUERY_CACHE = ".QueryCache";
    private boolean m_deInitialized = false;
    private String m_CacheDir = "";
    private Hashtable m_Updaters = new Hashtable();

    @Override
    public void initialize() {
        this.registerForCoreProductEvents();
        this.registerForExternalLoadEvents();
    }

    private void registerForExternalLoadEvents() {
        IElementChangeEventDispatcher iElementChangeEventDispatcher = (IElementChangeEventDispatcher)EventDispatchRetriever.instance().getDispatcher(EventDispatchNameKeeper.modifiedName());
        if (iElementChangeEventDispatcher != null) {
            iElementChangeEventDispatcher.registerForExternalElementEventsSink(this);
        }
    }

    private void registerForCoreProductEvents() {
        ICoreProductEventDispatcher iCoreProductEventDispatcher = (ICoreProductEventDispatcher)EventDispatchRetriever.instance().getDispatcher(EventDispatchNameKeeper.coreProduct());
        if (iCoreProductEventDispatcher != null) {
            iCoreProductEventDispatcher.registerForInitEvents(this);
        }
    }

    private void registerForStructureEvents() {
        IStructureEventDispatcher iStructureEventDispatcher = null;
        EventDispatchRetriever eventDispatchRetriever = EventDispatchRetriever.instance();
        Object t = eventDispatchRetriever.getDispatcher(EventDispatchNameKeeper.structure());
        if (t != null && t instanceof IStructureEventDispatcher) {
            iStructureEventDispatcher = (IStructureEventDispatcher)t;
        }
        if (iStructureEventDispatcher != null) {
            iStructureEventDispatcher.registerForProjectEvents(this);
        }
    }

    private void revokeStructureEvents() {
        IStructureEventDispatcher iStructureEventDispatcher = null;
        EventDispatchRetriever eventDispatchRetriever = EventDispatchRetriever.instance();
        Object t = eventDispatchRetriever.getDispatcher(EventDispatchNameKeeper.structure());
        if (t != null && t instanceof IStructureEventDispatcher) {
            iStructureEventDispatcher = (IStructureEventDispatcher)t;
        }
        if (iStructureEventDispatcher != null) {
            iStructureEventDispatcher.revokeProjectSink(this);
        }
    }

    private void revokeExternalLoadEvents() {
        IElementChangeEventDispatcher iElementChangeEventDispatcher = null;
        EventDispatchRetriever eventDispatchRetriever = EventDispatchRetriever.instance();
        Object t = eventDispatchRetriever.getDispatcher(EventDispatchNameKeeper.modifiedName());
        if (t != null && t instanceof IElementChangeEventDispatcher) {
            iElementChangeEventDispatcher = (IElementChangeEventDispatcher)t;
        }
        if (iElementChangeEventDispatcher != null) {
            iElementChangeEventDispatcher.revokeExternalElementEventsSink(this);
        }
    }

    private void revokeCoreProductEvents() {
        ICoreProductEventDispatcher iCoreProductEventDispatcher = null;
        EventDispatchRetriever eventDispatchRetriever = EventDispatchRetriever.instance();
        Object t = eventDispatchRetriever.getDispatcher(EventDispatchNameKeeper.coreProduct());
        if (t != null && t instanceof ICoreProductEventDispatcher) {
            iCoreProductEventDispatcher = (ICoreProductEventDispatcher)t;
        }
        if (iCoreProductEventDispatcher != null) {
            iCoreProductEventDispatcher.revokeInitSink(this);
        }
    }

    private IApplication getApplication() {
        IApplication iApplication = null;
        ICoreProduct iCoreProduct = ProductRetriever.retrieveProduct();
        if (iCoreProduct != null) {
            iApplication = iCoreProduct.getApplication();
        }
        return iApplication;
    }

    @Override
    public void deinitialize() {
        if (!this.m_deInitialized) {
            this.revokeCoreProductEvents();
            this.revokeExternalLoadEvents();
            this.m_deInitialized = true;
        }
    }

    @Override
    public ETList<IQueryUpdater> getUpdaters() {
        List list = null;
        if (this.m_Updaters != null) {
            Enumeration enumeration = this.m_Updaters.elements();
            while (enumeration.hasMoreElements()) {
                Object v = enumeration.nextElement();
                if (!(v instanceof ETList)) continue;
                ETArrayList eTArrayList = new ETArrayList((Collection)v);
                for (int i = 0; i < eTArrayList.size(); ++i) {
                    list.add(eTArrayList.get(i));
                }
            }
        }
        return list;
    }

    private void gatherUpdaters(IProject iProject, Document document) {
        List list;
        if (iProject == null || document == null) {
            return;
        }
        String string = iProject.getXMIID();
        Object v = this.m_Updaters.get(string);
        if (v != null) {
            this.deinitializeUpdaters(new ETArrayList<IQueryUpdater>((Collection)v));
            this.m_Updaters.remove(string);
        }
        if ((list = document.selectNodes("//@updater")) != null) {
            this.createUpdaters(iProject, document, list);
        }
    }

    private void deinitializeUpdaters(ETList<IQueryUpdater> eTList) {
        if (eTList != null) {
            int n = eTList.size();
            for (int i = 0; i < n; ++i) {
                IQueryUpdater iQueryUpdater = (IQueryUpdater)eTList.get(i);
                iQueryUpdater.deinitialize();
            }
        }
    }

    private void saveCRCs(IProject iProject) {
        Document document = this.openQueryCache(iProject);
        if (document != null) {
            String string = iProject.getFileName();
            this.setCRC(document, string);
            IStrings iStrings = this.getExternalFiles(iProject);
            if (iStrings != null) {
                int n = iStrings.getCount();
                for (int i = 0; i < n; ++i) {
                    String string2 = iStrings.item(i);
                    if (string2 == null || string2.length() <= 0) continue;
                    this.setCRC(document, string2);
                }
            }
            this.updateCache(iProject, document);
            this.saveCache(document, iProject);
        }
    }

    private void updateCache(IProject iProject, Document document) {
        if (iProject != null) {
            Object v;
            String string = iProject.getXMIID();
            if (this.m_Updaters != null && (v = this.m_Updaters.get(string)) != null) {
                ETArrayList eTArrayList = new ETArrayList((Collection)v);
                int n = eTArrayList.size();
                for (int i = 0; i < n; ++i) {
                    IQueryUpdater iQueryUpdater = (IQueryUpdater)eTArrayList.get(i);
                    iQueryUpdater.updateCache(document);
                    iQueryUpdater.deinitialize();
                }
            }
        }
    }

    private void setCRC(Document document, String string) {
        if (string != null && string.length() > 0) {
            Element element = this.getCRCValuesElement(document, string);
            String string2 = this.getCRCValuesOld(element);
            String string3 = this.getCRCValuesNew(string);
            if (element != null && (string2 != null ? !string2.equals(string3) : string3 != null)) {
                XMLManip.setAttributeValue(element, "crc", string3);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createUpdaters(IProject iProject, Document document, List list) {
        ETArrayList eTArrayList = null;
        if (list == null || list.size() <= 0) {
            String string;
            Element element;
            if (document != null && (element = document.getRootElement()) != null && (string = XMLManip.getAttributeValue((Node)element, "defaultUpdater")) != null && string.length() > 0) {
                eTArrayList = new ETArrayList();
                try {
                    Object obj = Class.forName(string).newInstance();
                    if (obj != null && obj instanceof IQueryUpdater) {
                        IQueryUpdater iQueryUpdater = (IQueryUpdater)obj;
                        iQueryUpdater.initialize(iProject, document);
                        eTArrayList.add(iQueryUpdater);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
        } else {
            int n = list.size();
            eTArrayList = new ETArrayList();
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            for (int i = 0; i < n; ++i) {
                Attribute attribute;
                String string;
                Node node = (Node)list.get(i);
                if (node.getNodeType() != 2 || (string = (attribute = (Attribute)node).getValue()) == null || string.length() <= 0 || hashMap.containsKey(string)) continue;
                hashMap.put(string, true);
                try {
                    IQueryUpdater iQueryUpdater = null;
                    Object obj = Class.forName(string).newInstance();
                    if (obj instanceof IQueryUpdater) {
                        iQueryUpdater = (IQueryUpdater)obj;
                        iQueryUpdater.initialize(iProject, document);
                    }
                    if (iQueryUpdater == null) continue;
                    eTArrayList.add(iQueryUpdater);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    continue;
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
        }
        if (eTArrayList != null && iProject != null) {
            String string = iProject.getXMIID();
            if (this.m_Updaters == null) {
                this.m_Updaters = new Hashtable();
            }
            this.m_Updaters.put(string, eTArrayList);
        }
    }

    private void establishQueryCache(IProject iProject) {
        this.m_CacheDir = "";
        String string = this.getQueryCachePath(iProject);
        File file = new File(string);
        if (file.exists()) {
            this.verifyCacheContents(iProject);
        } else {
            this.createNewQueryCache(iProject);
        }
    }

    private void verifyCacheContents(IProject iProject) {
        Document document = this.openQueryCache(iProject);
        IQueryBuilder iQueryBuilder = this.establishQueryBuilder(iProject);
        this.rebuildCacheIfNeeded(document, iQueryBuilder, iProject);
        IStrings iStrings = this.getExternalFiles(iProject);
        if (iStrings != null) {
            String string = iProject.getFileName();
            String string2 = "";
            if (string != null && string.length() > 0) {
                string2 = StringUtilities.getPath(string);
            }
            int n = iStrings.getCount();
            for (int i = 0; i < n; ++i) {
                String string3 = iStrings.item(i);
                if (string3 == null || string3.length() <= 0) continue;
                String string4 = StringUtilities.getPath(string3);
                if (string2 == null || string4 == null || !string2.equals(string4)) continue;
                this.rebuildCacheIfNeeded(document, iQueryBuilder, string3);
            }
        }
        this.gatherUpdaters(iProject, document);
        this.saveCache(document, iProject);
    }

    private void saveCache(Document document, IProject iProject) {
        if (document == null || iProject == null) {
            return;
        }
        String string = this.getQueryCachePath(iProject);
        if (string != null && !string.equals(QUERY_CACHE)) {
            try {
                File file = new File(string);
                FileObject fileObject = FileUtil.createData((File)file);
                XMLManip.save(document, string);
            }
            catch (IOException iOException) {
                String string2 = iOException.getMessage();
                logger.log(Level.WARNING, string2 != null ? string2 : "", iOException);
            }
        }
    }

    private void createNewQueryCache(IProject iProject) {
        Document document = this.createCacheFile();
        if (document != null) {
            IQueryBuilder iQueryBuilder = this.establishQueryBuilder(iProject);
            document = this.addResultsToCache(document, iQueryBuilder, iProject, null);
            IStrings iStrings = this.getExternalFiles(iProject);
            if (iStrings != null) {
                int n = iStrings.getCount();
                for (int i = 0; i < n; ++i) {
                    String string = iStrings.item(i);
                    if (string == null || string.length() <= 0) continue;
                    this.processExternalFile(document, iQueryBuilder, string, null);
                }
            }
            this.setDefaultUpdater(iQueryBuilder, document);
            this.gatherUpdaters(iProject, document);
            this.saveCache(document, iProject);
        }
    }

    private void setDefaultUpdater(IQueryBuilder iQueryBuilder, Document document) {
        Element element;
        String string;
        if (iQueryBuilder != null && (string = iQueryBuilder.getDefaultUpdaterProgId()) != null && string.length() > 0 && document != null && (element = document.getRootElement()) != null) {
            XMLManip.setAttributeValue(element, "defaultUpdater", string);
        }
    }

    private Document createCacheFile() {
        Document document = XMLManip.getDOMDocument();
        if (document != null) {
            Element element = XMLManip.createElement(document, "QueryCache");
            document.setRootElement(element);
        }
        return document;
    }

    private String getSchemaLocation() {
        IConfigManager iConfigManager;
        String string = "";
        ICoreProduct iCoreProduct = ProductRetriever.retrieveProduct();
        if (iCoreProduct != null && (iConfigManager = iCoreProduct.getConfigManager()) != null) {
            string = iConfigManager.getDefaultConfigLocation();
            string = string + "QuerySchemas.etc";
        }
        return string;
    }

    private Document appendResults(Document document, Document document2, String string, String string2) {
        Node node;
        Node node2;
        if (document2 != null && (node2 = document2.selectSingleNode("//CachedQueries")) != null && (node = document.selectSingleNode("//QueryCache")) != null) {
            if (string != null && string.length() > 0) {
                String string3 = FileSysManip.retrieveRelativePath(string, this.m_CacheDir);
                XMLManip.setAttributeValue(node2, "fileName", string3);
                if (string2 != null) {
                    XMLManip.setAttributeValue(node2, "crc", string2);
                }
            }
            node2.detach();
            ((Element)node).add(node2);
        }
        return document;
    }

    private void processExternalFile(Document document, IQueryBuilder iQueryBuilder, String string, String string2) {
        Document document2;
        Node node;
        Document document3;
        if (string != null && string.length() > 0 && (document3 = XMLManip.getDOMDocument(string)) != null && (node = document3.selectSingleNode("VersionedElement/child::*[1]")) != null && (document2 = iQueryBuilder.generateResults(node)) != null) {
            this.appendResults(document, document2, string, string2);
        }
    }

    private String getQueryCachePath(IProject iProject) {
        String string = "";
        if (iProject != null) {
            String string2 = iProject.getFileName();
            this.m_CacheDir = string = StringUtilities.getPath(string2);
            string = string + QUERY_CACHE;
        }
        return string;
    }

    private Document openQueryCache(IProject iProject) {
        Document document = null;
        String string = this.getQueryCachePath(iProject);
        document = XMLManip.getDOMDocument(string);
        return document;
    }

    private IStrings getExternalFiles(IProject iProject) {
        ITypeManager iTypeManager;
        IStrings iStrings = null;
        if (iProject != null && (iTypeManager = iProject.getTypeManager()) != null) {
            iStrings = iTypeManager.gatherExternalFileLocations();
        }
        return iStrings;
    }

    private void rebuildCacheIfNeeded(Document document, IQueryBuilder iQueryBuilder, String string) {
        String string2 = this.requiresCacheRebuild(document, string);
        if (string2 != null) {
            this.processExternalFile(document, iQueryBuilder, string, string2);
        }
    }

    private void rebuildCacheIfNeeded(Document document, IQueryBuilder iQueryBuilder, IProject iProject) {
        String string;
        String string2;
        if (iProject != null && (string2 = this.requiresCacheRebuild(document, string = iProject.getFileName())) != null) {
            this.addResultsToCache(document, iQueryBuilder, iProject, string2);
        }
    }

    private String requiresCacheRebuild(Document document, String string) {
        String string2 = null;
        if (document != null && string != null) {
            Element element = this.getCRCValuesElement(document, string);
            String string3 = this.getCRCValuesOld(element);
            String string4 = this.getCRCValuesNew(string);
            if (string4 != null ? !string4.equals(string3) : string3 != null) {
                Element element2;
                if (element != null && (element2 = element.getParent()) != null) {
                    element.detach();
                }
                string2 = string4;
            }
        }
        return string2;
    }

    private String getCRCValuesNew(String string) {
        try {
            File file = new File(string);
            if (file.exists()) {
                int n;
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[1000];
                CRC32 cRC32 = new CRC32();
                while ((n = fileInputStream.read(byArray)) > 0) {
                    cRC32.update(byArray, 0, n);
                }
                fileInputStream.close();
                return String.valueOf(cRC32.getValue());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private String getCRCValuesOld(Element element) {
        String string = null;
        if (element != null) {
            string = XMLManip.getAttributeValue((Node)element, "crc");
        }
        return string;
    }

    private Element getCRCValuesElement(Document document, String string) {
        Element element = null;
        if (string != null && string.length() > 0) {
            Node node;
            String string2 = FileSysManip.retrieveRelativePath(string, this.m_CacheDir);
            String string3 = "//CachedQueries[@fileName=\"";
            string3 = string3 + string2;
            string3 = string3 + "\"]";
            if (document != null && (node = document.selectSingleNode(string3)) != null && node.getNodeType() == 1) {
                element = (Element)node;
            }
        }
        return element;
    }

    private IQueryBuilder establishQueryBuilder(IProject iProject) {
        QueryBuilder queryBuilder = new QueryBuilder();
        String string = this.getSchemaLocation();
        queryBuilder.setSchemaLocation(string);
        if (iProject != null) {
            String string2 = iProject.getXMIID();
            queryBuilder.setProjectId(string2);
        }
        return queryBuilder;
    }

    private Document addResultsToCache(Document document, IQueryBuilder iQueryBuilder, IProject iProject, String string) {
        Document document2 = null;
        if (iProject != null) {
            Node node = iProject.getNode();
            Document document3 = iQueryBuilder.generateResults(node);
            String string2 = iProject.getFileName();
            document2 = this.appendResults(document, document3, string2, string);
        }
        return document2;
    }

    @Override
    public void establishCache(IProject iProject) {
        if (iProject != null) {
            this.establishQueryCache(iProject);
        }
    }

    @Override
    public void closeCache(IProject iProject) {
        if (iProject != null) {
            this.saveCRCs(iProject);
            this.removeUpdaters(iProject);
        }
    }

    private void removeUpdaters(IProject iProject) {
        if (iProject != null) {
            Object v;
            String string = iProject.getXMIID();
            if (this.m_Updaters != null && (v = this.m_Updaters.get(string)) != null) {
                this.m_Updaters.remove(string);
            }
        }
    }

    @Override
    public void onCoreProductPreInit(ICoreProduct iCoreProduct, IResultCell iResultCell) {
    }

    @Override
    public void onCoreProductInitialized(ICoreProduct iCoreProduct, IResultCell iResultCell) {
    }

    @Override
    public void onCoreProductPreQuit(ICoreProduct iCoreProduct, IResultCell iResultCell) {
        this.deinitialize();
    }

    @Override
    public void onCoreProductPreSaved(ICoreProduct iCoreProduct, IResultCell iResultCell) {
    }

    @Override
    public void onCoreProductSaved(ICoreProduct iCoreProduct, IResultCell iResultCell) {
    }

    @Override
    public void onExternalElementPreLoaded(String string, IResultCell iResultCell) {
    }

    @Override
    public void onExternalElementLoaded(IVersionableElement iVersionableElement, IResultCell iResultCell) {
    }

    @Override
    public void onPreInitialExtraction(String string, IVersionableElement iVersionableElement, IResultCell iResultCell) {
    }

    @Override
    public void onInitialExtraction(IVersionableElement iVersionableElement, IResultCell iResultCell) {
    }

    @Override
    public void onPreModeModified(IProject iProject, String string, IResultCell iResultCell) {
    }

    @Override
    public void onModeModified(IProject iProject, IResultCell iResultCell) {
    }

    @Override
    public void onPreDefaultLanguageModified(IProject iProject, String string, IResultCell iResultCell) {
    }

    @Override
    public void onDefaultLanguageModified(IProject iProject, IResultCell iResultCell) {
    }

    @Override
    public void onProjectPreCreate(IWorkspace iWorkspace, IResultCell iResultCell) {
    }

    @Override
    public void onProjectCreated(IProject iProject, IResultCell iResultCell) {
        this.establishQueryCache(iProject);
    }

    @Override
    public void onProjectPreOpen(IWorkspace iWorkspace, String string, IResultCell iResultCell) {
    }

    @Override
    public void onProjectOpened(IProject iProject, IResultCell iResultCell) {
        this.establishQueryCache(iProject);
    }

    @Override
    public void onProjectPreRename(IProject iProject, String string, IResultCell iResultCell) {
    }

    @Override
    public void onProjectRenamed(IProject iProject, String string, IResultCell iResultCell) {
    }

    @Override
    public void onProjectPreClose(IProject iProject, IResultCell iResultCell) {
    }

    @Override
    public void onProjectClosed(IProject iProject, IResultCell iResultCell) {
        this.saveCRCs(iProject);
    }

    @Override
    public void onProjectPreSave(IProject iProject, IResultCell iResultCell) {
    }

    @Override
    public void onProjectSaved(IProject iProject, IResultCell iResultCell) {
    }

    @Override
    public void onPreReferencedLibraryAdded(IProject iProject, String string, IResultCell iResultCell) {
    }

    @Override
    public void onReferencedLibraryAdded(IProject iProject, String string, IResultCell iResultCell) {
    }

    @Override
    public void onPreReferencedLibraryRemoved(IProject iProject, String string, IResultCell iResultCell) {
    }

    @Override
    public void onReferencedLibraryRemoved(IProject iProject, String string, IResultCell iResultCell) {
    }
}

