/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.generativeframework;

import java.lang.reflect.Method;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.coreapplication.IPreferenceManager2;
import org.netbeans.modules.uml.core.generativeframework.ICompoundVariable;
import org.netbeans.modules.uml.core.generativeframework.IExpansionVariable;
import org.netbeans.modules.uml.core.generativeframework.ITemplateManager;
import org.netbeans.modules.uml.core.generativeframework.IVariableExpander;
import org.netbeans.modules.uml.core.generativeframework.IVariableFactory;
import org.netbeans.modules.uml.core.generativeframework.VariableKind;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IVersionableElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.TypedFactoryRetriever;
import org.netbeans.modules.uml.core.metamodel.core.foundation.UMLXMLManip;
import org.netbeans.modules.uml.core.support.umlsupport.ProductRetriever;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.core.support.umlsupport.XMLManip;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpansionVariable
implements IExpansionVariable {
    public static final int EOK_NONE = 0;
    public static final int EOK_AND = 1;
    public static final int EOK_OR = 2;
    protected IVariableExpander m_Expander = null;
    protected IExpansionVariable m_ExpansionVar = null;
    protected Node m_Node = null;
    protected String m_Results = null;
    protected ETList<Node> m_ResultNodes = null;
    protected boolean m_BoolResultCalculated = false;
    protected boolean m_IsTrue = false;

    @Override
    public String getName() {
        return this.getValue("name");
    }

    @Override
    public void setName(String string) {
        this.setValue("name", string);
    }

    @Override
    public void setOperator(int n) {
        this.setValue("operator", n == 1 ? "and" : "or");
    }

    @Override
    public int getOperator() {
        return "and".equals(this.getValue("operator")) ? 1 : 2;
    }

    @Override
    public String getIDLookup() {
        return this.getValue("idLookup");
    }

    @Override
    public void setIDLookup(String string) {
        this.setValue("idLookup", string);
    }

    @Override
    public String getExpansionName() {
        return this.getValue("expand");
    }

    @Override
    public void setExpansionName(String string) {
        this.setValue("expand", string);
    }

    @Override
    public String getQuery() {
        return this.getValue("query");
    }

    @Override
    public void setQuery(String string) {
        this.setValue("query", string);
    }

    @Override
    public String getMethodGet() {
        return this.getValue("methodGet");
    }

    @Override
    public void setMethodGet(String string) {
        this.setValue("methodGet", string);
    }

    @Override
    public boolean getIsAttributeResult() {
        return this.isAttributeResult();
    }

    @Override
    public IVariableExpander getExecutionContext() {
        return this.m_Expander;
    }

    @Override
    public void setExecutionContext(IVariableExpander iVariableExpander) {
        this.m_Expander = iVariableExpander;
    }

    @Override
    public String getXSLFilter() {
        return this.getValue("xslFilter");
    }

    @Override
    public void setXSLFilter(String string) {
        this.setValue("xslFilter", string);
    }

    @Override
    public IExpansionVariable getExpansionVariable() {
        return this.m_ExpansionVar;
    }

    @Override
    public void setExpansionVariable(IExpansionVariable iExpansionVariable) {
        this.m_ExpansionVar = iExpansionVariable;
    }

    @Override
    public Node getNode() {
        return this.m_Node;
    }

    @Override
    public void setNode(Node node) {
        this.m_Node = node;
    }

    @Override
    public String expand(Node node) {
        String string = null;
        if (!this.isNodeDeleted(node)) {
            String string2;
            String string3;
            this.validate();
            int n = VariableKind.VK_NONE;
            n = this.getKind();
            if (n == VariableKind.VK_NODE_NAME) {
                this.m_Results = node.getName();
            } else {
                if (n == VariableKind.VK_ATTRIBUTE) {
                    this.m_Results = this.retrieveAttributeResult(node);
                } else {
                    string3 = this.getQuery();
                    if (string3 != null && string3.length() > 0) {
                        if (this.isAttributeResult()) {
                            this.m_Results = this.retrieveAttributeResult(node);
                        } else if (this.isPreferenceQuery()) {
                            this.m_Results = this.retrievePreferenceResult(string3);
                        } else {
                            this.retrieveElementResults(node, string3);
                        }
                    } else {
                        string2 = this.getIDLookup();
                        if (string2 != null && string2.length() > 0) {
                            this.retrieveIDResults(node, string2);
                        } else {
                            String string4 = this.getMethodGet();
                            if (string4 != null && string4.length() > 0) {
                                try {
                                    this.retrieveGetResults(node, string4);
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    noSuchMethodException.printStackTrace();
                                }
                            }
                        }
                    }
                }
                if (this.useExpansionVar() && (string3 = this.getExpansionName()) != null && string3.length() > 0) {
                    this.m_Results = this.resolveExpansionVar(node, string3);
                }
            }
            string3 = null;
            if (this.m_Results != null && this.m_Results.length() > 0) {
                string2 = this.getReplaceFilter();
                if (string2 != null && string2.length() > 0) {
                    this.m_Results = this.processReplaceFilter(string2, this.m_Results);
                }
                string3 = this.m_Results;
            }
            if (this.isBooleanVar()) {
                string3 = this.getBooleanResult(string3);
            }
            if (string3 != null && string3.length() > 0) {
                string = string3 = this.filterResults(string3, null);
            }
        }
        return string;
    }

    @Override
    public String expand(IElement iElement) {
        return iElement != null ? this.expand(iElement.getNode()) : null;
    }

    protected boolean isPreferenceQuery() {
        return this.getKind() == VariableKind.VK_PREFERENCE;
    }

    protected String retrievePreferenceResult(String string) {
        ICoreProduct iCoreProduct;
        IPreferenceManager2 iPreferenceManager2;
        if (string != null && (iPreferenceManager2 = (iCoreProduct = ProductRetriever.retrieveProduct()).getPreferenceManager()) != null) {
            return iPreferenceManager2.getPreferenceValue(string);
        }
        return null;
    }

    protected String filterResults(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null && (string2 = this.getValueFilter()) == null || string2.length() == 0) {
            return string;
        }
        ETList<String> eTList = StringUtilities.splitOnDelimiter(string2, ",");
        for (String string3 : eTList) {
            ETList<String> eTList2 = StringUtilities.splitOnDelimiter(string3, "=");
            if (eTList2.size() != 2) continue;
            String string4 = ((String)eTList2.get(0)).trim();
            String string5 = ((String)eTList2.get(1)).trim();
            if (string4.length() <= 0 || !string4.equals(string)) continue;
            string = string5;
            break;
        }
        return string;
    }

    protected String processReplaceFilter(String string, String string2) {
        ETList<String> eTList;
        if (string != null && string2 != null && (eTList = StringUtilities.splitOnDelimiter(string, "=")).size() == 2) {
            String string3 = (String)eTList.get(0);
            String string4 = (String)eTList.get(1);
            string2 = StringUtilities.replaceAllSubstrings(string2, string3, string4);
        }
        return string2;
    }

    protected Object retrieveGetResults(Node node, String string) throws NoSuchMethodException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Property name cannot be empty");
        }
        IElement iElement = (IElement)new TypedFactoryRetriever().createTypeAndFill(node);
        if (iElement != null) {
            String string2 = "get" + string.substring(0, 1).toUpperCase() + string.substring(1);
            Method method = iElement.getClass().getMethod(string2, null);
            try {
                Object object = method.invoke((Object)iElement, (Object[])null);
                if (object instanceof IVersionableElement) {
                    this.addToResultNodes((IVersionableElement)object);
                } else if (object != null) {
                    this.m_Results = this.m_Results != null ? this.m_Results + object : object.toString();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    protected void retrieveElementResults(Node node, String string) {
        List list = node.selectNodes(string);
        if (list.size() > 0) {
            if (this.isNodeValue()) {
                Element element;
                Node node2 = (Node)list.get(0);
                if (node2 instanceof Element && (element = (Element)node2).nodeCount() > 0) {
                    this.m_Results = element.node(0).getText();
                }
            } else {
                this.addToResultNodes(list);
            }
        }
    }

    protected void addToResultNodes(IVersionableElement iVersionableElement) {
        if (iVersionableElement != null) {
            this.addToResultNodes(iVersionableElement.getNode());
        }
    }

    protected void addToResultNodes(List list) {
        for (Node node : list) {
            this.addToResultNodes(node);
        }
    }

    protected void addToResultNodes(Node node) {
        ETList<Node> eTList = this.getResultNodes();
        if (node != null && !this.isNodeDeleted(node)) {
            eTList.add(node);
        }
    }

    protected boolean isAttributeResult() {
        boolean bl = false;
        String string = this.getQuery();
        if (string != null && string.startsWith("@")) {
            bl = true;
        }
        return bl;
    }

    protected String retrieveAttributeResult(Node node) {
        String string = this.getQuery();
        return this.retrieveAttributeResult(node, string);
    }

    protected String retrieveAttributeResult(Node node, String string) {
        String string2 = null;
        if (string != null && string.length() > 0) {
            String string3 = this.getValueFilter();
            string2 = XMLManip.getAttributeValue(node, string.substring(1));
            if (string3 != null && string3.length() > 0) {
                string2 = this.filterResults(string2, string3);
            }
        }
        return string2;
    }

    @Override
    public ETList<Node> getResultNodes() {
        if (this.m_ResultNodes == null) {
            this.m_ResultNodes = new ETArrayList<Node>();
        }
        return this.m_ResultNodes;
    }

    @Override
    public void setResultNodes(ETList<Node> eTList) {
        this.m_ResultNodes = eTList;
    }

    @Override
    public int getKind() {
        int n = VariableKind.VK_NONE;
        String string = this.getValue("varType");
        if (string == null || string.length() == 0) {
            if (this.isAttributeResult()) {
                n = VariableKind.VK_ATTRIBUTE;
            } else {
                String string2 = this.getQuery();
                if (string2 != null && string2.length() > 0) {
                    n = VariableKind.VK_NODES;
                }
            }
        } else {
            n = this.translateKind(string);
        }
        return n;
    }

    @Override
    public void setKind(int n) {
        this.setValue("varType", this.translateKind(n));
    }

    @Override
    public String getTypeFilter() {
        return this.getValue("type");
    }

    @Override
    public void setTypeFilter(String string) {
        this.setValue("type", string);
    }

    @Override
    public String getResults() {
        return this.m_Results;
    }

    @Override
    public void setResults(String string) {
        this.m_Results = string;
    }

    @Override
    public String getValueFilter() {
        return this.getValue("valueFilter");
    }

    @Override
    public void setValueFilter(String string) {
        this.setValue("valueFilter", string);
    }

    @Override
    public String getReplaceFilter() {
        return this.getValue("replaceFilter");
    }

    @Override
    public void setReplaceFilter(String string) {
        this.setValue("replaceFilter", string);
    }

    @Override
    public String getOverrideName() {
        return this.getValue("overrides");
    }

    @Override
    public void setOverrideName(String string) {
        this.setValue("overrides", string);
    }

    @Override
    public String getTrueValue() {
        return this.getValue("trueValue");
    }

    @Override
    public void setTrueValue(String string) {
        this.setValue("trueValue", string);
    }

    @Override
    public boolean getIsTrue() {
        return this.m_IsTrue;
    }

    @Override
    public void setIsTrue(boolean bl) {
        this.m_IsTrue = bl;
    }

    protected String getValue(String string) {
        String string2 = null;
        if (this.m_Node != null) {
            string2 = XMLManip.getAttributeValue(this.m_Node, string);
        }
        return string2;
    }

    protected void setValue(String string, String string2) {
        if (this.m_Node != null) {
            XMLManip.setAttributeValue(this.m_Node, string, string2);
        }
    }

    protected void retrieveIDResults(Node node, String string) {
        if (string != null) {
            int n = string.indexOf(32);
            if (n >= 0) {
                this.followLookups(node, string.split(" "));
            } else {
                this.resolveIDLookup(node, string);
            }
        }
    }

    protected void resolveIDLookup(Node node, String string) {
        String string2 = this.retrieveAttributeResult(node, string);
        if (string2 != null && string2.length() > 0) {
            ETList<String> eTList = StringUtilities.splitOnDelimiter(string2, " ");
            int n = eTList.size();
            for (int i = 0; i < n; ++i) {
                String string3 = (String)eTList.get(i);
                Node node2 = UMLXMLManip.findElementByID(node, string3);
                if (node2 == null) continue;
                this.filterResultNode(node2);
            }
        }
    }

    protected boolean filterResultNode(Node node) {
        String string = this.getTypeFilter();
        String string2 = ((Element)node).getQualifiedName();
        if (string == null || string.length() == 0 || string2.equals(string)) {
            this.addToResultNodes(node);
            return true;
        }
        return false;
    }

    protected void followLookups(Node node, String[] stringArray) {
        if (node != null && stringArray != null) {
            int n = stringArray.length;
            if (n > 0) {
                Node node2;
                String string = stringArray[0];
                String string2 = this.retrieveAttributeResult(node, string);
                if (string2 != null && string2.length() > 0 && (node2 = UMLXMLManip.findElementByID(node, string2)) != null) {
                    String[] stringArray2 = new String[n - 1];
                    for (int i = 0; i < n - 1; ++i) {
                        stringArray2[i] = stringArray[i + 1];
                    }
                    this.followLookups(node2, stringArray2);
                }
            } else {
                this.filterResultNode(node);
            }
        }
    }

    protected String resolveExpansionVar(Node node, String string) {
        String string2 = string;
        String string3 = null;
        if (string == null) {
            string2 = this.getExpansionName();
        }
        if (string2 != null && string2.length() > 0) {
            ETList<String> eTList = StringUtilities.splitOnDelimiter(string2, " ");
            boolean bl = this.isBooleanVar();
            int n = this.getOperator();
            for (String string4 : eTList) {
                int n2;
                IExpansionVariable iExpansionVariable = this.retrieveVarNode(string4);
                if (this.m_ResultNodes != null) {
                    if (iExpansionVariable == null) continue;
                    int n3 = iExpansionVariable.getKind();
                    if (n3 != VariableKind.VK_NODES) {
                        Node node2;
                        n2 = this.m_ResultNodes.size();
                        if (n2 > 0 && (node2 = (Node)this.m_ResultNodes.get(n2 - 1)) != null) {
                            string3 = this.resolveExpansionVar(iExpansionVariable, node2);
                        }
                    } else {
                        string3 = this.resolveExpansionVar(iExpansionVariable, node);
                    }
                } else if (node != null && iExpansionVariable != null) {
                    string3 = this.resolveExpansionVar(iExpansionVariable, node);
                }
                if (!bl) continue;
                String string5 = this.getBooleanResult(string3);
                n2 = Boolean.valueOf(string5).booleanValue() ? 1 : 0;
                if (n2 != 0 && n == 2) {
                    string3 = string5;
                    continue;
                }
                if (n2 == 0 && n == 1) {
                    this.m_BoolResultCalculated = true;
                    this.m_IsTrue = false;
                    break;
                }
                this.m_BoolResultCalculated = false;
            }
        }
        return string3;
    }

    protected String resolveExpansionVar(IExpansionVariable iExpansionVariable, Node node) {
        ETList<Node> eTList;
        String string = iExpansionVariable.expand(node);
        if ((string == null || string.length() == 0) && (eTList = iExpansionVariable.getResultNodes()) != null && eTList.size() > 0) {
            this.getResultNodes().addAll(eTList);
        }
        return string;
    }

    protected boolean isNodeValue() {
        boolean bl = false;
        int n = VariableKind.VK_NONE;
        n = this.getKind();
        if (n == VariableKind.VK_TEXT_VALUE) {
            bl = true;
        }
        return bl;
    }

    protected IExpansionVariable retrieveVarNode(String string) {
        IVariableFactory iVariableFactory;
        ITemplateManager iTemplateManager;
        Node node;
        IExpansionVariable iExpansionVariable = null;
        if (this.m_Expander != null && (node = this.m_Expander.retrieveVarNode(string)) != null && (iTemplateManager = this.m_Expander.getManager()) != null && (iVariableFactory = iTemplateManager.getFactory()) != null) {
            iExpansionVariable = iVariableFactory.createVariable(node);
        }
        return iExpansionVariable;
    }

    protected int translateKind(String string) {
        int n = VariableKind.VK_NONE;
        if (string.length() > 0) {
            if (string.equals("attr")) {
                n = VariableKind.VK_ATTRIBUTE;
            } else if (string.equals("nodes")) {
                n = VariableKind.VK_NODES;
            } else if (string.equals("text")) {
                n = VariableKind.VK_TEXT_VALUE;
            } else if (string.equals("nodeName")) {
                n = VariableKind.VK_NODE_NAME;
            } else if (string.equals("boolean")) {
                n = VariableKind.VK_BOOLEAN;
            }
        }
        return n;
    }

    protected String translateKind(int n) {
        String string = null;
        if (n == VariableKind.VK_ATTRIBUTE) {
            string = "attr";
        } else if (n == VariableKind.VK_NODES) {
            string = "nodes";
        } else if (n == VariableKind.VK_TEXT_VALUE) {
            string = "text";
        } else if (n == VariableKind.VK_NODE_NAME) {
            string = "nodeName";
        } else if (n == VariableKind.VK_BOOLEAN) {
            string = "boolean";
        }
        return string;
    }

    protected boolean isBooleanVar() {
        boolean bl = false;
        int n = this.getKind();
        if (n == VariableKind.VK_BOOLEAN) {
            bl = true;
        }
        return bl;
    }

    protected boolean isNodeDeleted(Node node) {
        String string;
        boolean bl = false;
        if (node != null && "true".equals(string = XMLManip.getAttributeValue(node, "isDeleted"))) {
            bl = true;
        }
        return bl;
    }

    protected boolean useExpansionVar() {
        boolean bl = true;
        long l = 0L;
        if (this.m_ResultNodes != null) {
            l = this.m_ResultNodes.size();
        }
        if (l == 0L) {
            String string = this.getQuery();
            String string2 = this.getIDLookup();
            bl = !(string != null && string.length() != 0 || string2 != null && string2.length() != 0);
        }
        return bl;
    }

    protected String getBooleanResult(String string) {
        String string2 = "false";
        if (this.m_BoolResultCalculated) {
            string2 = this.getIsTrue() ? "true" : "false";
        } else {
            this.m_BoolResultCalculated = true;
            boolean bl = false;
            String string3 = null;
            if (this.m_Node != null && "length".equals(string3 = XMLManip.getAttributeValue(this.m_Node, "trueValueType"))) {
                bl = true;
            }
            String string4 = string;
            String string5 = this.getTrueValue();
            boolean bl2 = true;
            if (((Element)this.m_Node).attribute("trueValue") != null) {
                bl2 = false;
                if (string5.equals(string4)) {
                    string2 = "true";
                }
            } else if ("false".equals(string) && !bl) {
                bl2 = false;
            }
            if (string4 != null && string4.length() > 0 && bl2) {
                string2 = "true";
                bl2 = false;
            }
            if (this.m_ResultNodes != null && bl2 && !bl && this.m_ResultNodes.size() > 0) {
                string2 = "true";
            }
            this.setIsTrue("true".equals(string2));
        }
        return string2;
    }

    protected void validate() {
        if (this.m_Node == null) {
            throw new IllegalStateException("Not initialized");
        }
    }

    protected String expandTemplateWithNode(String string, Node node) {
        ITemplateManager iTemplateManager;
        IVariableExpander iVariableExpander;
        this.validate();
        String string2 = null;
        if (string != null && string.length() > 0 && (iVariableExpander = this.getExecutionContext()) != null && (iTemplateManager = iVariableExpander.getManager()) != null) {
            string2 = iTemplateManager.expandTemplateWithNode(string, node);
            IVariableExpander iVariableExpander2 = iTemplateManager.getVariableExpander();
            if (this instanceof ICompoundVariable) {
                ((ICompoundVariable)((Object)this)).setExecutionContext(iVariableExpander2);
            }
        }
        return string2;
    }
}

