/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.generativeframework;

import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.dom4j.Node;
import org.netbeans.modules.uml.core.generativeframework.ExpansionVariable;
import org.netbeans.modules.uml.core.generativeframework.IExpansionVariable;
import org.netbeans.modules.uml.core.generativeframework.IIfTest;
import org.netbeans.modules.uml.core.generativeframework.IVariableExpander;
import org.netbeans.modules.uml.core.generativeframework.IVariableFactory;
import org.netbeans.modules.uml.core.generativeframework.IfTest;
import org.netbeans.modules.uml.core.generativeframework.IfVariable;
import org.netbeans.modules.uml.core.generativeframework.ImportVariable;
import org.netbeans.modules.uml.core.generativeframework.IterationVariable;
import org.netbeans.modules.uml.core.support.umlsupport.INamedCollection;
import org.netbeans.modules.uml.core.support.umlsupport.NamedCollection;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.core.support.umlsupport.Validator;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableFactory
implements IVariableFactory {
    private Stack<IVariableExpander> m_Contexts = new Stack();
    private String m_Config;
    private HashMap<String, IExpansionVariable> m_Overrides = new HashMap();

    @Override
    public IExpansionVariable createVariable(Node node) {
        ExpansionVariable expansionVariable = new ExpansionVariable();
        expansionVariable.setNode(node);
        this.checkForOverride(expansionVariable);
        this.establishContext(expansionVariable);
        return expansionVariable;
    }

    private void checkForOverride(IExpansionVariable iExpansionVariable) {
        String string = iExpansionVariable.getName();
        if (this.m_Overrides.containsKey(string)) {
            IExpansionVariable iExpansionVariable2 = this.m_Overrides.get(string);
            String string2 = iExpansionVariable2.getValueFilter();
            iExpansionVariable.setValueFilter(string2);
            String string3 = iExpansionVariable2.getReplaceFilter();
            iExpansionVariable.setReplaceFilter(string3);
        }
    }

    private void establishContext(IExpansionVariable iExpansionVariable) {
        IVariableExpander iVariableExpander = this.establishExpander();
        if (iVariableExpander != null) {
            iExpansionVariable.setExecutionContext(iVariableExpander);
        }
    }

    private IVariableExpander establishExpander() {
        return this.getExecutionContext();
    }

    private ETList<INamedCollection> getResultAndActions(String string) {
        ETArrayList<INamedCollection> eTArrayList = new ETArrayList<INamedCollection>();
        if (string != null && string.length() > 0) {
            HashMap<String, String> hashMap = this.getIndexedOptions("result", string);
            HashMap<String, String> hashMap2 = this.getIndexedOptions("resultAction", string);
            for (String string2 : hashMap.keySet()) {
                String string3 = hashMap2.get(string2);
                String string4 = hashMap.get(string2);
                if (string4 == null || string3 == null) continue;
                NamedCollection namedCollection = new NamedCollection();
                namedCollection.setName(string4);
                namedCollection.setData(string3);
                eTArrayList.add(namedCollection);
            }
        }
        return eTArrayList;
    }

    private HashMap<String, String> getIndexedOptions(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = string + "=\"";
        int n = string2.indexOf(string3);
        while (n != -1) {
            int n2 = n + string3.length();
            int n3 = string2.indexOf(34, n2);
            if (n3 == -1) {
                n3 = string2.length();
            }
            String string4 = string2.substring(n2, n3);
            int n4 = string4.indexOf(58);
            String string5 = string4.substring(0, n4);
            hashMap.put(string5, string4.substring(n4 + 1));
            n = string2.indexOf(string3, n3);
        }
        return hashMap;
    }

    @Override
    public IVariableExpander getExecutionContext() {
        return this.m_Contexts.size() > 0 ? this.m_Contexts.peek() : null;
    }

    @Override
    public void setExecutionContext(IVariableExpander iVariableExpander) {
        this.m_Contexts.push(iVariableExpander);
    }

    @Override
    public String getConfigFile() {
        return this.m_Config;
    }

    @Override
    public void setConfigFile(String string) {
        this.m_Config = string;
    }

    private void validateConfig() throws FileNotFoundException {
        if (!Validator.verifyFileExists(this.m_Config)) {
            throw new FileNotFoundException(this.m_Config);
        }
    }

    @Override
    public IExpansionVariable createVariableWithText(String string) {
        IExpansionVariable iExpansionVariable = null;
        if (string != null && string.length() > 0) {
            String string2;
            int n = string.indexOf(32);
            if (n == -1) {
                n = string.indexOf(37);
            }
            if (n == -1) {
                n = string.length();
            }
            if ("IterationVar".equals(string2 = string.substring(0, n))) {
                iExpansionVariable = this.createIterationVar(string.substring(n));
            } else if ("ImportVar".equals(string2)) {
                iExpansionVariable = this.createImportVar(string.substring(n));
            } else if ("IfVar".equals(string2)) {
                iExpansionVariable = this.createIfVar(string.substring(n));
            } else {
                IVariableExpander iVariableExpander = this.establishExpander();
                if (iVariableExpander != null) {
                    Node node = iVariableExpander.retrieveVarNode(string2);
                    if (node != null) {
                        iExpansionVariable = this.createVariable(node);
                    } else {
                        throw new IllegalArgumentException("Can't create variable from '" + string + "'");
                    }
                }
            }
        }
        return iExpansionVariable;
    }

    private IExpansionVariable createIterationVar(String string) {
        String string2 = this.getListOption(string);
        String string3 = this.getLiteral(string);
        String string4 = this.getVarOption(string);
        if (string4 == null || string3 == null) {
            throw new IllegalArgumentException("No Var option in '" + string + "'");
        }
        String string5 = this.getDelimiter(string);
        IterationVariable iterationVariable = new IterationVariable();
        if (string2 != null) {
            iterationVariable.setListVarName(string2);
        }
        if (string4 != null) {
            iterationVariable.setVarName(string4);
        }
        if (string5 != null) {
            iterationVariable.setDelimiter(string5);
        }
        if (string3 != null) {
            iterationVariable.setLiteral(string3);
        }
        this.establishContext(iterationVariable);
        return iterationVariable;
    }

    private IExpansionVariable createImportVar(String string) {
        String string2 = this.getVarOption(string);
        String string3 = this.getOption("test", string);
        ETList<INamedCollection> eTList = this.getResultAndActions(string);
        ImportVariable importVariable = new ImportVariable();
        if (string2 != null) {
            importVariable.setTemplate(string2);
        }
        if (string3 != null) {
            importVariable.setTestClause(string3);
        }
        if (eTList != null) {
            importVariable.setConditions(eTList);
        }
        this.establishContext(importVariable);
        return importVariable;
    }

    private IExpansionVariable createIfVar(String string) {
        List<String> list = this.gatherTestCases(string);
        if (list != null) {
            IfVariable ifVariable = new IfVariable();
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                IIfTest iIfTest = this.createIfTest(iterator.next());
                if (iIfTest == null) continue;
                ifVariable.addTest(iIfTest);
            }
            this.establishContext(ifVariable);
            return ifVariable;
        }
        return null;
    }

    private List<String> gatherTestCases(String string) {
        if (string != null && string.length() > 0) {
            ETList<String> eTList = StringUtilities.splitOnDelimiter(string, ">");
            for (int i = eTList.size() - 1; i >= 0; --i) {
                String string2 = ((String)eTList.get(i)).trim();
                if (string2.length() == 0) {
                    eTList.remove(i);
                    continue;
                }
                eTList.set(i, string2);
            }
            return eTList.size() > 0 ? eTList : null;
        }
        return null;
    }

    private IIfTest createIfTest(String string) {
        IfTest ifTest = null;
        String string2 = this.getOption("test", string);
        String string3 = this.getOption("var", string);
        ifTest = new IfTest();
        if (string2 != null) {
            ifTest.setTest(string2);
        }
        if (string3 != null) {
            ifTest.setResultAction(string3);
        }
        return ifTest;
    }

    private String getListOption(String string) {
        return this.getOption("list", string);
    }

    private String getVarOption(String string) {
        return this.getOption("var", string);
    }

    private String getOption(String string, String string2) {
        int n;
        String string3 = null;
        int n2 = string2.indexOf(string);
        if (n2 != -1 && (n2 = string2.indexOf(34, n2)) != -1 && (n = string2.indexOf(34, ++n2)) != -1) {
            string3 = string2.substring(n2, n);
        }
        return string3;
    }

    private String getDelimiter(String string) {
        return this.getOption("delimiter", string);
    }

    private String getLiteral(String string) {
        return this.getOption("literal", string);
    }

    @Override
    public IVariableExpander getPopContext() {
        return this.m_Contexts.size() > 0 ? this.m_Contexts.pop() : null;
    }

    @Override
    public ETList<IExpansionVariable> getOverrideVariables() {
        return new ETArrayList<IExpansionVariable>(this.m_Overrides.values());
    }

    @Override
    public void setOverrideVariables(ETList<IExpansionVariable> eTList) {
        this.m_Overrides.clear();
        if (eTList != null) {
            Iterator iterator = eTList.iterator();
            while (iterator.hasNext()) {
                this.addOverride((IExpansionVariable)iterator.next());
            }
        }
    }

    @Override
    public void addOverride(IExpansionVariable iExpansionVariable) {
        this.m_Overrides.put(iExpansionVariable.getName(), iExpansionVariable);
    }

    @Override
    public void removeOverride(IExpansionVariable iExpansionVariable) {
        this.m_Overrides.remove(iExpansionVariable.getName());
    }
}

