/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.metamodel.structure;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.eventframework.EventDispatchNameKeeper;
import org.netbeans.modules.uml.core.eventframework.EventDispatchRetriever;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.metamodel.structure.Artifact;
import org.netbeans.modules.uml.core.metamodel.structure.ISourceCodeHolder;
import org.netbeans.modules.uml.core.metamodel.structure.ISourceFileArtifact;
import org.netbeans.modules.uml.core.metamodel.structure.ISourceFileArtifactEventsSink;
import org.netbeans.modules.uml.core.metamodel.structure.IStructureEventDispatcher;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.ILanguage;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.ILanguageManager;
import org.netbeans.modules.uml.core.roundtripframework.codegeneration.IFileSystemManipulation;
import org.netbeans.modules.uml.core.roundtripframework.codegeneration.ISourceCodeManipulation;
import org.netbeans.modules.uml.core.support.umlsupport.ProductRetriever;
import org.netbeans.modules.uml.core.support.umlsupport.UMLUtilities;

public class SourceFileArtifact
extends Artifact
implements ISourceFileArtifact {
    int nextCookie = 1;
    private List<ISourceFileArtifactEventsSink> m_eventSinks = new ArrayList<ISourceFileArtifactEventsSink>();
    private ISourceCodeHolder m_pSourceCodeHolder = null;
    private ISourceCodeManipulation m_pSourceManipulation = null;

    public ILanguage getLanguage() {
        ILanguageManager iLanguageManager;
        ICoreProduct iCoreProduct;
        String string = this.getSourceFile();
        ILanguage iLanguage = null;
        if (string != null && (iCoreProduct = ProductRetriever.retrieveProduct()) != null && (iLanguageManager = iCoreProduct.getLanguageManager()) != null) {
            iLanguage = iLanguageManager.getLanguageForFile(string);
        }
        return iLanguage;
    }

    public void establishNodePresence(Document document, Node node) {
        this.buildNodePresence("UML:SourceFileArtifact", document, node);
    }

    public String getName() {
        return this.getSourceFile();
    }

    public String getShortName() {
        String string = this.getSourceFile();
        File file = new File(string);
        String string2 = null;
        if (file != null) {
            string2 = file.getName();
        }
        return string2;
    }

    public String getDrive() {
        int n;
        String string = this.getSourceFile();
        File file = new File(string);
        String string2 = null;
        String string3 = null;
        if (!(file == null || (n = (string2 = file.toString()).indexOf(File.separatorChar)) != 2 || Character.isLetter((string3 = string2.substring(0, n)).charAt(0)) && string3.charAt(1) == ':')) {
            string3 = null;
        }
        return string3;
    }

    public String getBaseDirectory() {
        IClassifier iClassifier;
        IClassifier iClassifier2 = UMLUtilities.getOwningClassifier(this);
        if (iClassifier2 != null && (iClassifier = UMLUtilities.getOutermostNestingClass(iClassifier2)) != null) {
            return this.getBaseDir(this.getSourceFile(), iClassifier.getQualifiedName());
        }
        return null;
    }

    public String getDirectory() {
        String string = this.getSourceFile();
        File file = new File(string);
        return file.getParent();
    }

    public void registerForSourceFileArtifactEvents(ISourceFileArtifactEventsSink iSourceFileArtifactEventsSink) {
        if (!this.m_eventSinks.contains(iSourceFileArtifactEventsSink)) {
            this.m_eventSinks.add(iSourceFileArtifactEventsSink);
        }
    }

    public void revokeSourceFileArtifactSink(ISourceFileArtifactEventsSink iSourceFileArtifactEventsSink) {
        this.m_eventSinks.remove(iSourceFileArtifactEventsSink);
    }

    public void fireTextInserted(int n, String string) {
        if (this.m_eventSinks != null && this.m_eventSinks.size() > 0) {
            for (ISourceFileArtifactEventsSink iSourceFileArtifactEventsSink : this.m_eventSinks) {
                iSourceFileArtifactEventsSink.onTextInserted(n, string);
            }
        }
    }

    public void fireRangeDeleted(int n, int n2, String string) {
        if (this.m_eventSinks != null && this.m_eventSinks.size() > 0) {
            for (ISourceFileArtifactEventsSink iSourceFileArtifactEventsSink : this.m_eventSinks) {
                iSourceFileArtifactEventsSink.onRangeDeleted(n, n2, string);
            }
        }
    }

    public void fireRangeModified(int n, int n2, String string, String string2) {
        if (this.m_eventSinks != null && this.m_eventSinks.size() > 0) {
            for (ISourceFileArtifactEventsSink iSourceFileArtifactEventsSink : this.m_eventSinks) {
                iSourceFileArtifactEventsSink.onRangeModified(n, n2, string, string2);
            }
        }
    }

    public int calculateCRC() {
        String string = this.getSourceCode();
        int n = 0;
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                n += string.charAt(i);
            }
        }
        return n;
    }

    public ISourceCodeManipulation modify(IFileSystemManipulation iFileSystemManipulation) {
        if (this.m_pSourceManipulation == null) {
            this.m_pSourceManipulation = iFileSystemManipulation.modifyFile(this.getSourceFile());
            if (this.m_pSourceManipulation != null && this.firePreDirty()) {
                this.m_pSourceManipulation.setSourceCode(this.getSourceCode());
                this.m_pSourceManipulation.setSourceFileArtifact(this);
                this.fireDirty();
            }
        }
        return this.m_pSourceManipulation;
    }

    public String getSourceCode() {
        String string = null;
        string = this.m_pSourceCodeHolder != null ? this.m_pSourceCodeHolder.getSourceCode() : (this.m_pSourceManipulation != null ? this.m_pSourceManipulation.getSourceCode() : this.readSourceCodeFromDisk());
        return string;
    }

    protected String readSourceCodeFromDisk() {
        File file;
        byte[] byArray = null;
        String string = this.getSourceFile();
        if (string != null && (file = new File(string)).exists() && file.isFile()) {
            int n = (int)file.length();
            byArray = new byte[n];
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                fileInputStream.read(byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return byArray != null ? new String(byArray) : null;
    }

    public ISourceCodeHolder getSourceCodeHolder() {
        return this.m_pSourceCodeHolder;
    }

    public void setSourceCodeHolder(ISourceCodeHolder iSourceCodeHolder) {
        this.m_pSourceCodeHolder = iSourceCodeHolder;
    }

    public void fireCommit() {
    }

    public void commitChanges() {
        this.fireCommit();
        if (this.m_pSourceCodeHolder != null) {
            this.m_pSourceCodeHolder.onCommit();
        }
        String string = this.getSourceCode();
        String string2 = this.getSourceFile();
        this.m_pSourceManipulation = null;
        if (string2 != null && string != null) {
            try {
                File file = new File(string2);
                if (file != null) {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(string.getBytes());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setSourceCode(String string) {
        if (this.m_pSourceManipulation != null) {
            this.m_pSourceManipulation.setSourceCode(string);
        }
    }

    public String getSourceFile() {
        return this.getFileName();
    }

    public void setSourceFile(String string) {
        String string2 = this.getFileName();
        if (!(string == null || string2 != null && new File(string).toString().equals(new File(string2).toString()))) {
            this.setFileName(string);
            this.fireSourceFileNameChanged(string2, string);
        }
    }

    public void fireSourceFileNameChanged(String string, String string2) {
        if (this.m_eventSinks != null && this.m_eventSinks.size() > 0) {
            for (ISourceFileArtifactEventsSink iSourceFileArtifactEventsSink : this.m_eventSinks) {
                iSourceFileArtifactEventsSink.onSourceFileNameChanged(string, string2);
            }
        }
    }

    public boolean firePreDirty() {
        boolean bl = false;
        EventDispatchRetriever eventDispatchRetriever = EventDispatchRetriever.instance();
        IStructureEventDispatcher iStructureEventDispatcher = (IStructureEventDispatcher)eventDispatchRetriever.getDispatcher(EventDispatchNameKeeper.structure());
        if (iStructureEventDispatcher != null) {
            bl = iStructureEventDispatcher.fireArtifactPreDirty(this, null);
        }
        return bl;
    }

    public void fireDirty() {
        EventDispatchRetriever eventDispatchRetriever = EventDispatchRetriever.instance();
        IStructureEventDispatcher iStructureEventDispatcher = (IStructureEventDispatcher)eventDispatchRetriever.getDispatcher(EventDispatchNameKeeper.structure());
        if (iStructureEventDispatcher != null) {
            iStructureEventDispatcher.fireArtifactDirty(this, null);
        }
    }

    public boolean ensureWriteAccess() {
        boolean bl = false;
        if (this.firePreDirty()) {
            bl = true;
            this.fireDirty();
        }
        return bl;
    }
}

