/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.preferenceframework;

import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import org.dom4j.Document;
import org.netbeans.modules.uml.core.coreapplication.IPreferenceManager2;
import org.netbeans.modules.uml.core.coreapplication.IPreferenceObject;
import org.netbeans.modules.uml.core.eventframework.EventDispatchNameKeeper;
import org.netbeans.modules.uml.core.eventframework.EventDispatchRetriever;
import org.netbeans.modules.uml.core.eventframework.IEventPayload;
import org.netbeans.modules.uml.core.preferenceframework.IPreferenceManagerEventDispatcher;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.core.support.umlsupport.XMLManip;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyDefinition;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyDefinitionXML;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyElement;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyElementManager;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyElementXML;
import org.netbeans.modules.uml.core.support.umlutils.PropertyDefinitionFactory;
import org.netbeans.modules.uml.core.support.umlutils.PropertyDefinitionXML;
import org.netbeans.modules.uml.core.support.umlutils.PropertyElementManager;
import org.netbeans.modules.uml.core.support.umlutils.PropertyElementXML;
import org.netbeans.modules.uml.ui.support.DispatchHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceManager
implements IPreferenceManager2 {
    private static final int CT_BOOLEAN = 0;
    private static final int CT_LIST = 1;
    private static final int CT_COMBO = 2;
    private static final int CT_EDIT = 3;
    private String m_DefaultFile = null;
    private Hashtable<String, String> m_FileMap = new Hashtable();
    private Vector<IPropertyElement> m_Elements = new Vector();
    private Vector<IPropertyDefinition> m_Definitions = new Vector();
    private IPropertyElementManager m_EleManager = new PropertyElementManager();
    private IPreferenceManagerEventDispatcher m_PreferenceManagerEventDispatcher = null;
    private String m_DefaultFont = null;
    private String m_DefaultDocFont = null;
    private boolean batchTestMode = false;
    private Vector<IPropertyElement> m_SavedElements = null;

    public PreferenceManager() {
        EventDispatchRetriever eventDispatchRetriever = EventDispatchRetriever.instance();
        Object t = eventDispatchRetriever.getDispatcher(EventDispatchNameKeeper.preferenceManager());
        if (t instanceof IPreferenceManagerEventDispatcher) {
            this.m_PreferenceManagerEventDispatcher = (IPreferenceManagerEventDispatcher)t;
        }
    }

    @Override
    public boolean isBatchTestMode() {
        return this.batchTestMode;
    }

    @Override
    public void setBatchTestMode(boolean bl) {
        this.batchTestMode = bl;
    }

    @Override
    public long registerFile(String string) {
        this.registerFile("Default", string);
        this.m_DefaultFile = string;
        return 0L;
    }

    @Override
    public long unregisterFile(String string) {
        this.unregisterFile("Default", string);
        return 0L;
    }

    @Override
    public boolean validateFile(String string) {
        return XMLManip.getDOMDocument(string) != null;
    }

    @Override
    public Vector<IPropertyDefinition> getPropertyDefinitions() {
        return this.m_Definitions;
    }

    @Override
    public void setPropertyDefinitions(IPropertyDefinition[] iPropertyDefinitionArray) {
        if (iPropertyDefinitionArray != null) {
            this.m_Definitions.clear();
            int n = iPropertyDefinitionArray.length;
            for (int i = 0; i < n; ++i) {
                this.m_Definitions.add(iPropertyDefinitionArray[i]);
            }
        }
    }

    @Override
    public IPropertyElement[] getPropertyElements() {
        return this.getElementsFromVector(this.m_Elements);
    }

    @Override
    public void setPropertyElements(IPropertyElement[] iPropertyElementArray) {
        if (this.m_Elements == null) {
            this.m_Elements = new Vector();
        }
        if (iPropertyElementArray != null) {
            for (int i = 0; i < iPropertyElementArray.length; ++i) {
                IPropertyElement iPropertyElement = iPropertyElementArray[i];
                this.m_Elements.add(iPropertyElement);
            }
        }
    }

    @Override
    public long buildPreferences(String string) {
        this.buildDefinitions(string);
        String string2 = this.getRelatedDataFile(string);
        if (string2 != null && string2.length() > 0 && this.validateFile(string2)) {
            this.buildElements(string2);
        }
        return 0L;
    }

    private void buildElements(String string) {
        if (this.m_EleManager != null) {
            this.m_EleManager.setElementFile(string);
            int n = this.m_Definitions.size();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                IPropertyDefinition iPropertyDefinition = this.m_Definitions.get(i);
                IPropertyElement[] iPropertyElementArray = this.m_EleManager.buildElementsUsingXMLFile(iPropertyDefinition);
                if (iPropertyElementArray == null) continue;
                for (int j = 0; j < iPropertyElementArray.length; ++j) {
                    this.m_Elements.add(iPropertyElementArray[j]);
                    ++n2;
                }
            }
        }
    }

    private void buildDefinitions(String string) {
        PropertyDefinitionFactory propertyDefinitionFactory = new PropertyDefinitionFactory();
        propertyDefinitionFactory.setDefinitionFile(string);
        this.m_Definitions = propertyDefinitionFactory.buildDefinitionsUsingFile();
    }

    @Override
    public long reloadPreferences() {
        if (this.m_DefaultFile != null) {
            this.unregisterFile(this.m_DefaultFile);
            this.m_Definitions = new Vector();
            this.m_Elements = new Vector();
            this.registerFile(this.m_DefaultFile);
        }
        return 0L;
    }

    @Override
    public long addBooleanPreference(IPreferenceObject iPreferenceObject) {
        this.addPreference(iPreferenceObject, 0);
        return 0L;
    }

    private void addPreference(IPreferenceObject iPreferenceObject, int n) {
        this.buildPreference(iPreferenceObject, n);
        this.save();
    }

    private void buildPreference(IPreferenceObject iPreferenceObject, int n) {
        String string;
        String string2;
        IPropertyDefinition iPropertyDefinition;
        String string3 = iPreferenceObject.getKey();
        if (string3.length() == 0) {
            string3 = "Default";
        }
        if ((iPropertyDefinition = this.getPreferenceDefinition(string3, string2 = iPreferenceObject.getHeading(), string = iPreferenceObject.getName())) != null) {
            IPropertyElement iPropertyElement = this.getPreferenceElement(string3, string2, string);
            if (iPropertyElement == null) {
                IPropertyDefinition iPropertyDefinition2 = null;
                IPropertyElement iPropertyElement2 = null;
                this.buildNecessaryStructures(string3, string2, iPropertyDefinition2, iPropertyElement2);
                if (iPropertyDefinition2 != null && iPropertyElement2 != null) {
                    this.createPreference(iPreferenceObject, n, string3, iPropertyDefinition2, iPropertyElement2);
                }
            }
        } else {
            IPropertyDefinition iPropertyDefinition3 = null;
            IPropertyElement iPropertyElement = null;
            this.buildNecessaryStructures(string3, string2, iPropertyDefinition3, iPropertyElement);
            if (iPropertyDefinition3 != null && iPropertyElement != null) {
                this.createPreference(iPreferenceObject, n, string3, iPropertyDefinition3, iPropertyElement);
            }
        }
    }

    private void createPreference(IPreferenceObject iPreferenceObject, int n, String string, IPropertyDefinition iPropertyDefinition, IPropertyElement iPropertyElement) {
        PropertyDefinitionXML propertyDefinitionXML = new PropertyDefinitionXML();
        this.loadDefinition(iPreferenceObject, n, string, propertyDefinitionXML);
        iPropertyDefinition.addSubDefinition(propertyDefinitionXML);
        PropertyElementXML propertyElementXML = new PropertyElementXML();
        String string2 = propertyDefinitionXML.getName();
        propertyElementXML.setName(string2);
        String string3 = this.getDefinitionFile(string);
        String string4 = this.getRelatedDataFile(string3);
        String string5 = iPreferenceObject.getDefaultValue();
        if (string5 == null || string5.length() == 0) {
            string5 = " ";
        }
        propertyElementXML.setValue(string5);
        propertyElementXML.setPropertyDefinition(propertyDefinitionXML);
        propertyElementXML.setModified(true);
        propertyElementXML.setPropertyElementManager(this.m_EleManager);
        iPropertyElement.addSubElement(propertyElementXML);
    }

    private void loadDefinition(IPreferenceObject iPreferenceObject, int n, String string, IPropertyDefinitionXML iPropertyDefinitionXML) {
        String string2 = iPreferenceObject.getName();
        String string3 = iPreferenceObject.getDisplayName();
        if (string3 == null || string3.length() == 0) {
            string3 = string2;
        }
        String string4 = this.getControlTypeAsString(n);
        String string5 = this.getDefinitionFile(string);
        iPropertyDefinitionXML.setName(string2);
        iPropertyDefinitionXML.setDisplayName(string3);
        if (string4 != null && string4.length() > 0) {
            iPropertyDefinitionXML.setControlType(string4);
            iPropertyDefinitionXML.setRequired(false);
            iPropertyDefinitionXML.setForceRefersh(false);
            iPropertyDefinitionXML.setMultiplicity(1L);
            String string6 = iPreferenceObject.getValues();
            iPropertyDefinitionXML.setValidValues(string6);
        }
        iPropertyDefinitionXML.setModified(true);
        iPropertyDefinitionXML.setFile(string5);
    }

    private void buildNecessaryStructures(String string, String string2, IPropertyDefinition iPropertyDefinition, IPropertyElement iPropertyElement) {
        Object object;
        String string3;
        IPropertyDefinition iPropertyDefinition2 = this.getRootDefinition(string);
        if (iPropertyDefinition2 == null) {
            iPropertyDefinition2 = new PropertyDefinitionXML();
            iPropertyDefinition2.setName(string);
            iPropertyDefinition2.setDisplayName(string);
            iPropertyDefinition2.setModified(true);
            string3 = this.getDefinitionFile(string);
            ((IPropertyDefinitionXML)iPropertyDefinition2).setFile(string3);
            this.m_Definitions.add(iPropertyDefinition2);
        } else {
            string3 = "";
        }
        IPropertyElement iPropertyElement2 = this.getRootElement(string);
        if (iPropertyElement2 == null) {
            iPropertyElement2 = new PropertyElementXML();
            iPropertyElement2.setPropertyDefinition(iPropertyDefinition2);
            iPropertyElement2.setName(string);
            iPropertyElement2.setModified(true);
            object = this.getRelatedDataFile(string3);
            iPropertyElement2.setPropertyElementManager(this.m_EleManager);
            this.m_Elements.add(iPropertyElement2);
        }
        if (iPropertyDefinition2 != null && iPropertyElement2 != null) {
            String[] stringArray;
            object = null;
            IPropertyElement iPropertyElement3 = null;
            Object object2 = iPropertyDefinition2;
            Object object3 = iPropertyElement2;
            if (string2.length() > 0 && (stringArray = string2.split("\\|")) != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    Object object4;
                    object = object2;
                    iPropertyElement3 = object3;
                    String string4 = stringArray[i];
                    IPropertyDefinition iPropertyDefinition3 = this.getDefinition((IPropertyDefinition)object, string4);
                    IPropertyElement iPropertyElement4 = this.getElement(iPropertyElement3, string4);
                    String string5 = this.getDefinitionFile(string);
                    if (iPropertyDefinition3 == null) {
                        object4 = new PropertyDefinitionXML();
                        object4.setName(string4);
                        object4.setDisplayName(string4);
                        object4.setModified(true);
                        ((IPropertyDefinitionXML)object4).setFile(string5);
                        object.addSubDefinition((IPropertyDefinition)object4);
                        object2 = object4;
                    } else {
                        object2 = iPropertyDefinition3;
                    }
                    if (iPropertyElement4 == null) {
                        object4 = new PropertyElementXML();
                        object4.setName(string4);
                        object4.setModified(true);
                        String string6 = this.getRelatedDataFile(string5);
                        object4.setPropertyElementManager(this.m_EleManager);
                        object4.setPropertyDefinition((IPropertyDefinition)object2);
                        iPropertyElement3.addSubElement((IPropertyElement)object4);
                        object3 = object4;
                        continue;
                    }
                    object3 = iPropertyElement4;
                }
            }
            if (object2 != null) {
                iPropertyDefinition = object2;
            }
            if (object3 != null) {
                iPropertyElement = object3;
            }
        }
    }

    private IPropertyDefinition getRootDefinition(String string) {
        for (int i = 0; i < this.m_Definitions.size(); ++i) {
            IPropertyDefinition iPropertyDefinition = this.m_Definitions.elementAt(i);
            if (!iPropertyDefinition.getName().equals(string)) continue;
            return iPropertyDefinition;
        }
        return null;
    }

    private IPropertyElement getRootElement(String string) {
        for (int i = 0; i < this.m_Elements.size(); ++i) {
            IPropertyElement iPropertyElement = this.m_Elements.elementAt(i);
            if (!iPropertyElement.getName().equals(string)) continue;
            return iPropertyElement;
        }
        return null;
    }

    private String getControlTypeAsString(int n) {
        switch (n) {
            case 0: {
                return "list";
            }
            case 1: {
                return "list";
            }
            case 2: {
                return "combo";
            }
            case 3: {
                return "edit";
            }
        }
        return "";
    }

    @Override
    public long removePreference(IPropertyElement iPropertyElement) {
        String string = iPropertyElement.getPath();
        if (this.m_Elements != null) {
            for (int i = 0; i < this.m_Elements.size(); ++i) {
                IPropertyElement iPropertyElement2 = this.m_Elements.elementAt(i);
                String string2 = iPropertyElement2.getPath();
                if (string2.equals(string)) {
                    this.firePreferenceRemove(iPropertyElement2);
                    this.m_Elements.remove(iPropertyElement2);
                    break;
                }
                this.removePreference(iPropertyElement2, iPropertyElement);
            }
        }
        return 0L;
    }

    private void removePreference(IPropertyElement iPropertyElement, IPropertyElement iPropertyElement2) {
        String string = iPropertyElement2.getPath();
        Vector<IPropertyElement> vector = iPropertyElement.getSubElements();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                IPropertyElement iPropertyElement3 = vector.elementAt(i);
                String string2 = iPropertyElement3.getPath();
                if (string2.equals(string)) {
                    this.firePreferenceRemove(iPropertyElement3);
                    vector.remove(iPropertyElement3);
                    break;
                }
                this.removePreference(iPropertyElement3, iPropertyElement2);
            }
        }
    }

    @Override
    public long registerFile(String string, String string2) {
        String string3;
        if (this.validateFile(string2) && (string3 = this.m_FileMap.get(string)) == null) {
            this.m_FileMap.put(string, string2);
            File file = new File(string2);
            if (file.exists()) {
                this.buildPreferences(string2);
            }
        }
        return 0L;
    }

    private boolean canWrite(String string) {
        File file = new File(string);
        return file.canWrite();
    }

    @Override
    public long unregisterFile(String string, String string2) {
        if (this.m_FileMap.get(string) != null) {
            this.m_FileMap.remove(string);
        }
        return 0L;
    }

    @Override
    public long addListPreference(IPreferenceObject iPreferenceObject) {
        this.addPreference(iPreferenceObject, 1);
        return 0L;
    }

    @Override
    public long addComboPreference(IPreferenceObject iPreferenceObject) {
        this.addPreference(iPreferenceObject, 2);
        return 0L;
    }

    @Override
    public long addEditPreference(IPreferenceObject iPreferenceObject) {
        this.addPreference(iPreferenceObject, 3);
        return 0L;
    }

    @Override
    public String getPreferenceValue(String string, String string2) {
        return this.getPreferenceValue("Default", string, string2);
    }

    @Override
    public String getPreferenceValue(String string) {
        int n = string.lastIndexOf(124);
        int n2 = string.indexOf(124);
        if (n2 != -1 && n != -1 && n2 != n) {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1, n);
            String string4 = string.substring(n + 1);
            return this.getPreferenceValue(string2, string3, string4);
        }
        return null;
    }

    @Override
    public String getPreferenceValue(String string, String string2, String string3) {
        IPropertyElement iPropertyElement = this.getPreferenceElement(string, string2, string3);
        return iPropertyElement != null ? iPropertyElement.getValue() : "";
    }

    @Override
    public long save() {
        this.saveDefinitions();
        this.saveElements();
        return 0L;
    }

    private void saveElements() {
        if (this.m_SavedElements == null) {
            this.m_SavedElements = new Vector();
        }
        if (this.m_Elements != null && this.m_Elements.size() > 0) {
            int n;
            boolean bl = true;
            int n2 = this.m_Elements.size();
            for (n = 0; n < n2; ++n) {
                IPropertyElementXML iPropertyElementXML;
                String string;
                String string2;
                String string3;
                Document document;
                IPropertyElement iPropertyElement = this.m_Elements.get(n);
                if (!(iPropertyElement instanceof IPropertyElementXML) || (document = XMLManip.getDOMDocument(string3 = this.getRelatedDataFile(string2 = this.getDefinitionFile(string = (iPropertyElementXML = (IPropertyElementXML)iPropertyElement).getName())))) == null) continue;
                if (iPropertyElementXML.getModified()) {
                    if (iPropertyElementXML.save(document)) {
                        this.firePreferenceChange(iPropertyElementXML);
                        this.m_SavedElements.add(iPropertyElementXML);
                    } else {
                        bl = false;
                        break;
                    }
                }
                if (this.saveSubElements(document, iPropertyElementXML)) {
                    XMLManip.save(document, string3);
                    continue;
                }
                bl = false;
                break;
            }
            if (bl && this.m_SavedElements != null && (n = this.m_SavedElements.size()) > 0) {
                this.firePreferencesChange(this.m_SavedElements);
                this.m_SavedElements.removeAllElements();
            }
        }
    }

    private void firePreferencesChange(Vector<IPropertyElement> vector) {
        DispatchHelper dispatchHelper = new DispatchHelper();
        IPreferenceManagerEventDispatcher iPreferenceManagerEventDispatcher = dispatchHelper.getPreferenceManagerDispatcher();
        if (iPreferenceManagerEventDispatcher != null) {
            IEventPayload iEventPayload = iPreferenceManagerEventDispatcher.createPayload("PreferencesChange");
            IPropertyElement[] iPropertyElementArray = this.getElementsFromVector(vector);
            iPreferenceManagerEventDispatcher.firePreferencesChange(iPropertyElementArray, iEventPayload);
        }
    }

    private IPropertyElement[] getElementsFromVector(Vector<IPropertyElement> vector) {
        IPropertyElement[] iPropertyElementArray = new IPropertyElement[vector.size()];
        vector.toArray(iPropertyElementArray);
        return iPropertyElementArray;
    }

    private void firePreferenceChange(IPropertyElement iPropertyElement) {
        DispatchHelper dispatchHelper = new DispatchHelper();
        IPreferenceManagerEventDispatcher iPreferenceManagerEventDispatcher = dispatchHelper.getPreferenceManagerDispatcher();
        if (iPreferenceManagerEventDispatcher != null) {
            iPreferenceManagerEventDispatcher.firePreferenceChange(iPropertyElement.getName(), iPropertyElement, iPreferenceManagerEventDispatcher.createPayload("PreferenceChange"));
        }
    }

    private void firePreferenceRemove(IPropertyElement iPropertyElement) {
        DispatchHelper dispatchHelper = new DispatchHelper();
        IPreferenceManagerEventDispatcher iPreferenceManagerEventDispatcher = dispatchHelper.getPreferenceManagerDispatcher();
        if (iPreferenceManagerEventDispatcher != null) {
            iPreferenceManagerEventDispatcher.firePreferenceRemove(iPropertyElement.getName(), iPropertyElement, iPreferenceManagerEventDispatcher.createPayload("PreferenceRemove"));
        }
    }

    private String getRelatedDataFile(String string) {
        String string2 = StringUtilities.getPath(string);
        String string3 = StringUtilities.getFileName(string);
        return StringUtilities.createFullPath(string2, string3, ".etcd");
    }

    private String getDefinitionFile(String string) {
        String string2 = this.m_FileMap.get(string);
        if (string2 == null) {
            string2 = this.m_FileMap.get("Default");
        }
        return string2;
    }

    private boolean saveSubElements(Document document, IPropertyElementXML iPropertyElementXML) {
        boolean bl = true;
        Vector<IPropertyElement> vector = iPropertyElementXML.getSubElements();
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                IPropertyElement iPropertyElement = vector.get(i);
                if (!(iPropertyElement instanceof IPropertyElementXML)) continue;
                IPropertyElementXML iPropertyElementXML2 = (IPropertyElementXML)iPropertyElement;
                if (iPropertyElementXML2.getModified()) {
                    if (iPropertyElementXML2.save(document)) {
                        this.firePreferenceChange(iPropertyElementXML2);
                        this.m_SavedElements.add(iPropertyElementXML2);
                    } else {
                        bl = false;
                        break;
                    }
                }
                if (!(bl = this.saveSubElements(document, iPropertyElementXML2))) break;
            }
        }
        return bl;
    }

    private void saveDefinitions() {
        if (this.m_Definitions != null && this.m_Definitions.size() > 0) {
            int n = this.m_Definitions.size();
            for (int i = 0; i < n; ++i) {
                IPropertyDefinition iPropertyDefinition = this.m_Definitions.get(i);
                if (!(iPropertyDefinition instanceof IPropertyDefinition)) continue;
                IPropertyDefinition iPropertyDefinition2 = iPropertyDefinition;
                if (iPropertyDefinition2.isModified()) {
                    iPropertyDefinition2.save();
                }
                this.saveSubDefinitions(iPropertyDefinition2);
            }
        }
    }

    private void saveSubDefinitions(IPropertyDefinition iPropertyDefinition) {
        Vector vector = iPropertyDefinition.getSubDefinitions();
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.get(i);
                if (!(e instanceof IPropertyDefinition)) continue;
                IPropertyDefinition iPropertyDefinition2 = (IPropertyDefinition)e;
                if (iPropertyDefinition2.isModified()) {
                    iPropertyDefinition2.save();
                }
                this.saveSubDefinitions(iPropertyDefinition2);
            }
        }
    }

    @Override
    public long setPreferenceValue(String string, String string2, String string3) {
        this.setPreferenceValue("Default", string, string2, string3);
        return 0L;
    }

    @Override
    public long setPreferenceValue(String string, String string2, String string3, String string4) {
        IPropertyElement iPropertyElement = this.getPreferenceElement(string, string2, string3);
        if (iPropertyElement != null) {
            this.setPreferenceValue(iPropertyElement, string4);
        }
        return 0L;
    }

    @Override
    public long setPreferenceValue(IPropertyElement iPropertyElement, String string) {
        String string2;
        String string3 = string2 = iPropertyElement != null ? iPropertyElement.getValue() : "";
        if (string2 == null || !string2.equals(string)) {
            iPropertyElement.setValue(string);
            iPropertyElement.setModified(true);
            this.save();
        }
        return 0L;
    }

    @Override
    public IPropertyElement getPreferenceElement(String string, String string2) {
        return this.getPreferenceElement("Default", string, string2);
    }

    @Override
    public IPropertyElement getPreferenceElement(String string, String string2, String string3) {
        IPropertyElement iPropertyElement = null;
        IPropertyElement iPropertyElement2 = this.getRootElement(string);
        if (iPropertyElement2 != null) {
            if (string2.length() > 0) {
                IPropertyElement iPropertyElement3 = iPropertyElement2;
                if (string2.indexOf("|") >= 0) {
                    String[] stringArray = string2.split("\\|");
                    if (stringArray != null && stringArray.length > 0) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            IPropertyElement iPropertyElement4;
                            if (iPropertyElement3 == null) continue;
                            iPropertyElement3 = iPropertyElement4 = this.getElement(iPropertyElement3, stringArray[i]);
                        }
                        if (iPropertyElement3 != null) {
                            iPropertyElement = this.getElement(iPropertyElement3, string3);
                        }
                    }
                } else {
                    iPropertyElement3 = this.getElement(iPropertyElement2, string2);
                    iPropertyElement = this.getElement(iPropertyElement3, string3);
                }
            } else {
                iPropertyElement = string3.length() > 0 ? this.getElement(iPropertyElement2, string3) : iPropertyElement2;
            }
        }
        return iPropertyElement;
    }

    private IPropertyElement getElement(IPropertyElement iPropertyElement, String string) {
        IPropertyElement iPropertyElement2 = null;
        if (iPropertyElement != null) {
            String string2 = iPropertyElement.getName();
            if (string2.equals(string)) {
                iPropertyElement2 = iPropertyElement;
            } else {
                Vector<IPropertyElement> vector = iPropertyElement.getSubElements();
                if (vector != null) {
                    for (int i = 0; i < vector.size(); ++i) {
                        IPropertyElement iPropertyElement3 = vector.elementAt(i);
                        if (!iPropertyElement3.getName().equals(string)) continue;
                        iPropertyElement2 = iPropertyElement3;
                        break;
                    }
                }
            }
        }
        return iPropertyElement2;
    }

    @Override
    public IPropertyDefinition getPreferenceDefinition(String string, String string2) {
        return this.getPreferenceDefinition("Default", string, string2);
    }

    @Override
    public IPropertyDefinition getPreferenceDefinition(String string, String string2, String string3) {
        IPropertyDefinition iPropertyDefinition = null;
        IPropertyDefinition iPropertyDefinition2 = this.getRootDefinition(string);
        if (iPropertyDefinition2 != null) {
            if (string2.length() > 0) {
                IPropertyDefinition iPropertyDefinition3 = iPropertyDefinition2;
                String[] stringArray = string2.split("\\|");
                if (stringArray != null && stringArray.length > 0) {
                    IPropertyDefinition iPropertyDefinition4;
                    for (int i = 0; i < stringArray.length; ++i) {
                        IPropertyDefinition iPropertyDefinition5;
                        if (iPropertyDefinition3 == null) continue;
                        iPropertyDefinition3 = iPropertyDefinition5 = this.getDefinition(iPropertyDefinition3, stringArray[i]);
                    }
                    if (iPropertyDefinition3 != null && (iPropertyDefinition4 = this.getDefinition(iPropertyDefinition3, string3)) != null) {
                        iPropertyDefinition = iPropertyDefinition4;
                    }
                }
            } else if (string3.length() > 0) {
                IPropertyDefinition iPropertyDefinition6 = this.getDefinition(iPropertyDefinition2, string3);
                if (iPropertyDefinition6 != null) {
                    iPropertyDefinition = iPropertyDefinition6;
                }
            } else {
                iPropertyDefinition = iPropertyDefinition2;
            }
        }
        return iPropertyDefinition;
    }

    private IPropertyDefinition getDefinition(IPropertyDefinition iPropertyDefinition, String string) {
        IPropertyDefinition iPropertyDefinition2 = null;
        String string2 = iPropertyDefinition.getName();
        if (string2.equals(string)) {
            iPropertyDefinition2 = iPropertyDefinition;
        } else {
            Vector vector = iPropertyDefinition.getSubDefinitions();
            if (vector != null && vector.size() > 0) {
                for (int i = 0; i < vector.size(); ++i) {
                    IPropertyDefinition iPropertyDefinition3 = (IPropertyDefinition)vector.elementAt(i);
                    if (!string.equals(iPropertyDefinition3.getName())) continue;
                    iPropertyDefinition2 = iPropertyDefinition3;
                    break;
                }
            }
        }
        return iPropertyDefinition2;
    }

    @Override
    public String getTranslatedPreferenceValue(String string, String string2) {
        return this.getTranslatedPreferenceValue("Default", string, string2);
    }

    @Override
    public String getTranslatedPreferenceValue(String string, String string2, String string3) {
        IPropertyElement iPropertyElement = this.getPreferenceElement(string, string2, string3);
        return iPropertyElement != null ? iPropertyElement.getTranslatedValue() : "";
    }

    @Override
    public boolean matches(String string, String string2, String string3) {
        return this.matches("Default", string, string2, string3);
    }

    @Override
    public boolean matches(String string, String string2, String string3, String string4) {
        String string5 = this.getPreferenceValue(string, string2, string3);
        return string5 != null && string5.equals(string4);
    }

    @Override
    public long restore() {
        if (this.m_Elements != null) {
            this.restoreElements(this.m_Elements, false);
        }
        return 0L;
    }

    private void restoreElements(Vector vector, boolean bl) {
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Vector<IPropertyElement> vector2;
                boolean bl2;
                IPropertyElement iPropertyElement = (IPropertyElement)vector.elementAt(i);
                IPropertyDefinition iPropertyDefinition = iPropertyElement.getPropertyDefinition();
                if (iPropertyDefinition != null && (bl2 = iPropertyDefinition.isDefaultExisting())) {
                    String string = iPropertyDefinition.getDefaultValue();
                    if (string.length() == 0 && !bl) {
                        string = iPropertyDefinition.getValidValues2();
                    }
                    iPropertyElement.setValue(string);
                    iPropertyElement.setModified(true);
                }
                if ((vector2 = iPropertyElement.getSubElements()) == null) continue;
                this.restoreElements(vector2, bl);
            }
        }
    }

    @Override
    public String getDefaultFont() {
        return "Arial";
    }

    @Override
    public String getDefaultDocFont() {
        return "Arial";
    }

    @Override
    public long restoreForInstall() {
        if (this.m_Elements != null) {
            this.restoreElements(this.m_Elements, true);
        }
        return 0L;
    }

    @Override
    public IPropertyElement findElement(IPropertyElement iPropertyElement, String string) {
        IPropertyElement iPropertyElement2 = null;
        String string2 = iPropertyElement.getName();
        if (string2.equals(string)) {
            iPropertyElement2 = iPropertyElement;
        } else {
            Vector<IPropertyElement> vector = iPropertyElement.getSubElements();
            if (vector != null) {
                IPropertyElement iPropertyElement3;
                int n;
                for (n = 0; n < vector.size(); ++n) {
                    iPropertyElement3 = vector.elementAt(n);
                    if (!string.equals(iPropertyElement3.getName())) continue;
                    iPropertyElement2 = iPropertyElement3;
                    break;
                }
                if (iPropertyElement2 == null) {
                    for (n = 0; n < vector.size() && iPropertyElement2 == null; ++n) {
                        iPropertyElement3 = vector.elementAt(n);
                        iPropertyElement2 = this.findElement(iPropertyElement3, string);
                    }
                }
            }
        }
        return iPropertyElement2;
    }

    @Override
    public boolean isEditable(IPropertyElement iPropertyElement) {
        return this.canWrite(this.m_EleManager.getElementFile());
    }

    @Override
    public String getPreferenceValueWithFullPath(String string) {
        String string2;
        int n;
        if (string != null && string.length() > 0 && (n = (string2 = string).indexOf(124)) > -1) {
            String string3 = string2.substring(0, n);
            int n2 = string2.lastIndexOf(124);
            if (n2 > -1) {
                String string4 = string2.substring(n2 + 1);
                String string5 = string2.substring(n + 1, n2);
                if (string3.length() > 0 && string4.length() > 0 && string5.length() > 0) {
                    return this.getPreferenceValue(string3, string5, string4);
                }
            }
        }
        return "";
    }
}

