/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.requirementsframework;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.uml.core.requirementsframework.IRequirementSource;
import org.netbeans.modules.uml.core.requirementsframework.IRequirementsManager;
import org.netbeans.modules.uml.core.requirementsframework.IRequirementsProvider;
import org.netbeans.modules.uml.core.requirementsframework.RequirementsException;
import org.netbeans.modules.uml.core.support.umlmessagingcore.UMLMessagingHelper;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class RequirementProviderPanel
extends JPanel {
    private IRequirementsManager m_Manager = null;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;

    public RequirementProviderPanel(IRequirementsManager iRequirementsManager) {
        this.initComponents();
        this.m_Manager = iRequirementsManager;
        IRequirementsProvider[] iRequirementsProviderArray = iRequirementsManager.getAddIns();
        DefaultComboBoxModel<IRequirementsProvider> defaultComboBoxModel = new DefaultComboBoxModel<IRequirementsProvider>(iRequirementsProviderArray);
        this.jComboBox1.setModel(defaultComboBoxModel);
        ProviderCellRenderer providerCellRenderer = new ProviderCellRenderer();
        this.jComboBox1.setRenderer(providerCellRenderer);
        this.updateState();
    }

    public void process() {
        IRequirementsProvider iRequirementsProvider = (IRequirementsProvider)this.jComboBox1.getSelectedItem();
        try {
            IRequirementSource iRequirementSource = iRequirementsProvider.displaySources();
            if (iRequirementSource != null && this.m_Manager instanceof IRequirementsManager) {
                IRequirementsManager iRequirementsManager = this.m_Manager;
                iRequirementsManager.processSource(iRequirementSource);
            }
        }
        catch (RequirementsException requirementsException) {
            UMLMessagingHelper uMLMessagingHelper = new UMLMessagingHelper();
            uMLMessagingHelper.sendExceptionMessage(requirementsException);
        }
    }

    private IRequirementsManager getManager() {
        return this.m_Manager;
    }

    private void updateState() {
        IRequirementsProvider iRequirementsProvider = (IRequirementsProvider)this.jComboBox1.getSelectedItem();
        this.jTextArea1.setText(iRequirementsProvider.getDescription());
    }

    private void initComponents() {
        this.jComboBox1 = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                RequirementProviderPanel.this.jComboBox1ItemStateChanged(itemEvent);
            }
        });
        this.jComboBox1.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/uml/core/requirementsframework/Bundle").getString("ACSN_Requirement_Provider_Name"));
        this.jComboBox1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RequirementProviderPanel.class, (String)"ACSD_Requirement_Provider_Name"));
        this.jComboBox1.getAccessibleContext().setAccessibleParent(this);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jTextArea1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RequirementProviderPanel.class, (String)"ACSN_Requirement_Provider_Description"));
        this.jTextArea1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RequirementProviderPanel.class, (String)"ACSD_Requirement_Provider_Description"));
        this.jLabel1.setLabelFor(this.jComboBox1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RequirementProviderPanel.class, (String)"LBL_RequirementProviderPanel_Providers"));
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RequirementProviderPanel.class, (String)"ACSN_Requirement_Provider_Name"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/uml/core/requirementsframework/Bundle").getString("ACSD_Requirement_Provider_Name"));
        this.jLabel1.getAccessibleContext().setAccessibleParent(this);
        this.jLabel2.setLabelFor(this.jTextArea1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(RequirementProviderPanel.class, (String)"LBL_RequirementProviderPanel_ProviderDescritpion"));
        this.jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RequirementProviderPanel.class, (String)"ACSN_Requirement_Provider_Description"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RequirementProviderPanel.class, (String)"ACSD_Requirement_Provider_Description"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 349, Short.MAX_VALUE).add((Component)this.jComboBox1, 0, 349, Short.MAX_VALUE).add((Component)this.jLabel1).add((Component)this.jLabel2)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jComboBox1, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 170, -2).addContainerGap()));
    }

    private void jComboBox1ItemStateChanged(ItemEvent itemEvent) {
        this.updateState();
    }

    private static class ProviderCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public ProviderCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof IRequirementsProvider) {
                this.setText(((IRequirementsProvider)object).getDisplayName());
            } else {
                this.setText(object == null ? " " : object.toString());
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }
}

