/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.requirementsframework;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IConfigManager;
import org.netbeans.modules.uml.core.requirementsframework.IRequirement;
import org.netbeans.modules.uml.core.requirementsframework.IRequirementSource;
import org.netbeans.modules.uml.core.requirementsframework.IRequirementsManager;
import org.netbeans.modules.uml.core.requirementsframework.IRequirementsProvider;
import org.netbeans.modules.uml.core.requirementsframework.ISatisfier;
import org.netbeans.modules.uml.core.requirementsframework.RequirementSource;
import org.netbeans.modules.uml.core.requirementsframework.RequirementsException;
import org.netbeans.modules.uml.core.support.umlsupport.ProductRetriever;
import org.netbeans.modules.uml.core.support.umlsupport.XMLManip;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class RequirementsManager
implements IRequirementsManager {
    private ResourceBundle m_Bundle = ResourceBundle.getBundle("org/netbeans/modules/uml/core/requirementsframework/Bundle");
    protected Document m_ReqProxyDoc;
    protected String m_ReqSourcesFile;
    protected String m_ReqProxyFile;
    private Document m_ReqSourcesDoc;
    private HashMap<String, IRequirementsProvider> mAddins = new HashMap();

    public RequirementsManager() {
        this.initialize();
    }

    public void initialize() {
        IRequirementsProvider[] iRequirementsProviderArray;
        for (IRequirementsProvider iRequirementsProvider : iRequirementsProviderArray = this.getAddinsFromRegistry("UML/requirements")) {
            String string = iRequirementsProvider.getProgID();
            this.mAddins.put(string, iRequirementsProvider);
        }
    }

    public IRequirementsProvider[] getAddIns() {
        IRequirementsProvider[] iRequirementsProviderArray = null;
        Collection<IRequirementsProvider> collection = this.mAddins.values();
        if (collection.size() > 0) {
            iRequirementsProviderArray = new IRequirementsProvider[collection.size()];
            collection.toArray(iRequirementsProviderArray);
        } else {
            iRequirementsProviderArray = new IRequirementsProvider[]{};
        }
        return iRequirementsProviderArray;
    }

    public IRequirementsProvider getRequirementsProvider(String string) {
        IRequirementsProvider iRequirementsProvider = this.mAddins.get(string);
        return iRequirementsProvider;
    }

    public void processSource(IRequirementSource iRequirementSource) throws RequirementsException {
        boolean bl = this.getReqSourcesDoc();
        if (this.m_ReqSourcesDoc != null) {
            if (!bl) {
                this.initializeReqSourcesDoc(this.m_ReqSourcesDoc);
            }
            String string = iRequirementSource.getLocation();
            String string2 = "RequirementSources/RequirementSource[@location='" + string + "']";
            Node node = XMLManip.selectSingleNode((Node)this.m_ReqSourcesDoc, string2);
            if (node != null) {
                throw new RequirementsException(1, this.m_Bundle.getString("IDS_DUPLICATESOURCE"));
            }
            String string3 = iRequirementSource.getDisplayName();
            string2 = "RequirementSources/RequirementSource[@displayName='" + string3 + "']";
            node = XMLManip.selectSingleNode((Node)this.m_ReqSourcesDoc, string2);
            if (node != null) {
                throw new RequirementsException(1, this.m_Bundle.getString("IDS_DUPLICATESOURCE"));
            }
            Element element = this.convertReqSourceToXMLElement(this.m_ReqSourcesDoc, iRequirementSource);
            if (element != null) {
                this.saveReqSourcesDoc();
            }
        }
    }

    public IRequirementSource getSource(String string) {
        RequirementSource requirementSource = null;
        boolean bl = this.getReqSourcesDoc();
        if (this.m_ReqSourcesDoc != null) {
            if (!bl) {
                this.initializeReqSourcesDoc(this.m_ReqSourcesDoc);
            }
            String string2 = "RequirementSources/RequirementSource[@id='";
            string2 = string2 + string;
            Node node = this.m_ReqSourcesDoc.selectSingleNode(string2 = string2 + "']");
            if (node != null) {
                Element element;
                String string3;
                requirementSource = new RequirementSource();
                requirementSource.setID(string);
                if (node instanceof Element && (string3 = (element = (Element)node).attributeValue("location")) != null) {
                    requirementSource.setLocation(string3);
                }
            }
        }
        return requirementSource;
    }

    public void processProxy(IRequirement iRequirement, ISatisfier iSatisfier) {
        String string = iRequirement.getSourceID();
        String string2 = iRequirement.getID();
        String string3 = iRequirement.getName();
        String string4 = iSatisfier.getXMIID();
        String string5 = iSatisfier.getName();
        String string6 = iSatisfier.getProjectName();
        String string7 = iSatisfier.getProjectID();
        boolean bl = this.getReqProxyDoc();
        if (this.m_ReqProxyDoc != null) {
            if (!bl) {
                Element element;
                Element element2 = XMLManip.createElement(this.m_ReqProxyDoc, "RequirementProxies");
                if (element2 != null && (element = XMLManip.createElement(element2, "RequirementProxy")) != null) {
                    element.addAttribute("source", string);
                    Element element3 = XMLManip.createElement(element, "Requirement");
                    if (element3 != null) {
                        Element element4;
                        element3.addAttribute("id", string2);
                        element3.addAttribute("name", string3);
                        Element element5 = XMLManip.createElement(element3, "Satisfiers");
                        if (element5 != null && (element4 = XMLManip.createElement(element5, "Satisfier")) != null) {
                            element4.addAttribute("name", string5);
                            element4.addAttribute("xmiid", string4);
                            element4.addAttribute("projectname", string6);
                            element4.addAttribute("projectid", string7);
                        }
                    }
                }
                this.updateProxyFileLocation(string);
            } else {
                Element element;
                Element element6 = this.findOrCreateElement((Node)this.m_ReqProxyDoc, "RequirementProxies", "", "");
                if (element6 != null && (element = this.findOrCreateElement((Node)element6, "RequirementProxy", "source", string)) != null) {
                    element.addAttribute("source", string);
                    Element element7 = this.findOrCreateElement((Node)element, "Requirement", "id", string2);
                    if (element7 != null) {
                        Element element8;
                        element7.addAttribute("id", string2);
                        element7.addAttribute("name", string3);
                        Element element9 = this.findOrCreateElement((Node)element7, "Satisfiers", "", "");
                        if (element9 != null && (element8 = this.findOrCreateElement((Node)element9, "Satisfier", "xmiid", string4)) != null) {
                            element8.addAttribute("name", string5);
                            element8.addAttribute("xmiid", string4);
                            element8.addAttribute("projectname", string6);
                            element8.addAttribute("projectid", string7);
                        }
                    }
                }
            }
            XMLManip.save(this.m_ReqProxyDoc, this.m_ReqProxyFile);
        }
    }

    public void deleteProxy(IRequirement iRequirement, ISatisfier iSatisfier) {
        String string = iRequirement.getSourceID();
        String string2 = iRequirement.getID();
        String string3 = iSatisfier.getXMIID();
        boolean bl = this.getReqProxyDoc();
        if (this.m_ReqProxyDoc != null && bl) {
            String string4 = "RequirementProxies/RequirementProxy[@source='";
            string4 = string4 + string;
            Node node = this.m_ReqProxyDoc.selectSingleNode(string4 = string4 + "']");
            if (node != null) {
                Node node2;
                string4 = "Requirement[@id='";
                string4 = string4 + string2;
                Node node3 = node.selectSingleNode(string4 = string4 + "']");
                if (node3 != null && (node2 = node3.selectSingleNode(string4 = "Satisfiers")) != null) {
                    string4 = "Satisfier[@xmiid=\"";
                    string4 = string4 + string3;
                    Node node4 = node2.selectSingleNode(string4 = string4 + "\"]");
                    if (node4 != null) {
                        node4.detach();
                        XMLManip.save(this.m_ReqProxyDoc, this.m_ReqProxyFile);
                    }
                }
            }
        }
    }

    protected boolean getReqSourcesDoc() {
        boolean bl = true;
        if (null == this.m_ReqSourcesDoc) {
            String string = this.getReqSourcesFile();
            this.m_ReqSourcesDoc = XMLManip.getDOMDocument(string);
            if (this.m_ReqSourcesDoc == null) {
                this.m_ReqSourcesDoc = XMLManip.getDOMDocument();
                bl = false;
            }
        }
        return bl;
    }

    protected boolean getReqProxyDoc() {
        boolean bl = true;
        if (null == this.m_ReqProxyDoc) {
            String string = "";
            if (this.m_ReqProxyFile != null && this.m_ReqProxyFile.length() > 0) {
                string = this.m_ReqProxyFile;
            } else {
                String string2 = this.getConfigDir();
                if (string2.length() > 0) {
                    this.m_ReqProxyFile = string = string2 + "RequirementSources.etrp";
                }
            }
            this.m_ReqProxyDoc = XMLManip.getDOMDocument(string);
            if (this.m_ReqProxyDoc == null) {
                this.m_ReqProxyDoc = XMLManip.getDOMDocument();
                if (this.m_ReqProxyDoc.getRootElement() != null) {
                    this.m_ReqProxyDoc.getRootElement().detach();
                }
                bl = false;
            }
        }
        return bl;
    }

    protected void updateProxyFileLocation(String string) {
        boolean bl;
        if (this.m_ReqSourcesDoc != null && (bl = this.getReqSourcesDoc())) {
            Element element;
            String string2 = "RequirementSources/RequirementSource";
            string2 = string2 + "[@id='";
            string2 = string2 + string;
            Node node = this.m_ReqSourcesDoc.selectSingleNode(string2 = string2 + "']");
            if (node instanceof Element && (element = (Element)node) != null) {
                element.addAttribute("proxyFile", this.m_ReqProxyFile);
                this.saveReqSourcesDoc();
            }
        }
    }

    protected void initializeReqSourcesDoc(Document document) {
        if (null == document) {
            throw new IllegalArgumentException();
        }
        Element element = document.getRootElement();
        if (element != null) {
            element.detach();
        }
        Element element2 = XMLManip.createElement(document, "RequirementSources");
    }

    protected String getReqSourcesFile() {
        String string = "";
        if (this.m_ReqSourcesFile != null && this.m_ReqSourcesFile.length() > 0) {
            string = this.m_ReqSourcesFile;
        } else {
            String string2 = this.getConfigDir();
            if (string2.length() > 0) {
                string = string2 + "RequirementSources.etd";
            }
        }
        return string;
    }

    protected String getConfigDir() {
        String string;
        IConfigManager iConfigManager;
        String string2 = "";
        ICoreProduct iCoreProduct = ProductRetriever.retrieveProduct();
        if (iCoreProduct != null && (iConfigManager = iCoreProduct.getConfigManager()) != null && (string = iConfigManager.getDefaultConfigLocation()) != null) {
            string2 = string;
        }
        return string2;
    }

    protected Element convertReqSourceToXMLElement(Document document, IRequirementSource iRequirementSource) {
        Element element;
        if (null == document) {
            throw new IllegalArgumentException();
        }
        if (null == iRequirementSource) {
            throw new IllegalArgumentException();
        }
        String string = "/RequirementSources";
        Node node = document.selectSingleNode(string);
        Element element2 = null;
        if (node instanceof Element && (element2 = XMLManip.createElement(element = (Element)node, "RequirementSource")) != null) {
            String string2 = iRequirementSource.getID();
            element2.addAttribute("id", string2);
            String string3 = iRequirementSource.getDisplayName();
            element2.addAttribute("displayName", string3);
            String string4 = iRequirementSource.getProvider();
            element2.addAttribute("provider", string4);
            String string5 = iRequirementSource.getLocation();
            element2.addAttribute("location", string5);
            String string6 = iRequirementSource.getRequiresLogin() ? "True" : "False";
            element2.addAttribute("loginRequired", string6);
            String string7 = iRequirementSource.getProxyFile();
            element2.addAttribute("proxyFile", string7);
        }
        return element2;
    }

    protected void addReqSourceToDoc(Document document, Element element) {
        if (null == document) {
            throw new IllegalArgumentException();
        }
        if (null == element) {
            throw new IllegalArgumentException();
        }
        String string = "/RequirementSources";
        Node node = document.selectSingleNode(string);
        if (node instanceof Branch) {
            Branch branch = (Branch)node;
            element.detach();
            branch.add(element);
        }
    }

    protected Element findOrCreateElement(Node node, String string, String string2, String string3) {
        Node node2;
        Element element = null;
        String string4 = string;
        if (string2.length() > 0) {
            string4 = string4 + "[@";
            string4 = string4 + string2;
            string4 = string4 + "='";
            string4 = string4 + string3;
            string4 = string4 + "']";
        }
        if ((node2 = node.selectSingleNode(string4)) != null) {
            if (node2 instanceof Element) {
                element = (Element)node2;
            }
        } else {
            element = node instanceof Element ? XMLManip.createElement((Element)node, string) : XMLManip.createElement(this.m_ReqProxyDoc, string);
        }
        return element;
    }

    protected void saveReqSourcesDoc() {
        String string;
        if (this.m_ReqSourcesDoc != null && (string = this.getReqSourcesFile()).length() > 0) {
            XMLManip.save(this.m_ReqSourcesDoc, string);
        }
    }

    protected void convertXMLElementToReqSource(Element element, IRequirementSource iRequirementSource) {
        if (null == element) {
            throw new IllegalArgumentException();
        }
        if (null == iRequirementSource) {
            throw new IllegalArgumentException();
        }
        String string = element.attributeValue("id");
        if (string != null) {
            iRequirementSource.setID(string);
        }
        if ((string = element.attributeValue("displayName")) != null) {
            iRequirementSource.setDisplayName(string);
        }
        if ((string = element.attributeValue("provider")) != null) {
            iRequirementSource.setProvider(string);
        }
        if ((string = element.attributeValue("location")) != null) {
            iRequirementSource.setLocation(string);
        }
        if ((string = element.attributeValue("loginRequired")) != null) {
            boolean bl = string.equals("True");
            iRequirementSource.setRequiresLogin(bl);
        }
        if ((string = element.attributeValue("proxyFile")) != null) {
            iRequirementSource.setProxyFile(string);
        }
    }

    protected IRequirementsProvider[] getAddinsFromRegistry(String string) {
        IRequirementsProvider[] iRequirementsProviderArray;
        ArrayList<IRequirementsProvider> arrayList = new ArrayList<IRequirementsProvider>();
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        try {
            if (fileSystem != null && (iRequirementsProviderArray = fileSystem.findResource(string)) != null) {
                FileObject[] fileObjectArray;
                for (FileObject fileObject : fileObjectArray = iRequirementsProviderArray.getChildren()) {
                    try {
                        Object object;
                        InstanceCookie instanceCookie;
                        DataObject dataObject = DataObject.find((FileObject)fileObject);
                        if (dataObject == null || (instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class)) == null || !((object = instanceCookie.instanceCreate()) instanceof IRequirementsProvider)) continue;
                        arrayList.add((IRequirementsProvider)object);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        iRequirementsProviderArray = new IRequirementsProvider[arrayList.size()];
        arrayList.toArray(iRequirementsProviderArray);
        return iRequirementsProviderArray;
    }
}

