/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.reverseengineering.reframework;

import org.netbeans.modules.uml.common.generics.ETPairT;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IDependency;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IMultiplicity;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IMultiplicityRange;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAttribute;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IBehavioralFeature;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.INavigableEnd;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IOperation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IParameter;
import org.netbeans.modules.uml.core.metamodel.structure.ISourceFileArtifact;
import org.netbeans.modules.uml.core.reverseengineering.parsingfacilities.ClassLoaderListener;
import org.netbeans.modules.uml.core.reverseengineering.parsingfacilities.IUMLParser;
import org.netbeans.modules.uml.core.reverseengineering.parsingfacilities.IUMLParserEventDispatcher;
import org.netbeans.modules.uml.core.reverseengineering.reframework.CollectionInformation;
import org.netbeans.modules.uml.core.reverseengineering.reframework.IFileInformation;
import org.netbeans.modules.uml.core.reverseengineering.reframework.IParserData;
import org.netbeans.modules.uml.core.reverseengineering.reframework.IREAttribute;
import org.netbeans.modules.uml.core.reverseengineering.reframework.IREClass;
import org.netbeans.modules.uml.core.reverseengineering.reframework.IREClassElement;
import org.netbeans.modules.uml.core.reverseengineering.reframework.IREOperation;
import org.netbeans.modules.uml.core.reverseengineering.reframework.IREParameter;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.IErrorEvent;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.IFacility;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.IFacilityManager;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.ILanguage;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.ITokenDescriptor;
import org.netbeans.modules.uml.core.roundtripframework.codegeneration.IParseInformationCache;
import org.netbeans.modules.uml.core.support.umlsupport.ProductRetriever;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.products.ad.applicationcore.IADProduct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLParserUtilities {
    public static final String PACKAGE_SEPARATOR = "::";
    public static final int ER_ENTIRE_ELEMENT = 0;
    public static final int ER_ELEMENT_HEAD = 1;

    public static ETList<ITokenDescriptor> getElementTokenDescriptors(IElement iElement) {
        IFileInformation iFileInformation;
        IParseInformationCache iParseInformationCache;
        ISourceFileArtifact iSourceFileArtifact = UMLParserUtilities.getSourceFileArtifact(iElement);
        if (iSourceFileArtifact != null && (iParseInformationCache = UMLParserUtilities.getParseInformationCache()) != null && (iFileInformation = iParseInformationCache.getParseInformation(iSourceFileArtifact)) != null) {
            return UMLParserUtilities.findElementTokenDescriptors(iElement, iFileInformation);
        }
        return null;
    }

    public static int getElementStartLineNumber(IElement iElement) {
        ETList<ITokenDescriptor> eTList = UMLParserUtilities.getElementTokenDescriptors(iElement);
        int n = 0;
        if (eTList != null) {
            int n2 = eTList.size();
            for (int i = 0; i < n2; ++i) {
                ITokenDescriptor iTokenDescriptor = (ITokenDescriptor)eTList.get(i);
                if (!"StartPosition".equals(iTokenDescriptor.getType())) continue;
                n = iTokenDescriptor.getLine();
            }
        }
        return n;
    }

    public static String getElementSourceFileName(IElement iElement) {
        ISourceFileArtifact iSourceFileArtifact = UMLParserUtilities.getSourceFileArtifact(iElement);
        return iSourceFileArtifact != null ? iSourceFileArtifact.getSourceFile() : null;
    }

    public static IUMLParser getUMLParser() {
        IFacilityManager iFacilityManager;
        IFacility iFacility;
        ICoreProduct iCoreProduct = ProductRetriever.retrieveProduct();
        if (iCoreProduct != null && (iFacility = (iFacilityManager = iCoreProduct.getFacilityManager()).retrieveFacility("Parsing.UMLParser")) instanceof IUMLParser) {
            return (IUMLParser)iFacility;
        }
        return null;
    }

    public static IFileInformation parseSourceFileArtifact(ISourceFileArtifact iSourceFileArtifact) {
        ILanguage iLanguage;
        String string = iSourceFileArtifact.getSourceCode();
        if (string != null && string.length() > 0 && (iLanguage = iSourceFileArtifact.getLanguage()) != null) {
            return UMLParserUtilities.parseText(string, iLanguage.getName(), false, null, null, null);
        }
        return null;
    }

    public static long getStartPosition(IParserData iParserData) {
        ITokenDescriptor iTokenDescriptor = iParserData.getTokenDescriptor("Comment");
        if (iTokenDescriptor == null) {
            iTokenDescriptor = iParserData.getTokenDescriptor("StartPosition");
        }
        return iTokenDescriptor != null ? iTokenDescriptor.getPosition() : -1L;
    }

    public static long getEndPosition(IParserData iParserData) {
        return UMLParserUtilities.getTokenDescriptorEndPosition(iParserData, "EndPosition");
    }

    public static long getTokenDescriptorEndPosition(IParserData iParserData, String string) {
        ITokenDescriptor iTokenDescriptor = iParserData.getTokenDescriptor(string);
        if (iTokenDescriptor != null) {
            long l = iTokenDescriptor.getPosition();
            if (l != -1L) {
                l += (long)iTokenDescriptor.getLength();
            }
            return l;
        }
        return -1L;
    }

    public static IOperation findMatchingOperation(IClassifier iClassifier, IREOperation iREOperation) {
        ETList<IOperation> eTList = iClassifier.getOperations();
        if (eTList != null) {
            int n = eTList.size();
            for (int i = 0; i < n; ++i) {
                IOperation iOperation = (IOperation)eTList.get(i);
                if (!UMLParserUtilities.isMatchingOperation(iOperation, iREOperation)) continue;
                return iOperation;
            }
        }
        return null;
    }

    public static IAttribute findMatchingAttribute(IClassifier iClassifier, IREAttribute iREAttribute) {
        ETList<INavigableEnd> eTList;
        String string = iREAttribute.getName();
        IAttribute iAttribute = iClassifier.getAttributeByName(string);
        if (iAttribute == null && (eTList = iClassifier.getOutboundNavigableEnds()) != null) {
            int n = eTList.size();
            for (int i = 0; i < n; ++i) {
                INavigableEnd iNavigableEnd = (INavigableEnd)eTList.get(i);
                if (iNavigableEnd == null || !(iNavigableEnd instanceof IAttribute) || !string.equals(iNavigableEnd.getName())) continue;
                iAttribute = iNavigableEnd;
                break;
            }
        }
        return iAttribute;
    }

    public static int getParameterCount(IOperation iOperation) {
        ETList<IParameter> eTList = iOperation.getParameters();
        if (eTList == null) {
            return 0;
        }
        int n = 0;
        int n2 = eTList.size();
        for (int i = 0; i < n2; ++i) {
            if (((IParameter)eTList.get(i)).getDirection() == 3) continue;
            ++n;
        }
        return n;
    }

    public static IParameter getNthParameter(IOperation iOperation, int n) {
        ETList<IParameter> eTList = iOperation.getParameters();
        if (eTList == null) {
            return null;
        }
        int n2 = 0;
        int n3 = eTList.size();
        for (int i = 0; i < n3; ++i) {
            IParameter iParameter = (IParameter)eTList.get(i);
            if (iParameter.getDirection() == 3 || n2++ != n) continue;
            return iParameter;
        }
        return null;
    }

    public static int getParameterCount(IREOperation iREOperation) {
        ETList<IREParameter> eTList = iREOperation.getParameters();
        if (eTList == null) {
            return 0;
        }
        int n = 0;
        int n2 = eTList.size();
        for (int i = 0; i < n2; ++i) {
            if (((IREParameter)eTList.get(i)).getKind() == 3) continue;
            ++n;
        }
        return n;
    }

    public static IREParameter getNthParameter(IREOperation iREOperation, int n) {
        ETList<IREParameter> eTList = iREOperation.getParameters();
        if (eTList == null) {
            return null;
        }
        int n2 = 0;
        int n3 = eTList.size();
        for (int i = 0; i < n3; ++i) {
            IREParameter iREParameter = (IREParameter)eTList.get(i);
            if (iREParameter.getKind() == 3 || n2++ != n) continue;
            return iREParameter;
        }
        return null;
    }

    public static SourceCodeRange getElementRange(IParserData iParserData, int n) {
        SourceCodeRange sourceCodeRange = new SourceCodeRange();
        sourceCodeRange.begin = UMLParserUtilities.getStartPosition(iParserData);
        String string = UMLParserUtilities.getTokenDescriptorEndTag(iParserData, n);
        if (string != null) {
            sourceCodeRange.end = UMLParserUtilities.getTokenDescriptorEndPosition(iParserData, string);
        }
        return sourceCodeRange;
    }

    private static String getTokenDescriptorEndTag(IParserData iParserData, int n) {
        if (n == 1) {
            if (iParserData instanceof IREOperation) {
                return "OpHeadEndPosition";
            }
            if (iParserData instanceof IREClass) {
                return "ClassHeadEndPosition";
            }
        }
        return "EndPosition";
    }

    private static IFileInformation parseText(String string, String string2, boolean bl, ETList<IREOperation> eTList, ETList<IREAttribute> eTList2, ETList<IErrorEvent> eTList3) {
        IUMLParserEventDispatcher iUMLParserEventDispatcher;
        IFileInformation iFileInformation = null;
        int n = bl ? 1 : 0;
        IUMLParser iUMLParser = UMLParserUtilities.getUMLParser();
        if (iUMLParser != null && (iUMLParserEventDispatcher = iUMLParser.getUMLParserDispatcher()) != null) {
            ClassLoaderListener classLoaderListener = new ClassLoaderListener();
            iUMLParserEventDispatcher.registerForUMLParserEvents(classLoaderListener, null);
            if (bl) {
                iUMLParserEventDispatcher.registerForUMLParserAtomicEvents(null, null);
            }
            iUMLParser.processStreamByType(string, string2, n);
            iUMLParserEventDispatcher.revokeUMLParserSink(classLoaderListener);
            iFileInformation = classLoaderListener.getFileInformation();
            if (bl) {
                iUMLParserEventDispatcher.revokeUMLParserAtomicSink(classLoaderListener);
                if (eTList2 != null) {
                    eTList2.addAll(classLoaderListener.getTopLevelAttributes());
                }
                if (eTList != null) {
                    eTList.addAll(classLoaderListener.getTopLevelOperations());
                }
            }
            if (eTList3 != null) {
                eTList3.addAll(iFileInformation.getErrors());
            }
        }
        return iFileInformation;
    }

    public static IFileInformation parseFile(String string) {
        IUMLParserEventDispatcher iUMLParserEventDispatcher;
        IUMLParser iUMLParser = UMLParserUtilities.getUMLParser();
        if (iUMLParser != null && (iUMLParserEventDispatcher = iUMLParser.getUMLParserDispatcher()) != null) {
            ClassLoaderListener classLoaderListener = new ClassLoaderListener();
            iUMLParserEventDispatcher.registerForUMLParserEvents(classLoaderListener, string);
            iUMLParser.processStreamFromFile(string);
            return classLoaderListener.getFileInformation();
        }
        return null;
    }

    private static ETList<ITokenDescriptor> findElementTokenDescriptors(IElement iElement, IFileInformation iFileInformation) {
        IREClass iREClass;
        IClassifier iClassifier = UMLParserUtilities.getClassifierFromElement(iElement);
        if (iClassifier != null && (iREClass = UMLParserUtilities.getREClassFromClassifier(iClassifier, iFileInformation)) != null) {
            return UMLParserUtilities.findElementTokenDescriptors(iElement, iREClass);
        }
        return null;
    }

    private static ETList<ITokenDescriptor> findElementTokenDescriptors(IElement iElement, IREClass iREClass) {
        IBehavioralFeature iBehavioralFeature;
        IREClassElement iREClassElement = null;
        if (iElement instanceof IClassifier) {
            iREClassElement = iREClass;
        } else if (!(iElement instanceof IAttribute && (iREClassElement = UMLParserUtilities.findMatchingREAttribute(iREClass, (IAttribute)iElement)) != null || iElement instanceof IOperation && (iREClassElement = UMLParserUtilities.findMatchingREOperation(iREClass, (IOperation)iElement)) != null || !(iElement instanceof IParameter) || !((iBehavioralFeature = ((IParameter)iElement).getBehavioralFeature()) instanceof IOperation))) {
            iREClassElement = UMLParserUtilities.findMatchingREOperation(iREClass, (IOperation)iBehavioralFeature);
        }
        return iREClassElement != null ? iREClassElement.getTokenDescriptors() : null;
    }

    public static IREClass getREClassFromClassifier(IClassifier iClassifier, IFileInformation iFileInformation) {
        String string = UMLParserUtilities.getNestedClassPath(iClassifier);
        return UMLParserUtilities.getREClassFromClassPath(string, iFileInformation);
    }

    private static IREClass getREClassFromClassPath(String string, IFileInformation iFileInformation) {
        ETPairT<String, String> eTPairT = StringUtilities.removeToken(string, PACKAGE_SEPARATOR);
        String string2 = eTPairT.getParamOne();
        string = eTPairT.getParamTwo();
        int n = iFileInformation.getTotalClasses();
        if (n > 0 && string2 != null && string2.length() > 0) {
            for (int i = 0; i < n; ++i) {
                String string3;
                IREClass iREClass = iFileInformation.getClass(i);
                if (iREClass == null || !string2.equals(string3 = iREClass.getName())) continue;
                return string.length() == 0 ? iREClass : UMLParserUtilities.findMatchingREClass(iREClass, string);
            }
        }
        return null;
    }

    public static IREOperation findMatchingREOperation(IREClass iREClass, IOperation iOperation) {
        ETList<IREOperation> eTList = iREClass.getOperations();
        if (eTList != null) {
            int n = eTList.size();
            for (int i = 0; i < n; ++i) {
                IREOperation iREOperation = (IREOperation)eTList.get(i);
                if (iREOperation == null || !UMLParserUtilities.isMatchingOperation(iOperation, iREOperation)) continue;
                return iREOperation;
            }
        }
        return null;
    }

    private static boolean isMatchingOperation(IOperation iOperation, IREOperation iREOperation) {
        String string = iOperation.getName();
        if (string == null || !string.equals(iREOperation.getName())) {
            return false;
        }
        ETList<IParameter> eTList = iOperation.getParameters();
        ETList<IREParameter> eTList2 = iREOperation.getParameters();
        if (!(eTList != null && eTList.size() != 0 || eTList2 != null && eTList2.size() != 0)) {
            return true;
        }
        if (eTList == null != (eTList2 == null) || eTList.size() != eTList2.size()) {
            return false;
        }
        int n = eTList.size();
        for (int i = 0; i < n; ++i) {
            if (UMLParserUtilities.isMatchingParameter(iOperation, (IParameter)eTList.get(i), (IREParameter)eTList2.get(i), false)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchTemplateParameter(String string, String string2) {
        int n = string.indexOf("<");
        if (n < 0) {
            return false;
        }
        String string3 = string.substring(0, n);
        string3 = string3.trim();
        int n2 = string2.indexOf("<");
        String string4 = string2;
        if (n2 > 0) {
            string4 = string2.substring(0, n2);
            string4 = string4.trim();
        }
        return string3.equals(string4);
    }

    protected static boolean matchCollectionParameter(IParameter iParameter, IREParameter iREParameter) {
        ILanguage iLanguage;
        boolean bl = false;
        if (iREParameter.isTemplateType() && iREParameter.isCollectionType(iLanguage = (ILanguage)iParameter.getLanguages().get(0))) {
            String string;
            CollectionInformation collectionInformation = iREParameter.getCollectionTypeInfo();
            String string2 = iParameter.getTypeName();
            if (string2.equals(string = collectionInformation.getTypeName())) {
                bl = true;
                IMultiplicity iMultiplicity = iParameter.getMultiplicity();
                if (collectionInformation.getNumberOfRanges() == iMultiplicity.getRangeCount()) {
                    ETList<IMultiplicityRange> eTList = iMultiplicity.getRanges();
                    int n = 0;
                    while ((long)n < collectionInformation.getNumberOfRanges()) {
                        String string3;
                        String string4 = ((IMultiplicityRange)eTList.get(n)).getCollectionType(false);
                        if (!string4.equals(string3 = collectionInformation.getCollectionForRange(n))) {
                            bl = false;
                            break;
                        }
                        ++n;
                    }
                }
            }
        }
        return bl;
    }

    protected static boolean isMatchingParameter(IOperation iOperation, IParameter iParameter, IREParameter iREParameter, boolean bl) {
        String string;
        boolean bl2 = false;
        IClassifier iClassifier = iParameter.getType();
        String string2 = null;
        if (iClassifier != null) {
            string2 = iClassifier.getFullyQualifiedName(false);
        } else {
            string = iParameter.getTypeID();
            string = string.replace(".", PACKAGE_SEPARATOR);
            iParameter.setType2(string);
            string2 = string;
        }
        string = iParameter.getTypeName();
        String string3 = iREParameter.getType();
        if (string.equals(string3) || string2.equals(string3)) {
            bl2 = true;
        } else if (UMLParserUtilities.matchTemplateParameter(string, string3)) {
            bl2 = true;
        } else if (UMLParserUtilities.matchCollectionParameter(iParameter, iREParameter)) {
            bl2 = true;
        } else {
            String string4;
            int n = string3.lastIndexOf(PACKAGE_SEPARATOR);
            if (n != -1 && (string4 = string3.substring(n + 1)).equals(string)) {
                bl2 = true;
            }
            if (!bl2 && !bl) {
                bl2 = UMLParserUtilities.isSetter(iOperation);
            }
        }
        return bl2;
    }

    public static boolean isSetter(IOperation iOperation) {
        IAttribute iAttribute = UMLParserUtilities.getSetterAttribute(iOperation);
        return iAttribute != null;
    }

    public static IAttribute getSetterAttribute(IOperation iOperation) {
        INamedElement iNamedElement;
        IDependency iDependency;
        ETList<IDependency> eTList = iOperation.getSupplierDependencies();
        if (eTList.getCount() > 0 && (iDependency = eTList.item(0)) != null && (iNamedElement = iDependency.getClient()) instanceof IAttribute) {
            return (IAttribute)iNamedElement;
        }
        return null;
    }

    private static IREAttribute findMatchingREAttribute(IREClass iREClass, IAttribute iAttribute) {
        String string = iAttribute.getName();
        ETList<IREAttribute> eTList = iREClass.getAttributes();
        if (eTList != null) {
            int n = eTList.size();
            for (int i = 0; i < n; ++i) {
                IREAttribute iREAttribute = (IREAttribute)eTList.get(i);
                if (iREAttribute == null || string == null || !string.equals(iREAttribute.getName())) continue;
                return iREAttribute;
            }
        }
        return null;
    }

    private static IREClass findMatchingREClass(IREClass iREClass, String string) {
        ETList<IREClass> eTList;
        if (string == null || string.length() == 0) {
            return iREClass;
        }
        ETPairT<String, String> eTPairT = StringUtilities.removeToken(string, PACKAGE_SEPARATOR);
        String string2 = eTPairT.getParamOne();
        string = eTPairT.getParamTwo();
        if (string2 != null && string2.length() > 0 && (eTList = iREClass.getAllInnerClasses()) != null) {
            int n = eTList.size();
            for (int i = 0; i < n; ++i) {
                IREClass iREClass2 = (IREClass)eTList.get(i);
                if (iREClass2 == null || !string2.equals(iREClass2.getName())) continue;
                return UMLParserUtilities.findMatchingREClass(iREClass2, string);
            }
        }
        return null;
    }

    private static String getNestedClassPath(IClassifier iClassifier) {
        INamespace iNamespace = iClassifier;
        StringBuffer stringBuffer = new StringBuffer();
        while (iNamespace instanceof IClassifier) {
            String string = iNamespace.getName();
            if (stringBuffer.length() > 0) {
                stringBuffer.insert(0, PACKAGE_SEPARATOR);
            }
            stringBuffer.insert(0, string);
            IElement iElement = iNamespace.getOwner();
            if (!(iElement instanceof INamespace)) continue;
            iNamespace = (INamespace)iElement;
        }
        return stringBuffer.toString();
    }

    public static IClassifier getClassifierFromElement(IElement iElement) {
        if (iElement instanceof IClassifier) {
            return (IClassifier)iElement;
        }
        if (iElement instanceof INavigableEnd) {
            return ((INavigableEnd)iElement).getReferencingClassifier();
        }
        IElement iElement2 = iElement.getOwner();
        if (iElement2 != null) {
            IElement iElement3;
            if (iElement2 instanceof IClassifier) {
                return (IClassifier)iElement2;
            }
            if (iElement2 instanceof IOperation && (iElement3 = iElement2.getOwner()) instanceof IClassifier) {
                return (IClassifier)iElement3;
            }
        }
        return null;
    }

    public static IParseInformationCache getParseInformationCache() {
        IADProduct iADProduct = UMLParserUtilities.getADProduct();
        return iADProduct != null ? iADProduct.getParseInformationCache() : null;
    }

    public static IADProduct getADProduct() {
        return (IADProduct)ProductRetriever.retrieveProduct();
    }

    public static ISourceFileArtifact getSourceFileArtifact(IElement iElement) {
        IElement iElement2;
        ETList<IElement> eTList = iElement.getSourceFiles();
        if (eTList != null && eTList.size() > 0 && (iElement2 = (IElement)eTList.get(0)) instanceof ISourceFileArtifact) {
            return (ISourceFileArtifact)iElement2;
        }
        return null;
    }

    public static class SourceCodeRange {
        public long begin = -1L;
        public long end = -1L;

        public boolean isValid() {
            return this.begin != -1L && this.end != -1L;
        }
    }
}

