/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.roundtripframework.codegeneration;

import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;
import org.netbeans.modules.uml.common.generics.ETPairT;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.eventframework.EventBlocker;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.INavigableEnd;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.preferenceframework.PreferenceAccessor;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.ILanguage;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.ILanguageManager;
import org.netbeans.modules.uml.core.roundtripframework.IRoundTripController;
import org.netbeans.modules.uml.core.roundtripframework.codegeneration.DefaultCodeGenerationResource;
import org.netbeans.modules.uml.core.roundtripframework.codegeneration.ICodeGenerator;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.support.umlutils.NameManager;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.netbeans.modules.uml.ui.support.messaging.IProgressController;
import org.netbeans.modules.uml.ui.support.messaging.IProgressDialog;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenerator
implements ICodeGenerator,
IProgressController {
    private String m_LanguageName = "";
    private IProgressDialog m_ProgressDialog = null;
    private boolean m_Cancelled = false;
    private boolean m_Done = false;

    @Override
    public void generateCode(String string, ETList<IElement> eTList) {
        ILanguageManager iLanguageManager;
        ICoreProduct iCoreProduct;
        if (eTList != null && (iCoreProduct = ProductHelper.getCoreProduct()) != null && (iLanguageManager = iCoreProduct.getLanguageManager()) != null) {
            ILanguage iLanguage = iLanguageManager.getLanguage(string);
            if (iLanguage != null) {
                this.m_LanguageName = string;
                this.generateCode(iLanguage, eTList);
            } else if (string == null || string.length() > 0) {
                // empty if block
            }
        }
    }

    private void generateCode(ILanguage iLanguage, ETList<IElement> eTList) {
        if (iLanguage != null && eTList != null) {
            int n = eTList.size();
            if (n > 0) {
                this.establishProgress(n);
                String string = this.translateString("IDS_GENERATING");
                Integer n2 = new Integer(n);
                String string2 = n2.toString();
                String string3 = string;
                String string4 = iLanguage.getName();
                ProjectKeeper projectKeeper = new ProjectKeeper();
                RoundTripState roundTripState = new RoundTripState();
                String string5 = this.getUnnamedValue();
                boolean bl = roundTripState.m_Controller.getMode() == 1;
                for (int i = 0; i < n && !this.m_Cancelled; ++i) {
                    Object object;
                    IElement iElement;
                    String string6 = string3;
                    Integer n3 = new Integer(i + 1);
                    String string7 = n3.toString();
                    string6 = StringUtilities.replaceSubString(string6, "%1", string7);
                    string6 = StringUtilities.replaceSubString(string6, "%2", string2);
                    if (this.m_ProgressDialog != null) {
                        this.m_ProgressDialog.setGroupingTitle(string6);
                    }
                    if ((iElement = (IElement)eTList.get(i)) instanceof INamedElement) {
                        object = (INamedElement)iElement;
                        String string8 = object.getName();
                        if (this.m_ProgressDialog != null) {
                            this.m_ProgressDialog.setFieldOne(string8);
                        }
                        if (!this.oKToCodeGen(string4, (IElement)object)) continue;
                        if (!bl) {
                            roundTripState.m_Controller.setMode(1);
                        }
                        this.generateCodeForElement(string5, (INamedElement)object);
                        if (bl) continue;
                        roundTripState.m_Controller.setMode(0);
                        continue;
                    }
                    if (this.m_ProgressDialog == null) continue;
                    object = this.translateString("IDS_CODE_EXISTS");
                    this.m_ProgressDialog.setFieldTwo((String)object, 3);
                }
                if (this.m_ProgressDialog != null) {
                    this.m_ProgressDialog.increment();
                    this.m_ProgressDialog.clearFields();
                }
                projectKeeper.dispose();
                roundTripState.dispose();
            }
            this.endProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCodeForElement(String string, INamedElement iNamedElement) {
        if (iNamedElement != null) {
            String string2 = iNamedElement.getName();
            boolean bl = EventBlocker.startBlocking();
            try {
                this.ensureUniqueRoleNames(iNamedElement);
                iNamedElement.setName(string);
            }
            finally {
                EventBlocker.stopBlocking(bl);
            }
            ArtifactState artifactState = new ArtifactState(iNamedElement);
            iNamedElement.setName(string2);
            artifactState.dispose();
        }
    }

    private String getUnnamedValue() {
        String string = "";
        PreferenceAccessor preferenceAccessor = PreferenceAccessor.instance();
        if (preferenceAccessor != null) {
            string = preferenceAccessor.getDefaultElementName();
        }
        return string;
    }

    private boolean oKToCodeGen(String string, IElement iElement) {
        boolean bl = false;
        if (iElement != null) {
            ETList<IElement> eTList = iElement.getSourceFiles2(string);
            if (eTList != null) {
                int n = eTList.size();
                if (n == 0) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public void onCancelled() {
        this.m_Cancelled = true;
        this.m_ProgressDialog = null;
    }

    public void establishProgress(int n) {
        if (this.m_ProgressDialog == null) {
            this.m_ProgressDialog = ProductHelper.getProgressDialog();
        }
        if (this.m_ProgressDialog != null) {
            this.m_ProgressDialog.setCollapse(true);
            this.m_ProgressDialog.setLimits(new ETPairT<Integer, Integer>(new Integer(0), new Integer(n)));
            String string = this.translateString("IDS_CODE_GEN_TITLE");
            this.m_ProgressDialog.setTitle(string);
            this.m_ProgressDialog.setProgressController(this);
            boolean bl = this.m_ProgressDialog.display(2);
        }
    }

    public void endProgress(boolean bl) {
        boolean bl2 = false;
        if (this.m_ProgressDialog != null) {
            String string = this.translateString("IDS_DONE");
            String string2 = this.translateString("IDS_ERROR");
            String string3 = string;
            this.m_Done = true;
            if (bl) {
                string3 = string2;
                this.m_Done = false;
            }
            this.m_ProgressDialog.clearFields();
            this.m_ProgressDialog.setPosition(0);
            this.m_ProgressDialog.setCollapse(false);
            this.m_ProgressDialog.promptForClosure(string3, true);
        }
    }

    @Override
    public void onProgressEnd() {
        this.onCancelled();
    }

    private void ensureUniqueRoleNames(IElement iElement) {
        int n;
        IClassifier iClassifier;
        ETList<INavigableEnd> eTList;
        if (iElement != null && iElement instanceof IClassifier && (eTList = (iClassifier = (IClassifier)iElement).getOutboundNavigableEnds()) != null && (n = eTList.size()) > 0) {
            NameManager nameManager = new NameManager();
            for (int i = 0; i < n; ++i) {
                String string;
                INavigableEnd iNavigableEnd = (INavigableEnd)eTList.get(i);
                if (iNavigableEnd == null || (string = iNavigableEnd.getName()) != null && string.length() != 0) continue;
                String string2 = this.getAttrPrefix(iNavigableEnd);
                NameManager.ensureUniqueRoleName(iNavigableEnd, string2, string2, 0);
            }
        }
    }

    private String getAttrPrefix(INavigableEnd iNavigableEnd) {
        IClassifier iClassifier;
        String string = "";
        if (iNavigableEnd != null && (iClassifier = iNavigableEnd.getParticipant()) != null) {
            string = this.getAttrPrefixFromPreferences();
            String string2 = iClassifier.getName();
            String string3 = string;
            string = string3 = string3 + string2;
        }
        return string;
    }

    private String getAttrPrefixFromPreferences() {
        return NbPreferences.forModule(CodeGenerator.class).get("UML_ATTRIBUTE_PREFIX", "m");
    }

    private String getLanguageName() {
        return this.m_LanguageName;
    }

    private String translateString(String string) {
        return DefaultCodeGenerationResource.getString(string);
    }

    private class ArtifactState {
        private INamedElement m_Element = null;
        private List m_RemovedArtifacts = null;

        public ArtifactState(INamedElement iNamedElement) {
            Node node;
            this.m_Element = iNamedElement;
            if (this.m_Element != null && (node = this.m_Element.getNode()) != null) {
                this.m_RemovedArtifacts = node.selectNodes("./UML:Element.ownedElement/UML:SourceFileArtifact");
                if (this.m_RemovedArtifacts != null) {
                    int n = this.m_RemovedArtifacts.size();
                    for (int i = 0; i < n; ++i) {
                        Element element;
                        Node node2 = (Node)this.m_RemovedArtifacts.get(i);
                        if (node2 == null || (element = node2.getParent()) == null) continue;
                        node2.detach();
                    }
                }
            }
        }

        public void dispose() {
            Node node;
            Node node2;
            if (this.m_Element != null && this.m_RemovedArtifacts != null && (node2 = this.m_Element.getNode()) != null && (node = node2.selectSingleNode("./UML:Element.ownedElement")) != null) {
                int n = this.m_RemovedArtifacts.size();
                for (int i = 0; i < n; ++i) {
                    Node node3 = (Node)this.m_RemovedArtifacts.get(i);
                    if (node3 == null) continue;
                    ((Element)node).add(node3);
                }
            }
        }
    }

    private class ProjectState {
        private IProject m_Project = null;
        private String m_OrigLang = "";
        private String m_OrigMode = "";

        public ProjectState(IProject iProject) {
            this.m_Project = iProject;
            if (this.m_Project != null) {
                this.m_OrigLang = this.m_Project.getDefaultLanguage();
                this.m_OrigMode = this.m_Project.getMode();
            }
        }

        public void cleanUp() {
            if (this.m_Project != null) {
                this.m_Project.setDefaultLanguage(this.m_OrigLang);
                this.m_Project.setMode(this.m_OrigMode);
            }
        }

        public void dispose() {
            if (this.m_Project != null) {
                this.m_Project.setDefaultLanguage(this.m_OrigLang);
                this.m_Project.setMode(this.m_OrigMode);
            }
        }
    }

    private class RoundTripState {
        private IRoundTripController m_Controller = null;
        private int m_OrigMode = -1;

        public RoundTripState() {
            ICoreProduct iCoreProduct = ProductHelper.getCoreProduct();
            if (iCoreProduct != null) {
                this.m_Controller = iCoreProduct.getRoundTripController();
                if (this.m_Controller != null) {
                    this.m_OrigMode = this.m_Controller.getMode();
                    this.m_Controller.setMode(1);
                }
            }
        }

        public void dispose() {
            if (this.m_Controller != null) {
                this.m_Controller.setMode(this.m_OrigMode);
            }
        }
    }

    private class ProjectKeeper {
        private Hashtable<String, ProjectState> m_Projects = new Hashtable();

        public void dispose() {
            Collection<ProjectState> collection = this.m_Projects.values();
            Object[] objectArray = collection.toArray();
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                ProjectState projectState = (ProjectState)objectArray[i];
                if (projectState == null) continue;
                projectState.cleanUp();
            }
        }

        boolean prepareProject(String string, IElement iElement) {
            IProject iProject;
            boolean bl = false;
            if (iElement != null && (iProject = iElement.getProject()) != null) {
                String string2 = iProject.getXMIID();
                ProjectState projectState = this.m_Projects.get(string2);
                if (projectState != null) {
                    bl = true;
                } else {
                    ProjectState projectState2 = new ProjectState(iProject);
                    iProject.setDefaultLanguage(string);
                    iProject.setMode("PSK_IMPLEMENTATION");
                    this.m_Projects.put(string2, projectState2);
                    bl = true;
                }
            }
            return bl;
        }
    }
}

